/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.Logger;
import com.threed.jpct.VisList;
import java.io.Serializable;

class AWTDisplayList
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int NONE = -1;
    static final int POLYGON = 0;
    static final int STRIP = 1;
    static final int ARRAY = 2;
    static final int EXECUTE = 3;
    static final int EXECUTE_ONCE = 4;
    static final int WIREFRAME = 5;
    VisList[] vl;
    int col = 0xFFFFFF;
    int[] start;
    int[] end;
    int[] mode;
    int[] command;
    Object[] params;
    int count = 0;
    int max = 0;
    boolean renderTarget = false;
    boolean rendered = false;
    private int cleanupCount = 0;

    AWTDisplayList() {
        int n = Config.glAWTCommandQueueSize;
        this.vl = new VisList[n];
        this.start = new int[n];
        this.end = new int[n];
        this.mode = new int[n];
        this.params = new Object[n];
        this.command = new int[n];
        this.max = n;
    }

    void enlarge() {
        if (this.max == this.count) {
            this.max += Config.glAWTCommandQueueSize;
            Logger.log("Expanding command queue to " + this.max + " entries!", 2);
            VisList[] visListArray = new VisList[this.max];
            System.arraycopy(this.vl, 0, visListArray, 0, this.vl.length);
            this.vl = visListArray;
            Object[] objectArray = new Object[this.max];
            System.arraycopy(this.params, 0, objectArray, 0, this.params.length);
            this.params = objectArray;
            int[] nArray = new int[this.max];
            System.arraycopy(this.start, 0, nArray, 0, this.start.length);
            this.start = nArray;
            int[] nArray2 = new int[this.max];
            System.arraycopy(this.end, 0, nArray2, 0, this.end.length);
            this.end = nArray2;
            int[] nArray3 = new int[this.max];
            System.arraycopy(this.mode, 0, nArray3, 0, this.mode.length);
            this.mode = nArray3;
            int[] nArray4 = new int[this.max];
            System.arraycopy(this.command, 0, nArray4, 0, this.command.length);
            this.command = nArray4;
        }
    }

    void reset() {
        this.rendered = false;
        this.count = 0;
        this.renderTarget = false;
    }

    void setColor(int n) {
        this.col = n;
    }

    int getColor() {
        return this.col;
    }

    void switchBuffers() {
        int n;
        for (n = 0; n < this.count; ++n) {
            if (this.vl[n] == null) continue;
            this.vl[n].switchBuffers();
        }
        ++this.cleanupCount;
        if (this.cleanupCount >= Config.glAWTCommandQueueCleanup) {
            this.cleanupCount = 0;
            for (n = this.count; n < this.max; ++n) {
                this.vl[n] = null;
                this.params[n] = null;
            }
        }
    }

    void addOnce(int n, Object object) {
        this.enlarge();
        this.params[this.count] = object;
        this.command[this.count] = n;
        this.vl[this.count] = null;
        this.mode[this.count] = 4;
        ++this.count;
    }

    void enableRenderTarget() {
        this.renderTarget = true;
    }

    void disableRenderTarget() {
        this.renderTarget = false;
    }

    boolean hasRenderTarget() {
        return this.renderTarget;
    }

    void add(int n, Object object) {
        this.enlarge();
        this.params[this.count] = object;
        this.command[this.count] = n;
        this.vl[this.count] = null;
        this.mode[this.count] = 3;
        ++this.count;
    }

    void delete(int n) {
        this.mode[n] = -1;
        this.vl[n] = null;
        this.params[n] = null;
        for (int i = 0; i < this.count; ++i) {
            if (this.mode[i] == -1) continue;
            return;
        }
        this.count = 0;
    }

    void add(VisList visList, int n, int n2, int n3) {
        this.enlarge();
        visList.extract();
        this.mode[this.count] = n3;
        this.vl[this.count] = visList;
        this.start[this.count] = n;
        this.end[this.count] = n2;
        ++this.count;
    }
}

