/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.Logger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class BufferUtils {
    public static ByteBuffer buffer = null;

    BufferUtils() {
    }

    public static ByteBuffer getDisposableByteBuffer(int n) {
        if (Logger.isDebugEnabled()) {
            Logger.log("Creating new disposable buffer of size " + n, 3);
        }
        return ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer getByteBuffer(int n) {
        if (Config.nativeBufferSize == 0 || n > 1024 * Config.nativeBufferSize) {
            return BufferUtils.getDisposableByteBuffer(n);
        }
        if (buffer == null || buffer.limit() < n) {
            buffer = ByteBuffer.allocateDirect(Math.max(1024 * Config.nativeBufferSize, n) + 16384);
            if (Logger.isDebugEnabled()) {
                Logger.log("Creating new cache buffer of size " + buffer.capacity(), 3);
            }
            buffer.position(buffer.capacity() - 16384);
            buffer.flip();
        }
        buffer.position(buffer.limit() - n);
        if (Logger.isDebugEnabled()) {
            Logger.log("Slicing buffer of size " + n, 3);
        }
        ByteBuffer byteBuffer = buffer.slice().order(ByteOrder.nativeOrder());
        buffer.flip();
        if (Logger.isDebugEnabled()) {
            Logger.log("Cache buffer flipped, new size is " + buffer.limit(), 3);
        }
        return byteBuffer;
    }
}

