/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.BufferedMatrix;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;
import java.io.Serializable;

public class Camera
extends BufferedMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CAMERA_MOVEIN = 1;
    public static final int CAMERA_MOVEOUT = 2;
    public static final int CAMERA_MOVEDOWN = 3;
    public static final int CAMERA_MOVEUP = 4;
    public static final int CAMERA_MOVELEFT = 6;
    public static final int CAMERA_MOVERIGHT = 5;
    public static final int CAMERA_DONT_MOVE = 7;
    public static final boolean SLIDE = true;
    public static final boolean DONT_SLIDE = false;
    public static final int ELLIPSOID_ALIGNED = 0;
    public static final int ELLIPSOID_TRANSFORMED = 1;
    float scaleX = 1.0f;
    float scaleY = 1.0f;
    float scaleXAfter;
    float scaleYAfter;
    float divx = 1.0f;
    float divy = 1.0f;
    float frustumOffsetX = 0.0f;
    float frustumOffsetY = 0.0f;
    Matrix billBoardMatrix = null;
    private float cameraFOV;
    private float yFOV = -1.0f;
    private float cameraFovOrg;
    private float yFovOrg = -1.0f;
    private float lowerLimit = 0.5f;
    private float higherLimit = 1.5f;
    float nearPlane = -1.0f;
    float farPlane = -1.0f;
    private float nearPlaneOld = Config.nearPlane;
    private float farPlaneOld = Config.farPlane;
    private int ellipsoidMode = 0;

    public Camera() {
        this.cameraFOV = Config.defaultCameraFOV;
        this.cameraFovOrg = Config.defaultCameraFOV;
    }

    void calcFOV(int n, int n2) {
        float f = this.cameraFOV / 2.0f;
        if (!Config.autoMaintainAspectRatio || this.yFOV != -1.0f) {
            this.divx = f;
            this.divy = f;
            if (this.yFOV != -1.0f) {
                this.divy = this.yFOV / 2.0f;
            }
        } else {
            this.divx = f;
            this.divy = f * ((float)n2 / (float)n);
        }
        this.scaleX = (float)n / (2.0f * this.divx);
        this.scaleY = (float)n2 / (2.0f * this.divy);
        if (!Config.glIgnoreNearPlane) {
            this.divx /= Config.nearPlane;
            this.divy /= Config.nearPlane;
        }
        this.scaleXAfter = (float)n / (2.0f * this.divx);
        this.scaleYAfter = (float)n2 / (2.0f * this.divy);
    }

    public SimpleVector getPosition() {
        return new SimpleVector(this.backBx, this.backBy, this.backBz);
    }

    public SimpleVector getPosition(SimpleVector simpleVector) {
        simpleVector.set(this.backBx, this.backBy, this.backBz);
        return simpleVector;
    }

    public SimpleVector getXAxis() {
        return this.backMatrix.getXAxis();
    }

    public SimpleVector getYAxis() {
        return this.backMatrix.getYAxis();
    }

    public SimpleVector getZAxis() {
        return this.backMatrix.getZAxis();
    }

    public SimpleVector getDirection() {
        return this.getVector(2);
    }

    public SimpleVector getDirection(SimpleVector simpleVector) {
        return this.getVector(2, simpleVector);
    }

    public SimpleVector getUpVector() {
        SimpleVector simpleVector = this.getVector(1);
        simpleVector.scalarMul(-1.0f);
        return simpleVector;
    }

    public SimpleVector getSideVector() {
        return this.getVector(0);
    }

    private SimpleVector getVector(int n) {
        return this.getVector(n, SimpleVector.create());
    }

    private SimpleVector getVector(int n, SimpleVector simpleVector) {
        float f = this.backMatrix.mat[0][n];
        float f2 = this.backMatrix.mat[1][n];
        float f3 = this.backMatrix.mat[2][n];
        float f4 = 1.0f / (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        simpleVector.set(f * f4, f2 * f4, f3 * f4);
        return simpleVector;
    }

    public float convertRADAngleIntoFOV(float f) {
        f = (float)(Math.tan((double)f / 2.0) * 2.0);
        return f;
    }

    public float convertDEGAngleIntoFOV(float f) {
        double d = (double)f / 180.0 * Math.PI;
        f = (float)(Math.tan(d / 2.0) * 2.0);
        return f;
    }

    public void setFOVLimits(float f, float f2) {
        this.lowerLimit = f;
        this.higherLimit = f2;
    }

    public float getMaxFOV() {
        return this.higherLimit;
    }

    public float getMinFOV() {
        return this.lowerLimit;
    }

    public void setFOV(float f) {
        if (f > this.higherLimit) {
            f = this.higherLimit;
        } else if (f < this.lowerLimit) {
            f = this.lowerLimit;
        }
        this.cameraFOV = f;
        this.cameraFovOrg = f;
    }

    public void setFovAngle(float f) {
        this.setFOV((float)(Math.tan((double)f / 2.0) * 2.0));
    }

    public void setYFOV(float f) {
        if (f != -1.0f) {
            if (f > this.higherLimit) {
                f = this.higherLimit;
            } else if (f < this.lowerLimit) {
                f = this.lowerLimit;
            }
        }
        this.yFOV = f;
        this.yFovOrg = f;
    }

    public void setYFovAngle(float f) {
        if (f == -1.0f) {
            this.setYFOV(-1.0f);
            return;
        }
        this.setYFOV((float)(Math.tan((double)f / 2.0) * 2.0));
    }

    public float getFOV() {
        return this.cameraFOV;
    }

    public float getYFOV() {
        return this.yFOV;
    }

    public void adjustFovToNearPlane() {
        if (!Config.glIgnoreNearPlane) {
            float f = Config.nearPlane;
            if (this.nearPlane != -1.0f) {
                f = this.nearPlane;
            }
            this.cameraFOV = this.cameraFovOrg * f;
            if (this.yFOV != -1.0f) {
                this.yFOV = this.yFovOrg * f;
            }
        }
    }

    public void increaseFOV(float f) {
        this.cameraFOV += f;
        if (this.cameraFOV > this.higherLimit) {
            this.cameraFOV = this.higherLimit;
        } else if (this.cameraFOV < this.lowerLimit) {
            this.cameraFOV = this.lowerLimit;
        }
    }

    public void decreaseFOV(float f) {
        this.cameraFOV -= f;
        if (this.cameraFOV > this.higherLimit) {
            this.cameraFOV = this.higherLimit;
        } else if (this.cameraFOV < this.lowerLimit) {
            this.cameraFOV = this.lowerLimit;
        }
    }

    public void setFOVtoDefault() {
        this.cameraFovOrg = this.cameraFOV = Config.defaultCameraFOV;
    }

    public void lookAt(SimpleVector simpleVector) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = simpleVector.x - this.backBx;
        double d6 = simpleVector.y - this.backBy;
        double d7 = simpleVector.z - this.backBz;
        if (d5 == 0.0 && d7 == 0.0) {
            d5 += 1.0E-128;
        }
        if ((d4 = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7)) != 0.0) {
            d5 /= d4;
            d6 /= d4;
            d7 /= d4;
        }
        Matrix matrix = new Matrix();
        float[][] fArray = matrix.mat;
        fArray[0][1] = 0.0f;
        fArray[1][1] = 1.0f;
        fArray[2][1] = 0.0f;
        fArray[0][2] = (float)d5;
        fArray[1][2] = (float)d6;
        fArray[2][2] = (float)d7;
        double d8 = 1.0;
        double d9 = d7;
        double d10 = 0.0;
        double d11 = d6;
        double d12 = d8 * d9 - d10 * d11;
        double d13 = d5;
        double d14 = 0.0;
        double d15 = d10 * d13 - d14 * d9;
        double d16 = d14 * d11 - d8 * d13;
        d4 = Math.sqrt(d12 * d12 + d15 * d15 + d16 * d16);
        if (d4 != 0.0) {
            d12 /= d4;
            d15 /= d4;
            d16 /= d4;
        }
        if ((d4 = Math.sqrt((d3 = d11 * d16 - d9 * d15) * d3 + (d2 = d9 * d12 - d13 * d16) * d2 + (d = d13 * d15 - d11 * d12) * d)) != 0.0) {
            d3 /= d4;
            d2 /= d4;
            d /= d4;
        }
        fArray[0][0] = (float)d12;
        fArray[1][0] = (float)d15;
        fArray[2][0] = (float)d16;
        fArray[0][1] = (float)d3;
        fArray[1][1] = (float)d2;
        fArray[2][1] = (float)d;
        matrix.orthonormalizeDouble();
        this.backMatrix = matrix;
    }

    public void align(Object3D object3D) {
        Matrix matrix = object3D.getRotationMatrix().cloneMatrix();
        matrix.scalarMul(1.0f / object3D.getScale());
        this.backMatrix.setTo(matrix.invert3x3());
    }

    public void setPositionToCenter(Object3D object3D) {
        SimpleVector simpleVector = object3D.getTransformedCenter();
        this.backBx = simpleVector.x;
        this.backBy = simpleVector.y;
        this.backBz = simpleVector.z;
    }

    public void setPosition(SimpleVector simpleVector) {
        this.backBx = simpleVector.x;
        this.backBy = simpleVector.y;
        this.backBz = simpleVector.z;
    }

    public void setPosition(float f, float f2, float f3) {
        this.backBx = f;
        this.backBy = f2;
        this.backBz = f3;
    }

    public void setOrientation(SimpleVector simpleVector, SimpleVector simpleVector2) {
        SimpleVector simpleVector3 = new SimpleVector(simpleVector2);
        simpleVector3.scalarMul(-1.0f);
        this.backMatrix.setOrientation(simpleVector, simpleVector3, false);
    }

    public SimpleVector transform(SimpleVector simpleVector) {
        return this.transform(simpleVector, new SimpleVector());
    }

    public SimpleVector transform(SimpleVector simpleVector, SimpleVector simpleVector2) {
        Matrix matrix = this.backMatrix;
        Matrix matrix2 = new Matrix();
        matrix2.setIdentity();
        matrix2.mat[3][0] = -this.backBx;
        matrix2.mat[3][1] = -this.backBy;
        matrix2.mat[3][2] = -this.backBz;
        matrix2.matMul(matrix);
        float f = matrix2.mat[2][2];
        float f2 = matrix2.mat[1][2];
        float f3 = matrix2.mat[0][2];
        float f4 = matrix2.mat[0][0];
        float f5 = matrix2.mat[1][0];
        float f6 = matrix2.mat[1][1];
        float f7 = matrix2.mat[2][1];
        float f8 = matrix2.mat[2][0];
        float f9 = matrix2.mat[0][1];
        float f10 = matrix2.mat[3][0];
        float f11 = matrix2.mat[3][1];
        float f12 = matrix2.mat[3][2];
        float f13 = simpleVector.x;
        float f14 = simpleVector.y;
        float f15 = simpleVector.z;
        float f16 = f13 * f4 + f14 * f5 + f15 * f8 + f10;
        float f17 = f13 * f9 + f14 * f6 + f15 * f7 + f11;
        float f18 = f13 * f3 + f14 * f2 + f15 * f + f12;
        simpleVector2.set(f16, f17, f18);
        return simpleVector2;
    }

    public void moveCamera(int n, float f) {
        float f2 = -1.0f;
        if ((n & 1) == 1) {
            f2 = 1.0f;
        }
        int n2 = 2 - ((n + 1) / 2 - 1);
        this.backBx += this.backMatrix.mat[0][n2] * (f2 *= f);
        this.backBy += this.backMatrix.mat[1][n2] * f2;
        this.backBz += this.backMatrix.mat[2][n2] * f2;
    }

    public void moveCamera(SimpleVector simpleVector, float f) {
        this.backBx += simpleVector.x * f;
        this.backBy += simpleVector.y * f;
        this.backBz += simpleVector.z * f;
    }

    public void rotateCameraAxis(SimpleVector simpleVector, float f) {
        this.backMatrix.rotateAxis(simpleVector, -f);
    }

    public void rotateCameraX(float f) {
        this.backMatrix.rotateX(-f);
    }

    public void rotateCameraY(float f) {
        this.backMatrix.rotateY(-f);
    }

    public void rotateCameraZ(float f) {
        this.backMatrix.rotateZ(-f);
    }

    public void setEllipsoidMode(int n) {
        this.ellipsoidMode = n;
    }

    public int getEllipsoidMode() {
        return this.ellipsoidMode;
    }

    public Matrix getProjectionMatrix(FrameBuffer frameBuffer) {
        return this.getProjectionMatrix(frameBuffer, this.getNearClippingPlane(), this.getFarClippingPlane());
    }

    public Matrix getProjectionMatrix(FrameBuffer frameBuffer, float f, float f2) {
        float f3 = frameBuffer.getHeight();
        float f4 = frameBuffer.getWidth();
        if (frameBuffer.renderTarget != null) {
            if (frameBuffer.virtualHeight > 0 && frameBuffer.virtualWidth > 0) {
                f3 = frameBuffer.virtualHeight;
                f4 = frameBuffer.virtualWidth;
            } else {
                f3 = frameBuffer.renderTarget.height;
                f4 = frameBuffer.renderTarget.width;
            }
        }
        Camera camera = this;
        float f5 = camera.getFOV();
        float f6 = 0.0f;
        f6 = Config.autoMaintainAspectRatio ? f5 * (f3 / f4) : f5;
        if (camera.getYFOV() != -1.0f) {
            f6 = camera.getYFOV();
        }
        float f7 = f2;
        float f8 = f;
        float f9 = this.applyOffsetY((f6 *= f8) * 0.5f);
        float f10 = this.applyOffsetY(-f6 * 0.5f);
        float f11 = this.applyOffsetX(-(f5 *= f8) * 0.5f);
        float f12 = this.applyOffsetX(f5 * 0.5f);
        float[] fArray = new float[16];
        Matrix matrix = new Matrix();
        float f13 = 1.0f / f8;
        this.frustum(fArray, f11 * f13, f12 * f13, f10 * f13, f9 * f13, f8, f7);
        matrix.setDump(fArray);
        matrix.transformToGL();
        return matrix;
    }

    public void setClippingPlanes(float f, float f2) {
        this.nearPlane = Math.max(f, 0.1f);
        this.farPlane = Math.max(f2, 1.0f);
    }

    public float getNearClippingPlane() {
        if (Config.glIgnoreNearPlane) {
            return 1.0f;
        }
        if (this.nearPlane > 0.0f) {
            return this.nearPlane;
        }
        return Config.nearPlane;
    }

    public float getFarClippingPlane() {
        if (this.farPlane > 0.0f) {
            return this.farPlane;
        }
        return Config.farPlane;
    }

    void setPlanes(boolean bl) {
        if (this.nearPlane != -1.0f) {
            if (!bl) {
                this.nearPlaneOld = Config.nearPlane;
                this.farPlaneOld = Config.farPlane;
                Config.nearPlane = this.nearPlane;
                Config.farPlane = this.farPlane;
            } else {
                Config.nearPlane = this.nearPlaneOld;
                Config.farPlane = this.farPlaneOld;
            }
        }
    }

    float applyOffsetX(float f) {
        return f - this.frustumOffsetX * Math.abs(f);
    }

    float applyOffsetY(float f) {
        return f + this.frustumOffsetY * Math.abs(f);
    }

    private void frustum(float[] fArray, float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = 1.0f / (f2 - f);
        float f8 = 1.0f / (f4 - f3);
        float f9 = 1.0f / (f5 - f6);
        float f10 = 2.0f * (f5 * f7);
        float f11 = 2.0f * (f5 * f8);
        float f12 = 2.0f * ((f2 + f) * f7);
        float f13 = (f4 + f3) * f8;
        float f14 = (f6 + f5) * f9;
        float f15 = 2.0f * (f6 * f5 * f9);
        fArray[0] = f10;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = f11;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = f12;
        fArray[9] = f13;
        fArray[10] = f14;
        fArray[11] = -1.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = f15;
        fArray[15] = 0.0f;
    }

    public void setBillBoardMatrix(Matrix matrix) {
        this.billBoardMatrix = matrix;
    }

    public Matrix getBillBoardMatrix() {
        return this.billBoardMatrix;
    }

    public void setFrustumOffset(float f, float f2) {
        this.frustumOffsetX = f;
        this.frustumOffsetY = f2;
    }

    public float getFrustumOffsetX() {
        return this.frustumOffsetX;
    }

    public float getFrustumOffsetY() {
        return this.frustumOffsetY;
    }
}

