/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;

final class CollisionInfo {
    SimpleVector eRadius;
    SimpleVector invERadius;
    SimpleVector invERadiusOrg;
    SimpleVector r3Velocity;
    SimpleVector r3Pos;
    SimpleVector r3Dest;
    SimpleVector intersectionPoint;
    SimpleVector eSpaceVelocity;
    SimpleVector eSpaceBasePoint;
    Object3D collisionObject = null;
    boolean foundCollision = false;
    boolean collision = false;
    boolean isPartOfCollision = false;
    float nearestDistance;
    Matrix addTransMat = null;
    Matrix addRotMat = null;

    CollisionInfo() {
    }

    float getMaxRadius() {
        return Math.max(Math.max(this.eRadius.x, this.eRadius.y), this.eRadius.z);
    }

    void setScale(float f) {
        this.invERadius.set(this.invERadiusOrg);
        this.invERadius.scalarMul(f);
    }

    void calculateInverseAndDest() {
        if (this.eRadius != null) {
            this.invERadius = new SimpleVector();
            this.invERadiusOrg = new SimpleVector();
            this.invERadiusOrg.x = 1.0f / this.eRadius.x;
            this.invERadiusOrg.y = 1.0f / this.eRadius.y;
            this.invERadiusOrg.z = 1.0f / this.eRadius.z;
            this.invERadius.set(this.invERadiusOrg);
        }
        this.recalcDest();
    }

    void recalcDest() {
        if (this.r3Pos != null && this.r3Velocity != null) {
            this.r3Dest = new SimpleVector(this.r3Pos);
            this.r3Dest.add(this.r3Velocity);
        }
    }
}

