/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.BufferUtils;
import com.threed.jpct.Camera;
import com.threed.jpct.Config;
import com.threed.jpct.GLBase;
import com.threed.jpct.GLSLShader;
import com.threed.jpct.GenericContainer;
import com.threed.jpct.ICompiledInstance;
import com.threed.jpct.IRenderHook;
import com.threed.jpct.IRenderer;
import com.threed.jpct.IntegerC;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Mesh;
import com.threed.jpct.Object3D;
import com.threed.jpct.TextureManager;
import com.threed.jpct.Vectors;
import com.threed.jpct.VertexAttributes;
import com.threed.jpct.World;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;

class CompiledInstance
implements ICompiledInstance {
    private static final Object SYNC = new Object();
    private static final int NO_RENDERER = -999999999;
    private static final long serialVersionUID = 1L;
    protected static final int[] stageMap = new int[]{33984, 33985, 33986, 33987};
    private static final float[] ALL_ONES = new float[]{1.0f, 1.0f, 1.0f};
    private static final int[] LIGHTS = new int[]{16384, 16385, 16386, 16387, 16388, 16389, 16390, 16391};
    private static final FloatBuffer floatBuffer64 = BufferUtils.getByteBuffer(64).asFloatBuffer();
    private static final FloatBuffer floatBuffer16_2 = BufferUtils.getByteBuffer(16).asFloatBuffer();
    private static final FloatBuffer ZEROS_ONE = BufferUtils.getByteBuffer(16).asFloatBuffer();
    public static Object3D lastObj;
    public static FloatBuffer lastVertexBuffer;
    public static int lastVertexBufferId;
    public static double chkSum;
    public static int lastLightCnt;
    public static int lastGlobalRenderer;
    public boolean texGenEnabled = false;
    public boolean useDL = true;
    public boolean dynamic = false;
    private boolean mayShare = true;
    Object3D obj = null;
    private FloatBuffer normals = null;
    private FloatBuffer tangents = null;
    private FloatBuffer vertices = null;
    private FloatBuffer colors = null;
    private IntBuffer indices = null;
    private FloatBuffer[] multiTextures = null;
    private FloatBuffer[] attributes = null;
    private List tris = new ArrayList();
    private int cnt = 0;
    private int polyIndex = 0;
    private int endStage = 0;
    private boolean indexed = true;
    private boolean staticUV = true;
    private int treeID = -1;
    private Matrix mat = new Matrix();
    private Matrix mo = new Matrix();
    private String key = null;
    private int listID = 0;
    private int tex0 = -1;
    private int tex1 = -1;
    private int lastTex0 = -99;
    private int lastTex1 = -99;
    private Map vertex2index = null;
    private int rendererID = -999999999;
    private IRenderer lastRenderer = null;
    private boolean filled = false;
    private float[] dumpy = new float[16];
    private boolean needsCoordMapper = true;
    private int[] coordMapper = null;
    private float[] vcoords = null;
    private float[] ncoords = null;
    private TextureManager tm = TextureManager.getInstance();
    private boolean useVBO = Config.glUseVBO;
    private int normalsId = 0;
    private int tangentsId = 0;
    private int verticesId = 0;
    private int colorsId = 0;
    private int indicesId = 0;
    private int[] attributesIds = null;
    private int[] multiTexturesIds = null;
    private boolean buffersCreated = false;
    private boolean vboPossible = true;
    private int indexCount = 0;
    protected boolean hasBeenRefilled = false;
    private int useStrip = Config.glTriangleStrips ? 0 : 2;
    private int primitiveType = 4;

    CompiledInstance(Object3D object3D, int n, int n2) {
        this.obj = object3D;
        this.polyIndex = n;
        this.treeID = n2;
        this.dynamic = object3D.dynamic;
        this.useDL = (!this.dynamic || this.useVBO && Config.glUseDynamicVBO) && object3D.preferDLOrVBO;
        this.indexed = object3D.indexed;
        this.staticUV = object3D.staticUV;
    }

    void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public int getTreeID() {
        return this.treeID;
    }

    public int getPolyIndex() {
        return this.polyIndex;
    }

    public int getStageCount() {
        return this.endStage;
    }

    private void dispose(IRenderer iRenderer) {
        this.unloadDL(iRenderer);
        this.unloadVBO(iRenderer);
        IRenderHook iRenderHook = this.obj.getHookInternal();
        if (iRenderHook != null) {
            iRenderHook.onDispose();
        }
    }

    private void unloadVBO(IRenderer iRenderer) {
        if (this.buffersCreated) {
            try {
                if (iRenderer instanceof GLBase) {
                    if (this.obj.shareWith == null) {
                        GLBase gLBase = (GLBase)((Object)iRenderer);
                        gLBase.removeBuffer(this.normalsId);
                        gLBase.removeBuffer(this.verticesId);
                        gLBase.removeBuffer(this.tangentsId);
                        gLBase.removeBuffer(this.colorsId);
                        gLBase.removeBuffer(this.indicesId);
                        for (int i = 0; i < this.endStage; ++i) {
                            gLBase.removeBuffer(this.multiTexturesIds[i]);
                        }
                    }
                    this.buffersCreated = false;
                }
            }
            catch (Throwable throwable) {
                Logger.log("Failed to delete VBOs!", 1);
            }
        }
    }

    private void unloadDL(IRenderer iRenderer) {
        if (this.listID != 0) {
            try {
                if (iRenderer instanceof GLBase) {
                    if (this.obj.shareWith == null) {
                        ((GLBase)((Object)iRenderer)).remove(this.listID);
                    }
                    this.listID = 0;
                }
            }
            catch (Throwable throwable) {
                Logger.log("Failed to delete display list: " + this.listID, 1);
            }
        }
    }

    void copy(CompiledInstance compiledInstance) {
        int n;
        this.listID = compiledInstance.listID;
        this.colors = compiledInstance.colors;
        this.tris = compiledInstance.tris;
        this.normals = compiledInstance.normals;
        this.indices = compiledInstance.indices;
        this.vertices = compiledInstance.vertices;
        this.tangents = compiledInstance.tangents;
        this.attributes = compiledInstance.attributes;
        this.multiTextures = compiledInstance.multiTextures;
        this.vertex2index = compiledInstance.vertex2index;
        this.polyIndex = compiledInstance.polyIndex;
        this.useDL = compiledInstance.useDL;
        this.dynamic = compiledInstance.dynamic;
        this.cnt = compiledInstance.cnt;
        this.endStage = compiledInstance.endStage;
        this.indexed = compiledInstance.indexed;
        this.staticUV = compiledInstance.staticUV;
        this.treeID = compiledInstance.treeID;
        this.key = compiledInstance.key;
        this.primitiveType = compiledInstance.primitiveType;
        this.buffersCreated = compiledInstance.buffersCreated;
        this.verticesId = compiledInstance.verticesId;
        this.normalsId = compiledInstance.normalsId;
        this.tangentsId = compiledInstance.tangentsId;
        this.indicesId = compiledInstance.indicesId;
        this.vboPossible = compiledInstance.vboPossible;
        this.colorsId = compiledInstance.colorsId;
        this.indexCount = compiledInstance.indexCount;
        this.useVBO = compiledInstance.useVBO;
        if (compiledInstance.multiTexturesIds != null) {
            this.multiTexturesIds = new int[compiledInstance.multiTexturesIds.length];
            for (n = 0; n < compiledInstance.multiTexturesIds.length; ++n) {
                this.multiTexturesIds[n] = compiledInstance.multiTexturesIds[n];
            }
        }
        if (compiledInstance.attributesIds != null) {
            this.attributesIds = new int[compiledInstance.attributesIds.length];
            n = 0;
            for (int i = 0; i < compiledInstance.attributesIds.length; ++i) {
                this.attributesIds[i] = compiledInstance.attributesIds[i];
            }
        }
        if (this.buffersCreated) {
            Logger.log("Object '" + this.obj.getName() + "' shares VBOs with object '" + this.obj.shareWith.getName() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void render(int n, GLBase gLBase, FloatBuffer floatBuffer, float[] fArray, boolean bl, Camera camera, float[][] fArray2, boolean bl2, Object[] objectArray) {
        Object object = SYNC;
        synchronized (object) {
            IRenderHook iRenderHook;
            int n2;
            boolean bl3;
            Object object2;
            int n3;
            int n4;
            boolean bl4;
            if (n != lastGlobalRenderer) {
                lastObj = null;
                lastVertexBuffer = null;
                chkSum = 0.0;
                lastLightCnt = 0;
                lastGlobalRenderer = n;
            }
            Matrix matrix = null;
            World world = this.obj.myWorld;
            if (world == null) {
                return;
            }
            boolean bl5 = this.obj.reverseCulling ^ world.invertCulling;
            boolean bl6 = bl4 = this.tangents != null || this.tangentsId != 0;
            if (objectArray != null) {
                matrix = (Matrix)objectArray[0];
                bl5 = (Boolean)objectArray[1];
            }
            if (this.obj.shareWith != null && !this.obj.sharing) {
                if (this.obj.shareWith.compiled == null) {
                    Logger.log("Can't use an uncompiled object as a source for compiled data!", 0);
                    return;
                }
                n4 = ((CompiledInstance)this.obj.shareWith.compiled.get((int)0)).rendererID;
                if (n4 != -999999999 && n4 != n && this.useDL) {
                    Logger.log("Master object has been compiled within a different gl context...can't share data with it, skipping rendering!", 0);
                    return;
                }
                if (this.mayShare) {
                    this.obj.sharing = true;
                    if (this.obj.compiled.size() != this.obj.shareWith.compiled.size()) {
                        Logger.log("Number of compiled instances don't match...can't share data!", 0);
                        return;
                    }
                    for (n3 = 0; n3 < this.obj.compiled.size(); n3 += 1) {
                        object2 = (CompiledInstance)this.obj.compiled.get(n3);
                        CompiledInstance compiledInstance = (CompiledInstance)this.obj.shareWith.compiled.get(n3);
                        if (this.useVBO && this.vboPossible && !this.dynamic) {
                            compiledInstance.compileToVBO();
                        }
                        object2.copy(compiledInstance);
                        object2.filled = true;
                    }
                    Logger.log("Object '" + this.obj.getName() + "' shares compiled data with object '" + this.obj.shareWith.getName() + "'", 2);
                }
            }
            if (!this.filled) {
                Logger.log("render() called on an uncompiled object (" + this.obj.getName() + ")!", 0);
                return;
            }
            if (world == null || this.useDL && this.listID == 0 && !this.buffersCreated) {
                return;
            }
            n4 = world.lights.lightCnt;
            n3 = this.obj.hasVertexAlpha();
            gLBase.endState();
            if (floatBuffer != null) {
                floatBuffer.rewind();
            }
            if (this.rendererID == -999999999) {
                this.rendererID = n;
            } else if (this.rendererID != n && this.useDL && (this.listID != 0 || this.buffersCreated)) {
                if (this.lastRenderer != null && !this.obj.sharing) {
                    this.dispose(this.lastRenderer);
                }
                this.listID = 0;
                this.buffersCreated = false;
                Logger.log("OpenGL context has changed...trying to recover by reverting to normal VAs", 1);
            }
            this.lastRenderer = (IRenderer)((Object)gLBase);
            object2 = null;
            boolean bl7 = bl3 = this.obj.compiled.size() > 1;
            if (bl3) {
                object2 = (float[])gLBase.matrixCache.get(this.obj);
            }
            if (object2 == null) {
                if (matrix != null) {
                    this.mo.setTo(matrix);
                } else {
                    this.mo.setTo(this.obj.transBuffer);
                }
                this.mat.setTo(camera.getBack());
                this.mat.transformToGL();
                this.mo.translate(-camera.backBx, -camera.backBy, -camera.backBz);
                this.mo.matMul(this.mat);
                object2 = this.mo.fillDump(this.dumpy);
                if (bl3) {
                    gLBase.matrixCache.put(this.obj, object2);
                }
            }
            floatBuffer64.put((float[])object2);
            floatBuffer64.rewind();
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            boolean bl8 = false;
            if (this.obj.doCulling) {
                if (bl5) {
                    GL11.glCullFace((int)1028);
                    bl8 = true;
                }
            } else {
                GL11.glDisable((int)2884);
            }
            if (!bl2) {
                float[] fArray3;
                if (n3) {
                    fArray[3] = 1.0f;
                }
                floatBuffer16_2.put(fArray);
                floatBuffer16_2.rewind();
                GL11.glLightModel((int)2899, (FloatBuffer)floatBuffer);
                GL11.glMaterial((int)1032, (int)5632, (FloatBuffer)floatBuffer16_2);
                double d = 0.0;
                for (n2 = 0; n2 < n4 && n2 < 8 && (fArray3 = fArray2[n2])[0] != -9999.0f; ++n2) {
                    d += ((double)n2 + (double)0.7181f) * (double)fArray3[0];
                    d += ((double)n2 + (double)1.1f) * (double)fArray3[1];
                    d += ((double)n2 + (double)2.24f) * (double)fArray3[2];
                    d += ((double)n2 + (double)3.567f) * (double)fArray3[3];
                    d += ((double)n2 + (double)9.7272f) * (double)(fArray3[4] + 1.4f * fArray3[5] + 4.56f * fArray3[6]);
                }
                if (n3) {
                    GL11.glColorMaterial((int)1032, (int)4609);
                    GL11.glEnable((int)2903);
                }
                if (chkSum != d || lastObj != this.obj) {
                    floatBuffer16_2.put(ALL_ONES);
                    floatBuffer16_2.rewind();
                    GL11.glMaterial((int)1032, (int)4608, (FloatBuffer)floatBuffer16_2);
                    GL11.glMaterial((int)1032, (int)4609, (FloatBuffer)floatBuffer16_2);
                    GL11.glMaterial((int)1032, (int)4610, (FloatBuffer)floatBuffer16_2);
                    GL11.glLightModeli((int)2897, (int)1);
                    if (n4 < lastLightCnt) {
                        for (n2 = 0; n2 < lastLightCnt; ++n2) {
                            GL11.glDisable((int)LIGHTS[n2]);
                        }
                    }
                    lastLightCnt = 0;
                    for (n2 = 0; n2 < n4 && n2 < 8; ++n2) {
                        boolean bl9;
                        fArray3 = fArray2[n2];
                        int n5 = LIGHTS[n2];
                        if (fArray3[0] == -9999.0f) {
                            GL11.glDisable((int)n5);
                            continue;
                        }
                        ++lastLightCnt;
                        boolean bl10 = bl9 = chkSum != d || lastObj != this.obj;
                        if (bl9) {
                            GL11.glEnable((int)n5);
                            floatBuffer16_2.put(fArray3[1]);
                            floatBuffer16_2.put(fArray3[2]);
                            floatBuffer16_2.put(fArray3[3]);
                            floatBuffer16_2.put(1.0f);
                            floatBuffer16_2.rewind();
                            GL11.glLight((int)n5, (int)4611, (FloatBuffer)floatBuffer16_2);
                            floatBuffer16_2.put(fArray3[4]);
                            floatBuffer16_2.put(fArray3[5]);
                            floatBuffer16_2.put(fArray3[6]);
                            floatBuffer16_2.put(1.0f);
                            floatBuffer16_2.rewind();
                            GL11.glLight((int)n5, (int)4609, (FloatBuffer)floatBuffer16_2);
                            ZEROS_ONE.rewind();
                            GL11.glLight((int)n5, (int)4608, (FloatBuffer)ZEROS_ONE);
                            if (fArray3[0] >= 0.0f) {
                                float f = fArray3[0];
                                if (f == 0.0f) {
                                    f = 0.001f;
                                }
                                GL11.glLightf((int)n5, (int)4616, (float)(4.0f / f));
                            } else {
                                GL11.glLightf((int)n5, (int)4616, (float)0.0f);
                            }
                        }
                        if (!this.obj.doSpecularLighting) {
                            ZEROS_ONE.rewind();
                            GL11.glLight((int)n5, (int)4610, (FloatBuffer)ZEROS_ONE);
                            continue;
                        }
                        GL11.glMateriali((int)1032, (int)5633, (int)((int)(Config.specPow / 2.0f)));
                        if (!bl9) {
                            floatBuffer16_2.put(fArray3[4]);
                            floatBuffer16_2.put(fArray3[5]);
                            floatBuffer16_2.put(fArray3[6]);
                            floatBuffer16_2.put(1.0f);
                            floatBuffer16_2.rewind();
                        }
                        GL11.glLight((int)n5, (int)4610, (FloatBuffer)floatBuffer16_2);
                    }
                    chkSum = d;
                    lastObj = this.obj;
                }
                if (this.obj.isFlatShaded) {
                    GL11.glShadeModel((int)7424);
                }
            } else {
                GL11.glDisable((int)2896);
            }
            GL11.glLoadMatrix((FloatBuffer)floatBuffer64);
            if (bl) {
                GL11.glMatrixMode((int)5889);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-Config.glShadowZBias));
            }
            boolean bl11 = false;
            if (!this.useDL || this.listID == 0 && !this.buffersCreated) {
                if (lastVertexBuffer != this.vertices) {
                    lastVertexBuffer = this.vertices;
                    GL11.glNormalPointer((int)12, (FloatBuffer)this.normals);
                    GL11.glVertexPointer((int)3, (int)12, (FloatBuffer)this.vertices);
                    GL11.glEnableClientState((int)32885);
                    GL11.glEnableClientState((int)32884);
                    if (!n3) {
                        GL11.glDisableClientState((int)32886);
                        bl11 = true;
                    } else {
                        GL11.glColorPointer((int)4, (int)16, (FloatBuffer)this.colors);
                        GL11.glEnableClientState((int)32886);
                        bl11 = false;
                    }
                    for (int i = 0; i < this.endStage; ++i) {
                        ARBMultitexture.glClientActiveTextureARB((int)stageMap[i]);
                        GL11.glEnableClientState((int)32888);
                        GL11.glTexCoordPointer((int)2, (int)8, (FloatBuffer)this.multiTextures[i]);
                    }
                    IRenderHook iRenderHook2 = this.obj.getHookInternal();
                    if (!bl4) {
                        this.clearTangents(iRenderHook2);
                    } else {
                        this.setTangents(iRenderHook2);
                    }
                    if (this.attributes != null) {
                        for (n2 = 0; n2 < this.attributes.length; ++n2) {
                            this.bindVertexAttributes(iRenderHook2, (VertexAttributes)this.obj.objMesh.attrList.elementAt(n2), this.attributes[n2]);
                        }
                    }
                } else {
                    if (!n3) {
                        GL11.glDisableClientState((int)32886);
                        bl11 = true;
                    } else {
                        GL11.glEnableClientState((int)32886);
                        bl11 = false;
                    }
                    if (!bl4) {
                        this.clearTangents(this.obj.getHookInternal());
                    } else {
                        this.setTangents(this.obj.getHookInternal());
                    }
                    if (this.attributes != null) {
                        for (int i = 0; i < this.attributes.length; ++i) {
                            this.bindVertexAttributes(this.obj.getHookInternal(), (VertexAttributes)this.obj.objMesh.attrList.elementAt(i), this.attributes[i]);
                        }
                    }
                }
            }
            if (!(bl2 || !this.obj.isEnvmapped || Config.glForceEnvMapToSecondStage && this.endStage <= 1)) {
                if (this.tex0 == -1 || this.obj.texture[this.polyIndex] != this.lastTex0) {
                    this.lastTex0 = this.obj.texture[this.polyIndex];
                    this.tex0 = this.tm.getTextureByID(this.lastTex0).getOpenGLID(n);
                }
                if (Config.glForceEnvMapToSecondStage && (this.tex1 == -1 || this.obj.multiTex[0][this.polyIndex] != this.lastTex1) && this.endStage > 1) {
                    this.lastTex1 = this.obj.multiTex[0][this.polyIndex];
                    this.tex1 = this.tm.getTextureByID(this.lastTex1).getOpenGLID(n);
                }
                int n6 = this.tex0;
                n2 = 0;
                if (Config.glForceEnvMapToSecondStage) {
                    n6 = this.tex1;
                    n2 = 1;
                }
                if (!this.texGenEnabled) {
                    gLBase.bindTexture(n2, n6, false);
                    GL11.glTexGeni((int)8192, (int)9472, (int)9218);
                    GL11.glTexGeni((int)8193, (int)9472, (int)9218);
                    GL11.glEnable((int)3168);
                    GL11.glEnable((int)3169);
                    this.texGenEnabled = true;
                }
            }
            if ((iRenderHook = this.obj.getHookInternal()) != null) {
                iRenderHook.setTransparency(fArray != null ? fArray[3] : 1.0f);
                iRenderHook.setCurrentObject3D(this.obj);
                iRenderHook.beforeRendering(this.polyIndex);
                gLBase.lastHook = iRenderHook;
                if (iRenderHook instanceof GLSLShader) {
                    iRenderHook.setCurrentShader((GLSLShader)iRenderHook);
                } else {
                    iRenderHook.setCurrentShader(null);
                }
            }
            n2 = 0;
            if (this.useVBO && this.buffersCreated) {
                this.renderVBO(n3 != 0, iRenderHook);
            } else {
                do {
                    if (this.useDL && this.listID != 0) {
                        GL11.glCallList((int)this.listID);
                        continue;
                    }
                    if (this.indexed) {
                        GL11.glDrawElements((int)this.primitiveType, (IntBuffer)this.indices);
                    } else {
                        GL11.glDrawArrays((int)this.primitiveType, (int)0, (int)this.cnt);
                    }
                    n2 = 1;
                } while (iRenderHook != null && iRenderHook.repeatRendering());
                lastVertexBufferId = -1;
                if (n2 != 0) {
                    if (bl4) {
                        this.clearTangents(this.obj.getHookInternal());
                    }
                    if (this.attributes != null) {
                        for (int i = 0; i < this.attributes.length; ++i) {
                            this.unbindVertexAttributes(this.obj.getHookInternal(), (VertexAttributes)this.obj.objMesh.attrList.elementAt(i), this.attributes[i]);
                        }
                    }
                }
            }
            if (iRenderHook != null) {
                iRenderHook.afterRendering(this.polyIndex);
            }
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            if (bl) {
                GL11.glMatrixMode((int)5889);
                GL11.glPopMatrix();
            }
            if (n3) {
                GL11.glDisable((int)2903);
            }
            if (bl11) {
                GL11.glEnableClientState((int)32886);
            }
            if (bl8) {
                GL11.glCullFace((int)1029);
            }
            if (this.obj.isFlatShaded) {
                GL11.glShadeModel((int)7425);
            }
            if (bl2) {
                GL11.glEnable((int)2896);
            }
            if (!this.obj.doCulling) {
                GL11.glEnable((int)2884);
            }
            if (this.texGenEnabled) {
                GL11.glDisable((int)3168);
                GL11.glDisable((int)3169);
                this.texGenEnabled = false;
            }
        }
    }

    private void renderVBO(boolean bl, IRenderHook iRenderHook) {
        int n;
        boolean bl2;
        this.compileToVBO();
        boolean bl3 = bl2 = this.tangents != null || this.tangentsId != 0;
        if (lastVertexBufferId != this.verticesId) {
            lastVertexBufferId = this.verticesId;
            GL11.glEnableClientState((int)32885);
            GL15.glBindBuffer((int)34962, (int)this.normalsId);
            GL11.glNormalPointer((int)5126, (int)0, (long)0L);
            GL11.glEnableClientState((int)32884);
            GL15.glBindBuffer((int)34962, (int)this.verticesId);
            GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
            if (!bl) {
                GL11.glDisableClientState((int)32886);
            } else {
                GL15.glBindBuffer((int)34962, (int)this.colorsId);
                GL11.glEnableClientState((int)32886);
                GL11.glColorPointer((int)4, (int)5126, (int)0, (long)0L);
            }
            if (!bl2) {
                this.clearTangents(iRenderHook);
            } else {
                this.setTangents(iRenderHook);
            }
            if (this.attributesIds != null) {
                for (n = 0; n < this.attributesIds.length; ++n) {
                    this.bindVertexAttributes(iRenderHook, (VertexAttributes)this.obj.objMesh.attrList.elementAt(n), this.attributesIds[n]);
                }
            }
            for (n = 0; n < this.endStage; ++n) {
                ARBMultitexture.glClientActiveTextureARB((int)stageMap[n]);
                GL11.glEnableClientState((int)32888);
                GL15.glBindBuffer((int)34962, (int)this.multiTexturesIds[n]);
                GL11.glTexCoordPointer((int)2, (int)5126, (int)0, (long)0L);
            }
            GL15.glBindBuffer((int)34962, (int)0);
        } else {
            if (!bl) {
                GL11.glDisableClientState((int)32886);
            } else {
                GL15.glBindBuffer((int)34962, (int)this.colorsId);
                GL11.glEnableClientState((int)32886);
                GL11.glColorPointer((int)4, (int)5126, (int)16, (long)0L);
                GL15.glBindBuffer((int)34962, (int)0);
            }
            if (!bl2) {
                this.clearTangents(iRenderHook);
            } else {
                this.setTangents(iRenderHook);
            }
            if (this.attributesIds != null) {
                for (n = 0; n < this.attributesIds.length; ++n) {
                    this.bindVertexAttributes(iRenderHook, (VertexAttributes)this.obj.objMesh.attrList.elementAt(n), this.attributesIds[n]);
                }
            }
        }
        do {
            if (this.indexed) {
                GL15.glBindBuffer((int)34963, (int)this.indicesId);
                GL11.glDrawElements((int)this.primitiveType, (int)this.indexCount, (int)5125, (long)0L);
                GL15.glBindBuffer((int)34963, (int)0);
                continue;
            }
            GL11.glDrawArrays((int)this.primitiveType, (int)0, (int)this.cnt);
        } while (iRenderHook != null && iRenderHook.repeatRendering());
        if (bl2) {
            this.clearTangents(iRenderHook);
        }
        if (this.attributesIds != null) {
            for (n = 0; n < this.attributesIds.length; ++n) {
                this.unbindVertexAttributes(iRenderHook, (VertexAttributes)this.obj.objMesh.attrList.elementAt(n), this.attributesIds[n]);
            }
        }
        lastVertexBuffer = null;
    }

    private void bindVertexAttributes(IRenderHook iRenderHook, VertexAttributes vertexAttributes, int n) {
        if (iRenderHook != null && iRenderHook instanceof GLSLShader) {
            GLSLShader gLSLShader = (GLSLShader)iRenderHook;
            this.initShader(iRenderHook);
            int n2 = gLSLShader.getAttributeHandle(vertexAttributes.name);
            if (n2 != -1) {
                GL15.glBindBuffer((int)34962, (int)n);
                GL20.glEnableVertexAttribArray((int)n2);
                GL20.glVertexAttribPointer((int)n2, (int)vertexAttributes.type, (int)5126, (boolean)false, (int)(vertexAttributes.type * 4), (long)0L);
            }
        }
    }

    private void bindVertexAttributes(IRenderHook iRenderHook, VertexAttributes vertexAttributes, FloatBuffer floatBuffer) {
        if (iRenderHook != null && iRenderHook instanceof GLSLShader) {
            GLSLShader gLSLShader = (GLSLShader)iRenderHook;
            this.initShader(iRenderHook);
            int n = gLSLShader.getAttributeHandle(vertexAttributes.name);
            if (n != -1) {
                GL20.glEnableVertexAttribArray((int)n);
                GL20.glVertexAttribPointer((int)n, (int)vertexAttributes.type, (boolean)false, (int)(vertexAttributes.type * 4), (FloatBuffer)floatBuffer);
            }
        }
    }

    private void unbindVertexAttributes(IRenderHook iRenderHook, VertexAttributes vertexAttributes, int n) {
        if (iRenderHook != null && iRenderHook instanceof GLSLShader) {
            GLSLShader gLSLShader = (GLSLShader)iRenderHook;
            this.initShader(iRenderHook);
            int n2 = gLSLShader.getAttributeHandle(vertexAttributes.name);
            if (n2 != -1) {
                GL20.glDisableVertexAttribArray((int)n2);
                if (n > 0) {
                    GL15.glBindBuffer((int)34962, (int)0);
                }
            }
        }
    }

    private void unbindVertexAttributes(IRenderHook iRenderHook, VertexAttributes vertexAttributes, FloatBuffer floatBuffer) {
        if (iRenderHook != null && iRenderHook instanceof GLSLShader) {
            GLSLShader gLSLShader = (GLSLShader)iRenderHook;
            this.initShader(iRenderHook);
            int n = gLSLShader.getAttributeHandle(vertexAttributes.name);
            if (n != -1) {
                GL20.glDisableVertexAttribArray((int)n);
            }
        }
    }

    private void clearTangents(IRenderHook iRenderHook) {
        if (iRenderHook != null && iRenderHook instanceof GLSLShader) {
            GLSLShader gLSLShader = (GLSLShader)iRenderHook;
            this.initShader(iRenderHook);
            gLSLShader.clearTangents(this.tangents, this.tangentsId);
        }
    }

    private void setTangents(IRenderHook iRenderHook) {
        if (iRenderHook != null && iRenderHook instanceof GLSLShader) {
            GLSLShader gLSLShader = (GLSLShader)iRenderHook;
            this.initShader(iRenderHook);
            gLSLShader.setTangents(this.tangents, this.tangentsId);
        }
    }

    private void initShader(IRenderHook iRenderHook) {
        if (iRenderHook != null && iRenderHook instanceof GLSLShader) {
            GLSLShader gLSLShader = (GLSLShader)iRenderHook;
            gLSLShader.init();
        }
    }

    void add(int n) {
        this.tris.add(new Integer(n));
    }

    public void error(Exception exception) {
        Logger.log("Error while compiling instance!", 0);
        exception.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileToDL() {
        Object object = SYNC;
        synchronized (object) {
            int n;
            int n2;
            if (this.useVBO && !this.buffersCreated && this.useDL && this.listID == 0) {
                this.useVBO = GLContext.getCapabilities().OpenGL15;
            }
            if (this.useVBO && !this.buffersCreated) {
                this.compileToVBO();
                Logger.log("VBO created for object '" + this.obj.getName() + "'");
                return;
            }
            GL11.glNormalPointer((int)12, (FloatBuffer)this.normals);
            GL11.glVertexPointer((int)3, (int)12, (FloatBuffer)this.vertices);
            GL11.glEnableClientState((int)32885);
            GL11.glEnableClientState((int)32884);
            if (!this.obj.hasVertexAlpha()) {
                GL11.glDisableClientState((int)32886);
            } else {
                GL11.glColorPointer((int)4, (int)16, (FloatBuffer)this.colors);
                GL11.glEnableClientState((int)32886);
            }
            for (n2 = 0; n2 < this.endStage; ++n2) {
                ARBMultitexture.glClientActiveTextureARB((int)stageMap[n2]);
                GL11.glEnableClientState((int)32888);
                GL11.glTexCoordPointer((int)2, (int)8, (FloatBuffer)this.multiTextures[n2]);
            }
            n2 = this.tangents != null || this.tangentsId != 0 ? 1 : 0;
            IRenderHook iRenderHook = this.obj.getHookInternal();
            if (n2 == 0) {
                this.clearTangents(iRenderHook);
            } else {
                this.initShader(iRenderHook);
                this.setTangents(iRenderHook);
            }
            boolean bl = false;
            if (this.attributes != null && iRenderHook != null && iRenderHook instanceof GLSLShader) {
                this.initShader(iRenderHook);
                for (n = 0; n < this.attributes.length; ++n) {
                    this.bindVertexAttributes(this.obj.getHookInternal(), (VertexAttributes)this.obj.objMesh.attrList.elementAt(n), this.attributes[n]);
                }
                bl = true;
            }
            GL11.glFlush();
            GL11.glFinish();
            n = GL11.glGenLists((int)1);
            GL11.glNewList((int)n, (int)4864);
            if (this.indexed) {
                GL11.glDrawElements((int)this.primitiveType, (IntBuffer)this.indices);
            } else {
                GL11.glDrawArrays((int)this.primitiveType, (int)0, (int)this.cnt);
            }
            GL11.glEndList();
            GL11.glFlush();
            GL11.glFinish();
            this.listID = n;
            if (this.attributes != null && bl) {
                for (int i = 0; i < this.attributes.length; ++i) {
                    this.unbindVertexAttributes(this.obj.getHookInternal(), (VertexAttributes)this.obj.objMesh.attrList.elementAt(i), this.attributes[i]);
                }
            }
            GL11.glEnableClientState((int)32886);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill() {
        if (this.obj.shareWith != null && this.mayShare) {
            return;
        }
        Object object = SYNC;
        synchronized (object) {
            if (this.useStrip == 0) {
                this.checkStrips();
            }
            this.hasBeenRefilled = true;
            long l = System.currentTimeMillis();
            if (this.tris != null) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6 = this.tris.size() * 3;
                boolean bl = false;
                if (this.normals == null) {
                    int n7;
                    int n8;
                    bl = true;
                    this.normals = BufferUtils.getByteBuffer(n6 * 3 * 4).asFloatBuffer();
                    this.vertices = BufferUtils.getByteBuffer(n6 * 3 * 4).asFloatBuffer();
                    if (this.obj.hasVertexAlpha()) {
                        this.colors = BufferUtils.getByteBuffer(n6 * 4 * 4).asFloatBuffer();
                    }
                    if (this.obj.objMesh.tangentVectors != null) {
                        this.tangents = BufferUtils.getByteBuffer(n6 * 4 * 4).asFloatBuffer();
                    }
                    if (this.obj.objMesh.attrList != null) {
                        n8 = this.obj.objMesh.attrList.size();
                        this.attributes = new FloatBuffer[n8];
                        for (n7 = 0; n7 < n8; ++n7) {
                            this.attributes[n7] = ByteBuffer.allocateDirect(n6 * ((VertexAttributes)this.obj.objMesh.attrList.elementAt((int)n7)).type * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
                        }
                    }
                    if (this.indexed) {
                        this.indices = BufferUtils.getByteBuffer(n6 * 4).asIntBuffer();
                        this.vertex2index = new HashMap();
                    }
                    n8 = 1;
                    if (this.obj.multiTex != null) {
                        for (n7 = 0; n7 < this.obj.multiTex.length && this.obj.multiTex[n7][this.polyIndex] != -1; ++n7) {
                            ++n8;
                        }
                    }
                    this.endStage = n8;
                    if (Config.glOverrideStageCount != -1 && Config.glOverrideStageCount < this.endStage) {
                        this.endStage = Config.glOverrideStageCount;
                    }
                    if (this.endStage > Config.glStageCount) {
                        this.endStage = Config.glStageCount;
                    }
                    this.multiTextures = new FloatBuffer[this.endStage];
                    for (n7 = 0; n7 < this.endStage; ++n7) {
                        this.multiTextures[n7] = BufferUtils.getByteBuffer(n6 * 2 * 4).asFloatBuffer();
                    }
                }
                Vectors vectors = this.obj.objVectors;
                Mesh mesh = this.obj.objMesh;
                int[][] nArray = mesh.points;
                float[] fArray = mesh.xOrg;
                float[] fArray2 = mesh.yOrg;
                float[] fArray3 = mesh.zOrg;
                float[] fArray4 = mesh.nxOrg;
                float[] fArray5 = mesh.nyOrg;
                float[] fArray6 = mesh.nzOrg;
                float[] fArray7 = vectors.nuOrg;
                float[] fArray8 = vectors.nvOrg;
                this.cnt = 0;
                if (this.vertex2index != null) {
                    this.vertex2index.clear();
                }
                int n9 = this.tris.size();
                int n10 = 0;
                ArrayList<Integer> arrayList = null;
                if (this.dynamic && bl && this.colors == null && this.coordMapper == null && mesh.attrList == null) {
                    arrayList = new ArrayList<Integer>();
                }
                float[][] fArray9 = this.obj.objMesh.tangentVectors;
                if (this.coordMapper != null && this.staticUV) {
                    n9 = this.coordMapper.length;
                    if (this.vcoords != null) {
                        n5 = 0;
                        n4 = 0;
                        if (this.needsCoordMapper) {
                            for (int i = 0; i < n9; ++i) {
                                n4 = this.coordMapper[i];
                                this.vcoords[n5] = fArray[n4];
                                this.ncoords[n5++] = fArray4[n4];
                                this.vcoords[n5] = fArray2[n4];
                                this.ncoords[n5++] = fArray5[n4];
                                this.vcoords[n5] = fArray3[n4];
                                this.ncoords[n5++] = fArray6[n4];
                            }
                            this.cnt = n9;
                        } else {
                            for (n4 = 0; n4 < n9; ++n4) {
                                this.vcoords[n5] = fArray[n4];
                                this.ncoords[n5++] = fArray4[n4];
                                this.vcoords[n5] = fArray2[n4];
                                this.ncoords[n5++] = fArray5[n4];
                                this.vcoords[n5] = fArray3[n4];
                                this.ncoords[n5++] = fArray6[n4];
                            }
                            this.cnt = n9;
                        }
                        this.vertices.put(this.vcoords);
                        this.normals.put(this.ncoords);
                    }
                } else {
                    for (n5 = 0; n5 < n9; ++n5) {
                        n10 = (Integer)this.tris.get(n5);
                        n4 = 0;
                        if (n5 > 0 && this.useStrip == 1) {
                            n4 = 2;
                        }
                        for (int i = n4; i < 3; ++i) {
                            int n11;
                            n3 = nArray[n10][i];
                            n2 = mesh.coords[n3];
                            if (!this.indexed) {
                                if (arrayList != null) {
                                    arrayList.add(IntegerC.valueOf(n2));
                                }
                                this.fillAttributes(bl, vectors, fArray, fArray2, fArray3, fArray4, fArray5, fArray6, fArray9, n3, n2);
                                continue;
                            }
                            GenericContainer genericContainer = new GenericContainer(11);
                            genericContainer.add(fArray[n2]);
                            genericContainer.add(fArray2[n2]);
                            genericContainer.add(fArray3[n2]);
                            genericContainer.add(fArray4[n2]);
                            genericContainer.add(fArray5[n2]);
                            genericContainer.add(fArray6[n2]);
                            for (n11 = 0; n11 < this.endStage; ++n11) {
                                if (n11 == 0) {
                                    fArray7 = vectors.nuOrg;
                                    fArray8 = vectors.nvOrg;
                                    genericContainer.add(fArray7[n3]);
                                    genericContainer.add(fArray8[n3]);
                                    continue;
                                }
                                if (this.obj.maxStagesUsed <= 1) continue;
                                fArray7 = vectors.uMul[n11 - 1];
                                fArray8 = vectors.vMul[n11 - 1];
                                genericContainer.add(fArray7[n3]);
                                genericContainer.add(fArray8[n3]);
                            }
                            if (this.colors != null) {
                                genericContainer.add(vectors.alpha[n3]);
                            }
                            n11 = n5 == n9 - 1 && i == 2 ? 1 : 0;
                            Integer n12 = (Integer)this.vertex2index.get(genericContainer);
                            if (n12 == null) {
                                if (arrayList != null) {
                                    arrayList.add(IntegerC.valueOf(n2));
                                }
                                this.fillAttributes(bl, vectors, fArray, fArray2, fArray3, fArray4, fArray5, fArray6, fArray9, n3, n2);
                                int n13 = (this.vertices.position() - 3) / 3;
                                this.vertex2index.put(genericContainer, IntegerC.valueOf(n13));
                                this.indices.put(n13);
                                continue;
                            }
                            this.indices.put(n12);
                        }
                        if (n5 == 0 || this.useStrip == 2) {
                            this.cnt += 3;
                            continue;
                        }
                        ++this.cnt;
                    }
                    if (this.indices != null) {
                        this.indexCount = this.indices.position();
                        if (this.indexCount != this.indices.limit()) {
                            this.indices = (IntBuffer)this.indices.flip();
                        }
                    }
                    if (arrayList != null) {
                        n5 = arrayList.size();
                        Logger.log("Remapping " + n5 + " vertex indices!", 2);
                        this.coordMapper = new int[n5];
                        if (this.dynamic) {
                            Logger.log("Creating vertex cache (" + n5 * 24 + " bytes)!", 2);
                            this.vcoords = new float[n5 * 3];
                            this.ncoords = new float[n5 * 3];
                        }
                        n4 = 0;
                        this.needsCoordMapper = false;
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            this.coordMapper[n4] = (Integer)iterator.next();
                            if (this.coordMapper[n4] != n4) {
                                this.needsCoordMapper = true;
                            }
                            ++n4;
                        }
                        if (this.needsCoordMapper) {
                            Logger.log("Vertex indices will be mapped!", 2);
                        } else {
                            Logger.log("Vertex indices will be accessed directly!", 2);
                        }
                        arrayList = null;
                    }
                }
                n5 = this.vertices.position();
                n4 = this.multiTextures[0].position();
                int[] nArray2 = null;
                if (this.attributes != null) {
                    nArray2 = new int[this.attributes.length];
                }
                n3 = 0;
                if (this.colors != null) {
                    n3 = this.colors.position();
                    this.colors.rewind();
                }
                n2 = 0;
                if (this.tangents != null) {
                    n2 = this.tangents.position();
                    this.tangents.rewind();
                }
                if (this.attributes != null) {
                    for (int i = 0; i < this.attributes.length; ++i) {
                        nArray2[i] = this.attributes[i].position();
                        this.attributes[i].rewind();
                    }
                }
                this.vertices.rewind();
                this.normals.rewind();
                for (n = 0; n < this.endStage; ++n) {
                    this.multiTextures[n].rewind();
                }
                if (this.indices != null) {
                    this.indices.rewind();
                }
                if (bl) {
                    if (!this.dynamic) {
                        this.tris = null;
                        this.vertex2index = null;
                        if (this.indexed) {
                            this.normals = this.flip(this.normals, n5);
                            this.vertices = this.flip(this.vertices, n5);
                            if (this.colors != null) {
                                this.colors = this.flip(this.colors, n3);
                            }
                            if (this.tangents != null) {
                                this.tangents = this.flip(this.tangents, n2);
                            }
                            if (this.attributes != null) {
                                for (n = 0; n < this.attributes.length; ++n) {
                                    this.attributes[n] = this.flip(this.attributes[n], nArray2[n]);
                                }
                            }
                            for (n = 0; n < this.endStage; ++n) {
                                this.multiTextures[n] = this.flip(this.multiTextures[n], n4);
                            }
                        }
                    }
                    Logger.log("Subobject of object " + this.obj.getID() + "/" + this.obj.getName() + " compiled to " + (this.obj.indexed ? "indexed" : "flat") + " data using " + this.cnt + "/" + this.vertices.limit() / 3 + " vertices " + (this.useStrip == 1 ? "in a strip " : "") + "in " + (System.currentTimeMillis() - l) + "ms!", 2);
                }
            }
            this.filled = true;
        }
    }

    private void fillAttributes(boolean bl, Vectors vectors, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, float[][] fArray7, int n, int n2) {
        Object object;
        this.vertices.put(fArray[n2]);
        this.vertices.put(fArray2[n2]);
        this.vertices.put(fArray3[n2]);
        this.normals.put(fArray4[n2]);
        this.normals.put(fArray5[n2]);
        this.normals.put(fArray6[n2]);
        if (this.colors != null) {
            this.colors.put(0.0f);
            this.colors.put(0.0f);
            this.colors.put(0.0f);
            this.colors.put(vectors.alpha[n]);
        }
        if (bl && this.tangents != null) {
            object = fArray7[n2];
            this.tangents.put(object[0]);
            this.tangents.put((float)object[1]);
            this.tangents.put((float)object[2]);
            this.tangents.put((float)object[3]);
        }
        if (this.obj.objMesh.attrList != null) {
            object = this.obj.objMesh.attrList;
            int n3 = ((Vector)object).size();
            for (int i = 0; i < n3; ++i) {
                VertexAttributes vertexAttributes = (VertexAttributes)((Vector)object).elementAt(i);
                int n4 = n2 * vertexAttributes.type;
                float[] fArray8 = vertexAttributes.data;
                if (vertexAttributes.type == 1) {
                    this.attributes[i].put(fArray8[n4]);
                    continue;
                }
                if (vertexAttributes.type == 2) {
                    this.attributes[i].put(fArray8[n4++]);
                    this.attributes[i].put(fArray8[n4]);
                    continue;
                }
                if (vertexAttributes.type == 3) {
                    this.attributes[i].put(fArray8[n4++]);
                    this.attributes[i].put(fArray8[n4++]);
                    this.attributes[i].put(fArray8[n4]);
                    continue;
                }
                if (vertexAttributes.type != 4) continue;
                this.attributes[i].put(fArray8[n4++]);
                this.attributes[i].put(fArray8[n4++]);
                this.attributes[i].put(fArray8[n4++]);
                this.attributes[i].put(fArray8[n4]);
            }
        }
        if (bl || !this.staticUV) {
            for (int i = 0; i < this.endStage; ++i) {
                float[] fArray9;
                float[] fArray10;
                if (i == 0) {
                    fArray10 = vectors.nuOrg;
                    fArray9 = vectors.nvOrg;
                    this.multiTextures[i].put(fArray10[n]);
                    this.multiTextures[i].put(fArray9[n]);
                    continue;
                }
                if (this.obj.maxStagesUsed <= 1) continue;
                fArray10 = vectors.uMul[i - 1];
                fArray9 = vectors.vMul[i - 1];
                this.multiTextures[i].put(fArray10[n]);
                this.multiTextures[i].put(fArray9[n]);
            }
        }
    }

    private void checkStrips() {
        int n;
        int n2;
        int n3;
        if (this.useStrip != 0) {
            Logger.log("Triangle strip checker has been called multiple times!", 1);
            return;
        }
        int n4 = this.tris.size();
        Vectors vectors = this.obj.objVectors;
        Mesh mesh = this.obj.objMesh;
        int[][] nArray = mesh.points;
        float[] fArray = mesh.xOrg;
        float[] fArray2 = mesh.yOrg;
        float[] fArray3 = mesh.zOrg;
        float[] fArray4 = vectors.nuOrg;
        float[] fArray5 = vectors.nvOrg;
        Logger.log("Checking for triangle strip...");
        float[][] fArrayArray = new float[3][];
        float[][] fArrayArray2 = new float[3][];
        if (n4 > 0) {
            n3 = (Integer)this.tris.get(0);
            for (n2 = 0; n2 < 3; ++n2) {
                n = mesh.coords[nArray[n3][n2]];
                fArrayArray[n2] = new float[]{fArray[n], fArray2[n], fArray3[n], fArray4[n], fArray5[n]};
                fArrayArray2[n2] = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            }
        } else {
            this.useStrip = 2;
            return;
        }
        n3 = 0;
        for (n2 = 1; n2 < n4; ++n2) {
            int n5;
            n = (Integer)this.tris.get(n2);
            for (n5 = 0; n5 < 3; ++n5) {
                int n6 = nArray[n][n5];
                int n7 = mesh.coords[n6];
                fArrayArray2[n5][0] = fArray[n7];
                fArrayArray2[n5][1] = fArray2[n7];
                fArrayArray2[n5][2] = fArray3[n7];
                fArrayArray2[n5][3] = fArray4[n7];
                fArrayArray2[n5][4] = fArray5[n7];
            }
            if (n3 == 0) {
                int n8 = n5 = this.compare(fArrayArray[1], fArrayArray2[1]) && this.compare(fArrayArray[2], fArrayArray2[0]) ? 1 : 0;
                if (n5 == 0) {
                    this.useStrip = 2;
                    Logger.log("Not a triangle strip at position " + n2 + "!");
                    return;
                }
                n3 = 1;
            } else {
                int n9 = n5 = this.compare(fArrayArray[0], fArrayArray2[0]) && this.compare(fArrayArray[2], fArrayArray2[1]) ? 1 : 0;
                if (n5 == 0) {
                    this.useStrip = 2;
                    Logger.log("Not a triangle strip at position " + n2 + "!");
                    return;
                }
                n3 = 0;
            }
            float[][] fArrayArray3 = fArrayArray;
            fArrayArray = fArrayArray2;
            fArrayArray2 = fArrayArray3;
        }
        this.useStrip = 1;
        this.primitiveType = 5;
        Logger.log("Triangle strip found!");
    }

    private boolean compare(float[] fArray, float[] fArray2) {
        for (int i = 0; i < 5; ++i) {
            if (fArray[i] == fArray2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFilled() {
        Object object = SYNC;
        synchronized (object) {
            return this.filled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReFilled() {
        Object object = SYNC;
        synchronized (object) {
            return this.hasBeenRefilled;
        }
    }

    private FloatBuffer flip(FloatBuffer floatBuffer, int n) {
        FloatBuffer floatBuffer2 = BufferUtils.getByteBuffer(n * 4).asFloatBuffer();
        floatBuffer.rewind();
        for (int i = 0; i < n; ++i) {
            floatBuffer2.put(floatBuffer.get());
        }
        floatBuffer2.rewind();
        return floatBuffer2;
    }

    protected void compileToVBO() {
        if (this.dynamic && this.obj.sharing) {
            List list = this.obj.shareWith.compiled;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                CompiledInstance compiledInstance = (CompiledInstance)list.get(i);
                if (!compiledInstance.isReFilled()) continue;
                compiledInstance.compileToVBO();
            }
            return;
        }
        if (!(this.dynamic || !this.buffersCreated && this.useVBO)) {
            return;
        }
        if (this.dynamic && !this.hasBeenRefilled) {
            return;
        }
        this.hasBeenRefilled = false;
        this.buffersCreated = true;
        int n = 35044;
        if (this.dynamic) {
            n = 35048;
        }
        if (this.normalsId == 0) {
            int n2;
            if (this.attributes != null) {
                this.attributesIds = new int[this.attributes.length];
            }
            IntBuffer intBuffer = BufferUtils.getByteBuffer(4).asIntBuffer();
            GL15.glGenBuffers((IntBuffer)intBuffer);
            this.normalsId = intBuffer.get(0);
            intBuffer.rewind();
            GL15.glGenBuffers((IntBuffer)intBuffer);
            this.verticesId = intBuffer.get(0);
            if (this.colors != null) {
                intBuffer.rewind();
                GL15.glGenBuffers((IntBuffer)intBuffer);
                this.colorsId = intBuffer.get(0);
            }
            this.multiTexturesIds = new int[this.endStage];
            for (n2 = 0; n2 < this.endStage; ++n2) {
                intBuffer.rewind();
                GL15.glGenBuffers((IntBuffer)intBuffer);
                this.multiTexturesIds[n2] = intBuffer.get(0);
            }
            if (this.indexed) {
                intBuffer.rewind();
                GL15.glGenBuffers((IntBuffer)intBuffer);
                this.indicesId = intBuffer.get(0);
            }
            if (this.tangents != null) {
                intBuffer.rewind();
                GL15.glGenBuffers((IntBuffer)intBuffer);
                this.tangentsId = intBuffer.get(0);
            }
            if (this.attributes != null) {
                for (n2 = 0; n2 < this.attributesIds.length; ++n2) {
                    intBuffer.rewind();
                    GL15.glGenBuffers((IntBuffer)intBuffer);
                    this.attributesIds[n2] = intBuffer.get(0);
                }
            }
        }
        this.normals.rewind();
        this.vertices.rewind();
        GL15.glBindBuffer((int)34962, (int)this.normalsId);
        GL15.glBufferData((int)34962, (FloatBuffer)this.normals, (int)n);
        GL15.glBindBuffer((int)34962, (int)this.verticesId);
        GL15.glBufferData((int)34962, (FloatBuffer)this.vertices, (int)n);
        if (this.normalsId == 0 || this.verticesId == 0) {
            this.bufferError();
        }
        if (this.colors != null) {
            this.colors.rewind();
            GL15.glBindBuffer((int)34962, (int)this.colorsId);
            GL15.glBufferData((int)34962, (FloatBuffer)this.colors, (int)n);
            if (this.colorsId == 0) {
                this.bufferError();
            }
        }
        if (this.tangents != null) {
            this.tangents.rewind();
            GL15.glBindBuffer((int)34962, (int)this.tangentsId);
            GL15.glBufferData((int)34962, (FloatBuffer)this.tangents, (int)n);
        }
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                GL15.glBindBuffer((int)34962, (int)this.attributesIds[i]);
                GL15.glBufferData((int)34962, (FloatBuffer)this.attributes[i], (int)n);
            }
            GL15.glBindBuffer((int)34962, (int)0);
        }
        for (int i = 0; i < this.endStage; ++i) {
            this.multiTextures[i].rewind();
            GL15.glBindBuffer((int)34962, (int)this.multiTexturesIds[i]);
            GL15.glBufferData((int)34962, (FloatBuffer)this.multiTextures[i], (int)n);
            if (this.multiTexturesIds[i] != 0) continue;
            this.bufferError();
        }
        GL15.glBindBuffer((int)34962, (int)0);
        if (this.indexed) {
            this.indices.rewind();
            GL15.glBindBuffer((int)34963, (int)this.indicesId);
            GL15.glBufferData((int)34963, (IntBuffer)this.indices, (int)n);
            GL15.glBindBuffer((int)34963, (int)0);
            if (this.indicesId == 0) {
                this.bufferError();
            }
        }
        if (!this.dynamic && this.useVBO) {
            this.normals = null;
            this.vertices = null;
            this.colors = null;
            this.multiTextures = null;
            this.indices = null;
        }
    }

    protected void bufferError() {
        new Exception().printStackTrace();
        if (this.useVBO) {
            Logger.log("Unable to initialize VBO!", 1);
        }
        this.useVBO = false;
    }

    public void finalize() {
        if (this.lastRenderer != null && !this.obj.sharing) {
            this.dispose(this.lastRenderer);
        }
    }

    static {
        ZEROS_ONE.put(0.0f);
        ZEROS_ONE.put(0.0f);
        ZEROS_ONE.put(0.0f);
        ZEROS_ONE.put(1.0f);
        ZEROS_ONE.rewind();
        lastObj = null;
        lastVertexBuffer = null;
        lastVertexBufferId = -1;
        chkSum = 0.0;
        lastLightCnt = 0;
        lastGlobalRenderer = -1;
    }
}

