/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.BufferUtils;
import com.threed.jpct.Camera;
import com.threed.jpct.CompiledInstance;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.GLHelper;
import com.threed.jpct.GLSLShader;
import com.threed.jpct.ICompiledInstance;
import com.threed.jpct.IPaintListener;
import com.threed.jpct.IPostProcessor;
import com.threed.jpct.IRenderHook;
import com.threed.jpct.IntegerC;
import com.threed.jpct.Interact2D;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.Polyline;
import com.threed.jpct.Projector;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.VideoMode;
import com.threed.jpct.World;
import java.awt.Color;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Util;
import org.lwjgl.util.glu.GLU;

abstract class GLBase {
    static final int MODE_SET_FRUSTUM = 0;
    static final int MODE_SWAP_BUFFERS = 1;
    static final int MODE_CLEAR = 2;
    static final int MODE_PRINT_LOGS = 3;
    static final int MODE_BLIT_TEXTURE = 4;
    static final int MODE_FLUSH = 5;
    static final int MODE_GRAB_SCREEN = 6;
    static final int MODE_BLIT_INT = 7;
    static final int MODE_END_STATE = 8;
    static final int MODE_SET_VIEWPORT = 9;
    static final int MODE_CHECK_EXT = 10;
    static final int MODE_RETURN_CANVAS = 11;
    static final int MODE_START_PAINTING = 12;
    static final int MODE_END_PAINTING = 13;
    static final int MODE_SET_CANVAS_MODE = 14;
    static final int MODE_CLEAR_ZBUFFER = 15;
    static final int MODE_POST_PROCESS = 16;
    static final int MODE_DISPOSE_PROCESSOR = 17;
    static final int MODE_SET_RENDER_TARGET = 18;
    static final int MODE_SET_CAMERA = 21;
    static final int MODE_SET_TEXTURE_PROJECTOR = 22;
    static final int MODE_REINIT = 23;
    static final int MODE_SET_LISTENER_STATE = 24;
    static final int MODE_GET_MAX_TEXTURE_SIZE = 25;
    static final int MODE_ADD_CLIPPING_PLANE = 26;
    static final int MODE_REMOVE_CLIPPING_PLANE = 27;
    static final int MODE_REVALIDATE = 28;
    static final int MODE_ENABLE_LINES = 29;
    static final int MODE_DISABLE_LINES = 30;
    static final int MODE_DRAW_LINES = 31;
    static final int SET_LINES_MATRIX = 32;
    static final int MODE_RENDER_TO_TARGET = 1000;
    static final int MODE_DISABLE_BLITTING = 33;
    static final int MODE_COMPILE_ALL = 34;
    protected static float COLOR_INV = 0.003921569f;
    protected static final int VERTEX_ARRAY_SIZE = 1000;
    protected static int[] stageMap = new int[]{33984, 33985, 33986, 33987};
    protected static int[] modeMap = new int[]{8448, 8448, 260, 7681, 3042, 34164, 34023, 8449};
    protected static int[] blendSrcMap = new int[]{0, 0, 1, 1, 0};
    protected static int[] blendDstMap = new int[]{768, 768, 1, 0, 769};
    private static final int NO_STATE = -999989;
    protected static int rendererID = 0;
    protected int myID;
    protected float lastFOV;
    protected boolean lastFOVMode = Config.autoMaintainAspectRatio;
    protected boolean init = false;
    protected int stateChanges = 0;
    protected World myWorld = null;
    protected IntBuffer pixelBuffer;
    protected int pixelBufferSize = 0;
    protected Texture blitBuffer;
    protected int blitBufferWidth = 0;
    protected int blitBufferHeight = 0;
    protected int currentRGBScaling = 1;
    protected TextureManager texMan = null;
    protected int curPos = 0;
    protected int colPos = 0;
    protected int vertPos = 0;
    protected int texPos = 0;
    protected int[] mtTexPos = null;
    protected boolean wasTransparent = false;
    protected int lastTransMode = 0;
    protected boolean vertexArraysInitialized = false;
    protected int xp;
    protected int yp;
    protected boolean textureMatrixSet = false;
    protected boolean disposed = false;
    protected IPaintListener listener = null;
    protected boolean listenerActive = true;
    protected float scaleX;
    protected float scaleY;
    protected float frustumOffsetX;
    protected float frustumOffsetY;
    protected boolean[] stageInitialized = new boolean[4];
    protected int[] lastTextures = new int[4];
    protected int maxStages = 0;
    protected int[] lastMultiTextures = new int[4];
    protected int[] lastIDs = new int[4];
    protected int[] lastMultiModes = new int[4];
    protected int[] lastMode = new int[4];
    protected int minDriverAndConfig = 0;
    protected int lastCoords = 1;
    protected int veryLastCoords = 1;
    protected int lastTexture;
    protected float lastFarPlane = -999.0f;
    protected float lastNearPlane = -999.0f;
    protected FloatBuffer colors = null;
    protected FloatBuffer vertices = null;
    protected FloatBuffer textures = null;
    protected DoubleBuffer clippingBuffer = null;
    protected FloatBuffer[] multiTextures = new FloatBuffer[4];
    protected Texture renderTarget = null;
    protected int yTargetStart = 0;
    protected Matrix textureScale = new Matrix();
    protected boolean[] projective = new boolean[4];
    protected boolean alphaTest = false;
    protected boolean useFBO = false;
    protected int fbo = -1;
    protected int fboTexture = -1;
    protected boolean fboDepthMode = false;
    protected Texture fboColorStorage = null;
    protected Texture fboDepthStorage = null;
    protected boolean blending = false;
    protected IRenderHook lastHook = null;
    private boolean hasOpenGL12 = false;
    private boolean[] buffersEnabled = new boolean[4];
    private boolean[] enabledStages = new boolean[4];
    private boolean singleTexturing = true;
    private int currentFogColor = -1;
    private boolean currentFoggingState = false;
    private float currentFogDistance = -1.0f;
    private int lastState = -999989;
    private int changeCnt = 0;
    private int supportsRGBScaling = 0;
    private int supportsShadowMapping = 0;
    private int textureBufferSize = 0;
    private IntBuffer smallBuffer = null;
    private ByteBuffer textureBuffer;
    private SimpleVector blitCoords1 = new SimpleVector();
    private SimpleVector blitCoords2 = new SimpleVector();
    private boolean depthBuffer = false;
    protected boolean blitMode = false;
    private boolean blitTrans = false;
    private boolean blitAdditive = false;
    private boolean scissorEnabled = false;
    private boolean scissorClearAll = true;
    private int blitScaling = 0;
    private float[] floatBuffer = new float[16];
    private Map fovMatrixCache = new HashMap();
    private FloatBuffer floatBuffer64 = BufferUtils.getByteBuffer(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private FloatBuffer floatBuffer16 = BufferUtils.getByteBuffer(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected FloatBuffer ambientBuffer = BufferUtils.getByteBuffer(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected float[] ambientTmp = new float[3];
    protected float[] colsTmp = new float[4];
    private Map toUnload = new HashMap();
    private List toRemove = new ArrayList();
    protected Map matrixCache = new HashMap();
    private List toDispose = new ArrayList();
    private List toDisposeVBO = new ArrayList();
    private Set toCompileToDLOrVBO = new HashSet();
    private boolean foggingOn = false;
    private FloatBuffer fogColors = BufferUtils.getByteBuffer(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private int lastWorldHash = 0;
    private float maxAniso = -1.0f;
    private GLSLShader blittingShader = null;

    protected GLBase() {
        float[] fArray = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f};
        this.textureScale.setDump(fArray);
        this.resetStates();
        this.myID = rendererID++;
        this.lastFOV = -999.0f;
        this.lastFarPlane = -999.0f;
        this.lastNearPlane = -999.0f;
        this.init = false;
        this.lastTexture = 0;
        this.stateChanges = 0;
        this.pixelBuffer = null;
        this.pixelBufferSize = 0;
        this.textureBuffer = null;
        this.textureBufferSize = 0;
        this.blitBuffer = null;
        this.blitBufferWidth = 0;
        this.blitBufferHeight = 0;
        this.supportsRGBScaling = 0;
        this.texMan = TextureManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int n) {
        GLBase gLBase = this;
        synchronized (gLBase) {
            this.toDispose.add(IntegerC.valueOf(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBuffer(int n) {
        GLBase gLBase = this;
        synchronized (gLBase) {
            this.toDisposeVBO.add(IntegerC.valueOf(n));
        }
    }

    protected void resetStates() {
        for (int i = 0; i < 4; ++i) {
            this.stageInitialized[i] = false;
            this.enabledStages[i] = false;
            this.buffersEnabled[i] = false;
            this.lastTextures[i] = 0;
            this.lastMultiTextures[i] = 0;
            this.lastIDs[i] = 0;
            this.lastMultiModes[i] = 0;
            this.lastMode[i] = -1;
        }
    }

    public final void setPaintListener(IPaintListener iPaintListener) {
        this.listener = iPaintListener;
    }

    public final boolean isInitialized() {
        return this.init;
    }

    public VideoMode[] getAvailableVideoModes() {
        try {
            DisplayMode[] displayModeArray = Display.getAvailableDisplayModes();
            VideoMode[] videoModeArray = new VideoMode[displayModeArray.length];
            for (int i = 0; i < displayModeArray.length; ++i) {
                if (displayModeArray[i] == null) continue;
                videoModeArray[i] = new VideoMode(displayModeArray[i].getWidth(), displayModeArray[i].getHeight(), displayModeArray[i].getBitsPerPixel(), Config.glZBufferDepth, displayModeArray[i].getFrequency());
            }
            return videoModeArray;
        }
        catch (Exception exception) {
            Logger.log("Couldn't get available video modes: " + exception.getMessage(), 0);
            return null;
        }
    }

    protected synchronized void addToCompile(ICompiledInstance iCompiledInstance) {
        this.toCompileToDLOrVBO.add(iCompiledInstance);
    }

    protected synchronized void removeToCompile(ICompiledInstance iCompiledInstance) {
        this.toCompileToDLOrVBO.remove(iCompiledInstance);
    }

    protected synchronized void compileDLOrVBO() {
        if (this.toCompileToDLOrVBO.size() != 0) {
            Iterator iterator = this.toCompileToDLOrVBO.iterator();
            while (iterator.hasNext()) {
                ICompiledInstance iCompiledInstance = (ICompiledInstance)iterator.next();
                if (!iCompiledInstance.isFilled()) {
                    Logger.log("Internal error: Unfilled object!", 0);
                }
                iCompiledInstance.compileToDL();
            }
            if (Config.glUseVBO) {
                Logger.log("Compiled " + this.toCompileToDLOrVBO.size() + " VBO!", 2);
            } else {
                Logger.log("Compiled " + this.toCompileToDLOrVBO.size() + " display lists!", 2);
            }
            this.toCompileToDLOrVBO.clear();
            this.renableVertexArrays();
        }
    }

    protected void unsetBlendingMode() {
        if (this.renderTarget == null || !this.renderTarget.isShadowMap) {
            GL11.glDisable((int)3042);
        } else {
            GL11.glDisable((int)3008);
            this.alphaTest = false;
        }
    }

    protected void setDepthBuffer() {
        if (this.renderTarget == null || !this.renderTarget.isShadowMap) {
            GL11.glDepthMask((boolean)false);
        }
    }

    protected void clear(Object[] objectArray) {
        if (this.scissorEnabled && this.scissorClearAll) {
            GL11.glDisable((int)3089);
        }
        int n = 256;
        if (!Config.isIndoor) {
            n |= 0x4000;
            if (objectArray != null) {
                Color color = (Color)objectArray[0];
                GL11.glClearColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
            } else {
                GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            }
        }
        GL11.glClear((int)n);
        if (this.scissorEnabled && this.scissorClearAll) {
            GL11.glEnable((int)3089);
        }
    }

    protected void clearZBufferOnly() {
        if (this.scissorEnabled && this.scissorClearAll) {
            GL11.glDisable((int)3089);
        }
        GL11.glClear((int)256);
        if (this.scissorEnabled && this.scissorClearAll) {
            GL11.glEnable((int)3089);
        }
    }

    protected void clearColorBufferOnly(Object object) {
        if (this.scissorEnabled && this.scissorClearAll) {
            GL11.glDisable((int)3089);
        }
        if (object != null) {
            Color color = (Color)object;
            GL11.glClearColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        } else {
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glClear((int)16384);
        if (this.scissorEnabled && this.scissorClearAll) {
            GL11.glEnable((int)3089);
        }
    }

    protected void setBlendingMode(int n) {
        if (this.renderTarget == null || !this.renderTarget.isShadowMap) {
            switch (n) {
                case 0: {
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    break;
                }
                case 1: {
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)1);
                }
            }
        } else {
            GL11.glAlphaFunc((int)518, (float)0.01f);
            GL11.glEnable((int)3008);
        }
    }

    protected void doPostProcessing(Object[] objectArray) {
        this.endState();
        IPostProcessor iPostProcessor = (IPostProcessor)objectArray[1];
        if (!iPostProcessor.isInitialized()) {
            iPostProcessor.init((FrameBuffer)objectArray[0]);
        }
        int n = this.currentRGBScaling;
        this.disableAllHigherStages();
        this.enableStage(0);
        if (this.projective[0]) {
            this.projective[0] = false;
            this.disableProjection();
        }
        this.setRGBScaling(1);
        if (this.renderTarget != null) {
            this.resetViewport((FrameBuffer)objectArray[0]);
        }
        this.lastTextures[0] = -1;
        this.switchTextureMode(0, modeMap[0]);
        iPostProcessor.process();
        if (this.renderTarget != null) {
            this.setViewport((FrameBuffer)objectArray[0]);
        }
        this.setRGBScaling(n);
    }

    protected void setTextureMatrix(Matrix matrix) {
        if (this.textureMatrixSet) {
            ARBMultitexture.glActiveTextureARB((int)stageMap[0]);
            GL11.glMatrixMode((int)5890);
            GL11.glPopMatrix();
            this.textureMatrixSet = false;
        }
        if (matrix != null) {
            ARBMultitexture.glActiveTextureARB((int)stageMap[0]);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            float[] fArray = matrix.getDump();
            this.floatBuffer64.rewind();
            this.floatBuffer64.put(fArray);
            this.floatBuffer64.rewind();
            GL11.glLoadMatrix((FloatBuffer)this.floatBuffer64);
            this.textureMatrixSet = true;
        }
    }

    protected void setRenderTarget(Object[] objectArray) {
        this.renderTarget = (Texture)objectArray[0];
        FrameBuffer frameBuffer = (FrameBuffer)objectArray[1];
        int n = (Integer)objectArray[2];
        int n2 = (Integer)objectArray[3];
        int n3 = (Integer)objectArray[4];
        int n4 = (Integer)objectArray[5];
        this.scissorClearAll = (Boolean)objectArray[6];
        if (this.renderTarget != null) {
            this.enableScissor(frameBuffer, this.renderTarget, n, n2, n3, n4);
        } else {
            this.disableScissor();
        }
        if (!this.useFBO) {
            if (this.renderTarget == null) {
                this.resetViewport(frameBuffer);
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            } else {
                this.setViewport(frameBuffer);
                if (this.renderTarget.isShadowMap) {
                    GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                }
            }
        } else if (this.renderTarget == null) {
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            if (this.fbo != -1) {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
                this.resetViewport(frameBuffer);
            }
        } else {
            if (this.fbo == -1 || this.fboTexture != this.renderTarget.getOpenGLID(this.myID) || this.fboDepthMode != this.renderTarget.isShadowMap) {
                IntBuffer intBuffer = this.getSmallBuffer();
                if (this.fbo != -1) {
                    intBuffer.put(this.fbo);
                    intBuffer.rewind();
                    EXTFramebufferObject.glDeleteFramebuffersEXT((IntBuffer)intBuffer);
                    intBuffer.rewind();
                    this.fbo = -1;
                }
                EXTFramebufferObject.glGenFramebuffersEXT((IntBuffer)intBuffer);
                this.fbo = intBuffer.get();
                if (this.renderTarget.getOpenGLID(this.myID) == 0) {
                    this.renderTarget.setMarker(this.myID, Texture.MARKER_NOTHING);
                    this.endState();
                    this.convertTexture(this.renderTarget);
                    this.lastTextures[0] = -1;
                }
                int n5 = this.renderTarget.getOpenGLID(this.myID);
                this.bindTexture(0, n5);
                this.fboTexture = this.renderTarget.getOpenGLID(this.myID);
                this.fboDepthMode = this.renderTarget.isShadowMap;
                int n6 = 36064;
                if (this.fboDepthMode) {
                    n6 = 36096;
                }
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.fbo);
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)n6, (int)3553, (int)n5, (int)0);
                if (this.fboDepthMode) {
                    if (this.fboColorStorage != null && (this.fboColorStorage.getHeight() != this.renderTarget.getHeight() || this.fboColorStorage.getWidth() != this.renderTarget.getWidth())) {
                        this.removeTexture(this.fboColorStorage);
                        this.fboColorStorage = null;
                    }
                    if (this.fboColorStorage == null) {
                        this.fboColorStorage = new Texture(this.renderTarget.getWidth(), this.renderTarget.getHeight(), null);
                        this.fboColorStorage.setGLFiltering(false);
                        this.fboColorStorage.setMipmap(false);
                        this.convertTexture(this.fboColorStorage);
                        this.fboColorStorage.texels = null;
                    }
                    int n7 = this.fboColorStorage.getOpenGLID(this.myID);
                    if (!Config.glIgnoreAlphaBlendingFBO) {
                        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)n7, (int)0);
                    }
                    GL11.glReadBuffer((int)0);
                    if (Config.glIgnoreAlphaBlendingFBO) {
                        GL11.glDrawBuffer((int)0);
                    }
                    GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                } else {
                    if (this.fboDepthStorage != null && (this.fboDepthStorage.getHeight() != this.renderTarget.getHeight() || this.fboDepthStorage.getWidth() != this.renderTarget.getWidth())) {
                        this.removeTexture(this.fboDepthStorage);
                        this.fboDepthStorage = null;
                    }
                    if (this.fboDepthStorage == null) {
                        this.fboDepthStorage = new Texture(this.renderTarget.getWidth(), this.renderTarget.getHeight(), null);
                        this.fboDepthStorage.setGLFiltering(false);
                        this.fboDepthStorage.setMipmap(false);
                        this.fboDepthStorage.setAsShadowMap(true);
                        this.convertTexture(this.fboDepthStorage);
                        this.fboDepthStorage.texels = null;
                    }
                    int n8 = this.fboDepthStorage.getOpenGLID(this.myID);
                    EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)n8, (int)0);
                    GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                }
                this.checkFrameBufferObject();
            } else {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.fbo);
            }
            GL11.glViewport((int)0, (int)0, (int)this.renderTarget.getWidth(), (int)this.renderTarget.getHeight());
        }
    }

    private void checkFrameBufferObject() {
        int n = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (n != 36053) {
            this.useFBO = false;
            this.fbo = -1;
        }
        switch (n) {
            case 36053: {
                break;
            }
            case 36054: {
                Logger.log("FrameBuffer: " + this.fbo + " has caused a GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT exception", 0);
                break;
            }
            case 36055: {
                Logger.log("FrameBuffer: " + this.fbo + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT exception", 0);
                break;
            }
            case 36057: {
                Logger.log("FrameBuffer: " + this.fbo + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT exception", 0);
                break;
            }
            case 36059: {
                Logger.log("FrameBuffer: " + this.fbo + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT exception", 0);
                break;
            }
            case 36058: {
                Logger.log("FrameBuffer: " + this.fbo + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT exception", 0);
                break;
            }
            case 36060: {
                Logger.log("FrameBuffer: " + this.fbo + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT exception", 0);
                break;
            }
            default: {
                Logger.log("Unexpected reply from glCheckFramebufferStatusEXT: " + n, 0);
            }
        }
    }

    protected Matrix createTextureProjectionMatrix(Camera camera, Texture texture) {
        float f = camera.getFOV();
        String string = new Float(f + 100.0f * camera.getYFOV()) + texture.toString();
        Matrix matrix = (Matrix)this.fovMatrixCache.get(string);
        if (matrix == null) {
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            float f2 = f;
            if (Config.autoMaintainAspectRatio) {
                f2 = f * ((float)texture.width / (float)texture.height);
            }
            if (camera.getYFOV() != -1.0f && (f2 = camera.getYFOV()) == 0.0f) {
                f2 = 1.0E-5f;
            }
            float f3 = Config.farPlane;
            float f4 = 1.0f;
            if (!Config.glIgnoreNearPlane) {
                f4 = Config.nearPlane;
            }
            float f5 = camera.applyOffsetY(f2 * 0.5f);
            float f6 = camera.applyOffsetY(-f2 * 0.5f);
            float f7 = camera.applyOffsetX(-f * 0.5f);
            float f8 = camera.applyOffsetX(f * 0.5f);
            GL11.glFrustum((double)f7, (double)f8, (double)f6, (double)f5, (double)f4, (double)f3);
            GL11.glGetFloat((int)2983, (FloatBuffer)this.floatBuffer64);
            GL11.glPopMatrix();
            this.floatBuffer64.rewind();
            matrix = new Matrix();
            float[] fArray = this.floatBuffer;
            for (int i = 0; i < 16; ++i) {
                fArray[i] = this.floatBuffer64.get(i);
            }
            matrix.setDump(fArray);
            if (this.fovMatrixCache.size() > 1000) {
                this.fovMatrixCache.clear();
            }
            this.fovMatrixCache.put(string, matrix);
        }
        return matrix;
    }

    protected void resetTextureStates() {
        for (int i = 0; i < 4; ++i) {
            this.lastTextures[i] = -1;
        }
    }

    protected void processProjection(int n, Texture texture, Camera camera) {
        if (texture.projector != null || texture.projectorBuffer != null) {
            int n2;
            Matrix matrix = new Matrix();
            Matrix matrix2 = null;
            SimpleVector simpleVector = camera.getPosition();
            matrix2 = camera.getBack().cloneMatrix();
            matrix2.transformToGL();
            matrix2 = matrix2.invert3x3();
            matrix2.mat[3][0] = simpleVector.x;
            matrix2.mat[3][1] = simpleVector.y;
            matrix2.mat[3][2] = simpleVector.z;
            Projector projector = texture.projectorBuffer;
            if (projector == null) {
                projector = texture.projector;
            }
            simpleVector = projector.getPosition();
            matrix.mat[3][0] = -simpleVector.x;
            matrix.mat[3][1] = -simpleVector.y;
            matrix.mat[3][2] = -simpleVector.z;
            matrix2.matMul(matrix);
            Matrix matrix3 = projector.getBack().cloneMatrix();
            matrix3.rotateX((float)Math.PI);
            matrix2.matMul(matrix3);
            matrix2.matMul(this.createTextureProjectionMatrix(projector, texture));
            matrix2.matMul(this.textureScale);
            float[] fArray = matrix2.getDump();
            this.floatBuffer16.rewind();
            for (n2 = 0; n2 < 4; ++n2) {
                this.floatBuffer16.put(fArray[n2 << 2]);
            }
            this.floatBuffer16.flip();
            GL11.glTexGeni((int)8192, (int)9472, (int)9216);
            GL11.glTexGen((int)8192, (int)9474, (FloatBuffer)this.floatBuffer16);
            GL11.glEnable((int)3168);
            this.floatBuffer16.rewind();
            for (n2 = 0; n2 < 4; ++n2) {
                this.floatBuffer16.put(fArray[1 + (n2 << 2)]);
            }
            this.floatBuffer16.flip();
            GL11.glTexGeni((int)8193, (int)9472, (int)9216);
            GL11.glTexGen((int)8193, (int)9474, (FloatBuffer)this.floatBuffer16);
            GL11.glEnable((int)3169);
            this.floatBuffer16.rewind();
            for (n2 = 0; n2 < 4; ++n2) {
                this.floatBuffer16.put(fArray[2 + (n2 << 2)]);
            }
            this.floatBuffer16.flip();
            GL11.glTexGeni((int)8194, (int)9472, (int)9216);
            GL11.glTexGen((int)8194, (int)9474, (FloatBuffer)this.floatBuffer16);
            GL11.glEnable((int)3170);
            this.floatBuffer16.rewind();
            for (n2 = 0; n2 < 4; ++n2) {
                this.floatBuffer16.put(fArray[3 + (n2 << 2)]);
            }
            this.floatBuffer16.flip();
            GL11.glTexGeni((int)8195, (int)9472, (int)9216);
            GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this.floatBuffer16);
            GL11.glEnable((int)3171);
            if (texture.getOpenGLID(this.myID) == 0) {
                texture.setMarker(this.myID, Texture.MARKER_NOTHING);
                this.endState();
                this.convertTexture(texture);
                this.lastTextures[0] = -1;
            }
            this.projective[n] = true;
            if (texture.isShadowMap) {
                this.enableShadowMapping(texture);
            }
        }
    }

    protected void enableShadowMapping(Texture texture) {
        if (this.renderTarget != texture) {
            GL11.glAlphaFunc((int)518, (float)0.01f);
            GL11.glEnable((int)3008);
            this.alphaTest = true;
        }
    }

    protected void disableProjection() {
        GL11.glDisable((int)3168);
        GL11.glDisable((int)3169);
        GL11.glDisable((int)3170);
        GL11.glDisable((int)3171);
    }

    protected void disableGlobalAlphaTest() {
        if (this.alphaTest) {
            GL11.glDisable((int)3008);
            this.alphaTest = false;
        }
    }

    protected void disableShadowMap() {
        this.disableGlobalAlphaTest();
    }

    protected boolean renderToTarget() {
        if (this.renderTarget == null) {
            return false;
        }
        if (this.useFBO) {
            return true;
        }
        this.disableUnusedStages();
        this.switchTextureMode(0, modeMap[0]);
        this.endState();
        int n = this.currentRGBScaling;
        this.setRGBScaling(1);
        if (this.renderTarget.getOpenGLID(this.myID) == 0) {
            this.renderTarget.setMarker(this.myID, Texture.MARKER_NOTHING);
            this.endState();
            this.convertTexture(this.renderTarget);
            this.lastTextures[0] = -1;
        }
        int n2 = this.renderTarget.getOpenGLID(this.myID);
        this.bindTexture(0, n2);
        if (this.renderTarget.isShadowMap) {
            if (this.supportsShadowMapping == 1) {
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)this.yTargetStart, (int)this.renderTarget.getWidth(), (int)this.renderTarget.getHeight());
            }
        } else if (Config.glFlipRenderTargets) {
            GLBase.toOrtho();
            GL11.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)0, (int)this.yTargetStart, (int)this.renderTarget.getWidth(), (int)this.renderTarget.getHeight(), (int)0);
            this.disableDepthBuffer();
            this.drawQuad();
            this.enableDepthBuffer();
            GL11.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)0, (int)this.yTargetStart, (int)this.renderTarget.getWidth(), (int)this.renderTarget.getHeight(), (int)0);
            GLBase.restorePerspectiveProjection();
        } else {
            GL11.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)0, (int)this.yTargetStart, (int)this.renderTarget.getWidth(), (int)this.renderTarget.getHeight(), (int)0);
        }
        this.setRGBScaling(n);
        return true;
    }

    protected void disableAllHigherStages() {
        for (int i = 1; i < this.maxStages; ++i) {
            this.disableStage(i);
        }
    }

    private void drawQuad() {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)-1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)-1.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
        GL11.glEnd();
    }

    private static void toOrtho() {
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)1.0, (double)0.0, (double)0.1, (double)100.0);
    }

    private static void restorePerspectiveProjection() {
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
    }

    protected final void init(boolean bl, int n, int n2) {
        if (bl) {
            GL11.glViewport((int)0, (int)0, (int)n, (int)n2);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glShadeModel((int)7425);
            GL11.glClearDepth((double)1.0);
            this.enableDepthBuffer();
            GL11.glDepthFunc((int)515);
            GL11.glHint((int)3152, (int)4354);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16640);
            this.initTextureStage(0);
            this.lastFOV = -999.0f;
            this.lastFarPlane = -999.0f;
            this.lastNearPlane = -999.0f;
            Config.glStageCount = this.minDriverAndConfig = this.getTextureStages();
            GLHelper.printDriver();
            this.hasOpenGL12 = GLContext.getCapabilities().OpenGL12;
            boolean bl2 = Config.glBlendingAffectsAlpha = GLContext.getCapabilities().GL_ARB_texture_env_combine && Config.glBlendingAffectsAlpha;
            if (Config.glBlendingAffectsAlpha) {
                Logger.log("GL_ARB_texture_env_combine supported and used!", 2);
            } else {
                Logger.log("GL_ARB_texture_env_combine not supported or disabled!", 2);
            }
            Config.glUseFBO = this.useFBO = GLContext.getCapabilities().GL_EXT_framebuffer_object && Config.glUseFBO;
            if (this.useFBO) {
                Logger.log("FBO supported and used!", 2);
            } else {
                Logger.log("FBO not supported or disabled!", 2);
            }
            if (Config.glUseVBO) {
                Config.glUseVBO = GLContext.getCapabilities().GL_ARB_vertex_buffer_object;
            }
            if (Config.glUseVBO) {
                Logger.log("VBO supported and used!", 2);
            } else {
                Logger.log("VBO not supported or disabled!", 2);
            }
            Logger.log("OpenGL renderer initialized (using " + this.minDriverAndConfig + " texture stages)", 2);
            GL11.glFinish();
            this.init = true;
        }
    }

    protected void reInit() {
        this.endState();
        if (this.depthBuffer && !GL11.glIsEnabled((int)2929)) {
            GL11.glEnable((int)2929);
        }
        if (this.enabledStages[0]) {
            ARBMultitexture.glActiveTextureARB((int)stageMap[0]);
            if (!GL11.glIsEnabled((int)3553)) {
                GL11.glEnable((int)3553);
                this.disableAllHigherStages();
            }
        }
    }

    protected void dispose() {
        if (!this.disposed) {
            Object object;
            this.disposed = true;
            this.init = false;
            this.lastFOV = -999.0f;
            this.lastFarPlane = -999.0f;
            this.lastNearPlane = -999.0f;
            this.lastTexture = 0;
            this.pixelBuffer = null;
            this.textureBuffer = null;
            this.blitBuffer = null;
            this.listener = null;
            try {
                if (this.useFBO && this.fbo != -1) {
                    object = this.getSmallBuffer();
                    if (this.fbo != -1) {
                        ((IntBuffer)object).put(this.fbo);
                        ((IntBuffer)object).rewind();
                        EXTFramebufferObject.glDeleteFramebuffersEXT((IntBuffer)object);
                    }
                    if (this.fboColorStorage != null) {
                        this.removeTexture(this.fboColorStorage);
                        this.fboColorStorage = null;
                    }
                    if (this.fboDepthStorage != null) {
                        this.removeTexture(this.fboDepthStorage);
                        this.fboDepthStorage = null;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = TextureManager.getInstance().textures;
            for (int i = 0; i < ((Texture[])object).length; ++i) {
                try {
                    this.removeTexture(object[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.texMan.flushOpenGLIDs(this.myID);
        }
    }

    protected final void initTextureStage(int n, int n2) {
        this.switchTextureMode(n, n2);
        this.stageInitialized[n] = true;
    }

    protected final void disableUnusedStages() {
        if (!this.singleTexturing) {
            this.endState();
            for (int i = 1; i < this.maxStages; ++i) {
                if (!this.enabledStages[i]) continue;
                ARBMultitexture.glActiveTextureARB((int)stageMap[i]);
                GL11.glDisable((int)3553);
                this.enabledStages[i] = false;
            }
            this.enableStage(0);
            this.singleTexturing = true;
        }
    }

    protected final void enableStage(int n) {
        this.endState();
        ARBMultitexture.glActiveTextureARB((int)stageMap[n]);
        if (!this.enabledStages[n]) {
            GL11.glEnable((int)3553);
            this.enabledStages[n] = true;
            if (n > 0) {
                this.singleTexturing = false;
            }
        }
    }

    protected final void disableStage(int n) {
        if (this.enabledStages[n] && !this.singleTexturing) {
            this.endState();
            ARBMultitexture.glActiveTextureARB((int)stageMap[n]);
            GL11.glDisable((int)3553);
            this.enabledStages[n] = false;
            this.singleTexturing = true;
            for (int i = 1; i < this.maxStages; ++i) {
                if (!this.enabledStages[i]) continue;
                this.singleTexturing = false;
                break;
            }
        }
    }

    protected void bindAndProject(int n, Texture texture, Camera camera) {
        boolean bl;
        int n2 = texture.getOpenGLID(this.myID);
        boolean bl2 = bl = texture.projector != null;
        if (n2 != this.lastTextures[n] || bl != this.projective[n] || texture.isShadowMap && !this.alphaTest) {
            this.bindTexture(n, n2, bl);
            this.processProjection(n, texture, camera);
        } else if (n != 0) {
            this.enableStage(n);
        }
    }

    protected final void enableCompiledPipeline() {
        CompiledInstance.lastVertexBuffer = null;
        CompiledInstance.lastVertexBufferId = -1;
        GL11.glEnable((int)2977);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        this.clearHook(null);
    }

    protected final void disableCompiledPipeline() {
        CompiledInstance.lastVertexBuffer = null;
        CompiledInstance.lastVertexBufferId = -1;
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2977);
        this.clearHook(null);
    }

    protected final void bindTexture(int n, int n2, boolean bl) {
        this.enableStage(n);
        GL11.glBindTexture((int)3553, (int)n2);
        ++this.stateChanges;
        this.lastTextures[n] = n2;
        if (!bl && this.projective[n]) {
            this.disableProjection();
            this.projective[n] = false;
        }
    }

    protected final void bindTexture(int n, int n2) {
        this.bindTexture(n, n2, false);
    }

    protected final void switchTextureMode(int n, int n2) {
        if (this.lastMode[n] != n2) {
            this.endState();
            this.enableStage(n);
            if (n2 != 8449 || !Config.glBlendingAffectsAlpha) {
                if (Config.glBlendingAffectsAlpha && n2 != 3042) {
                    GL11.glTexEnvi((int)8960, (int)8704, (int)34160);
                    GL11.glTexEnvi((int)8960, (int)34161, (int)n2);
                    GL11.glTexEnvi((int)8960, (int)34162, (int)n2);
                } else {
                    GL11.glTexEnvi((int)8960, (int)8704, (int)n2);
                }
            } else {
                GL11.glTexEnvi((int)8960, (int)8704, (int)34160);
                GL11.glTexEnvi((int)8960, (int)34161, (int)34165);
                GL11.glTexEnvi((int)8960, (int)34176, (int)5890);
                GL11.glTexEnvi((int)8960, (int)34192, (int)768);
                GL11.glTexEnvi((int)8960, (int)34177, (int)34168);
                GL11.glTexEnvi((int)8960, (int)34193, (int)768);
                GL11.glTexEnvi((int)8960, (int)34178, (int)5890);
                GL11.glTexEnvi((int)8960, (int)34194, (int)6406);
                GL11.glTexEnvi((int)8960, (int)34162, (int)7681);
                GL11.glTexEnvi((int)8960, (int)34184, (int)34168);
                GL11.glTexEnvi((int)8960, (int)34200, (int)770);
            }
            this.lastMode[n] = n2;
        }
    }

    protected final void beginState(int n) {
        if (this.lastState != n) {
            if (this.lastState != -999989) {
                GL11.glEnd();
            }
            GL11.glBegin((int)n);
            this.lastState = n;
        } else {
            ++this.changeCnt;
        }
    }

    protected final void endState() {
        if (this.lastState != -999989) {
            GL11.glEnd();
        }
        this.changeCnt = 0;
        this.lastState = -999989;
    }

    protected final boolean isDisposed() {
        return this.disposed;
    }

    protected final void removeTexture(Texture texture) {
        if (texture != null && texture.getOpenGLID(this.myID) != 0) {
            IntBuffer intBuffer = this.getSmallBuffer();
            intBuffer.put(texture.getOpenGLID(this.myID));
            intBuffer.flip();
            GL11.glDeleteTextures((IntBuffer)intBuffer);
            if (Logger.isDebugEnabled()) {
                Logger.log("texture " + texture.getOpenGLID(this.myID) + " unloaded from GPU memory!", 3);
            }
        }
    }

    protected final void addClippingPlane(int n, float[] fArray) {
        this.endState();
        if (this.clippingBuffer == null) {
            this.clippingBuffer = BufferUtils.getByteBuffer(32).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        }
        this.clippingBuffer.rewind();
        this.clippingBuffer.put(0, fArray[0]);
        this.clippingBuffer.put(1, fArray[1]);
        this.clippingBuffer.put(2, fArray[2]);
        this.clippingBuffer.put(3, fArray[3]);
        GL11.glClipPlane((int)(12288 + n), (DoubleBuffer)this.clippingBuffer);
        GL11.glEnable((int)(12288 + n));
    }

    protected final void removeClippingPlane(int n) {
        GL11.glDisable((int)(12288 + n));
    }

    protected final void initializeVertexArrays() {
        if (this.init) {
            this.colors = BufferUtils.getByteBuffer(16000).asFloatBuffer();
            this.vertices = BufferUtils.getByteBuffer(12000).asFloatBuffer();
            GL11.glColorPointer((int)4, (int)16, (FloatBuffer)this.colors);
            GL11.glVertexPointer((int)3, (int)12, (FloatBuffer)this.vertices);
            GL11.glEnableClientState((int)32886);
            GL11.glEnableClientState((int)32884);
            this.createVertexArrays(this.minDriverAndConfig);
            this.vertexArraysInitialized = true;
        }
    }

    protected final void renableVertexArrays() {
        if (this.colors != null) {
            GL11.glColorPointer((int)4, (int)16, (FloatBuffer)this.colors);
            GL11.glVertexPointer((int)3, (int)12, (FloatBuffer)this.vertices);
            GL11.glEnableClientState((int)32886);
            GL11.glEnableClientState((int)32884);
            GL11.glDisableClientState((int)32885);
            for (int i = 0; i < this.minDriverAndConfig; ++i) {
                ARBMultitexture.glClientActiveTextureARB((int)stageMap[i]);
                GL11.glEnableClientState((int)32888);
                GL11.glTexCoordPointer((int)2, (int)8, (FloatBuffer)this.multiTextures[i]);
            }
        }
    }

    protected final void enableVertexArrays(int n, int n2) {
        if (n > this.minDriverAndConfig) {
            return;
        }
        if (n == n2) {
            return;
        }
        if (n < n2) {
            for (int i = n; i < n2; ++i) {
                if (!this.buffersEnabled[i]) continue;
                ARBMultitexture.glClientActiveTextureARB((int)stageMap[i]);
                GL11.glDisableClientState((int)32888);
                this.buffersEnabled[i] = false;
            }
            return;
        }
        if (n2 < n) {
            for (int i = n2; i < n; ++i) {
                if (this.buffersEnabled[i]) continue;
                ARBMultitexture.glClientActiveTextureARB((int)stageMap[i]);
                GL11.glEnableClientState((int)32888);
                this.buffersEnabled[i] = true;
            }
            return;
        }
    }

    protected final void renderVertexArray(int n) {
        if (n != 0) {
            int n2;
            boolean bl = false;
            for (n2 = 0; n2 < this.projective.length; ++n2) {
                if (!this.projective[n2] || !this.buffersEnabled[n2]) continue;
                ARBMultitexture.glClientActiveTextureARB((int)stageMap[n2]);
                GL11.glDisableClientState((int)32888);
                bl = true;
            }
            GL11.glDrawArrays((int)4, (int)0, (int)n);
            if (bl) {
                for (n2 = 0; n2 < this.projective.length; ++n2) {
                    if (!this.projective[n2] || !this.buffersEnabled[n2]) continue;
                    ARBMultitexture.glClientActiveTextureARB((int)stageMap[n2]);
                    GL11.glEnableClientState((int)32888);
                }
            }
        }
    }

    protected final IntBuffer getSmallBuffer() {
        if (this.smallBuffer == null || !Config.glUseCaches) {
            this.smallBuffer = BufferUtils.getByteBuffer(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        } else {
            this.smallBuffer.clear();
        }
        return this.smallBuffer;
    }

    protected final void disableFogging() {
        GL11.glDisable((int)2912);
        this.currentFoggingState = false;
        this.currentFogColor = -1;
        this.currentFogDistance = -1.0f;
    }

    protected void setFrustum(World world, FrameBuffer frameBuffer) {
        Camera camera = world.getCamera();
        float f = camera.getFOV();
        float f2 = 0.0f;
        if (f != this.lastFOV || Config.farPlane != this.lastFarPlane || !Config.glIgnoreNearPlane && Config.nearPlane != this.lastNearPlane || Config.autoMaintainAspectRatio != this.lastFOVMode) {
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            float f3 = frameBuffer.getOutputHeight();
            float f4 = frameBuffer.getOutputWidth();
            if (frameBuffer.renderTarget != null) {
                if (frameBuffer.virtualHeight > 0 && frameBuffer.virtualWidth > 0) {
                    f3 = frameBuffer.virtualHeight;
                    f4 = frameBuffer.virtualWidth;
                } else {
                    f3 = frameBuffer.renderTarget.height;
                    f4 = frameBuffer.renderTarget.width;
                }
            }
            f2 = Config.autoMaintainAspectRatio ? f * (f3 / f4) : f;
            if (camera.getYFOV() != -1.0f) {
                f2 = camera.getYFOV();
            }
            float f5 = Config.farPlane;
            float f6 = 1.0f;
            if (!Config.glIgnoreNearPlane) {
                f6 = Config.nearPlane;
            }
            float f7 = camera.applyOffsetY(f2 * 0.5f);
            float f8 = camera.applyOffsetY(-f2 * 0.5f);
            float f9 = camera.applyOffsetX(-f * 0.5f);
            float f10 = camera.applyOffsetX(f * 0.5f);
            GL11.glFrustum((double)f9, (double)f10, (double)f8, (double)f7, (double)f6, (double)f5);
            this.lastFOV = f + 100.0f * f2;
            this.lastFarPlane = Config.farPlane;
            this.lastNearPlane = Config.nearPlane;
            this.lastFOVMode = Config.autoMaintainAspectRatio;
        }
    }

    private void resetShadows() {
        this.disableShadowMap();
    }

    protected final void setRGBScaling(int n) {
        this.resetShadows();
        try {
            if (n != this.currentRGBScaling) {
                if (this.supportsRGBScaling == 0) {
                    if (this.supportsExtension("GL_ARB_texture_env_combine")) {
                        this.supportsRGBScaling = 1;
                    } else {
                        this.supportsRGBScaling = -1;
                        Logger.log("This hardware or driver doesn't support the GL_ARB_texture_env_combine extension!", 1);
                    }
                }
                if (this.supportsRGBScaling == 1) {
                    this.enableStage(0);
                    GL11.glTexEnvi((int)8960, (int)8704, (int)34160);
                    GL11.glTexEnvi((int)8960, (int)34161, (int)8448);
                    GL11.glTexEnvi((int)8960, (int)34163, (int)n);
                    this.currentRGBScaling = n;
                }
            }
        }
        catch (Exception exception) {
            Logger.log("Couldn't initialize the GL_ARB_texture_env_combine extension!", 0);
        }
    }

    protected final void enableFogging(float f, float f2, float f3, float f4, float f5) {
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 255.0f) {
            f3 = 255.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        } else if (f4 > 255.0f) {
            f4 = 255.0f;
        }
        if (f5 < 0.0f) {
            f5 = 0.0f;
        } else if (f5 > 255.0f) {
            f5 = 255.0f;
        }
        int n = (int)f3 << 16 | (int)f4 << 8 | (int)f5;
        if (f2 != this.currentFogDistance || n != this.currentFogColor) {
            if (this.currentFoggingState) {
                this.disableFogging();
            }
            this.currentFoggingState = true;
            this.fogColors.rewind();
            this.fogColors.put(f3 / 255.0f);
            this.fogColors.put(f4 / 255.0f);
            this.fogColors.put(f5 / 255.0f);
            this.fogColors.put(1.0f);
            this.fogColors.flip();
            GL11.glEnable((int)2912);
            GL11.glFogf((int)2915, (float)f);
            GL11.glFogf((int)2916, (float)f2);
            GL11.glFogi((int)2917, (int)9729);
            GL11.glFog((int)2918, (FloatBuffer)this.fogColors);
            GL11.glFogf((int)2914, (float)1.0f);
            this.currentFogColor = n;
            this.currentFogDistance = f2;
        }
    }

    protected final void convertTexture(Texture texture) {
        int n;
        int n2;
        int n3;
        Object object;
        Buffer buffer;
        int n4 = texture.getHeight();
        int n5 = texture.getWidth();
        int n6 = n4 * n5;
        int[] nArray = texture.texels;
        int n7 = Config.glAnisotropy;
        if (n7 > 0) {
            n7 = (int)Math.pow(2.0, n7);
        }
        if (this.maxAniso == -1.0f && n7 > 0) {
            buffer = BufferUtils.getDisposableByteBuffer(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
            GL11.glGetFloat((int)34047, (FloatBuffer)buffer);
            ((FloatBuffer)buffer).rewind();
            this.maxAniso = ((FloatBuffer)buffer).get();
            Logger.log("Max. anisotropy supported: " + (int)this.maxAniso);
        }
        n7 = (int)Math.min((float)n7, this.maxAniso);
        buffer = null;
        int n8 = n6 << 2;
        boolean bl = false;
        if (texture.overrideBuffer != null) {
            buffer = texture.overrideBuffer;
            texture.overrideBuffer = null;
            bl = true;
        } else {
            if (nArray != null) {
                if (Config.glUseCaches && this.textureBuffer != null && n8 == this.textureBufferSize) {
                    buffer = this.textureBuffer;
                }
                if (buffer == null) {
                    if (Config.glVerbose) {
                        Logger.log("Allocating " + n8 + " bytes of direct memory for texture: " + texture, 2);
                    }
                    try {
                        buffer = BufferUtils.getDisposableByteBuffer(n8);
                        ((ByteBuffer)buffer).order(ByteOrder.LITTLE_ENDIAN);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        Logger.log("Unable to allocate " + n8 + " bytes of direct memory", 0);
                        return;
                    }
                    if (n6 <= 0x100000) {
                        this.textureBuffer = buffer;
                        this.textureBufferSize = n8;
                        if (Config.glVerbose) {
                            Logger.log("Caching " + n8 + " bytes of direct memory!", 2);
                        }
                    }
                }
            }
            object = texture.alpha;
            if (nArray != null) {
                for (int i = 0; i < n6; ++i) {
                    n3 = i << 2;
                    n2 = nArray[i];
                    n = n2 & 0xFF00 | (n2 & 0xFF) << 16 | n2 >> 16;
                    if (object == null) {
                        if ((n2 & 0xF0F0F0) != 0) {
                            n |= 0xFF000000;
                        }
                    } else {
                        n |= object[i];
                    }
                    ((ByteBuffer)buffer).putInt(n3, n);
                }
            }
        }
        object = buffer;
        IntBuffer intBuffer = this.getSmallBuffer();
        GL11.glGenTextures((IntBuffer)intBuffer);
        n3 = intBuffer.get(0);
        if (Logger.isDebugEnabled()) {
            Logger.log("New texture's id is: " + n3, 3);
        }
        if (n3 == 0) {
            Logger.log("Failed to upload texture!", 0);
        }
        n2 = this.lastTextures[0];
        this.bindTexture(0, n3);
        n = 9729;
        if (Config.glMipmap) {
            n = 9985;
        }
        if (Config.glTrilinear) {
            n = 9987;
        }
        if (!texture.mipmap) {
            n = 9729;
        }
        int n9 = 6408;
        if (Config.glTextureDepth == 32) {
            n9 = 32856;
        }
        if (Config.glTextureDepth == 16 && !bl) {
            n9 = 32854;
        }
        if (n == 9729 || texture.isShadowMap) {
            if (texture.isShadowMap) {
                if (this.supportsShadowMapping == 0) {
                    if (this.supportsExtension("GL_ARB_shadow") && this.supportsExtension("GL_ARB_depth_texture")) {
                        this.supportsShadowMapping = 1;
                        this.checkLimitations();
                    } else {
                        this.supportsShadowMapping = -1;
                        Logger.log("This hardware or driver doesn't support ARB shadow mapping extensions!", 1);
                    }
                }
                if (this.supportsShadowMapping == 1) {
                    GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)n5, (int)n4, (int)0, (int)6402, (int)5121, (ByteBuffer)null);
                    GL11.glTexParameteri((int)3553, (int)34892, (int)34894);
                    GL11.glTexParameteri((int)3553, (int)34893, (int)515);
                    GL11.glTexParameteri((int)3553, (int)34891, (int)32841);
                    this.floatBuffer16.rewind();
                    this.floatBuffer16.put(1.0f);
                    this.floatBuffer16.put(1.0f);
                    this.floatBuffer16.put(1.0f);
                    this.floatBuffer16.put(1.0f);
                    this.floatBuffer16.flip();
                    GL11.glTexParameter((int)3553, (int)4100, (FloatBuffer)this.floatBuffer16);
                }
            } else {
                GL11.glTexImage2D((int)3553, (int)0, (int)n9, (int)n5, (int)n4, (int)0, (int)6408, (int)5121, (ByteBuffer)object);
            }
        } else {
            GLU.gluBuild2DMipmaps((int)3553, (int)n9, (int)n5, (int)n4, (int)6408, (int)5121, (ByteBuffer)object);
            if (n7 > 0) {
                GL11.glTexParameterf((int)3553, (int)34046, (float)n7);
            }
        }
        int n10 = 10497;
        if (!texture.repeat) {
            n10 = this.hasOpenGL12 ? 33071 : 10496;
        }
        if (texture.isShadowMap) {
            n = 9728;
            n10 = 10496;
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)n);
        if (texture.bilinear) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        GL11.glTexParameteri((int)3553, (int)10242, (int)n10);
        GL11.glTexParameteri((int)3553, (int)10243, (int)n10);
        texture.setOpenGLID(this.myID, n3);
        if (n2 != 0) {
            this.bindTexture(0, n2);
        }
        if (Logger.isDebugEnabled()) {
            Logger.log("New texture uploaded: " + texture + " in thread " + Thread.currentThread(), 3);
        }
    }

    protected void checkLimitations() {
        if (!Config.glUseFBO) {
            String string = GLHelper.getHardware().toLowerCase();
            String[] stringArray = new String[]{"x800", "x700", "x600", "x500", "x300", "x850", "x1800", "9700", "9800", "9650", "9600", "9500", "9200", "9100", "9000", "8500", "8000", "7500"};
            String[] stringArray2 = new String[]{"x1900", "x1600", "x1950", "x1650", "hd 2900", "hd 2600", "hd 2400", "x1300"};
            if (string.indexOf("ati") != -1) {
                int n;
                for (n = 0; n < stringArray.length; ++n) {
                    if (string.indexOf(stringArray[n]) == -1) continue;
                    Logger.log("This graphics hardware may have performance problems with shadow mapping/depth textures without using FBOs!", 1);
                    break;
                }
                for (n = 0; n < stringArray2.length; ++n) {
                    if (string.indexOf(stringArray2[n]) == -1) continue;
                    Logger.log("This graphics hardware may have problems with shadow mapping in combination with anti-aliasing without using FBOs!", 1);
                    break;
                }
            }
        }
    }

    protected final boolean supportsExtension(String string) {
        String string2 = GL11.glGetString((int)7939);
        return string2.toLowerCase().indexOf(string.toLowerCase()) != -1;
    }

    protected final int getTextureSize() {
        IntBuffer intBuffer = BufferUtils.getDisposableByteBuffer(64).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL11.glGetInteger((int)3379, (IntBuffer)intBuffer);
        return intBuffer.get(0);
    }

    protected final void enableDepthBuffer() {
        if (!this.depthBuffer) {
            GL11.glEnable((int)2929);
            this.depthBuffer = true;
        }
    }

    protected final void disableDepthBuffer() {
        if (this.depthBuffer) {
            GL11.glDisable((int)2929);
            this.depthBuffer = false;
        }
    }

    protected void setLineMatrix(Camera camera, Object3D object3D) {
        Matrix matrix = new Matrix();
        Matrix matrix2 = new Matrix();
        float[] fArray = new float[16];
        matrix.setTo(camera.getBack());
        matrix.transformToGL();
        if (object3D != null) {
            matrix2 = object3D.getWorldTransformation(matrix2);
        } else {
            matrix2.setIdentity();
        }
        matrix2.translate(-camera.backBx, -camera.backBy, -camera.backBz);
        matrix2.matMul(matrix);
        fArray = matrix2.fillDump(fArray);
        this.floatBuffer64.rewind();
        this.floatBuffer64.put(fArray);
        this.floatBuffer64.rewind();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadMatrix((FloatBuffer)this.floatBuffer64);
    }

    protected void enableLineMode(Camera camera) {
        this.disableBlitting();
        this.disableCompiledPipeline();
        Matrix matrix = new Matrix();
        Matrix matrix2 = new Matrix();
        float[] fArray = new float[16];
        matrix.setTo(camera.getBack());
        matrix.transformToGL();
        matrix2.setIdentity();
        matrix2.translate(-camera.backBx, -camera.backBy, -camera.backBz);
        matrix2.matMul(matrix);
        fArray = matrix2.fillDump(fArray);
        this.floatBuffer64.rewind();
        this.floatBuffer64.put(fArray);
        this.floatBuffer64.rewind();
        this.renableVertexArrays();
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glLoadMatrix((FloatBuffer)this.floatBuffer64);
        GL11.glDisable((int)3553);
        GL11.glEnableClientState((int)32884);
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32885);
        GL11.glDisableClientState((int)32886);
        this.disableUnusedStages();
    }

    protected void disableLineMode() {
        GL11.glLineWidth((float)1.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        this.renableVertexArrays();
    }

    protected void drawLine(Polyline polyline) {
        polyline.getData().rewind();
        Color color = polyline.getColor();
        this.setLineColor(color);
        if (color.getAlpha() < 255) {
            this.setBlendingMode(polyline.getTransparencyMode());
        }
        if (polyline.isPointMode()) {
            GL11.glPointSize((float)polyline.getWidth());
        } else {
            GL11.glLineWidth((float)polyline.getWidth());
        }
        GL11.glVertexPointer((int)3, (int)12, (FloatBuffer)polyline.getData());
        if (polyline.isPointMode()) {
            GL11.glDrawArrays((int)0, (int)0, (int)polyline.getLength());
        } else {
            GL11.glDrawArrays((int)3, (int)0, (int)polyline.getLength());
        }
        if (color.getAlpha() < 255) {
            this.unsetBlendingMode();
        }
    }

    private void setLineColor(Color color) {
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
    }

    protected void enableBlitting(Object[] objectArray) {
        int n;
        if (!this.blitMode) {
            GL11.glFlush();
            this.curPos = 0;
            this.colPos = 0;
            this.texPos = 0;
            this.vertPos = 0;
        }
        boolean bl = (Boolean)objectArray[8];
        boolean bl2 = objectArray.length > 11 && (Boolean)objectArray[14] != false;
        this.endState();
        this.resetShadows();
        FrameBuffer frameBuffer = (FrameBuffer)objectArray[1];
        if (frameBuffer.blittingShader != null) {
            this.blittingShader = frameBuffer.blittingShader;
            this.blittingShader.beforeRendering(0);
        }
        if (!(!bl || this.blitMode && this.blitTrans)) {
            if (this.blitMode) {
                this.executeBufferedBlits();
            }
            n = 0;
            if (bl2) {
                n = 1;
            }
            this.blitAdditive = bl2;
            this.setBlendingMode(n);
            this.blitTrans = true;
        }
        if (!this.blitMode) {
            this.blitScaling = this.currentRGBScaling;
            if (this.myWorld != null) {
                this.setRGBScaling(1);
            }
            this.disableDepthBuffer();
            this.blitMode = true;
        } else {
            if (this.blitTrans && !bl) {
                this.executeBufferedBlits();
                GL11.glDisable((int)3042);
                this.blitTrans = false;
            }
            if (this.blitTrans && bl && bl2 != this.blitAdditive) {
                this.executeBufferedBlits();
                this.blitAdditive = bl2;
                n = 0;
                if (bl2) {
                    n = 1;
                }
                this.setBlendingMode(n);
            }
        }
    }

    protected void executeBufferedBlits() {
        if (Config.glVertexArrays && Config.glBufferedBlits) {
            this.renderVertexArray(this.curPos);
            this.curPos = 0;
            this.colPos = 0;
            this.texPos = 0;
            this.vertPos = 0;
        }
    }

    protected void disableBlitting() {
        if (this.blitMode) {
            this.executeBufferedBlits();
            if (this.myWorld != null && this.blitScaling != this.currentRGBScaling) {
                this.setRGBScaling(this.blitScaling);
            }
            if (this.blitTrans) {
                GL11.glDisable((int)3042);
                this.blitTrans = false;
            }
            if (this.blittingShader != null) {
                this.blittingShader.setDelayedDisabling(false);
                this.blittingShader.afterRendering(0);
                this.blittingShader = null;
            }
            this.enableDepthBuffer();
            this.blitMode = false;
        }
    }

    protected void setLightsAndFog(World world) {
        this.setRGBScaling(world.lights.rgbScale);
        boolean bl = false;
        if (world.fogModeChanged == 1) {
            this.enableFogging(world.fogStart, world.fogDistance, world.fogColorR, world.fogColorG, world.fogColorB);
            world.fogModeChanged = 0;
            this.foggingOn = true;
            bl = true;
        } else if (world.fogModeChanged == 2) {
            this.disableFogging();
            world.fogModeChanged = 0;
            this.foggingOn = false;
            bl = true;
        }
        int n = world.hashCode();
        boolean bl2 = false;
        if (n != this.lastWorldHash) {
            if (this.foggingOn && world.useFogging && world.perPixelFogging) {
                bl2 = true;
            }
            this.lastWorldHash = n;
        }
        if (!bl) {
            if (!world.useFogging && this.foggingOn) {
                this.disableFogging();
                this.foggingOn = false;
            } else if (bl2 || world.useFogging && world.perPixelFogging && !this.foggingOn) {
                this.enableFogging(world.fogStart, world.fogDistance, world.fogColorR, world.fogColorG, world.fogColorB);
                this.foggingOn = true;
            }
        }
    }

    protected void grabScreen(Object[] objectArray) {
        FrameBuffer frameBuffer = (FrameBuffer)objectArray[0];
        int[] nArray = (int[])objectArray[1];
        int n = frameBuffer.getOutputWidth();
        int n2 = frameBuffer.getOutputHeight();
        int n3 = n * n2;
        int n4 = n3 << 2;
        IntBuffer intBuffer = null;
        if (this.pixelBuffer != null && n4 == this.pixelBufferSize) {
            intBuffer = this.pixelBuffer;
        }
        if (!Config.glUseCaches) {
            intBuffer = null;
        }
        if (intBuffer == null) {
            this.pixelBuffer = intBuffer = BufferUtils.getDisposableByteBuffer(n4).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
            this.pixelBufferSize = n4;
        }
        GL11.glReadPixels((int)0, (int)0, (int)n, (int)n2, (int)32993, (int)5121, (IntBuffer)intBuffer);
        intBuffer.rewind();
        intBuffer.get(nArray);
        intBuffer.rewind();
        for (int i = 0; i < n2 >> 1; ++i) {
            int n5 = i * n;
            int n6 = (n2 - 1 - i) * n;
            for (int j = 0; j < n; ++j) {
                int n7 = j + n5;
                int n8 = n6 + j;
                int n9 = nArray[n7];
                nArray[n7] = nArray[n8] & 0xFFFFFF;
                nArray[n8] = n9 & 0xFFFFFF;
            }
        }
    }

    protected void prepareForBlitting(Object[] objectArray) {
        int n = 0;
        int n2 = (Integer)objectArray[9];
        int n3 = (Integer)objectArray[10];
        if (this.blitBuffer != null) {
            n = this.blitBuffer.getOpenGLID(this.myID);
            if (this.blitBufferWidth == n2 && this.blitBufferHeight == n3) {
                if (!Config.glUseIgnorantBlits) {
                    this.blitBuffer.refill((int[])objectArray[0], n2, n3);
                    this.blitBuffer.setMarker(this.myID, Texture.MARKER_DELETE_AND_UPLOAD);
                    this.blitBuffer.setOpenGLID(this.myID, n);
                }
            } else {
                this.removeTexture(this.blitBuffer);
                this.blitBuffer = new Texture((int[])objectArray[0], n2, n3, true);
                this.blitBuffer.setMarker(this.myID, Texture.MARKER_DELETE_AND_UPLOAD);
                this.blitBuffer.setOpenGLID(this.myID, n);
            }
        } else {
            this.blitBuffer = new Texture((int[])objectArray[0], n2, n3, true);
        }
        this.blitBufferWidth = n2;
        this.blitBufferHeight = n3;
    }

    protected void setBufferViewport(Object[] objectArray) {
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        int n3 = (Integer)objectArray[2];
        int n4 = (Integer)objectArray[3];
        if (this.renderTarget == null || Config.viewportOffsetAffectsRenderTarget) {
            GL11.glViewport((int)n, (int)n2, (int)n3, (int)n4);
        }
    }

    protected void blitVA(Object[] objectArray, float f, float f2, float f3, float f4) {
        if (this.init) {
            float f5;
            float f6;
            if (!this.vertexArraysInitialized) {
                this.initializeVertexArrays();
            }
            FrameBuffer frameBuffer = (FrameBuffer)objectArray[1];
            if (this.veryLastCoords != 1) {
                this.enableVertexArrays(1, this.veryLastCoords);
                this.lastCoords = 1;
                this.veryLastCoords = 1;
            }
            this.disableUnusedStages();
            this.switchTextureMode(0, modeMap[0]);
            float f7 = -1.0f;
            if (Config.glFixedBlitting) {
                f7 = -1.0000001f;
            }
            if (!Config.glIgnoreNearPlane) {
                float f8 = Config.nearPlane;
                if (this.myWorld != null && this.myWorld.camera.nearPlane != -1.0f) {
                    f8 = this.myWorld.camera.nearPlane;
                }
                if (f8 != -1.0f) {
                    f7 = -f8;
                    if (Config.glFixedBlitting) {
                        f7 = f8 < 1.0f ? -f8 - 6.0E-8f : -f8 - 6.0E-7f;
                    }
                }
            }
            this.endState();
            Texture texture = (Texture)objectArray[0];
            float f9 = texture.getHeight();
            float f10 = texture.getWidth();
            int n = texture.getOpenGLID(this.myID);
            if (n == 0 || texture.getMarker(this.myID) == Texture.MARKER_DELETE_AND_UPLOAD) {
                texture.setMarker(this.myID, Texture.MARKER_NOTHING);
                if (n != 0) {
                    IntBuffer intBuffer = this.getSmallBuffer();
                    intBuffer.put(n);
                    intBuffer.flip();
                    GL11.glDeleteTextures((IntBuffer)intBuffer);
                }
                this.convertTexture(texture);
                n = texture.getOpenGLID(this.myID);
            }
            if (n != this.lastTextures[0]) {
                this.executeBufferedBlits();
                this.bindTexture(0, n);
            }
            int n2 = frameBuffer.getSamplingMode();
            float f11 = 1.0f;
            if (n2 != 0) {
                switch (n2) {
                    case 1: {
                        f11 = 2.0f;
                        break;
                    }
                    case 3: {
                        f11 = 1.5f;
                        break;
                    }
                    case 2: {
                        f11 = 0.5f;
                    }
                }
            }
            float f12 = ((Float)objectArray[2]).floatValue();
            float f13 = ((Float)objectArray[3]).floatValue();
            float f14 = ((Float)objectArray[6]).floatValue();
            float f15 = ((Float)objectArray[7]).floatValue();
            float f16 = f14;
            float f17 = f15;
            float f18 = 1.0f;
            float f19 = 1.0f;
            float f20 = 1.0f;
            float f21 = 1.0f;
            if (objectArray.length > 11) {
                f16 = ((Float)objectArray[11]).floatValue();
                f17 = ((Float)objectArray[12]).floatValue();
                f18 = Config.glTransparencyOffset + (float)((Integer)objectArray[13]).intValue() * Config.glTransparencyMul;
                if (f18 > 1.0f) {
                    f18 = 1.0f;
                }
                f19 = ((Integer)objectArray[15]).floatValue() / 255.0f;
                f20 = ((Integer)objectArray[16]).floatValue() / 255.0f;
                f21 = ((Integer)objectArray[17]).floatValue() / 255.0f;
            }
            if (this.cull(frameBuffer, f16, f17, f6 = ((Float)objectArray[4]).floatValue(), f5 = ((Float)objectArray[5]).floatValue())) {
                return;
            }
            float f22 = 1.0f / f10;
            float f23 = 1.0f / f9;
            float f24 = f22 * f12;
            float f25 = f23 * f13;
            float f26 = f22 * (f14 + f12);
            float f27 = f23 * (f15 + f13);
            if (this.myWorld != null) {
                if (f11 != 1.0f) {
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, f6, f5, 1.0f, f11, this.blitCoords1, f3, f4);
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, f6 + f16, f5 + f17, 1.0f, f11, this.blitCoords2, f3, f4);
                } else {
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, f6, f5, 1.0f, this.blitCoords1, f3, f4);
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, f6 + f16, f5 + f17, 1.0f, this.blitCoords2, f3, f4);
                }
                if (this.curPos >= 994) {
                    this.executeBufferedBlits();
                }
                for (int i = 0; i < 6; ++i) {
                    this.colors.put(this.colPos, f19);
                    this.colors.put(this.colPos + 1, f20);
                    this.colors.put(this.colPos + 2, f21);
                    this.colors.put(this.colPos + 3, f18);
                    this.colPos += 4;
                }
                this.vertices.put(this.vertPos, this.blitCoords1.x);
                this.vertices.put(this.vertPos + 1, -this.blitCoords2.y);
                this.vertices.put(this.vertPos + 2, f7);
                this.vertPos += 3;
                this.vertices.put(this.vertPos, this.blitCoords2.x);
                this.vertices.put(this.vertPos + 1, -this.blitCoords2.y);
                this.vertices.put(this.vertPos + 2, f7);
                this.vertPos += 3;
                this.vertices.put(this.vertPos, this.blitCoords1.x);
                this.vertices.put(this.vertPos + 1, -this.blitCoords1.y);
                this.vertices.put(this.vertPos + 2, f7);
                this.vertPos += 3;
                this.vertices.put(this.vertPos, this.blitCoords1.x);
                this.vertices.put(this.vertPos + 1, -this.blitCoords1.y);
                this.vertices.put(this.vertPos + 2, f7);
                this.vertPos += 3;
                this.vertices.put(this.vertPos, this.blitCoords2.x);
                this.vertices.put(this.vertPos + 1, -this.blitCoords1.y);
                this.vertices.put(this.vertPos + 2, f7);
                this.vertPos += 3;
                this.vertices.put(this.vertPos, this.blitCoords2.x);
                this.vertices.put(this.vertPos + 1, -this.blitCoords2.y);
                this.vertices.put(this.vertPos + 2, f7);
                this.vertPos += 3;
                this.textures.put(this.texPos, f24);
                this.textures.put(this.texPos + 1, f27);
                this.texPos += 2;
                this.textures.put(this.texPos, f26);
                this.textures.put(this.texPos + 1, f27);
                this.texPos += 2;
                this.textures.put(this.texPos, f24);
                this.textures.put(this.texPos + 1, f25);
                this.texPos += 2;
                this.textures.put(this.texPos, f24);
                this.textures.put(this.texPos + 1, f25);
                this.texPos += 2;
                this.textures.put(this.texPos, f26);
                this.textures.put(this.texPos + 1, f25);
                this.texPos += 2;
                this.textures.put(this.texPos, f26);
                this.textures.put(this.texPos + 1, f27);
                this.texPos += 2;
                this.curPos += 6;
            }
        }
    }

    private boolean cull(FrameBuffer frameBuffer, float f, float f2, float f3, float f4) {
        if (!Config.cullBlits) {
            return false;
        }
        float f5 = f3;
        float f6 = f3 + f;
        float f7 = f4;
        float f8 = f4 + f2;
        return f5 < 0.0f && f6 < 0.0f || f7 < 0.0f && f8 < 0.0f || f5 > (float)frameBuffer.getWidth() && f6 > (float)frameBuffer.getWidth() || f7 > (float)frameBuffer.getHeight() && f8 > (float)frameBuffer.getHeight();
    }

    protected void blit(Object[] objectArray, float f, float f2, float f3, float f4) {
        if (this.init) {
            if (Config.glVertexArrays && Config.glBufferedBlits) {
                this.blitVA(objectArray, f, f2, f3, f4);
                return;
            }
            FrameBuffer frameBuffer = (FrameBuffer)objectArray[1];
            this.disableUnusedStages();
            this.switchTextureMode(0, modeMap[0]);
            float f5 = -1.0f;
            if (Config.glFixedBlitting) {
                f5 = -1.0000001f;
            }
            if (!Config.glIgnoreNearPlane) {
                float f6 = Config.nearPlane;
                if (this.myWorld != null && this.myWorld.camera.nearPlane != -1.0f) {
                    f6 = this.myWorld.camera.nearPlane;
                }
                if (f6 != -1.0f) {
                    f5 = -f6;
                    if (Config.glFixedBlitting) {
                        f5 = f6 < 1.0f ? -f6 - 6.0E-8f : -f6 - 6.0E-7f;
                    }
                }
            }
            this.endState();
            Texture texture = (Texture)objectArray[0];
            if (texture == null) {
                return;
            }
            float f7 = texture.getHeight();
            float f8 = texture.getWidth();
            int n = texture.getOpenGLID(this.myID);
            if (n == 0 || texture.getMarker(this.myID) == Texture.MARKER_DELETE_AND_UPLOAD) {
                texture.setMarker(this.myID, Texture.MARKER_NOTHING);
                if (n != 0) {
                    IntBuffer intBuffer = this.getSmallBuffer();
                    intBuffer.put(n);
                    intBuffer.flip();
                    GL11.glDeleteTextures((IntBuffer)intBuffer);
                }
                this.convertTexture(texture);
                n = texture.getOpenGLID(this.myID);
            }
            if (n != this.lastTextures[0]) {
                this.bindTexture(0, n);
            }
            int n2 = frameBuffer.getSamplingMode();
            float f9 = 1.0f;
            if (n2 != 0) {
                switch (n2) {
                    case 1: {
                        f9 = 2.0f;
                        break;
                    }
                    case 3: {
                        f9 = 1.5f;
                        break;
                    }
                    case 2: {
                        f9 = 0.5f;
                    }
                }
            }
            float f10 = ((Float)objectArray[2]).floatValue();
            float f11 = ((Float)objectArray[3]).floatValue();
            float f12 = ((Float)objectArray[6]).floatValue();
            float f13 = ((Float)objectArray[7]).floatValue();
            float f14 = f12;
            float f15 = f13;
            float f16 = 1.0f;
            float f17 = 1.0f;
            float f18 = 1.0f;
            float f19 = 1.0f;
            if (objectArray.length > 11) {
                f14 = ((Float)objectArray[11]).floatValue();
                f15 = ((Float)objectArray[12]).floatValue();
                f16 = Config.glTransparencyOffset + (float)((Integer)objectArray[13]).intValue() * Config.glTransparencyMul;
                if (f16 > 1.0f) {
                    f16 = 1.0f;
                }
                f17 = ((Integer)objectArray[15]).floatValue() / 255.0f;
                f18 = ((Integer)objectArray[16]).floatValue() / 255.0f;
                f19 = ((Integer)objectArray[17]).floatValue() / 255.0f;
            }
            float f20 = ((Float)objectArray[4]).floatValue();
            float f21 = ((Float)objectArray[5]).floatValue();
            float f22 = 1.0f / f8;
            float f23 = 1.0f / f7;
            float f24 = f22 * f10;
            float f25 = f23 * f11;
            float f26 = f22 * (f12 + f10);
            float f27 = f23 * (f13 + f11);
            if (this.cull(frameBuffer, f14, f15, f20, f21)) {
                return;
            }
            if (this.myWorld != null) {
                if (f9 != 1.0f) {
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, f20, f21, 1.0f, f9, this.blitCoords1, f3, f4);
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, f20 + f14, f21 + f15, 1.0f, f9, this.blitCoords2, f3, f4);
                } else {
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, f20, f21, 1.0f, this.blitCoords1, f3, f4);
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, f20 + f14, f21 + f15, 1.0f, this.blitCoords2, f3, f4);
                }
                GL11.glBegin((int)5);
                GL11.glColor4f((float)f17, (float)f18, (float)f19, (float)f16);
                GL11.glTexCoord2f((float)f24, (float)f27);
                GL11.glVertex3f((float)this.blitCoords1.x, (float)(-this.blitCoords2.y), (float)f5);
                GL11.glTexCoord2f((float)f26, (float)f27);
                GL11.glVertex3f((float)this.blitCoords2.x, (float)(-this.blitCoords2.y), (float)f5);
                GL11.glTexCoord2f((float)f24, (float)f25);
                GL11.glVertex3f((float)this.blitCoords1.x, (float)(-this.blitCoords1.y), (float)f5);
                GL11.glTexCoord2f((float)f26, (float)f25);
                GL11.glVertex3f((float)this.blitCoords2.x, (float)(-this.blitCoords1.y), (float)f5);
                GL11.glEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addForUnload(Texture texture) {
        GLBase gLBase = this;
        synchronized (gLBase) {
            this.toUnload.put(texture, new Long(System.currentTimeMillis()));
            if (Logger.isDebugEnabled()) {
                Logger.log("Texture " + texture.getOpenGLID(this.myID) + " added for unloading (" + this.toUnload.size() + ")!", 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unloadTextures(World world) {
        if (this.toUnload.size() > 0) {
            GLBase gLBase = this;
            synchronized (gLBase) {
                Map.Entry entry;
                if (Logger.isDebugEnabled()) {
                    Logger.log("Textures to unload: " + this.toUnload.size(), 3);
                }
                this.endState();
                this.toRemove.clear();
                Iterator iterator = this.toUnload.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    Texture texture = (Texture)entry.getKey();
                    if (texture.getOpenGLID(this.myID) != 0) {
                        if (world.getVisibilityList().referencesTexture(texture)) {
                            if (!Logger.isDebugEnabled()) continue;
                            Logger.log("Texture " + texture.getOpenGLID(this.myID) + " is still referenced, delaying unload operation!", 3);
                            continue;
                        }
                        if (Logger.isDebugEnabled()) {
                            Logger.log("Unloading texture " + texture.getOpenGLID(this.myID), 3);
                        }
                        this.removeTexture(texture);
                        texture.clearIDs(this.myID);
                        this.toRemove.add(texture);
                        continue;
                    }
                    if (System.currentTimeMillis() - (Long)entry.getValue() <= Config.unloadTimeout) continue;
                    if (Logger.isDebugEnabled()) {
                        Logger.log("Unloading unused texture " + texture.getOpenGLID(this.myID), 3);
                    }
                    this.toRemove.add(texture);
                }
                for (int i = 0; i < this.toRemove.size(); ++i) {
                    entry = (Texture)this.toRemove.get(i);
                    this.toUnload.remove(entry);
                }
                this.toRemove.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean upload(Texture texture) {
        GLBase gLBase = this;
        synchronized (gLBase) {
            this.endState();
            if (texture.getOpenGLID(this.myID) == 0 && texture != this.renderTarget) {
                texture.setMarker(this.myID, Texture.MARKER_NOTHING);
                this.convertTexture(texture);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListsAndBuffers() {
        int n;
        GLBase gLBase;
        if (this.toDispose != null && this.toDispose.size() > 0) {
            gLBase = this;
            synchronized (gLBase) {
                GL11.glFlush();
                GL11.glFinish();
                for (int i = 0; i < this.toDispose.size(); ++i) {
                    try {
                        n = (Integer)this.toDispose.get(i);
                        GL11.glDeleteLists((int)n, (int)1);
                        Util.checkGLError();
                        Logger.log("Display list " + n + " deleted!", 2);
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.log("Failed to delete display list: " + this.toDispose.get(i), 1);
                    }
                }
                GL11.glFlush();
                GL11.glFinish();
                this.toDispose.clear();
            }
        }
        if (this.toDisposeVBO != null && this.toDisposeVBO.size() > 0) {
            gLBase = this;
            synchronized (gLBase) {
                GL11.glFlush();
                GL11.glFinish();
                IntBuffer intBuffer = this.getSmallBuffer();
                for (n = 0; n < this.toDisposeVBO.size(); ++n) {
                    try {
                        int n2 = (Integer)this.toDisposeVBO.get(n);
                        if (n2 == 0) continue;
                        intBuffer.rewind();
                        intBuffer.put(n2);
                        intBuffer.rewind();
                        GL15.glDeleteBuffers((IntBuffer)intBuffer);
                        Util.checkGLError();
                        Logger.log("VBO " + n2 + " deleted!", 2);
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.log("Failed to delete VBO: " + this.toDisposeVBO.get(n), 1);
                    }
                }
                GL11.glFlush();
                GL11.glFinish();
                this.toDisposeVBO.clear();
            }
        }
    }

    private final void createVertexArrays(int n) {
        GL11.glEnableClientState((int)32888);
        for (int i = 0; i < n; ++i) {
            this.multiTextures[i] = BufferUtils.getByteBuffer(8000).order(ByteOrder.nativeOrder()).asFloatBuffer();
            ARBMultitexture.glClientActiveTextureARB((int)stageMap[i]);
            GL11.glTexCoordPointer((int)2, (int)8, (FloatBuffer)this.multiTextures[i]);
            if (i != 0) continue;
            this.textures = this.multiTextures[0];
            this.buffersEnabled[0] = true;
        }
    }

    private final int getTextureStages() {
        IntBuffer intBuffer = BufferUtils.getDisposableByteBuffer(64).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL11.glGetInteger((int)34018, (IntBuffer)intBuffer);
        int n = intBuffer.get(0);
        if (Config.glOverrideStageCount > 0) {
            n = Config.glOverrideStageCount;
        }
        if (n > 4) {
            n = 4;
        }
        return n;
    }

    private final void initTextureStage(int n) {
        this.initTextureStage(n, modeMap[0]);
    }

    private void resetViewport(FrameBuffer frameBuffer) {
        int n = (int)(Config.viewportOffsetX * (float)frameBuffer.getOutputWidth());
        int n2 = (int)(-Config.viewportOffsetY * (float)frameBuffer.getOutputHeight());
        int n3 = frameBuffer.getOutputWidth();
        int n4 = frameBuffer.getOutputHeight();
        GL11.glViewport((int)n, (int)n2, (int)n3, (int)n4);
    }

    private void setViewport(FrameBuffer frameBuffer) {
        if (!Config.glUseFBO) {
            this.yTargetStart = frameBuffer.getOutputHeight() - this.renderTarget.getHeight();
            GL11.glViewport((int)0, (int)this.yTargetStart, (int)this.renderTarget.getWidth(), (int)this.renderTarget.getHeight());
        } else {
            GL11.glViewport((int)0, (int)0, (int)this.renderTarget.getWidth(), (int)this.renderTarget.getHeight());
        }
    }

    private void enableScissor(FrameBuffer frameBuffer, Texture texture, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (!this.useFBO) {
            n6 = frameBuffer.getOutputHeight() - texture.getHeight();
        }
        int n7 = texture.getWidth();
        int n8 = texture.getHeight();
        if (n != -1) {
            this.scissorEnabled = true;
            n5 += n;
        }
        if (n2 != -1) {
            this.scissorEnabled = true;
            n6 += n2;
        }
        if (n3 != -1) {
            this.scissorEnabled = true;
            n7 -= n + n3;
        }
        if (n4 != -1) {
            this.scissorEnabled = true;
            n8 -= n2 + n4;
        }
        if (this.scissorEnabled) {
            GL11.glEnable((int)3089);
            if (n5 < 0) {
                n5 = 0;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            if (n6 < 0) {
                n6 = 0;
            }
            if (n8 < 0) {
                n8 = 0;
            }
            GL11.glScissor((int)n5, (int)n6, (int)n7, (int)n8);
        }
    }

    private void disableScissor() {
        if (this.scissorEnabled) {
            GL11.glDisable((int)3089);
            this.scissorEnabled = false;
        }
    }

    protected void clearHook(IRenderHook iRenderHook) {
        if (this.lastHook != null && this.lastHook != iRenderHook) {
            this.lastHook.clear();
            this.lastHook = null;
        }
    }

    protected void revalidate(int n, int n2) {
        GL11.glViewport((int)0, (int)0, (int)n, (int)n2);
    }
}

