/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Camera;
import com.threed.jpct.CompiledInstance;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.GLBase;
import com.threed.jpct.GLHelper;
import com.threed.jpct.IPostProcessor;
import com.threed.jpct.IRenderer;
import com.threed.jpct.IntegerC;
import com.threed.jpct.Logger;
import com.threed.jpct.Mesh;
import com.threed.jpct.Object3D;
import com.threed.jpct.Polyline;
import com.threed.jpct.Texture;
import com.threed.jpct.Vectors;
import com.threed.jpct.VisList;
import com.threed.jpct.World;
import java.awt.Color;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;

public final class GLRenderer
extends GLBase
implements IRenderer {
    GLRenderer() {
    }

    public void init(int n, int n2, int n3, int n4, int n5) {
        this.init = false;
        this.init(GLHelper.init(n, n2, n3, n4, n5), n, n2);
    }

    public void dispose() {
        super.dispose();
        GLHelper.dispose();
        Logger.log("OpenGL renderer disposed", 2);
    }

    public void execute(int n, Object[] objectArray) {
        if (this.init) {
            if (n == 4 || n == 7) {
                this.enableBlitting(objectArray);
            } else {
                this.disableBlitting();
            }
            switch (n) {
                case 33: {
                    this.disableBlitting();
                    break;
                }
                case 0: {
                    this.myWorld = (World)objectArray[0];
                    FrameBuffer frameBuffer = (FrameBuffer)objectArray[1];
                    this.setFrustum(this.myWorld, frameBuffer);
                    this.setLightsAndFog(this.myWorld);
                    this.unloadTextures(this.myWorld);
                    break;
                }
                case 1: {
                    this.endState();
                    if (this.renderToTarget()) break;
                    GLHelper.swap();
                    this.removeListsAndBuffers();
                    break;
                }
                case 2: {
                    this.clear(objectArray);
                    break;
                }
                case 3: {
                    Logger.log("State changes: " + this.stateChanges, 2);
                    this.stateChanges = 0;
                    break;
                }
                case 28: {
                    this.revalidate((Integer)objectArray[0], (Integer)objectArray[1]);
                    break;
                }
                case 4: {
                    this.blit(objectArray);
                    break;
                }
                case 5: {
                    GL11.glFlush();
                    break;
                }
                case 6: {
                    this.grabScreen(objectArray);
                    break;
                }
                case 7: {
                    this.prepareForBlitting(objectArray);
                    objectArray[0] = this.blitBuffer;
                    this.blit(objectArray);
                    break;
                }
                case 8: {
                    this.endState();
                    break;
                }
                case 9: {
                    this.setBufferViewport(objectArray);
                    break;
                }
                case 10: {
                    Boolean bl = Config.booleanValueOf(this.supportsExtension((String)objectArray[0]));
                    objectArray[0] = bl;
                    break;
                }
                case 26: {
                    float[] fArray = (float[])objectArray[1];
                    Integer n2 = (Integer)objectArray[0];
                    this.addClippingPlane(n2, fArray);
                    break;
                }
                case 27: {
                    Integer n3 = (Integer)objectArray[0];
                    this.removeClippingPlane(n3);
                    break;
                }
                case 25: {
                    Integer n4 = IntegerC.valueOf(this.getTextureSize());
                    objectArray[0] = n4;
                    break;
                }
                case 11: {
                    objectArray[0] = null;
                    break;
                }
                case 12: {
                    if (this.listener == null || !this.listenerActive) break;
                    this.listener.startPainting();
                    break;
                }
                case 13: {
                    this.resetTextureStates();
                    if (this.listener == null || !this.listenerActive) break;
                    this.listener.finishedPainting();
                    break;
                }
                case 15: {
                    if (objectArray != null && objectArray.length > 0) {
                        this.clearColorBufferOnly(objectArray[0]);
                        break;
                    }
                    this.clearZBufferOnly();
                    break;
                }
                case 16: {
                    this.doPostProcessing(objectArray);
                    break;
                }
                case 17: {
                    IPostProcessor iPostProcessor = (IPostProcessor)objectArray[1];
                    iPostProcessor.dispose();
                    break;
                }
                case 18: {
                    this.setRenderTarget(objectArray);
                    break;
                }
                case 23: {
                    this.reInit();
                    break;
                }
                case 24: {
                    boolean bl;
                    this.listenerActive = bl = ((Boolean)objectArray[0]).booleanValue();
                    break;
                }
                case 29: {
                    this.enableLineMode(((World)objectArray[0]).getCamera());
                    break;
                }
                case 32: {
                    this.setLineMatrix(((World)objectArray[0]).getCamera(), (Object3D)objectArray[1]);
                    break;
                }
                case 30: {
                    this.disableLineMode();
                    break;
                }
                case 31: {
                    this.drawLine((Polyline)objectArray[0]);
                }
            }
        }
    }

    protected void enableBlitting(Object[] objectArray) {
        if (this.myWorld == null) {
            this.myWorld = new World();
            FrameBuffer frameBuffer = (FrameBuffer)objectArray[1];
            int n = frameBuffer.getOutputWidth();
            int n2 = frameBuffer.getOutputHeight();
            this.myWorld.getCamera().calcFOV(n, n2);
            this.setFrustum(this.myWorld, frameBuffer);
        }
        super.enableBlitting(objectArray);
    }

    private void blit(Object[] objectArray) {
        if (this.myWorld != null) {
            Camera camera = this.myWorld.getCamera();
            this.blit(objectArray, camera.scaleX, camera.scaleY, camera.frustumOffsetX, camera.frustumOffsetY);
        }
    }

    public void drawStrip(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
        if (this.init) {
            int n3;
            int n4;
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float f9;
            float f10;
            float f11;
            int n5;
            int n6;
            boolean bl;
            this.endState();
            Object3D object3D = visList.vorg[n];
            int n7 = visList.vnum[n];
            int n8 = visList.stageCnt[n];
            if (!visList.splitted) {
                n8 = 0;
            }
            Texture texture = this.setTextures(object3D, n7, n8, frameBuffer, world);
            this.disableBlitting();
            int n9 = texture.width;
            int n10 = texture.height;
            boolean bl2 = texture.projector == null;
            float f12 = 1.0f / (float)n9;
            float f13 = 1.0f / (float)n10;
            Vectors vectors = object3D.objVectors;
            Mesh mesh = object3D.objMesh;
            int[][] nArray = mesh.points;
            float[] fArray = vectors.nuOrg;
            float[] fArray2 = vectors.nvOrg;
            float[] fArray3 = vectors.srOrg;
            float[] fArray4 = vectors.sgOrg;
            float[] fArray5 = vectors.sbOrg;
            int n11 = nArray[visList.vnumOrg[n]][0];
            int n12 = nArray[visList.vnumOrg[n]][1];
            int n13 = nArray[visList.vnumOrg[n]][2];
            float f14 = 1.0f;
            float f15 = 1.0f;
            float f16 = 1.0f;
            boolean bl3 = n8 < 1 && object3D.isTrans && (!object3D.isBumpmapped || !object3D.isEnvmapped);
            boolean bl4 = bl = object3D.usesMultiTexturing && n8 == 0;
            if (bl && object3D.multiTex[0][n7] == -1) {
                bl = false;
            }
            boolean bl5 = object3D.isEnvmapped && !object3D.isBlended && n8 <= 0;
            boolean bl6 = bl5 && (!Config.glForceEnvMapToSecondStage || !bl);
            bl5 = bl5 && Config.glForceEnvMapToSecondStage;
            int n14 = this.currentRGBScaling;
            if (n8 > 0) {
                n6 = (n8 & 0xFFFF) - 1;
                n5 = object3D.multiMode[n6][n7];
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)blendSrcMap[n5], (int)blendDstMap[n5]);
                if (n14 != 1) {
                    this.setRGBScaling(1);
                }
                GL11.glDepthMask((boolean)false);
                GL11.glDepthFunc((int)514);
                f11 = 1.0f;
                f10 = 1.0f;
                f9 = 1.0f;
                f8 = 1.0f;
                f7 = 1.0f;
                f6 = 1.0f;
                f5 = 1.0f;
                f4 = 1.0f;
                f3 = 1.0f;
                fArray = vectors.uMul[n6];
                fArray2 = vectors.vMul[n6];
            } else {
                f11 = fArray3[n11] * COLOR_INV;
                f8 = fArray4[n11] * COLOR_INV;
                f5 = fArray5[n11] * COLOR_INV;
                f10 = fArray3[n12] * COLOR_INV;
                f7 = fArray4[n12] * COLOR_INV;
                f4 = fArray5[n12] * COLOR_INV;
                f9 = fArray3[n13] * COLOR_INV;
                f6 = fArray4[n13] * COLOR_INV;
                f3 = fArray5[n13] * COLOR_INV;
            }
            if (bl3) {
                this.setBlendingMode(object3D.transMode);
                if (n8 == 0) {
                    this.setDepthBuffer();
                }
                if (vectors.alpha == null) {
                    f14 = Config.glTransparencyOffset + (float)object3D.transValue * Config.glTransparencyMul;
                    if (f14 > 1.0f) {
                        f14 = 1.0f;
                    }
                    f15 = f14;
                    f16 = f14;
                } else {
                    f14 = vectors.alpha[n11];
                    f15 = vectors.alpha[n12];
                    f16 = vectors.alpha[n13];
                }
            }
            GL11.glBegin((int)5);
            n6 = mesh.coords[n11];
            n5 = mesh.coords[n12];
            int n15 = mesh.coords[n13];
            float[] fArray6 = vectors.xTr;
            float[] fArray7 = vectors.yTr;
            float[] fArray8 = vectors.zTr;
            float f17 = fArray6[n6];
            float f18 = fArray7[n6];
            float f19 = fArray8[n6];
            float f20 = fArray6[n5];
            float f21 = fArray7[n5];
            float f22 = fArray8[n5];
            float f23 = fArray6[n15];
            float f24 = fArray7[n15];
            float f25 = fArray8[n15];
            int n16 = object3D.maxStagesUsed;
            if (n16 > this.minDriverAndConfig) {
                n16 = this.minDriverAndConfig;
            }
            if (bl2) {
                if (bl6) {
                    f2 = vectors.eu[n11] * f12;
                    f = vectors.ev[n11] * f13;
                } else {
                    f2 = fArray[n11];
                    f = fArray2[n11];
                }
                GL11.glTexCoord2f((float)f2, (float)f);
            }
            if (bl) {
                for (n4 = 0; n4 < n16 - 1; ++n4) {
                    n3 = object3D.multiTex[n4][n7];
                    if (n3 == -1 || this.texMan.textures[n3].projector != null) continue;
                    if (bl5) {
                        ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n4 + 1], (float)(vectors.eu[n11] * f12), (float)(vectors.ev[n11] * f13));
                        continue;
                    }
                    ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n4 + 1], (float)vectors.uMul[n4][n11], (float)vectors.vMul[n4][n11]);
                }
            }
            GL11.glColor4f((float)f11, (float)f8, (float)f5, (float)f14);
            GL11.glVertex3f((float)f17, (float)(-f18), (float)(-f19));
            if (bl2) {
                if (bl6) {
                    f2 = vectors.eu[n12] * f12;
                    f = vectors.ev[n12] * f13;
                } else {
                    f2 = fArray[n12];
                    f = fArray2[n12];
                }
                GL11.glTexCoord2f((float)f2, (float)f);
            }
            if (bl) {
                for (n4 = 0; n4 < n16 - 1; ++n4) {
                    n3 = object3D.multiTex[n4][n7];
                    if (n3 == -1 || this.texMan.textures[n3].projector != null) continue;
                    if (bl5) {
                        ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n4 + 1], (float)(vectors.eu[n12] * f12), (float)(vectors.ev[n12] * f13));
                        continue;
                    }
                    ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n4 + 1], (float)vectors.uMul[n4][n12], (float)vectors.vMul[n4][n12]);
                }
            }
            GL11.glColor4f((float)f10, (float)f7, (float)f4, (float)f15);
            GL11.glVertex3f((float)f20, (float)(-f21), (float)(-f22));
            if (bl2) {
                if (bl6) {
                    f2 = vectors.eu[n13] * f12;
                    f = vectors.ev[n13] * f13;
                } else {
                    f2 = fArray[n13];
                    f = fArray2[n13];
                }
                GL11.glTexCoord2f((float)f2, (float)f);
            }
            if (bl) {
                for (n4 = 0; n4 < n16 - 1; ++n4) {
                    n3 = object3D.multiTex[n4][n7];
                    if (n3 == -1 || this.texMan.textures[n3].projector != null) continue;
                    if (bl5) {
                        ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n4 + 1], (float)(vectors.eu[n13] * f12), (float)(vectors.ev[n13] * f13));
                        continue;
                    }
                    ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n4 + 1], (float)vectors.uMul[n4][n13], (float)vectors.vMul[n4][n13]);
                }
            }
            GL11.glColor4f((float)f9, (float)f6, (float)f3, (float)f16);
            GL11.glVertex3f((float)f23, (float)(-f24), (float)(-f25));
            n2 += ++n;
            f11 = 1.0f;
            f8 = 1.0f;
            f5 = 1.0f;
            for (n4 = n; n4 < n2; ++n4) {
                n12 = nArray[visList.vnumOrg[n4]][2];
                if (n8 <= 0) {
                    f11 = fArray3[n12] * COLOR_INV;
                    f8 = fArray4[n12] * COLOR_INV;
                    f5 = fArray5[n12] * COLOR_INV;
                }
                if (bl2) {
                    if (bl6) {
                        f2 = vectors.eu[n12] * f12;
                        f = vectors.ev[n12] * f13;
                    } else {
                        f2 = fArray[n12];
                        f = fArray2[n12];
                    }
                    GL11.glTexCoord2f((float)f2, (float)f);
                }
                n5 = mesh.coords[n12];
                if (bl) {
                    for (n3 = 0; n3 < n16 - 1; ++n3) {
                        int n17 = object3D.multiTex[n3][n7];
                        if (n17 == -1 || this.texMan.textures[n17].projector != null) continue;
                        if (bl5) {
                            ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n3 + 1], (float)(vectors.eu[n12] * f12), (float)(vectors.ev[n12] * f13));
                            continue;
                        }
                        ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n3 + 1], (float)vectors.uMul[n3][n12], (float)vectors.vMul[n3][n12]);
                    }
                }
                if (vectors.alpha != null) {
                    f14 = vectors.alpha[n12];
                }
                GL11.glColor4f((float)f11, (float)f8, (float)f5, (float)f14);
                GL11.glVertex3f((float)fArray6[n5], (float)(-fArray7[n5]), (float)(-fArray8[n5]));
            }
            GL11.glEnd();
            if (bl3 || n8 > 0) {
                this.unsetBlendingMode();
                GL11.glDepthMask((boolean)true);
                if (n8 > 0) {
                    GL11.glDepthFunc((int)515);
                    if (n14 != 1) {
                        this.setRGBScaling(n14);
                    }
                }
            }
        }
    }

    public void drawPolygon(VisList visList, int n, FrameBuffer frameBuffer, World world) {
        if (this.init) {
            int n2;
            int n3;
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float f9;
            float f10;
            float f11;
            int n4;
            int n5;
            Object3D object3D = visList.vorg[n];
            int n6 = visList.vnum[n];
            Vectors vectors = object3D.objVectors;
            Mesh mesh = object3D.objMesh;
            int[][] nArray = mesh.points;
            int n7 = nArray[visList.vnumOrg[n]][0];
            int n8 = nArray[visList.vnumOrg[n]][1];
            int n9 = nArray[visList.vnumOrg[n]][2];
            int n10 = mesh.coords[n7];
            int n11 = mesh.coords[n8];
            int n12 = mesh.coords[n9];
            float[] fArray = vectors.xTr;
            float[] fArray2 = vectors.yTr;
            float[] fArray3 = vectors.zTr;
            int n13 = visList.stageCnt[n];
            if (!visList.splitted) {
                n13 = 0;
            }
            Texture texture = this.setTextures(object3D, n6, n13, frameBuffer, world);
            this.disableBlitting();
            boolean bl = texture.projector == null;
            int n14 = texture.width;
            int n15 = texture.height;
            float f12 = 1.0f / (float)n14;
            float f13 = 1.0f / (float)n15;
            float f14 = 1.0f;
            float f15 = 1.0f;
            float f16 = 1.0f;
            float[] fArray4 = vectors.nuOrg;
            float[] fArray5 = vectors.nvOrg;
            boolean bl2 = n13 < 1 & object3D.isTrans & (!object3D.isBumpmapped || !object3D.isEnvmapped);
            boolean bl3 = object3D.usesMultiTexturing & n13 == 0;
            if (bl3 && object3D.multiTex[0][n6] == -1) {
                bl3 = false;
            }
            int n16 = this.currentRGBScaling;
            if (n13 > 0) {
                n5 = (n13 & 0xFFFF) - 1;
                n4 = object3D.multiMode[n5][n6];
                this.endState();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)blendSrcMap[n4], (int)blendDstMap[n4]);
                if (n16 != 1) {
                    this.setRGBScaling(1);
                }
                GL11.glDepthMask((boolean)false);
                GL11.glDepthFunc((int)514);
                f11 = 1.0f;
                f10 = 1.0f;
                f9 = 1.0f;
                f8 = 1.0f;
                f7 = 1.0f;
                f6 = 1.0f;
                f5 = 1.0f;
                f4 = 1.0f;
                f3 = 1.0f;
                fArray4 = vectors.uMul[n5];
                fArray5 = vectors.vMul[n5];
            } else {
                f11 = vectors.srOrg[n7] * COLOR_INV;
                f8 = vectors.sgOrg[n7] * COLOR_INV;
                f5 = vectors.sbOrg[n7] * COLOR_INV;
                f10 = vectors.srOrg[n8] * COLOR_INV;
                f7 = vectors.sgOrg[n8] * COLOR_INV;
                f4 = vectors.sbOrg[n8] * COLOR_INV;
                f9 = vectors.srOrg[n9] * COLOR_INV;
                f6 = vectors.sgOrg[n9] * COLOR_INV;
                f3 = vectors.sbOrg[n9] * COLOR_INV;
            }
            if (bl2) {
                this.endState();
                this.setBlendingMode(object3D.transMode);
                if (n13 == 0) {
                    this.setDepthBuffer();
                }
                if (vectors.alpha == null) {
                    f14 = Config.glTransparencyOffset + (float)object3D.transValue * Config.glTransparencyMul;
                    if (f14 > 1.0f) {
                        f14 = 1.0f;
                    }
                    f15 = f14;
                    f16 = f14;
                } else {
                    f14 = vectors.alpha[n7];
                    f15 = vectors.alpha[n8];
                    f16 = vectors.alpha[n9];
                }
            }
            if ((n5 = object3D.maxStagesUsed) > this.minDriverAndConfig) {
                n5 = this.minDriverAndConfig;
            }
            this.beginState(4);
            n4 = object3D.isEnvmapped && !object3D.isBlended && n13 <= 0 ? 1 : 0;
            boolean bl4 = n4 != 0 && (!Config.glForceEnvMapToSecondStage || !bl3);
            int n17 = n4 = n4 != 0 && Config.glForceEnvMapToSecondStage ? 1 : 0;
            if (bl) {
                if (bl4) {
                    f2 = vectors.eu[n7] * f12;
                    f = vectors.ev[n7] * f13;
                } else {
                    f2 = fArray4[n7];
                    f = fArray5[n7];
                }
                GL11.glTexCoord2f((float)f2, (float)f);
            }
            if (bl3) {
                for (n3 = 0; n3 < n5 - 1; ++n3) {
                    n2 = object3D.multiTex[n3][n6];
                    if (n2 == -1 || this.texMan.textures[n2].projector != null) continue;
                    if (n4 != 0) {
                        ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n3 + 1], (float)(vectors.eu[n7] * f12), (float)(vectors.ev[n7] * f13));
                        continue;
                    }
                    ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n3 + 1], (float)vectors.uMul[n3][n7], (float)vectors.vMul[n3][n7]);
                }
            }
            GL11.glColor4f((float)f11, (float)f8, (float)f5, (float)f14);
            GL11.glVertex3f((float)fArray[n10], (float)(-fArray2[n10]), (float)(-fArray3[n10]));
            if (bl) {
                if (bl4) {
                    f2 = vectors.eu[n8] * f12;
                    f = vectors.ev[n8] * f13;
                } else {
                    f2 = fArray4[n8];
                    f = fArray5[n8];
                }
                GL11.glTexCoord2f((float)f2, (float)f);
            }
            if (bl3) {
                for (n3 = 0; n3 < n5 - 1; ++n3) {
                    n2 = object3D.multiTex[n3][n6];
                    if (n2 == -1 || this.texMan.textures[n2].projector != null) continue;
                    if (n4 != 0) {
                        ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n3 + 1], (float)(vectors.eu[n8] * f12), (float)(vectors.ev[n8] * f13));
                        continue;
                    }
                    ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n3 + 1], (float)vectors.uMul[n3][n8], (float)vectors.vMul[n3][n8]);
                }
            }
            GL11.glColor4f((float)f10, (float)f7, (float)f4, (float)f15);
            GL11.glVertex3f((float)fArray[n11], (float)(-fArray2[n11]), (float)(-fArray3[n11]));
            if (bl) {
                if (bl4) {
                    f2 = vectors.eu[n9] * f12;
                    f = vectors.ev[n9] * f13;
                } else {
                    f2 = fArray4[n9];
                    f = fArray5[n9];
                }
                GL11.glTexCoord2f((float)f2, (float)f);
            }
            if (bl3) {
                for (n3 = 0; n3 < n5 - 1; ++n3) {
                    n2 = object3D.multiTex[n3][n6];
                    if (n2 == -1 || this.texMan.textures[n2].projector != null) continue;
                    if (n4 != 0) {
                        ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n3 + 1], (float)(vectors.eu[n9] * f12), (float)(vectors.ev[n9] * f13));
                        continue;
                    }
                    ARBMultitexture.glMultiTexCoord2fARB((int)stageMap[n3 + 1], (float)vectors.uMul[n3][n9], (float)vectors.vMul[n3][n9]);
                }
            }
            GL11.glColor4f((float)f9, (float)f6, (float)f3, (float)f16);
            GL11.glVertex3f((float)fArray[n12], (float)(-fArray2[n12]), (float)(-fArray3[n12]));
            if (bl2 || n13 > 0) {
                this.endState();
                this.unsetBlendingMode();
                GL11.glDepthMask((boolean)true);
                if (n13 > 0) {
                    GL11.glDepthFunc((int)515);
                    if (n16 != 1) {
                        this.setRGBScaling(n16);
                    }
                }
            }
        }
    }

    public void drawVertexArray(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        this.endState();
        this.disableBlitting();
        this.compileDLOrVBO();
        CompiledInstance.lastObj = null;
        this.curPos = 0;
        this.colPos = 0;
        this.texPos = 0;
        this.vertPos = 0;
        boolean bl = false;
        if (this.mtTexPos == null) {
            this.mtTexPos = new int[this.minDriverAndConfig];
        }
        if (this.init) {
            int n3;
            int n4;
            for (n4 = 0; n4 < this.minDriverAndConfig; ++n4) {
                this.lastIDs[n4] = -9999;
                this.lastMultiTextures[n4] = -9999;
                this.lastMultiModes[n4] = -9999;
                this.mtTexPos[n4] = 0;
            }
            n4 = -9999;
            Object3D object3D = null;
            if (!this.vertexArraysInitialized) {
                this.initializeVertexArrays();
            }
            this.wasTransparent = false;
            this.lastTransMode = 0;
            this.lastTexture = -9999;
            Texture texture = null;
            int n5 = 0;
            int n6 = 0;
            float f12 = 0.0f;
            float f13 = 0.0f;
            int n7 = n4;
            Object3D object3D2 = null;
            int n8 = 0;
            int n9 = 0;
            int n10 = this.currentRGBScaling;
            int[] nArray = world.getAmbientLight();
            for (n3 = 0; n3 < 3; ++n3) {
                this.ambientTmp[n3] = (float)nArray[n3] * COLOR_INV;
                if (this.ambientTmp[n3] < 0.0f) {
                    this.ambientTmp[n3] = 0.0f;
                }
                this.colsTmp[n3] = 0.0f;
            }
            this.colsTmp[3] = 0.0f;
            this.ambientBuffer.rewind();
            this.ambientBuffer.put(this.ambientTmp);
            this.ambientBuffer.put(1.0f);
            this.blending = false;
            for (n3 = n; n3 <= n2; ++n3) {
                int n11;
                Object object;
                int n12;
                int n13;
                boolean bl2;
                boolean bl3;
                int n14;
                int n15;
                boolean bl4 = false;
                boolean bl5 = false;
                object3D = object3D2;
                object3D2 = visList.vorg[n3];
                n4 = n7;
                n7 = visList.vnum[n3];
                n9 = n8;
                n8 = 0;
                if (visList.splitted) {
                    n8 = visList.stageCnt[n3];
                }
                if ((n15 = object3D2.maxStagesUsed) > this.minDriverAndConfig) {
                    n15 = this.minDriverAndConfig;
                }
                Vectors vectors = object3D2.objVectors;
                Mesh mesh = object3D2.objMesh;
                float[] fArray = vectors.nuOrg;
                float[] fArray2 = vectors.nvOrg;
                float[][] fArray3 = vectors.uMul;
                float[][] fArray4 = vectors.vMul;
                float[] fArray5 = vectors.xTr;
                float[] fArray6 = vectors.yTr;
                float[] fArray7 = vectors.zTr;
                float[] fArray8 = vectors.srOrg;
                float[] fArray9 = vectors.sgOrg;
                float[] fArray10 = vectors.sbOrg;
                int n16 = mesh.points[visList.vnumOrg[n3]][0];
                int n17 = mesh.points[visList.vnumOrg[n3]][1];
                int n18 = mesh.points[visList.vnumOrg[n3]][2];
                boolean bl6 = object3D2.isCompiled();
                if (n8 > 0) {
                    n14 = (n8 & 0xFFFF) - 1;
                    texture = this.texMan.textures[object3D2.multiTex[n14][n7]];
                    fArray = vectors.uMul[n14];
                    fArray2 = vectors.vMul[n14];
                    f3 = 1.0f;
                    f6 = 1.0f;
                    f9 = 1.0f;
                    f4 = 1.0f;
                    f7 = 1.0f;
                    f10 = 1.0f;
                    f5 = 1.0f;
                    f8 = 1.0f;
                    f11 = 1.0f;
                } else {
                    if (!bl6) {
                        f3 = fArray8[n16] * COLOR_INV;
                        f4 = fArray9[n16] * COLOR_INV;
                        f5 = fArray10[n16] * COLOR_INV;
                        f6 = fArray8[n17] * COLOR_INV;
                        f7 = fArray9[n17] * COLOR_INV;
                        f8 = fArray10[n17] * COLOR_INV;
                        f9 = fArray8[n18] * COLOR_INV;
                        f10 = fArray9[n18] * COLOR_INV;
                        f11 = fArray10[n18] * COLOR_INV;
                    }
                    texture = this.texMan.textures[object3D2.texture[n7]];
                }
                if (object3D2.isBlended) {
                    texture = this.texMan.textures[object3D2.basemap[n7]];
                }
                n5 = texture.width;
                n6 = texture.height;
                n14 = texture.projector == null ? 1 : 0;
                int n19 = mesh.coords[n16];
                int n20 = mesh.coords[n17];
                int n21 = mesh.coords[n18];
                boolean bl7 = n8 < 1 && object3D2.isTrans && (!object3D2.isBumpmapped || !object3D2.isEnvmapped);
                boolean bl8 = bl3 = object3D2.usesMultiTexturing && n8 == 0;
                if (bl3 && object3D2.multiTex[0][n7] == -1) {
                    bl3 = false;
                }
                boolean bl9 = object3D2.isEnvmapped && !object3D2.isBlended && n8 <= 0;
                boolean bl10 = bl9 && (!Config.glForceEnvMapToSecondStage || !bl3);
                boolean bl11 = bl9 = bl9 && Config.glForceEnvMapToSecondStage;
                if (!bl6) {
                    if (bl10) {
                        f12 = 1.0f / (float)n5;
                        f13 = 1.0f / (float)n6;
                        f = vectors.eu[n16] * f12;
                        f2 = vectors.ev[n16] * f13;
                    } else {
                        f = fArray[n16];
                        f2 = fArray2[n16];
                    }
                }
                float f14 = 1.0f;
                float f15 = 1.0f;
                float f16 = 1.0f;
                if (bl7) {
                    if (vectors.alpha == null) {
                        f14 = Config.glTransparencyOffset + (float)object3D2.transValue * Config.glTransparencyMul;
                        if (f14 > 1.0f) {
                            f14 = 1.0f;
                        }
                        f15 = f14;
                        f16 = f14;
                    } else {
                        f14 = vectors.alpha[n16];
                        f15 = vectors.alpha[n17];
                        f16 = vectors.alpha[n18];
                    }
                }
                boolean bl12 = bl2 = texture.getOpenGLID(this.myID) != this.lastTexture;
                if (this.lastCoords != this.veryLastCoords) {
                    this.enableVertexArrays(this.lastCoords, this.veryLastCoords);
                }
                this.veryLastCoords = this.lastCoords;
                this.lastCoords = 1;
                if (bl3) {
                    for (n13 = 1; n13 < n15 && object3D2.multiTex[n13 - 1][n7] != -1; ++n13) {
                        ++this.lastCoords;
                    }
                }
                if (!bl2) {
                    bl2 |= texture.getOpenGLID(this.myID) == 0 || texture.getMarker(this.myID) == Texture.MARKER_DELETE_AND_UPLOAD;
                    bl2 |= this.lastCoords != this.veryLastCoords;
                    bl2 |= object3D != null && object3D2.maxStagesUsed != object3D.maxStagesUsed;
                }
                if (!bl2 && bl3) {
                    for (n13 = 1; n13 < n15; ++n13) {
                        n12 = object3D2.multiTex[n13 - 1][n7];
                        if (n12 != -1) {
                            object = this.texMan.textures[n12];
                            if (!((Texture)object).enabled || ((Texture)object).getOpenGLID(this.myID) == this.lastMultiTextures[n13] && object3D2.multiMode[n13 - 1][n7] == this.lastMultiModes[n13] && ((Texture)object).getOpenGLID(this.myID) != 0 && ((Texture)object).getMarker(this.myID) != Texture.MARKER_DELETE_AND_UPLOAD) continue;
                            bl2 = true;
                            break;
                        }
                        if (this.lastMultiTextures[n13] == -1 || this.lastMultiTextures[n13] == -9999) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (bl6 && this.curPos != 0 || bl7 != this.wasTransparent || object3D2.transMode != this.lastTransMode || bl2 || this.curPos >= 997 || n8 != n9) {
                    if (n3 != n) {
                        if (bl) {
                            this.disableCompiledPipeline();
                            this.renableVertexArrays();
                            bl = false;
                        }
                        if (this.wasTransparent) {
                            this.setBlendingMode(this.lastTransMode);
                            if (n9 == 0) {
                                this.setDepthBuffer();
                            }
                            bl4 = true;
                        }
                        if (n9 > 0) {
                            n13 = object3D.multiMode[(n9 & 0xFFFF) - 1][n4];
                            GL11.glEnable((int)3042);
                            GL11.glBlendFunc((int)blendSrcMap[n13], (int)blendDstMap[n13]);
                            if (n10 != 1) {
                                this.setRGBScaling(1);
                            }
                            GL11.glDepthMask((boolean)false);
                            GL11.glDepthFunc((int)514);
                            bl5 = true;
                        }
                        this.setTextures(object3D, n4, n9, frameBuffer, world);
                        this.renderVertexArray(this.curPos);
                    }
                    this.wasTransparent = bl7;
                    this.lastTransMode = object3D2.transMode;
                    this.curPos = 0;
                    this.colPos = 0;
                    this.texPos = 0;
                    for (n13 = 0; n13 < this.mtTexPos.length; ++n13) {
                        this.mtTexPos[n13] = 0;
                    }
                    this.vertPos = 0;
                    this.lastTexture = texture.getOpenGLID(this.myID);
                    for (n13 = 1; n13 < n15; ++n13) {
                        n12 = object3D2.multiTex[n13 - 1][n7];
                        if (n12 != -1) {
                            object = this.texMan.textures[n12];
                            this.lastMultiTextures[n13] = ((Texture)object).getOpenGLID(this.myID);
                            this.lastMultiModes[n13] = object3D2.multiMode[n13 - 1][n7];
                            continue;
                        }
                        this.lastMultiTextures[n13] = -9999;
                        this.lastMultiModes[n13] = -9999;
                    }
                }
                if (bl6) {
                    if (bl4 || bl5) {
                        this.blending = false;
                        this.unsetBlendingMode();
                        GL11.glDepthMask((boolean)true);
                        bl4 = false;
                        if (bl5) {
                            bl5 = false;
                            GL11.glDepthFunc((int)515);
                            if (n10 != 1) {
                                this.setRGBScaling(n10);
                            }
                        }
                    }
                    if (!bl) {
                        this.enableCompiledPipeline();
                    }
                    if (object3D2.isTrans) {
                        if (!this.blending) {
                            this.setBlendingMode(object3D2.transMode);
                        }
                        bl4 = true;
                        if (n8 == 0) {
                            Object3D object3D3;
                            if (!this.blending) {
                                this.setDepthBuffer();
                            }
                            if (n3 < n2 && (object3D3 = visList.vorg[n3 + 1]).isCompiled() && object3D3.isTrans == object3D2.isTrans && object3D3.transMode == object3D2.transMode) {
                                bl4 = false;
                                this.blending = true;
                            }
                        }
                    }
                    if (n8 > 0) {
                        int n22 = object3D2.multiMode[(n8 & 0xFFFF) - 1][n7];
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)blendSrcMap[n22], (int)blendDstMap[n22]);
                        if (n10 != 1) {
                            this.setRGBScaling(1);
                        }
                        GL11.glDepthMask((boolean)false);
                        GL11.glDepthFunc((int)514);
                        bl5 = true;
                    }
                    this.setTextures(object3D2, n7, n8, frameBuffer, world);
                    Color color = object3D2.getAdditionalColor();
                    this.colsTmp[0] = (float)color.getRed() * COLOR_INV;
                    this.colsTmp[1] = (float)color.getGreen() * COLOR_INV;
                    this.colsTmp[2] = (float)color.getBlue() * COLOR_INV;
                    float f17 = 1.0f;
                    if (bl7 && (f17 = Config.glTransparencyOffset + (float)object3D2.transValue * Config.glTransparencyMul) > 1.0f) {
                        f17 = 1.0f;
                    }
                    this.colsTmp[3] = f17;
                    object = (CompiledInstance)object3D2.compiled.get(visList.portalNum[n3]);
                    this.clearHook(object3D2.getHookInternal());
                    ((CompiledInstance)object).render(this.myID, this, this.ambientBuffer, this.colsTmp, this.renderTarget != null && this.renderTarget.isShadowMap, world.camera, object3D2.nearestLights, false, null);
                    bl = true;
                    this.curPos = 0;
                    this.colPos = 0;
                    this.texPos = 0;
                    for (n11 = 0; n11 < this.mtTexPos.length; ++n11) {
                        this.mtTexPos[n11] = 0;
                    }
                    this.vertPos = 0;
                } else {
                    this.colors.put(this.colPos, f3);
                    this.colors.put(this.colPos + 1, f4);
                    this.colors.put(this.colPos + 2, f5);
                    this.colors.put(this.colPos + 3, f14);
                    this.colPos += 4;
                    this.vertices.put(this.vertPos, fArray5[n19]);
                    this.vertices.put(this.vertPos + 1, -fArray6[n19]);
                    this.vertices.put(this.vertPos + 2, -fArray7[n19]);
                    this.vertPos += 3;
                    if (n14 != 0) {
                        this.textures.put(this.texPos, f);
                        this.textures.put(this.texPos + 1, f2);
                        this.texPos += 2;
                    }
                    if (bl3) {
                        for (n13 = 1; n13 < n15; ++n13) {
                            float[] fArray11;
                            float[] fArray12;
                            n12 = n13 - 1;
                            int n23 = object3D2.multiTex[n12][n7];
                            if (n23 == -1 || this.texMan.textures[n23].projector != null) continue;
                            n11 = this.mtTexPos[n13];
                            FloatBuffer floatBuffer = this.multiTextures[n13];
                            if (bl9) {
                                f12 = 1.0f / (float)n5;
                                f13 = 1.0f / (float)n6;
                                fArray12 = vectors.eu;
                                fArray11 = vectors.ev;
                                floatBuffer.put(n11, fArray12[n16] * f12);
                                floatBuffer.put(n11 + 1, fArray11[n16] * f13);
                                floatBuffer.put(n11 + 2, fArray12[n17] * f12);
                                floatBuffer.put(n11 + 3, fArray11[n17] * f13);
                                floatBuffer.put(n11 + 4, fArray12[n18] * f12);
                                floatBuffer.put(n11 + 5, fArray11[n18] * f13);
                            } else {
                                fArray12 = fArray3[n12];
                                fArray11 = fArray4[n12];
                                floatBuffer.put(n11, fArray12[n16]);
                                floatBuffer.put(n11 + 1, fArray11[n16]);
                                floatBuffer.put(n11 + 2, fArray12[n17]);
                                floatBuffer.put(n11 + 3, fArray11[n17]);
                                floatBuffer.put(n11 + 4, fArray12[n18]);
                                floatBuffer.put(n11 + 5, fArray11[n18]);
                            }
                            int n24 = n13;
                            this.mtTexPos[n24] = this.mtTexPos[n24] + 6;
                        }
                    }
                    ++this.curPos;
                    if (bl10) {
                        f = vectors.eu[n17] * f12;
                        f2 = vectors.ev[n17] * f13;
                    } else {
                        f = fArray[n17];
                        f2 = fArray2[n17];
                    }
                    this.colors.put(this.colPos, f6);
                    this.colors.put(this.colPos + 1, f7);
                    this.colors.put(this.colPos + 2, f8);
                    this.colors.put(this.colPos + 3, f15);
                    this.colPos += 4;
                    this.vertices.put(this.vertPos, fArray5[n20]);
                    this.vertices.put(this.vertPos + 1, -fArray6[n20]);
                    this.vertices.put(this.vertPos + 2, -fArray7[n20]);
                    this.vertPos += 3;
                    if (n14 != 0) {
                        this.textures.put(this.texPos, f);
                        this.textures.put(this.texPos + 1, f2);
                        this.texPos += 2;
                    }
                    ++this.curPos;
                    if (bl10) {
                        f = vectors.eu[n18] * f12;
                        f2 = vectors.ev[n18] * f13;
                    } else {
                        f = fArray[n18];
                        f2 = fArray2[n18];
                    }
                    this.colors.put(this.colPos, f9);
                    this.colors.put(this.colPos + 1, f10);
                    this.colors.put(this.colPos + 2, f11);
                    this.colors.put(this.colPos + 3, f16);
                    this.colPos += 4;
                    this.vertices.put(this.vertPos, fArray5[n21]);
                    this.vertices.put(this.vertPos + 1, -fArray6[n21]);
                    this.vertices.put(this.vertPos + 2, -fArray7[n21]);
                    this.vertPos += 3;
                    if (n14 != 0) {
                        this.textures.put(this.texPos, f);
                        this.textures.put(this.texPos + 1, f2);
                        this.texPos += 2;
                    }
                    ++this.curPos;
                    if (n2 == n3) {
                        if (bl) {
                            this.disableCompiledPipeline();
                            this.renableVertexArrays();
                            bl = false;
                        }
                        if (bl7) {
                            this.setBlendingMode(object3D2.transMode);
                            if (n8 == 0) {
                                this.setDepthBuffer();
                            }
                            this.wasTransparent = bl7;
                            this.lastTransMode = object3D2.transMode;
                            bl4 = true;
                        }
                        if (n8 > 0) {
                            n13 = object3D2.multiMode[(n8 & 0xFFFF) - 1][n7];
                            GL11.glEnable((int)3042);
                            GL11.glBlendFunc((int)blendSrcMap[n13], (int)blendDstMap[n13]);
                            if (n10 != 1) {
                                this.setRGBScaling(1);
                            }
                            GL11.glDepthMask((boolean)false);
                            GL11.glDepthFunc((int)514);
                            bl5 = true;
                        }
                        this.setTextures(object3D2, n7, n8, frameBuffer, world);
                        this.renderVertexArray(this.curPos);
                        this.curPos = 0;
                        this.colPos = 0;
                        this.texPos = 0;
                        this.vertPos = 0;
                        for (n13 = 0; n13 < this.mtTexPos.length; ++n13) {
                            this.mtTexPos[n13] = 0;
                        }
                    }
                }
                if (!bl4 && !bl5) continue;
                this.blending = false;
                this.unsetBlendingMode();
                GL11.glDepthMask((boolean)true);
                if (!bl5) continue;
                GL11.glDepthFunc((int)515);
                if (n10 == 1) continue;
                this.setRGBScaling(n10);
            }
        }
        this.setTextureMatrix(null);
        this.matrixCache.clear();
        if (bl) {
            this.disableCompiledPipeline();
            this.renableVertexArrays();
        }
        CompiledInstance.lastObj = null;
    }

    public void drawWireframe(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
        if (this.init) {
            this.endState();
            this.disableBlitting();
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            this.disableAllHigherStages();
            Object3D object3D = visList.vorg[n];
            Vectors vectors = object3D.objVectors;
            Mesh mesh = object3D.objMesh;
            int n3 = mesh.points[visList.vnumOrg[n]][0];
            int n4 = mesh.points[visList.vnumOrg[n]][1];
            int n5 = mesh.points[visList.vnumOrg[n]][2];
            int n6 = mesh.coords[n3];
            int n7 = mesh.coords[n4];
            int n8 = mesh.coords[n5];
            this.beginState(4);
            int n9 = n2 >> 16 & 0xFF;
            int n10 = n2 >> 8 & 0xFF;
            int n11 = n2 & 0xFF;
            GL11.glColor3f((float)((float)n9 / 255.0f), (float)((float)n10 / 255.0f), (float)((float)n11 / 255.0f));
            if (!object3D.isCompiled()) {
                GL11.glVertex3f((float)vectors.xTr[n6], (float)(-vectors.yTr[n6]), (float)(-vectors.zTr[n6]));
                GL11.glVertex3f((float)vectors.xTr[n7], (float)(-vectors.yTr[n7]), (float)(-vectors.zTr[n7]));
                GL11.glVertex3f((float)vectors.xTr[n8], (float)(-vectors.yTr[n8]), (float)(-vectors.zTr[n8]));
            } else {
                CompiledInstance compiledInstance = (CompiledInstance)object3D.compiled.get(visList.portalNum[n]);
                compiledInstance.render(this.myID, this, null, null, false, world.camera, null, true, null);
                this.disableCompiledPipeline();
                this.renableVertexArrays();
                this.matrixCache.clear();
            }
            this.endState();
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3553);
            GL11.glPolygonMode((int)1032, (int)6914);
        }
    }

    private Texture setTextures(Object3D object3D, int n, int n2, FrameBuffer frameBuffer, World world) {
        boolean bl = false;
        Texture texture = null;
        if (n2 < 1) {
            texture = this.texMan.textures[object3D.texture[n]];
            if (object3D.isBlended) {
                texture = this.texMan.textures[object3D.basemap[n]];
            }
        } else {
            texture = this.texMan.textures[object3D.multiTex[(n2 & 0xFFFF) - 1][n]];
        }
        if (texture.getOpenGLID(this.myID) == 0 || texture.getMarker(this.myID) == Texture.MARKER_DELETE_AND_UPLOAD) {
            texture.setMarker(this.myID, Texture.MARKER_NOTHING);
            this.endState();
            if (texture != this.renderTarget) {
                if (texture.getOpenGLID(this.myID) != 0) {
                    this.removeTexture(texture);
                }
                this.convertTexture(texture);
            }
            this.lastTextures[0] = -1;
        }
        bl = texture.isShadowMap;
        this.setTextureMatrix(object3D.textureMatrix);
        this.bindAndProject(0, texture, world.getCamera());
        if (object3D.usesMultiTexturing && n2 == 0) {
            if (this.maxStages < object3D.maxStagesUsed) {
                this.maxStages = object3D.maxStagesUsed;
                if (this.maxStages > this.minDriverAndConfig) {
                    this.maxStages = this.minDriverAndConfig;
                }
            }
            int n3 = object3D.multiTex.length;
            for (int i = 1; i < this.maxStages; ++i) {
                int n4;
                int n5 = i - 1;
                int n6 = n4 = n5 >= n3 ? -1 : object3D.multiTex[n5][n];
                if (n4 != -1) {
                    Texture texture2 = this.texMan.textures[n4];
                    if (texture2.enabled) {
                        bl |= texture2.isShadowMap;
                        int n7 = modeMap[object3D.multiMode[n5][n]];
                        if (Config.glRevertADDtoMODULATE && (n7 == 260 || n7 == 34164 || n7 == 34023)) {
                            n7 = 8448;
                        }
                        if (!this.stageInitialized[i]) {
                            this.initTextureStage(i, n7);
                        } else {
                            this.switchTextureMode(i, n7);
                        }
                        if (texture2.getOpenGLID(this.myID) == 0 || texture2.getMarker(this.myID) == Texture.MARKER_DELETE_AND_UPLOAD) {
                            texture2.setMarker(this.myID, Texture.MARKER_NOTHING);
                            this.endState();
                            if (texture2 != this.renderTarget) {
                                if (texture2.getOpenGLID(this.myID) != 0) {
                                    this.removeTexture(texture2);
                                }
                                this.convertTexture(texture2);
                            }
                            this.lastTextures[i] = -1;
                        }
                        this.bindAndProject(i, texture2, world.getCamera());
                        continue;
                    }
                    this.disableStage(i);
                    continue;
                }
                this.disableStage(i);
            }
        } else {
            this.disableUnusedStages();
        }
        if (!bl) {
            this.disableGlobalAlphaTest();
        }
        return texture;
    }
}

