/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.IVertexController;
import com.threed.jpct.Logger;
import com.threed.jpct.Mesh;
import com.threed.jpct.SimpleVector;
import java.io.Serializable;

public abstract class GenericVertexController
implements IVertexController,
Serializable {
    private SimpleVector[] meshData;
    private SimpleVector[] normalData;
    private SimpleVector[] meshTarget;
    private SimpleVector[] normalTarget;
    private Mesh mesh;
    private int size = 0;
    private boolean initialized = false;

    public final boolean init(Mesh mesh, boolean bl) {
        boolean bl2 = true;
        if (!this.initialized) {
            int n;
            this.mesh = mesh;
            if (!mesh.normalsCalculated) {
                Logger.log("No normals have been calculated for this mesh yet!", 1);
            }
            if ((n = mesh.obbStart) == 0 || mesh.obbEnd + 1 != mesh.anzCoords) {
                n = mesh.anzCoords;
            }
            this.size = n;
            this.meshData = new SimpleVector[n];
            this.normalData = new SimpleVector[n];
            if (bl) {
                this.meshTarget = this.meshData;
                this.normalTarget = this.normalData;
            } else {
                this.meshTarget = new SimpleVector[n];
                this.normalTarget = new SimpleVector[n];
            }
            for (int i = 0; i < n; ++i) {
                float f = mesh.xOrg[i];
                float f2 = mesh.yOrg[i];
                float f3 = mesh.zOrg[i];
                float f4 = mesh.nxOrg[i];
                float f5 = mesh.nyOrg[i];
                float f6 = mesh.nzOrg[i];
                if (!bl) {
                    this.meshTarget[i] = new SimpleVector(f, f2, f3);
                    this.normalTarget[i] = new SimpleVector(f4, f5, f6);
                }
                this.meshData[i] = new SimpleVector(f, f2, f3);
                this.normalData[i] = new SimpleVector(f4, f5, f6);
            }
            this.initialized = bl2 &= this.setup();
        } else {
            bl2 = false;
            Logger.log("This instance has already been assigned to another Mesh!", 0);
        }
        return bl2;
    }

    public boolean setup() {
        return true;
    }

    public final SimpleVector[] getSourceMesh() {
        return this.meshData;
    }

    public final SimpleVector[] getSourceNormals() {
        return this.normalData;
    }

    public final SimpleVector[] getDestinationMesh() {
        return this.meshTarget;
    }

    public final SimpleVector[] getDestinationNormals() {
        return this.normalTarget;
    }

    public final int getMeshSize() {
        return this.size;
    }

    public void refreshMeshData() {
        for (int i = 0; i < this.size; ++i) {
            this.meshTarget[i].x = this.mesh.xOrg[i];
            this.meshTarget[i].y = this.mesh.yOrg[i];
            this.meshTarget[i].z = this.mesh.zOrg[i];
            this.normalData[i].x = this.mesh.nxOrg[i];
            this.normalData[i].y = this.mesh.nyOrg[i];
            this.normalData[i].z = this.mesh.nzOrg[i];
        }
    }

    public final void updateMesh() {
        int n;
        if (this.size == 0) {
            return;
        }
        float f = 1.0E11f;
        float f2 = -1.0E11f;
        float f3 = 1.0E11f;
        float f4 = -1.0E11f;
        float f5 = 1.0E11f;
        float f6 = -1.0E11f;
        for (n = 0; n < this.size; ++n) {
            float f7 = this.meshTarget[n].x;
            float f8 = this.meshTarget[n].y;
            float f9 = this.meshTarget[n].z;
            this.mesh.xOrg[n] = f7;
            this.mesh.yOrg[n] = f8;
            this.mesh.zOrg[n] = f9;
            this.mesh.nxOrg[n] = this.normalTarget[n].x;
            this.mesh.nyOrg[n] = this.normalTarget[n].y;
            this.mesh.nzOrg[n] = this.normalTarget[n].z;
            if (f7 < f) {
                f = f7;
            }
            if (f7 > f2) {
                f2 = f7;
            }
            if (f8 < f3) {
                f3 = f8;
            }
            if (f8 > f4) {
                f4 = f8;
            }
            if (f9 < f5) {
                f5 = f9;
            }
            if (!(f9 > f6)) continue;
            f6 = f9;
        }
        if (this.mesh.obbEnd == this.mesh.obbStart) {
            this.mesh.obbStart = this.mesh.anzCoords;
            this.mesh.obbEnd = this.size + 7;
            this.mesh.anzCoords += 8;
        }
        n = this.mesh.obbStart;
        this.mesh.xOrg[n] = f;
        this.mesh.yOrg[n] = f3;
        this.mesh.zOrg[n] = f5;
        this.mesh.xOrg[++n] = f;
        this.mesh.yOrg[n] = f3;
        this.mesh.zOrg[n] = f6;
        this.mesh.xOrg[++n] = f2;
        this.mesh.yOrg[n] = f3;
        this.mesh.zOrg[n] = f5;
        this.mesh.xOrg[++n] = f2;
        this.mesh.yOrg[n] = f3;
        this.mesh.zOrg[n] = f6;
        this.mesh.xOrg[++n] = f2;
        this.mesh.yOrg[n] = f4;
        this.mesh.zOrg[n] = f5;
        this.mesh.xOrg[++n] = f2;
        this.mesh.yOrg[n] = f4;
        this.mesh.zOrg[n] = f6;
        this.mesh.xOrg[++n] = f;
        this.mesh.yOrg[n] = f4;
        this.mesh.zOrg[n] = f5;
        this.mesh.xOrg[++n] = f;
        this.mesh.yOrg[n] = f4;
        this.mesh.zOrg[n] = f6;
    }

    public final void destroy() {
        this.cleanup();
        this.initialized = false;
    }

    public void cleanup() {
    }

    public int[] getPolygonIDs(int n, int n2) {
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < this.mesh.anzTri && n3 < n2; ++i) {
            if (this.mesh.coords[this.mesh.points[i][0]] != n && this.mesh.coords[this.mesh.points[i][1]] != n && this.mesh.coords[this.mesh.points[i][2]] != n) continue;
            nArray[n3] = i;
            ++n3;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public float[][] getTangentVectors() {
        return this.mesh.tangentVectors;
    }
}

