/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.AWTDisplayList;
import com.threed.jpct.Camera;
import com.threed.jpct.Config;
import com.threed.jpct.IThreadBuffer;
import com.threed.jpct.JOGLRenderer;
import com.threed.jpct.Logger;
import com.threed.jpct.VisList;
import java.lang.reflect.Field;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.Util;

class JOGLCanvas
extends GLCanvas
implements IThreadBuffer,
GLEventListener {
    private static final long serialVersionUID = 1L;
    private JOGLRenderer renderer = null;
    private AWTDisplayList[] list = null;
    private AWTDisplayList onceList = null;
    private int curList = 0;
    private Object lock = new Object();
    private boolean paintObserver = false;
    private Object[] result = null;

    JOGLCanvas() throws Exception {
    }

    JOGLCanvas(JOGLRenderer jOGLRenderer) throws Exception {
        this.init(jOGLRenderer);
        this.addGLEventListener(this);
    }

    JOGLCanvas(JOGLRenderer jOGLRenderer, GLCapabilities gLCapabilities) throws Exception {
        super(gLCapabilities);
        this.init(jOGLRenderer);
        this.addGLEventListener(this);
    }

    public void setSamples(int n) {
    }

    protected void init(JOGLRenderer jOGLRenderer) {
        this.renderer = jOGLRenderer;
        this.list = new AWTDisplayList[2];
        this.list[0] = new AWTDisplayList();
        this.list[1] = new AWTDisplayList();
        this.onceList = new AWTDisplayList();
    }

    public void dispose() {
        this.setEnabled(false);
    }

    public final void add(int n, Object object) {
        this.list[this.curList].add(n, object);
    }

    public void add(Camera camera, int[] nArray) {
        Object[] objectArray = new Object[2];
        Camera camera2 = new Camera();
        camera2.setBack(camera.getBack().cloneMatrix());
        camera2.setPosition(camera.getPosition());
        camera2.setFOVLimits(camera.getMinFOV(), camera.getMaxFOV());
        camera2.setFOV(camera.getFOV());
        objectArray[0] = camera2;
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[i];
        }
        objectArray[1] = nArray2;
        this.add(21, objectArray);
    }

    public final void addOnce(int n, Object object) {
        this.onceList.addOnce(n, object);
    }

    public Object getLock() {
        return this.lock;
    }

    public final void add(VisList visList, int n, int n2, int n3) {
        this.list[this.curList].add(visList, n, n2, n3);
    }

    public void enableRenderTarget() {
        this.list[this.curList].enableRenderTarget();
    }

    public void disableRenderTarget() {
        this.list[this.curList].disableRenderTarget();
    }

    public boolean hasRenderTarget() {
        return this.list[this.curList].hasRenderTarget();
    }

    public final void setColor(int n) {
        this.list[this.curList].setColor(n);
    }

    public final AWTDisplayList getDisplayList() {
        return this.list[this.curList];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void switchList() {
        if (Config.synchronizedRendering) {
            while (!this.list[this.curList ^ 1].rendered) {
                Thread.yield();
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.list[this.curList].switchBuffers();
            this.curList ^= 1;
            this.list[this.curList].reset();
        }
    }

    public final boolean hasBeenPainted() {
        return this.paintObserver;
    }

    public final void observePainting() {
        this.paintObserver = false;
    }

    public final Object[] getPaintResults() {
        if (this.hasBeenPainted()) {
            Object[] objectArray = this.result;
            this.result = null;
            return objectArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(GLAutoDrawable gLAutoDrawable) {
        try {
            if (!this.renderer.isDisposed()) {
                this.injectGL();
                if (!this.renderer.isInitialized()) {
                    this.renderer.init();
                }
                this.renderer.execute(12, null);
                Object object = this.lock;
                synchronized (object) {
                    int n;
                    int n2;
                    int n3 = this.curList ^ 1;
                    AWTDisplayList aWTDisplayList = this.list[n3];
                    int n4 = aWTDisplayList.count;
                    block12: for (n2 = 0; n2 < n4; ++n2) {
                        n = aWTDisplayList.mode[n2];
                        switch (n) {
                            case 3: {
                                this.renderer.executeGL(aWTDisplayList, n2);
                                continue block12;
                            }
                            case 2: {
                                this.renderer.drawVertexArray(aWTDisplayList, n2);
                                continue block12;
                            }
                            case 1: {
                                this.renderer.drawStrip(aWTDisplayList, n2);
                                continue block12;
                            }
                            case 0: {
                                this.renderer.drawPolygon(aWTDisplayList, n2);
                                continue block12;
                            }
                            case 5: {
                                this.renderer.drawWireframe(aWTDisplayList, n2);
                            }
                        }
                    }
                    n2 = this.paintObserver ? 1 : 0;
                    if (this.onceList.count != 0) {
                        n = 0;
                        for (int i = 0; i < this.onceList.count; ++i) {
                            int n5 = this.onceList.mode[i];
                            if (n5 != 4 || n2 != 0) continue;
                            this.result = this.renderer.executeGL(this.onceList, i);
                            this.onceList.delete(i);
                            n = 1;
                        }
                        this.paintObserver = n;
                    }
                }
            }
            this.renderer.execute(13, null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    private void injectGL() {
        Class[] classArray = new Class[]{GL11.class, GL15.class, GL20.class, Util.class, ARBMultitexture.class, EXTFramebufferObject.class, ARBShaderObjects.class, org.lwjgl.opengl.GLContext.class};
        GL gL = GLContext.getCurrent().getGL();
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            try {
                Field field = clazz.getDeclaredField("gl");
                field.set(clazz, gL);
                continue;
            }
            catch (Exception exception) {
                Logger.log("Unable to inject GL context into the facade!", 0);
            }
        }
    }
}

