/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.AWTGLRenderer;
import com.threed.jpct.Config;
import com.threed.jpct.JOGLCanvas;
import com.threed.jpct.Logger;
import com.threed.jpct.VideoMode;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.media.opengl.GLCapabilities;

public class JOGLRenderer
extends AWTGLRenderer {
    JOGLRenderer() {
    }

    public void init(int n, int n2, int n3, int n4, int n5) {
        this.init = false;
        try {
            GLCapabilities gLCapabilities = this.getPixelFormatFromConfig();
            if (gLCapabilities == null && n5 > 0) {
                DisplayMode displayMode = this.findMode(n, n2, n3, n4);
                if (displayMode != null) {
                    try {
                        gLCapabilities = JOGLRenderer.createPixelFormat(displayMode.getBitDepth(), 0, n4, 0, n5);
                    }
                    catch (Exception exception) {
                        Logger.log("Number of samples not supported or incorrect video mode!", 0);
                        n5 = 0;
                    }
                } else {
                    Logger.log("Can't set videomode - try different settings!", 0);
                }
            }
            this.canvas = gLCapabilities == null ? new JOGLCanvas(this) : new JOGLCanvas(this, gLCapabilities);
            this.canvas.setBounds(0, 0, n, n2);
            this.canvas.setSamples(n5);
            this.xp = n;
            this.yp = n2;
        }
        catch (Exception exception) {
            Logger.log("Can't initialize canvas!", 0);
            exception.printStackTrace();
        }
    }

    public VideoMode[] getAvailableVideoModes() {
        try {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            DisplayMode[] displayModeArray = graphicsDevice.getDisplayModes();
            VideoMode[] videoModeArray = new VideoMode[displayModeArray.length];
            for (int i = 0; i < displayModeArray.length; ++i) {
                if (displayModeArray[i] == null) continue;
                videoModeArray[i] = new VideoMode(displayModeArray[i].getWidth(), displayModeArray[i].getHeight(), displayModeArray[i].getBitDepth(), Config.glZBufferDepth, displayModeArray[i].getRefreshRate());
            }
            return videoModeArray;
        }
        catch (Exception exception) {
            Logger.log("Couldn't get available video modes: " + exception.getMessage(), 0);
            return null;
        }
    }

    private DisplayMode findMode(int n, int n2, int n3, int n4) throws Exception {
        int n5;
        int n6 = -1;
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode[] displayModeArray = graphicsDevice.getDisplayModes();
        for (n5 = 0; n5 < displayModeArray.length; ++n5) {
            if (Config.glVerbose) {
                Logger.log("mode: " + displayModeArray[n5].getWidth() + "/" + displayModeArray[n5].getHeight() + "/" + displayModeArray[n5].getBitDepth() + "/" + displayModeArray[n5].getRefreshRate(), 2);
            }
            if (displayModeArray[n5].getWidth() != n || displayModeArray[n5].getHeight() != n2 || displayModeArray[n5].getBitDepth() != n3 || Config.glRefresh != 0 && displayModeArray[n5].getRefreshRate() != Config.glRefresh && Config.glFullscreen) continue;
            n6 = n5;
            break;
        }
        if (n6 == -1) {
            Logger.log("Can't find desired videomode (" + n + " x " + n2 + " x " + n3 + ") - searching for alternatives", 2);
            for (n5 = 0; n5 < displayModeArray.length; ++n5) {
                if (displayModeArray[n5].getWidth() != n || displayModeArray[n5].getHeight() != n2 || displayModeArray[n5].getBitDepth() < n3 || displayModeArray[n5].getRefreshRate() < Config.glRefresh && Config.glFullscreen) continue;
                n6 = n5;
                break;
            }
            if (n6 == -1) {
                Logger.log("Can't find alternative videomode (" + n + " x " + n2 + " x " + n3 + ") - trying something else", 2);
                for (n5 = 0; n5 < displayModeArray.length; ++n5) {
                    if (displayModeArray[n5].getWidth() != n || displayModeArray[n5].getHeight() != n2) continue;
                    n6 = n5;
                    break;
                }
            }
            if (n6 == -1) {
                Logger.log("Can't find any suitable videomode!", 0);
                return null;
            }
        }
        return displayModeArray[n6];
    }

    private GLCapabilities getPixelFormatFromConfig() {
        if (Config.glAdditionalConfiguration != null) {
            for (int i = 0; i < Config.glAdditionalConfiguration.length; ++i) {
                if (!(Config.glAdditionalConfiguration[i] instanceof GLCapabilities)) continue;
                return (GLCapabilities)Config.glAdditionalConfiguration[i];
            }
        }
        return null;
    }

    public static GLCapabilities createPixelFormat(int n, int n2, int n3, int n4, int n5) {
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setRedBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setAlphaBits(n2);
        gLCapabilities.setDepthBits(n3);
        gLCapabilities.setStencilBits(n4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(n5);
        return gLCapabilities;
    }
}

