/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.BufferedMatrix;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.SimpleVector;
import java.io.Serializable;

public final class Lights
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean LIGHT_VISIBLE = true;
    public static final boolean LIGHT_INVISIBLE = false;
    public static final int OVERBRIGHT_LIGHTING_DISABLED = 255;
    public static final int OVERBRIGHT_LIGHTING_ENABLED = 8191;
    public static final int RGB_SCALE_DEFAULT = 1;
    public static final int RGB_SCALE_2X = 2;
    public static final int RGB_SCALE_4X = 4;
    int rgbScale = 1;
    int maxLightValue = 8192;
    int lightCnt;
    int maxLights;
    float[] xOrg;
    float[] yOrg;
    float[] zOrg;
    float[] xTr;
    float[] yTr;
    float[] zTr;
    float[] xRot;
    float[] yRot;
    float[] zRot;
    float[] bOrg;
    float[] rOrg;
    float[] gOrg;
    BufferedMatrix[] transform;
    boolean[] isVisible;
    boolean[] isRemoved;
    float[] attenuation;
    float[] discardDistance;
    float[] distanceOverride;
    private Matrix mat5 = new Matrix();
    private Matrix mat6 = new Matrix();

    Lights(int n) {
        this.maxLights = n;
        this.lightCnt = 0;
        this.xOrg = new float[this.maxLights];
        this.yOrg = new float[this.maxLights];
        this.zOrg = new float[this.maxLights];
        this.xTr = new float[this.maxLights];
        this.yTr = new float[this.maxLights];
        this.zTr = new float[this.maxLights];
        this.xRot = new float[this.maxLights];
        this.yRot = new float[this.maxLights];
        this.zRot = new float[this.maxLights];
        this.bOrg = new float[this.maxLights];
        this.gOrg = new float[this.maxLights];
        this.rOrg = new float[this.maxLights];
        this.transform = new BufferedMatrix[this.maxLights];
        this.isVisible = new boolean[this.maxLights];
        this.attenuation = new float[this.maxLights];
        this.discardDistance = new float[this.maxLights];
        this.distanceOverride = new float[this.maxLights];
        this.isRemoved = new boolean[this.maxLights];
        for (int i = 0; i < this.maxLights; ++i) {
            this.attenuation[i] = -2.0f;
            this.discardDistance[i] = -2.0f;
            this.distanceOverride[i] = -1.0f;
            this.isRemoved[i] = false;
        }
    }

    public void setOverbrightLighting(int n) {
        this.maxLightValue = n;
    }

    public void setRGBScale(int n) {
        if (n > 0 && n < 5 && n != 3) {
            this.rgbScale = n;
        } else {
            Logger.log("This RGB scaling (" + n + ") is not supported!", 1);
        }
    }

    float getAttenuation(int n) {
        if (!this.isFine(n)) {
            return 0.0f;
        }
        return this.attenuation[n];
    }

    float getDiscardDistance(int n) {
        if (!this.isFine(n)) {
            return 0.0f;
        }
        return this.discardDistance[n];
    }

    SimpleVector getPosition(int n) {
        SimpleVector simpleVector = new SimpleVector();
        if (this.isFine(n)) {
            simpleVector.z = this.zOrg[n];
            simpleVector.x = this.xOrg[n];
            simpleVector.y = this.yOrg[n];
        }
        return simpleVector;
    }

    SimpleVector getIntensity(int n) {
        if (!this.isFine(n)) {
            return new SimpleVector(0.0f, 0.0f, 0.0f);
        }
        return new SimpleVector(this.rOrg[n], this.gOrg[n], this.bOrg[n]);
    }

    void setAttenuation(int n, float f) {
        if (this.isFine(n)) {
            if (f < -1.0f) {
                f = -1.0f;
            }
            if (f == 0.0f) {
                f = 1.0f;
            }
            this.attenuation[n] = f;
        }
    }

    void setDiscardDistance(int n, float f) {
        if (this.isFine(n)) {
            if (f < -1.0f) {
                f = -2.0f;
            }
            this.discardDistance[n] = f;
        }
    }

    void setDistanceOverride(int n, float f) {
        if (this.isFine(n)) {
            this.distanceOverride[n] = f;
        }
    }

    float getDistanceOverride(int n) {
        return this.distanceOverride[n];
    }

    int addLight(float f, float f2, float f3, float f4, float f5, float f6) {
        int n = this.lightCnt;
        if (n >= this.maxLights) {
            for (int i = 0; i < this.maxLights; ++i) {
                if (!this.isRemoved[i]) continue;
                n = i;
                this.isRemoved[n] = false;
                this.attenuation[n] = -2.0f;
                this.discardDistance[n] = -2.0f;
                this.distanceOverride[n] = -1.0f;
                break;
            }
        }
        if (n < this.maxLights) {
            this.xOrg[n] = f;
            this.yOrg[n] = f2;
            this.zOrg[n] = f3;
            this.rOrg[n] = f4;
            this.gOrg[n] = f5;
            this.bOrg[n] = f6;
            this.isVisible[n] = true;
            this.transform[n] = new BufferedMatrix();
            Logger.log("Adding Lightsource: " + n, 2);
            if (n == this.lightCnt) {
                ++this.lightCnt;
            }
        } else {
            Logger.log("Maximum number of Lightsources reached...ignoring additional ones!", 1);
        }
        return n;
    }

    void transformLights(BufferedMatrix bufferedMatrix) {
        Matrix matrix = bufferedMatrix.frontMatrix;
        for (int i = 0; i < this.lightCnt; ++i) {
            if (!this.isVisible[i] || this.isRemoved[i]) continue;
            if (this.xRot[i] != 0.0f) {
                this.transform[i].rotateX(this.xRot[i]);
            }
            if (this.yRot[i] != 0.0f) {
                this.transform[i].rotateY(this.yRot[i]);
            }
            if (this.zRot[i] != 0.0f) {
                this.transform[i].rotateZ(this.zRot[i]);
            }
            this.transform[i].prepareTransform();
            this.mat5.setIdentity();
            if (!this.transform[i].frontMatrix.isIdentity()) {
                this.mat6.setIdentity();
                this.mat5.mat[3][0] = -this.transform[i].frontBx;
                this.mat5.mat[3][1] = -this.transform[i].frontBy;
                this.mat5.mat[3][2] = -this.transform[i].frontBz;
                this.mat6.mat[3][0] = this.transform[i].frontBx;
                this.mat6.mat[3][1] = this.transform[i].frontBy;
                this.mat6.mat[3][2] = this.transform[i].frontBz;
                this.mat5.matMul(this.transform[i].frontMatrix);
                this.mat5.matMul(this.mat6);
            }
            this.mat5.translate(-bufferedMatrix.backBx, -bufferedMatrix.backBy, -bufferedMatrix.backBz);
            this.mat5.matMul(matrix);
            float f = this.mat5.mat[0][0];
            float f2 = this.mat5.mat[1][0];
            float f3 = this.mat5.mat[1][1];
            float f4 = this.mat5.mat[2][1];
            float f5 = this.mat5.mat[2][2];
            float f6 = this.mat5.mat[1][2];
            float f7 = this.mat5.mat[2][0];
            float f8 = this.mat5.mat[0][2];
            float f9 = this.mat5.mat[0][1];
            float f10 = this.mat5.mat[3][0];
            float f11 = this.mat5.mat[3][1];
            float f12 = this.mat5.mat[3][2];
            float f13 = this.xOrg[i];
            float f14 = this.yOrg[i];
            float f15 = this.zOrg[i];
            this.xTr[i] = f13 * f + f14 * f2 + f15 * f7 + f10;
            this.yTr[i] = f13 * f9 + f14 * f3 + f15 * f4 + f11;
            this.zTr[i] = f13 * f8 + f14 * f6 + f15 * f5 + f12;
        }
    }

    void setVisibility(int n, boolean bl) {
        if (this.isFine(n)) {
            this.isVisible[n] = bl;
        }
    }

    void remove(int n) {
        if (this.isFine(n)) {
            this.isRemoved[n] = true;
            this.isVisible[n] = false;
        }
    }

    void setAutoRotation(int n, float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isFine(n)) {
            this.transform[n].backBx = f;
            this.transform[n].backBy = f2;
            this.transform[n].backBz = f3;
            this.xRot[n] = f4;
            this.yRot[n] = f5;
            this.zRot[n] = f6;
        }
    }

    void setAutoRotation(int n, float f, float f2, float f3) {
        if (this.isFine(n)) {
            this.xRot[n] = f;
            this.yRot[n] = f2;
            this.zRot[n] = f3;
        }
    }

    void setLightIntensity(int n, float f, float f2, float f3) {
        if (this.isFine(n)) {
            this.rOrg[n] = f;
            this.gOrg[n] = f2;
            this.bOrg[n] = f3;
        }
    }

    void setPosition(int n, float f, float f2, float f3) {
        if (this.isFine(n)) {
            this.zOrg[n] = f3;
            this.xOrg[n] = f;
            this.yOrg[n] = f2;
        }
    }

    void displaceLights(float f, float f2, float f3) {
        int n = 0;
        while (n < this.lightCnt) {
            int n2 = n;
            this.zOrg[n2] = this.zOrg[n2] + f3;
            int n3 = n;
            this.xOrg[n3] = this.xOrg[n3] + f;
            int n4 = n++;
            this.yOrg[n4] = this.yOrg[n4] + f2;
        }
    }

    private boolean isFine(int n) {
        if (n < 0) {
            return false;
        }
        if (n < this.lightCnt && this.isRemoved[n]) {
            return false;
        }
        if (n < this.lightCnt) {
            return true;
        }
        Logger.log("Tried to modify an undefined light source!", 1);
        return false;
    }
}

