/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Logger;
import com.threed.jpct.SimpleVector;
import java.io.Serializable;

public class Matrix
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final float pi = (float)Math.PI;
    private static final float mpi = (float)(-Math.PI);
    private static final float pih = 1.5707964f;
    private static final float mpih = -1.5707964f;
    private static final float spi = (float)Math.sin(Math.PI);
    private static final float mspi = (float)Math.sin(-Math.PI);
    private static final float cpi = (float)Math.cos(Math.PI);
    private static final float mcpi = (float)Math.cos(-Math.PI);
    private static final float spih = (float)Math.sin(1.5707963267948966);
    private static final float mspih = (float)Math.sin(-1.5707963267948966);
    private static final float cpih = (float)Math.cos(1.5707963267948966);
    private static final float mcpih = (float)Math.cos(-1.5707963267948966);
    float[][] mat = new float[4][4];
    float[] mat0 = this.mat[0];
    float[] mat1 = this.mat[1];
    float[] mat2 = this.mat[2];
    float[] mat3 = this.mat[3];

    public Matrix() {
        this.mat0[0] = 1.0f;
        this.mat1[1] = 1.0f;
        this.mat2[2] = 1.0f;
        this.mat3[3] = 1.0f;
    }

    public Matrix(Matrix matrix) {
        this.setTo(matrix);
    }

    public final boolean isIdentity() {
        return this.mat[0][0] == 1.0f && this.mat[1][1] == 1.0f && this.mat[2][2] == 1.0f && this.mat[3][3] == 1.0f && this.mat[0][1] == 0.0f && this.mat[0][2] == 0.0f && this.mat[0][3] == 0.0f && this.mat[1][0] == 0.0f && this.mat[1][2] == 0.0f && this.mat[1][3] == 0.0f && this.mat[2][1] == 0.0f && this.mat[2][0] == 0.0f && this.mat[2][3] == 0.0f && this.mat[3][1] == 0.0f && this.mat[3][2] == 0.0f && this.mat[3][0] == 0.0f;
    }

    public final void setIdentity() {
        this.mat[0][0] = 1.0f;
        this.mat[1][1] = 1.0f;
        this.mat[2][2] = 1.0f;
        this.mat[3][3] = 1.0f;
        this.mat[0][1] = 0.0f;
        this.mat[0][2] = 0.0f;
        this.mat[0][3] = 0.0f;
        this.mat[1][0] = 0.0f;
        this.mat[1][2] = 0.0f;
        this.mat[1][3] = 0.0f;
        this.mat[2][1] = 0.0f;
        this.mat[2][0] = 0.0f;
        this.mat[2][3] = 0.0f;
        this.mat[3][1] = 0.0f;
        this.mat[3][2] = 0.0f;
        this.mat[3][0] = 0.0f;
    }

    public final void scalarMul(float f) {
        float[] fArray = this.mat[0];
        fArray[0] = fArray[0] * f;
        float[] fArray2 = this.mat[0];
        fArray2[1] = fArray2[1] * f;
        float[] fArray3 = this.mat[0];
        fArray3[2] = fArray3[2] * f;
        float[] fArray4 = this.mat[1];
        fArray4[0] = fArray4[0] * f;
        float[] fArray5 = this.mat[1];
        fArray5[1] = fArray5[1] * f;
        float[] fArray6 = this.mat[1];
        fArray6[2] = fArray6[2] * f;
        float[] fArray7 = this.mat[2];
        fArray7[0] = fArray7[0] * f;
        float[] fArray8 = this.mat[2];
        fArray8[1] = fArray8[1] * f;
        float[] fArray9 = this.mat[2];
        fArray9[2] = fArray9[2] * f;
    }

    public final void matMul(Matrix matrix) {
        float f = this.mat0[0];
        float f2 = this.mat0[1];
        float f3 = this.mat0[2];
        float f4 = this.mat0[3];
        float f5 = this.mat1[0];
        float f6 = this.mat1[1];
        float f7 = this.mat1[2];
        float f8 = this.mat1[3];
        float f9 = this.mat2[0];
        float f10 = this.mat2[1];
        float f11 = this.mat2[2];
        float f12 = this.mat2[3];
        float f13 = this.mat3[0];
        float f14 = this.mat3[1];
        float f15 = this.mat3[2];
        float f16 = this.mat3[3];
        float f17 = matrix.mat0[0];
        float f18 = matrix.mat0[1];
        float f19 = matrix.mat0[2];
        float f20 = matrix.mat0[3];
        float f21 = matrix.mat1[0];
        float f22 = matrix.mat1[1];
        float f23 = matrix.mat1[2];
        float f24 = matrix.mat1[3];
        float f25 = matrix.mat2[0];
        float f26 = matrix.mat2[1];
        float f27 = matrix.mat2[2];
        float f28 = matrix.mat2[3];
        float f29 = matrix.mat3[0];
        float f30 = matrix.mat3[1];
        float f31 = matrix.mat3[2];
        float f32 = matrix.mat3[3];
        this.mat0[0] = f * f17 + f2 * f21 + f3 * f25 + f4 * f29;
        this.mat0[1] = f * f18 + f2 * f22 + f3 * f26 + f4 * f30;
        this.mat0[2] = f * f19 + f2 * f23 + f3 * f27 + f4 * f31;
        this.mat0[3] = f * f20 + f2 * f24 + f3 * f28 + f4 * f32;
        this.mat1[0] = f5 * f17 + f6 * f21 + f7 * f25 + f8 * f29;
        this.mat1[1] = f5 * f18 + f6 * f22 + f7 * f26 + f8 * f30;
        this.mat1[2] = f5 * f19 + f6 * f23 + f7 * f27 + f8 * f31;
        this.mat1[3] = f5 * f20 + f6 * f24 + f7 * f28 + f8 * f32;
        this.mat2[0] = f9 * f17 + f10 * f21 + f11 * f25 + f12 * f29;
        this.mat2[1] = f9 * f18 + f10 * f22 + f11 * f26 + f12 * f30;
        this.mat2[2] = f9 * f19 + f10 * f23 + f11 * f27 + f12 * f31;
        this.mat2[3] = f9 * f20 + f10 * f24 + f11 * f28 + f12 * f32;
        this.mat3[0] = f13 * f17 + f14 * f21 + f15 * f25 + f16 * f29;
        this.mat3[1] = f13 * f18 + f14 * f22 + f15 * f26 + f16 * f30;
        this.mat3[2] = f13 * f19 + f14 * f23 + f15 * f27 + f16 * f31;
        this.mat3[3] = f13 * f20 + f14 * f24 + f15 * f28 + f16 * f32;
    }

    public final void rotateX(float f) {
        float f2;
        float f3;
        if (f == (float)Math.PI) {
            f3 = cpi;
            f2 = spi;
        } else if (f == (float)(-Math.PI)) {
            f3 = mcpi;
            f2 = mspi;
        } else if (f == 1.5707964f) {
            f3 = cpih;
            f2 = spih;
        } else if (f == -1.5707964f) {
            f3 = mcpih;
            f2 = mspih;
        } else {
            f3 = (float)Math.cos(f);
            f2 = (float)Math.sin(f);
        }
        float f4 = this.mat0[1];
        float f5 = this.mat0[2];
        float f6 = this.mat1[1];
        float f7 = this.mat1[2];
        float f8 = this.mat2[1];
        float f9 = this.mat2[2];
        float f10 = this.mat3[1];
        float f11 = this.mat3[2];
        this.mat0[1] = f4 * f3 + f5 * f2;
        this.mat0[2] = f4 * -f2 + f5 * f3;
        this.mat1[1] = f6 * f3 + f7 * f2;
        this.mat1[2] = f6 * -f2 + f7 * f3;
        this.mat2[1] = f8 * f3 + f9 * f2;
        this.mat2[2] = f8 * -f2 + f9 * f3;
        this.mat3[1] = f10 * f3 + f11 * f2;
        this.mat3[2] = f10 * -f2 + f11 * f3;
    }

    public final void rotateY(float f) {
        float f2;
        float f3;
        if (f == (float)Math.PI) {
            f3 = cpi;
            f2 = spi;
        } else if (f == (float)(-Math.PI)) {
            f3 = mcpi;
            f2 = mspi;
        } else if (f == 1.5707964f) {
            f3 = cpih;
            f2 = spih;
        } else if (f == -1.5707964f) {
            f3 = mcpih;
            f2 = mspih;
        } else {
            f3 = (float)Math.cos(f);
            f2 = (float)Math.sin(f);
        }
        float f4 = this.mat0[0];
        float f5 = this.mat0[2];
        float f6 = this.mat1[0];
        float f7 = this.mat1[2];
        float f8 = this.mat2[0];
        float f9 = this.mat2[2];
        float f10 = this.mat3[0];
        float f11 = this.mat3[2];
        this.mat0[0] = f4 * f3 + f5 * f2;
        this.mat0[2] = f4 * -f2 + f5 * f3;
        this.mat1[0] = f6 * f3 + f7 * f2;
        this.mat1[2] = f6 * -f2 + f7 * f3;
        this.mat2[0] = f8 * f3 + f9 * f2;
        this.mat2[2] = f8 * -f2 + f9 * f3;
        this.mat3[0] = f10 * f3 + f11 * f2;
        this.mat3[2] = f10 * -f2 + f11 * f3;
    }

    public final void rotateZ(float f) {
        float f2;
        float f3;
        if (f == (float)Math.PI) {
            f3 = cpi;
            f2 = spi;
        } else if (f == (float)(-Math.PI)) {
            f3 = mcpi;
            f2 = mspi;
        } else if (f == 1.5707964f) {
            f3 = cpih;
            f2 = spih;
        } else if (f == -1.5707964f) {
            f3 = mcpih;
            f2 = mspih;
        } else {
            f3 = (float)Math.cos(f);
            f2 = (float)Math.sin(f);
        }
        float f4 = this.mat0[0];
        float f5 = this.mat0[1];
        float f6 = this.mat1[0];
        float f7 = this.mat1[1];
        float f8 = this.mat2[0];
        float f9 = this.mat2[1];
        float f10 = this.mat3[0];
        float f11 = this.mat3[1];
        this.mat0[0] = f4 * f3 + f5 * f2;
        this.mat0[1] = f4 * -f2 + f5 * f3;
        this.mat1[0] = f6 * f3 + f7 * f2;
        this.mat1[1] = f6 * -f2 + f7 * f3;
        this.mat2[0] = f8 * f3 + f9 * f2;
        this.mat2[1] = f8 * -f2 + f9 * f3;
        this.mat3[0] = f10 * f3 + f11 * f2;
        this.mat3[1] = f10 * -f2 + f11 * f3;
    }

    public final void rotateAxis(SimpleVector simpleVector, float f) {
        double d = Math.cos(f);
        double d2 = Math.sin(f);
        double d3 = 1.0 - d;
        simpleVector = simpleVector.normalize();
        double d4 = simpleVector.x;
        double d5 = simpleVector.y;
        double d6 = simpleVector.z;
        Matrix matrix = new Matrix();
        double d7 = d2 * d5;
        double d8 = d2 * d4;
        double d9 = d2 * d6;
        double d10 = d3 * d4 * d5;
        double d11 = d3 * d4 * d6;
        double d12 = d3 * d5 * d6;
        matrix.mat0[0] = (float)(d3 * d4 * d4 + d);
        matrix.mat1[0] = (float)(d10 + d9);
        matrix.mat2[0] = (float)(d11 - d7);
        matrix.mat0[1] = (float)(d10 - d9);
        matrix.mat1[1] = (float)(d3 * d5 * d5 + d);
        matrix.mat2[1] = (float)(d12 + d8);
        matrix.mat0[2] = (float)(d11 + d7);
        matrix.mat1[2] = (float)(d12 - d8);
        matrix.mat2[2] = (float)(d3 * d6 * d6 + d);
        matrix.orthonormalize();
        this.matMul(matrix);
    }

    public final void interpolate(Matrix matrix, Matrix matrix2, float f) {
        if (f > 1.0f) {
            f = 1.0f;
        } else if (f < 0.0f) {
            f = 0.0f;
        }
        float f2 = 1.0f - f;
        for (int i = 0; i < 4; ++i) {
            this.mat[i][0] = matrix.mat[i][0] * f2 + matrix2.mat[i][0] * f;
            this.mat[i][1] = matrix.mat[i][1] * f2 + matrix2.mat[i][1] * f;
            this.mat[i][2] = matrix.mat[i][2] * f2 + matrix2.mat[i][2] * f;
            this.mat[i][3] = matrix.mat[i][3] * f2 + matrix2.mat[i][3] * f;
        }
        this.orthonormalize();
    }

    public final SimpleVector getTranslation() {
        return new SimpleVector(this.mat3[0], this.mat3[1], this.mat3[2]);
    }

    public final SimpleVector getTranslation(SimpleVector simpleVector) {
        simpleVector.set(this.mat3[0], this.mat3[1], this.mat3[2]);
        return simpleVector;
    }

    public final SimpleVector getXAxis() {
        return new SimpleVector(this.mat0[0], this.mat0[1], this.mat0[2]);
    }

    public final SimpleVector getYAxis() {
        return new SimpleVector(this.mat1[0], this.mat1[1], this.mat1[2]);
    }

    public final SimpleVector getZAxis() {
        return new SimpleVector(this.mat2[0], this.mat2[1], this.mat2[2]);
    }

    public final SimpleVector getXAxis(SimpleVector simpleVector) {
        simpleVector.set(this.mat0[0], this.mat0[1], this.mat0[2]);
        return simpleVector;
    }

    public final SimpleVector getYAxis(SimpleVector simpleVector) {
        simpleVector.set(this.mat1[0], this.mat1[1], this.mat1[2]);
        return simpleVector;
    }

    public final SimpleVector getZAxis(SimpleVector simpleVector) {
        simpleVector.set(this.mat2[0], this.mat2[1], this.mat2[2]);
        return simpleVector;
    }

    public final void setOrientation(SimpleVector simpleVector, SimpleVector simpleVector2) {
        this.setOrientation(simpleVector, simpleVector2, true);
    }

    final void setOrientation(SimpleVector simpleVector, SimpleVector simpleVector2, boolean bl) {
        simpleVector2 = simpleVector2.normalize();
        simpleVector = simpleVector.normalize();
        SimpleVector simpleVector3 = simpleVector2.calcCross(simpleVector).normalize();
        if (!bl) {
            this.mat[0][0] = simpleVector3.x;
            this.mat[1][0] = simpleVector3.y;
            this.mat[2][0] = simpleVector3.z;
            this.mat[3][0] = 0.0f;
            this.mat[0][1] = simpleVector2.x;
            this.mat[1][1] = simpleVector2.y;
            this.mat[2][1] = simpleVector2.z;
            this.mat[3][1] = 0.0f;
            this.mat[0][2] = simpleVector.x;
            this.mat[1][2] = simpleVector.y;
            this.mat[2][2] = simpleVector.z;
            this.mat[3][2] = 0.0f;
            this.mat[0][3] = 0.0f;
            this.mat[1][3] = 0.0f;
            this.mat[2][3] = 0.0f;
            this.mat[3][3] = 1.0f;
        } else {
            this.mat[0][0] = simpleVector3.x;
            this.mat[0][1] = simpleVector3.y;
            this.mat[0][2] = simpleVector3.z;
            this.mat[0][3] = 0.0f;
            this.mat[1][0] = simpleVector2.x;
            this.mat[1][1] = simpleVector2.y;
            this.mat[1][2] = simpleVector2.z;
            this.mat[1][3] = 0.0f;
            this.mat[2][0] = simpleVector.x;
            this.mat[2][1] = simpleVector.y;
            this.mat[2][2] = simpleVector.z;
            this.mat[2][3] = 0.0f;
            this.mat[3][0] = 0.0f;
            this.mat[3][1] = 0.0f;
            this.mat[3][2] = 0.0f;
            this.mat[3][3] = 1.0f;
        }
    }

    public final void translate(SimpleVector simpleVector) {
        this.mat3[0] = this.mat3[0] + simpleVector.x;
        this.mat3[1] = this.mat3[1] + simpleVector.y;
        this.mat3[2] = this.mat3[2] + simpleVector.z;
    }

    public final void translate(float f, float f2, float f3) {
        this.mat3[0] = this.mat3[0] + f;
        this.mat3[1] = this.mat3[1] + f2;
        this.mat3[2] = this.mat3[2] + f3;
    }

    public final Matrix cloneMatrix() {
        Matrix matrix = new Matrix();
        matrix.setTo(this);
        return matrix;
    }

    public final Matrix invert() {
        return this.invert(new Matrix());
    }

    public final Matrix invert(Matrix matrix) {
        float f = this.mat[0][0];
        float f2 = this.mat[0][1];
        float f3 = this.mat[0][2];
        float f4 = this.mat[0][3];
        float f5 = this.mat[1][0];
        float f6 = this.mat[1][1];
        float f7 = this.mat[1][2];
        float f8 = this.mat[1][3];
        float f9 = this.mat[2][0];
        float f10 = this.mat[2][1];
        float f11 = this.mat[2][2];
        float f12 = this.mat[2][3];
        float f13 = this.mat[3][0];
        float f14 = this.mat[3][1];
        float f15 = this.mat[3][2];
        float f16 = this.mat[3][3];
        float f17 = f11 * f16;
        float f18 = f15 * f12;
        float f19 = f7 * f16;
        float f20 = f15 * f8;
        float f21 = f7 * f12;
        float f22 = f11 * f8;
        float f23 = f3 * f16;
        float f24 = f15 * f4;
        float f25 = f3 * f12;
        float f26 = f11 * f4;
        float f27 = f3 * f8;
        float f28 = f7 * f4;
        float f29 = f17 * f6 + f20 * f10 + f21 * f14 - (f18 * f6 + f19 * f10 + f22 * f14);
        float f30 = f18 * f2 + f23 * f10 + f26 * f14 - (f17 * f2 + f24 * f10 + f25 * f14);
        float f31 = f19 * f2 + f24 * f6 + f27 * f14 - (f20 * f2 + f23 * f6 + f28 * f14);
        float f32 = f22 * f2 + f25 * f6 + f28 * f10 - (f21 * f2 + f26 * f6 + f27 * f10);
        float f33 = f18 * f5 + f19 * f9 + f22 * f13 - (f17 * f5 + f20 * f9 + f21 * f13);
        float f34 = f17 * f + f24 * f9 + f25 * f13 - (f18 * f + f23 * f9 + f26 * f13);
        float f35 = f20 * f + f23 * f5 + f28 * f13 - (f19 * f + f24 * f5 + f27 * f13);
        float f36 = f21 * f + f26 * f5 + f27 * f9 - (f22 * f + f25 * f5 + f28 * f9);
        f17 = f9 * f14;
        f18 = f13 * f10;
        f19 = f5 * f14;
        f20 = f13 * f6;
        f21 = f5 * f10;
        f22 = f9 * f6;
        f23 = f * f14;
        f24 = f13 * f2;
        f25 = f * f10;
        f26 = f9 * f2;
        f27 = f * f6;
        f28 = f5 * f2;
        float f37 = f17 * f8 + f20 * f12 + f21 * f16 - (f18 * f8 + f19 * f12 + f22 * f16);
        float f38 = f18 * f4 + f23 * f12 + f26 * f16 - (f17 * f4 + f24 * f12 + f25 * f16);
        float f39 = f19 * f4 + f24 * f8 + f27 * f16 - (f20 * f4 + f23 * f8 + f28 * f16);
        float f40 = f22 * f4 + f25 * f8 + f28 * f12 - (f21 * f4 + f26 * f8 + f27 * f12);
        float f41 = f19 * f11 + f22 * f15 + f18 * f7 - (f21 * f15 + f17 * f7 + f20 * f11);
        float f42 = f25 * f15 + f17 * f3 + f24 * f11 - (f23 * f11 + f26 * f15 + f18 * f3);
        float f43 = f23 * f7 + f28 * f15 + f20 * f3 - (f27 * f15 + f19 * f3 + f24 * f7);
        float f44 = f27 * f11 + f21 * f3 + f26 * f7 - (f25 * f7 + f28 * f11 + f22 * f3);
        float f45 = 1.0f / (f * f29 + f5 * f30 + f9 * f31 + f13 * f32);
        matrix.mat[0][0] = f29 * f45;
        matrix.mat[0][1] = f30 * f45;
        matrix.mat[0][2] = f31 * f45;
        matrix.mat[0][3] = f32 * f45;
        matrix.mat[1][0] = f33 * f45;
        matrix.mat[1][1] = f34 * f45;
        matrix.mat[1][2] = f35 * f45;
        matrix.mat[1][3] = f36 * f45;
        matrix.mat[2][0] = f37 * f45;
        matrix.mat[2][1] = f38 * f45;
        matrix.mat[2][2] = f39 * f45;
        matrix.mat[2][3] = f40 * f45;
        matrix.mat[3][0] = f41 * f45;
        matrix.mat[3][1] = f42 * f45;
        matrix.mat[3][2] = f43 * f45;
        matrix.mat[3][3] = f44 * f45;
        return matrix;
    }

    public final Matrix invert3x3() {
        return this.invert3x3(new Matrix());
    }

    public final Matrix invert3x3(Matrix matrix) {
        if (matrix == this) {
            Logger.log("The matrix to be filled can't be the same instance as the matrix to invert!", 0);
        }
        matrix.mat[0][1] = this.mat[1][0];
        matrix.mat[0][2] = this.mat[2][0];
        matrix.mat[1][0] = this.mat[0][1];
        matrix.mat[1][2] = this.mat[2][1];
        matrix.mat[2][0] = this.mat[0][2];
        matrix.mat[2][1] = this.mat[1][2];
        matrix.mat[0][0] = this.mat[0][0];
        matrix.mat[1][1] = this.mat[1][1];
        matrix.mat[2][2] = this.mat[2][2];
        return matrix;
    }

    public final Matrix transpose() {
        Matrix matrix = new Matrix();
        matrix.mat[0][1] = this.mat[1][0];
        matrix.mat[0][2] = this.mat[2][0];
        matrix.mat[0][3] = this.mat[3][0];
        matrix.mat[1][0] = this.mat[0][1];
        matrix.mat[1][2] = this.mat[2][1];
        matrix.mat[1][3] = this.mat[3][1];
        matrix.mat[2][0] = this.mat[0][2];
        matrix.mat[2][1] = this.mat[1][2];
        matrix.mat[2][3] = this.mat[3][2];
        matrix.mat[3][0] = this.mat[0][3];
        matrix.mat[3][1] = this.mat[1][3];
        matrix.mat[3][2] = this.mat[2][3];
        matrix.mat[0][0] = this.mat[0][0];
        matrix.mat[1][1] = this.mat[1][1];
        matrix.mat[2][2] = this.mat[2][2];
        matrix.mat[3][3] = this.mat[3][3];
        return matrix;
    }

    public final void orthonormalizeDouble() {
        double[][] dArray = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            dArray[i][0] = this.mat[i][0];
            dArray[i][1] = this.mat[i][1];
            dArray[i][2] = this.mat[i][2];
        }
        int n = 0;
        while (n < 3) {
            double d;
            double d2;
            int n2 = 0;
            while (n2 < n) {
                d2 = dArray[0][n];
                double d3 = dArray[1][n];
                d = dArray[2][n];
                double d4 = dArray[0][n2];
                double d5 = dArray[1][n2];
                double d6 = dArray[2][n2];
                double d7 = d2 * d4 + d3 * d5 + d * d6;
                double[] dArray2 = dArray[0];
                int n3 = n2;
                dArray2[n3] = dArray2[n3] - d2 * d7;
                double[] dArray3 = dArray[1];
                int n4 = n2;
                dArray3[n4] = dArray3[n4] - d3 * d7;
                double[] dArray4 = dArray[2];
                int n5 = n2++;
                dArray4[n5] = dArray4[n5] - d * d7;
            }
            d2 = dArray[0][n];
            double d8 = dArray[1][n];
            d = dArray[2][n];
            double d9 = 1.0 / Math.sqrt(d2 * d2 + d8 * d8 + d * d);
            double[] dArray5 = dArray[0];
            int n6 = n;
            dArray5[n6] = dArray5[n6] * d9;
            double[] dArray6 = dArray[1];
            int n7 = n;
            dArray6[n7] = dArray6[n7] * d9;
            double[] dArray7 = dArray[2];
            int n8 = n++;
            dArray7[n8] = dArray7[n8] * d9;
        }
        for (n = 0; n < 3; ++n) {
            this.mat[n][0] = (float)dArray[n][0];
            this.mat[n][1] = (float)dArray[n][1];
            this.mat[n][2] = (float)dArray[n][2];
        }
    }

    public final void orthonormalize() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < n) {
                f = this.mat[0][n];
                f2 = this.mat[1][n];
                f3 = this.mat[2][n];
                f4 = this.mat[0][n2];
                f5 = this.mat[1][n2];
                f6 = this.mat[2][n2];
                float f7 = f * f4 + f2 * f5 + f3 * f6;
                float[] fArray = this.mat[0];
                int n3 = n2;
                fArray[n3] = fArray[n3] - f * f7;
                float[] fArray2 = this.mat[1];
                int n4 = n2;
                fArray2[n4] = fArray2[n4] - f2 * f7;
                float[] fArray3 = this.mat[2];
                int n5 = n2++;
                fArray3[n5] = fArray3[n5] - f3 * f7;
            }
            f = this.mat[0][n];
            f2 = this.mat[1][n];
            f3 = this.mat[2][n];
            double d = 1.0 / Math.sqrt(f * f + f2 * f2 + f3 * f3);
            float[] fArray = this.mat[0];
            int n6 = n;
            fArray[n6] = (float)((double)fArray[n6] * d);
            float[] fArray4 = this.mat[1];
            int n7 = n;
            fArray4[n7] = (float)((double)fArray4[n7] * d);
            float[] fArray5 = this.mat[2];
            int n8 = n++;
            fArray5[n8] = (float)((double)fArray5[n8] * d);
        }
    }

    public final float[] getDump() {
        return this.fillDump(null);
    }

    public final float[] fillDump(float[] fArray) {
        if (fArray == null) {
            fArray = new float[16];
        } else if (fArray.length != 16) {
            Logger.log("Dump array has to have a length of 16!", 0);
        }
        int n = 0;
        fArray[n++] = this.mat0[0];
        fArray[n++] = this.mat0[1];
        fArray[n++] = this.mat0[2];
        fArray[n++] = this.mat0[3];
        fArray[n++] = this.mat1[0];
        fArray[n++] = this.mat1[1];
        fArray[n++] = this.mat1[2];
        fArray[n++] = this.mat1[3];
        fArray[n++] = this.mat2[0];
        fArray[n++] = this.mat2[1];
        fArray[n++] = this.mat2[2];
        fArray[n++] = this.mat2[3];
        fArray[n++] = this.mat3[0];
        fArray[n++] = this.mat3[1];
        fArray[n++] = this.mat3[2];
        fArray[n] = this.mat3[3];
        return fArray;
    }

    public final void setDump(float[] fArray) {
        if (fArray.length == 16) {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                this.mat[i][0] = fArray[n];
                this.mat[i][1] = fArray[n + 1];
                this.mat[i][2] = fArray[n + 2];
                this.mat[i][3] = fArray[n + 3];
                n += 4;
            }
        } else {
            Logger.log("Not a valid matrix dump!", 0);
        }
    }

    public final void setTo(Matrix matrix) {
        float[] fArray = this.mat[0];
        float[] fArray2 = matrix.mat[0];
        fArray[0] = fArray2[0];
        fArray[1] = fArray2[1];
        fArray[2] = fArray2[2];
        fArray[3] = fArray2[3];
        fArray = this.mat[1];
        fArray2 = matrix.mat[1];
        fArray[0] = fArray2[0];
        fArray[1] = fArray2[1];
        fArray[2] = fArray2[2];
        fArray[3] = fArray2[3];
        fArray = this.mat[2];
        fArray2 = matrix.mat[2];
        fArray[0] = fArray2[0];
        fArray[1] = fArray2[1];
        fArray[2] = fArray2[2];
        fArray[3] = fArray2[3];
        fArray = this.mat[3];
        fArray2 = matrix.mat[3];
        fArray[0] = fArray2[0];
        fArray[1] = fArray2[1];
        fArray[2] = fArray2[2];
        fArray[3] = fArray2[3];
    }

    public final void set(int n, int n2, float f) {
        if (n >= 0 && n <= 4 && n2 >= 0 && n2 <= 4) {
            this.mat[n][n2] = f;
        }
    }

    public final void setRow(int n, float f, float f2, float f3, float f4) {
        if (n >= 0 && n <= 4) {
            this.mat[n][0] = f;
            this.mat[n][1] = f2;
            this.mat[n][2] = f3;
            this.mat[n][3] = f4;
        }
    }

    public final void setColumn(int n, float f, float f2, float f3, float f4) {
        if (n >= 0 && n <= 4) {
            this.mat[0][n] = f;
            this.mat[1][n] = f2;
            this.mat[2][n] = f3;
            this.mat[3][n] = f4;
        }
    }

    public final float get(int n, int n2) {
        if (n >= 0 && n <= 4 && n2 >= 0 && n2 <= 4) {
            return this.mat[n][n2];
        }
        return 0.0f;
    }

    public String toString() {
        String string = "(\n";
        for (int i = 0; i < 4; ++i) {
            string = string + "\t" + this.mat[i][0];
            string = string + "\t" + this.mat[i][1];
            string = string + "\t" + this.mat[i][2];
            string = string + "\t" + this.mat[i][3] + "\n";
        }
        string = string + ")\n";
        return string;
    }

    public int hashCode() {
        return (int)(1000.0f * (this.mat[0][0] + this.mat[1][1] + this.mat[2][2]));
    }

    public boolean equals(Object object) {
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            for (int i = 0; i < 4; ++i) {
                if (matrix.mat[i][0] != this.mat[i][0]) {
                    return false;
                }
                if (matrix.mat[i][1] != this.mat[i][1]) {
                    return false;
                }
                if (matrix.mat[i][2] != this.mat[i][2]) {
                    return false;
                }
                if (matrix.mat[i][3] == this.mat[i][3]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void transformToGL() {
        this.mat0[1] = this.mat0[1] * -1.0f;
        this.mat0[2] = this.mat0[2] * -1.0f;
        this.mat1[1] = this.mat1[1] * -1.0f;
        this.mat1[2] = this.mat1[2] * -1.0f;
        this.mat2[1] = this.mat2[1] * -1.0f;
        this.mat2[2] = this.mat2[2] * -1.0f;
        this.mat3[1] = this.mat3[1] * -1.0f;
        this.mat3[2] = this.mat3[2] * -1.0f;
    }
}

