/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.AWTGLRenderer;
import com.threed.jpct.CompiledInstance;
import com.threed.jpct.Config;
import com.threed.jpct.GLBase;
import com.threed.jpct.ICompiledInstance;
import com.threed.jpct.IRenderer;
import com.threed.jpct.Logger;
import com.threed.jpct.Object3D;
import com.threed.jpct.OcTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

class Object3DCompiler {
    Object3DCompiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void compile(Object3D object3D, IRenderer iRenderer) {
        Object object;
        if (object3D.compiled == null || object3D.compiled.size() != 0) {
            return;
        }
        if (object3D.shareWith != null) {
            if (object3D.shareWith.shareWith != null) {
                Logger.log("Can't share data with an object that shares data itself. Share data with the source object instead!", 0);
                return;
            }
            int n = object3D.shareWith.compiled.size();
            for (int i = 0; i < n; ++i) {
                object3D.addCompiled(new CompiledInstance(object3D, ((CompiledInstance)object3D.shareWith.compiled.get(i)).getPolyIndex(), -1));
            }
            Logger.log("Object " + object3D.getID() + "/" + object3D.getName() + " precompiled!", 2);
            return;
        }
        long l = System.currentTimeMillis();
        GLBase gLBase = null;
        if (iRenderer instanceof GLBase) {
            gLBase = (GLBase)((Object)iRenderer);
        }
        Object object2 = new Object();
        if (iRenderer instanceof AWTGLRenderer) {
            object = ((AWTGLRenderer)iRenderer).getLock();
            try {
                boolean bl;
                boolean bl2 = bl = Thread.currentThread().getName().toLowerCase().indexOf("awt") != -1;
                for (int i = 0; !iRenderer.isInitialized() && i < 50 && !bl; ++i) {
                    ((AWTGLRenderer)iRenderer).canvas.repaint();
                    Logger.log("Waiting for renderer to initialize..." + i, 2);
                    Thread.sleep(50L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object != null) {
                object2 = object;
            }
        }
        object = object2;
        synchronized (object) {
            if (!object3D.isCompiled() && object3D.compiled != null) {
                HashMap<Object, CompiledInstance> hashMap = new HashMap<Object, CompiledInstance>();
                List list = object3D.compiled;
                synchronized (list) {
                    Object object3;
                    Object object4;
                    int n = Config.glBatchSize;
                    if (object3D.dynamic) {
                        n = Config.glDynamicBatchSize;
                    }
                    if (object3D.batchSize != -1) {
                        n = object3D.batchSize;
                    }
                    int n2 = object3D.getMesh().anzTri;
                    HashMap<Object, int[]> hashMap2 = new HashMap<Object, int[]>();
                    Vector vector = null;
                    boolean bl = false;
                    if (object3D.getOcTree() != null && object3D.getOcTree().getRenderingUse()) {
                        vector = object3D.getOcTree().getFilledLeafs();
                        bl = true;
                    }
                    int n3 = -1;
                    for (int i = 0; i < n2; ++i) {
                        int n4;
                        object4 = String.valueOf(object3D.texture[i]);
                        if (object3D.multiTex != null) {
                            for (n4 = 0; n4 < object3D.multiTex.length; ++n4) {
                                object4 = (String)object4 + "_" + object3D.multiTex[n4][i] + "/" + object3D.multiMode[n4][i];
                            }
                        }
                        n4 = -1;
                        if (bl) {
                            if (n3 != -1) {
                                object3 = ((OcTreeNode)vector.get(n3)).getPolygons();
                                for (int j = 0; j < ((Object)object3).length; ++j) {
                                    if (i != object3[j]) continue;
                                    n4 = ((OcTreeNode)vector.get(n3)).getID();
                                    break;
                                }
                            }
                            if (n4 == -1) {
                                block13: for (int j = 0; j < vector.size(); ++j) {
                                    int[] nArray = ((OcTreeNode)vector.get(j)).getPolygons();
                                    for (int k = 0; k < nArray.length; ++k) {
                                        if (i != nArray[k]) continue;
                                        n4 = ((OcTreeNode)vector.get(j)).getID();
                                        n3 = j;
                                        j = vector.size();
                                        continue block13;
                                    }
                                }
                            }
                            object4 = (String)object4 + "_oc_" + n4;
                        }
                        if ((object3 = (int[])hashMap2.get(object4)) == null) {
                            object3 = new int[]{0};
                            hashMap2.put(object4, (int[])object3);
                        }
                        object4 = (String)object4 + "_" + object3[0] / n;
                        object3[0] = object3[0] + 1;
                        CompiledInstance compiledInstance = (CompiledInstance)hashMap.get(object4);
                        if (compiledInstance == null) {
                            compiledInstance = new CompiledInstance(object3D, i, n4);
                            hashMap.put(object4, compiledInstance);
                        }
                        compiledInstance.add(i);
                    }
                    ArrayList arrayList = new ArrayList(hashMap.keySet());
                    Collections.sort(arrayList);
                    object4 = arrayList.iterator();
                    while (object4.hasNext()) {
                        Object e = object4.next();
                        object3 = (CompiledInstance)hashMap.get(e);
                        object3.fill();
                        object3.setKey(e.toString());
                        object3D.addCompiled((ICompiledInstance)object3);
                        if (gLBase == null || !object3.useDL) continue;
                        gLBase.addToCompile((ICompiledInstance)object3);
                    }
                }
                Logger.log("Object " + object3D.getID() + "/" + object3D.getName() + " compiled to " + hashMap.size() + " subobjects in " + (System.currentTimeMillis() - l) + "ms!", 2);
            } else if (object3D.compiled != null) {
                Logger.log("Object " + object3D.getID() + "/" + object3D.getName() + " already compiled!", 0);
            }
        }
    }
}

