/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.IntegerC;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Mesh;
import com.threed.jpct.Object3D;
import com.threed.jpct.OcTreeNode;
import com.threed.jpct.World;
import java.io.Serializable;
import java.util.Vector;

public final class OcTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_OPTIMIZED = 1;
    public static final boolean COLLISION_USE = true;
    public static final boolean COLLISION_DONT_USE = false;
    public static final boolean RENDERING_USE = true;
    public static final boolean RENDERING_DONT_USE = false;
    private int curLeafs = 0;
    private OcTreeNode[] leafList = null;
    private boolean[] visibleLeafs = null;
    private float radiusMul;
    private OcTreeNode[] threadsBuffer = null;
    private Vector allLeafs = null;
    private Mesh objMesh = null;
    int leafs = 0;
    int nodes = 0;
    int[] tris = null;
    int maxPoly = 0;
    int maxDepth = -1;
    int totalPolys = 0;
    boolean useForCollision = true;
    boolean useForRendering = true;
    int mode;
    OcTreeNode root = null;

    public OcTree(Mesh mesh, int n, int n2) {
        this.initOcTree(mesh, n, -1, n2);
    }

    public OcTree(Mesh mesh, int n, int n2, int n3) {
        this.initOcTree(mesh, n, n2, n3);
    }

    public OcTree(Object3D object3D, int n, int n2) {
        this.initOcTree(object3D.getMesh(), n, -1, n2);
    }

    public OcTree(Object3D object3D, int n, int n2, int n3) {
        this.initOcTree(object3D.getMesh(), n, n2, n3);
    }

    OcTree() {
    }

    void postConstruct() {
        this.leafList = new OcTreeNode[this.leafs];
        this.visibleLeafs = new boolean[this.leafs];
        this.radiusMul = 1.5f;
    }

    private void initOcTree(Mesh mesh, int n, int n2, int n3) {
        this.leafs = 0;
        this.nodes = 0;
        this.maxDepth = n2;
        this.objMesh = mesh.cloneMesh(false);
        this.maxPoly = n;
        this.tris = new int[n + 1];
        this.buildTree();
        this.objMesh = null;
        this.tris = null;
        this.mode = n3;
        this.useForCollision = false;
        this.postConstruct();
    }

    public Vector getFilledLeafs() {
        if (this.allLeafs == null) {
            this.allLeafs = new Vector();
            this.fillLeafs(this.root);
        }
        return this.allLeafs;
    }

    private void fillLeafs(OcTreeNode ocTreeNode) {
        if (ocTreeNode.getPolyCount() > 0) {
            this.allLeafs.add(ocTreeNode);
        }
        for (int i = 0; i < ocTreeNode.getChildCount(); ++i) {
            this.fillLeafs(ocTreeNode.getChildren()[i]);
        }
    }

    public void setCollisionUse(boolean bl) {
        this.useForCollision = bl;
    }

    public void setRenderingUse(boolean bl) {
        this.useForRendering = bl;
    }

    public boolean getCollisionUse() {
        return this.useForCollision;
    }

    public boolean getRenderingUse() {
        return this.useForRendering;
    }

    public void setRadiusMultiplier(float f) {
        if (f > 0.0f) {
            this.radiusMul = f;
        }
    }

    public float getRadiusMultiplier() {
        return this.radiusMul;
    }

    public boolean isOfOrderZero() {
        return this.root.isLeaf();
    }

    Vector getAffectedLeafs(float f, float f2, float f3, float f4) {
        Object[] objectArray = this.getColliderLeafs(f, f2, f3, f4);
        Vector<OcTreeNode> vector = new Vector<OcTreeNode>();
        if (objectArray != null) {
            Integer n = (Integer)objectArray[0];
            for (int i = 0; i < n; ++i) {
                vector.addElement(((OcTreeNode[])objectArray[1])[i]);
            }
        }
        return vector;
    }

    int getVisibleLeafs(Matrix matrix, float f, float f2, float f3, float f4) {
        int[] nArray = new int[]{0};
        this.curLeafs = 0;
        this.getVisibleLeafs(this.root, matrix, f, f2, nArray, f3, f4);
        this.curLeafs = nArray[0];
        return this.curLeafs;
    }

    Object[] getColliderLeafs(float f, float f2, float f3, float f4) {
        int[] nArray = new int[]{0};
        return this.getColliderLeafs(this.root, f, f2, f3, f4, nArray, null);
    }

    int getLeafCount() {
        return this.curLeafs;
    }

    int getTotalLeafs() {
        return this.leafs;
    }

    int getTotalPolyCount() {
        return this.totalPolys;
    }

    boolean isCompletelyVisible(int n) {
        return this.visibleLeafs[n];
    }

    OcTreeNode[] getLeafList() {
        return this.leafList;
    }

    private Object[] getColliderLeafs(OcTreeNode ocTreeNode, float f, float f2, float f3, float f4, int[] nArray, OcTreeNode[] ocTreeNodeArray) {
        Thread thread;
        boolean bl = false;
        if (ocTreeNode.getChildCount() != 0 || ocTreeNode.getPolyCount() != 0) {
            bl = ocTreeNode.sphereIntersectsNode(f, f2, f3, f4);
        }
        if ((thread = World.defaultThread) == null) {
            World.setDefaultThread(Thread.currentThread());
            thread = World.defaultThread;
        }
        if (bl && ocTreeNodeArray == null) {
            if (thread == null || Thread.currentThread() != thread || thread == Thread.currentThread() && this.threadsBuffer == null) {
                ocTreeNodeArray = new OcTreeNode[this.leafs];
                if (thread != null && thread == Thread.currentThread()) {
                    this.threadsBuffer = ocTreeNodeArray;
                }
            } else if (this.threadsBuffer != null) {
                ocTreeNodeArray = this.threadsBuffer;
            }
        }
        if (ocTreeNode.getPolyCount() != 0 && ocTreeNode.getChildCount() == 0 && bl) {
            ocTreeNodeArray[nArray[0]] = ocTreeNode;
            nArray[0] = nArray[0] + 1;
        } else if (bl && ocTreeNode.getChildCount() != 0) {
            int n = ocTreeNode.getChildCount();
            OcTreeNode[] ocTreeNodeArray2 = ocTreeNode.getChildren();
            for (int i = 0; i < n; ++i) {
                this.getColliderLeafs(ocTreeNodeArray2[i], f, f2, f3, f4, nArray, ocTreeNodeArray);
            }
        }
        return new Object[]{IntegerC.valueOf(nArray[0]), ocTreeNodeArray};
    }

    private void markAllLeafsAsVisible(OcTreeNode ocTreeNode, int[] nArray) {
        if (ocTreeNode.getPolyCount() != 0 && ocTreeNode.getChildCount() == 0) {
            this.leafList[nArray[0]] = ocTreeNode;
            this.visibleLeafs[nArray[0]] = true;
            nArray[0] = nArray[0] + 1;
        } else {
            OcTreeNode[] ocTreeNodeArray = ocTreeNode.getChildren();
            int n = ocTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.markAllLeafsAsVisible(ocTreeNodeArray[i], nArray);
            }
        }
    }

    private void getVisibleLeafs(OcTreeNode ocTreeNode, Matrix matrix, float f, float f2, int[] nArray, float f3, float f4) {
        boolean bl = false;
        boolean bl2 = false;
        int n = ocTreeNode.getChildCount();
        if (n != 0 || ocTreeNode.getPolyCount() != 0) {
            int n2 = ocTreeNode.isVisible(matrix, f, f2, f3, f4);
            if (n2 == 999) {
                bl2 = true;
                if (n != 0) {
                    this.markAllLeafsAsVisible(ocTreeNode, nArray);
                    n2 = 0;
                } else {
                    n2 = 1;
                }
            }
            boolean bl3 = bl = n2 == 1;
        }
        if (bl && ocTreeNode.getPolyCount() != 0 && n == 0) {
            this.leafList[nArray[0]] = ocTreeNode;
            this.visibleLeafs[nArray[0]] = bl2;
            nArray[0] = nArray[0] + 1;
        } else if (bl && n != 0) {
            OcTreeNode[] ocTreeNodeArray = ocTreeNode.getChildren();
            int n3 = n;
            for (int i = 0; i < n3; ++i) {
                this.getVisibleLeafs(ocTreeNodeArray[i], matrix, f, f2, nArray, f3, f4);
            }
        }
    }

    private boolean createChildren(OcTreeNode ocTreeNode, int n) {
        ++this.nodes;
        int n2 = 0;
        ++n;
        if (ocTreeNode != null) {
            Object object;
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float f9;
            int n3;
            int n4;
            int n5;
            int n6;
            for (n6 = 0; n6 < this.objMesh.anzTri; ++n6) {
                n5 = this.objMesh.coords[this.objMesh.points[n6][0]];
                if (n5 == -9999) continue;
                n4 = this.objMesh.coords[this.objMesh.points[n6][1]];
                n3 = this.objMesh.coords[this.objMesh.points[n6][2]];
                f9 = this.objMesh.xOrg[n5];
                f8 = this.objMesh.yOrg[n5];
                f7 = this.objMesh.zOrg[n5];
                f6 = this.objMesh.xOrg[n4];
                f5 = this.objMesh.yOrg[n4];
                f4 = this.objMesh.zOrg[n4];
                f3 = this.objMesh.xOrg[n3];
                f2 = this.objMesh.yOrg[n3];
                f = this.objMesh.zOrg[n3];
                if (this.tris.length < n2 + 1) {
                    object = new int[this.tris.length * 2];
                    System.arraycopy(this.tris, 0, object, 0, this.tris.length);
                    this.tris = (int[])object;
                }
                if (ocTreeNode.completeFit(f9, f8, f7, f6, f5, f4, f3, f2, f)) {
                    this.tris[n2] = n6;
                    ++n2;
                } else if (ocTreeNode.partialFit(f9, f8, f7, f6, f5, f4, f3, f2, f)) {
                    this.tris[n2] = n6;
                    ++n2;
                }
                if (n2 > this.maxPoly && n != this.maxDepth + 1) break;
            }
            if (n2 <= this.maxPoly || n == this.maxDepth + 1) {
                if (n2 != 0) {
                    for (n6 = 0; n6 < n2; ++n6) {
                        n5 = this.tris[n6];
                        n4 = this.objMesh.coords[this.objMesh.points[n5][0]];
                        f8 = this.objMesh.xOrg[n4];
                        f7 = this.objMesh.yOrg[n4];
                        f6 = this.objMesh.zOrg[n4];
                        n3 = this.objMesh.coords[this.objMesh.points[n5][1]];
                        f5 = this.objMesh.xOrg[n3];
                        f4 = this.objMesh.yOrg[n3];
                        f3 = this.objMesh.zOrg[n3];
                        int n7 = this.objMesh.coords[this.objMesh.points[n5][2]];
                        f2 = this.objMesh.xOrg[n7];
                        f = this.objMesh.yOrg[n7];
                        float f10 = this.objMesh.zOrg[n7];
                        if (ocTreeNode.partialFit(f8, f7, f6, f5, f4, f3, f2, f, f10)) {
                            ocTreeNode.extendDimensions(f8, f7, f6, f5, f4, f3, f2, f, f10);
                        }
                        ocTreeNode.addTriangle(n2, n5, n4, n3, n7);
                        this.objMesh.coords[this.objMesh.points[n5][0]] = -9999;
                        this.objMesh.coords[this.objMesh.points[n5][1]] = -9999;
                        this.objMesh.coords[this.objMesh.points[n5][2]] = -9999;
                    }
                    if (this.mode == 1) {
                        ocTreeNode.packPoints();
                    }
                    this.totalPolys += ocTreeNode.getPolyCount();
                    ++this.leafs;
                }
            } else {
                float f11 = ocTreeNode.xLow;
                float f12 = ocTreeNode.yLow;
                float f13 = ocTreeNode.zLow;
                float f14 = ocTreeNode.xHigh;
                f9 = ocTreeNode.yHigh;
                f8 = ocTreeNode.zHigh;
                f7 = (f14 - f11) / 2.0f + f11;
                f6 = (f9 - f12) / 2.0f + f12;
                f5 = (f8 - f13) / 2.0f + f13;
                OcTreeNode ocTreeNode2 = new OcTreeNode();
                OcTreeNode ocTreeNode3 = new OcTreeNode();
                OcTreeNode ocTreeNode4 = new OcTreeNode();
                OcTreeNode ocTreeNode5 = new OcTreeNode();
                object = new OcTreeNode();
                OcTreeNode ocTreeNode6 = new OcTreeNode();
                OcTreeNode ocTreeNode7 = new OcTreeNode();
                OcTreeNode ocTreeNode8 = new OcTreeNode();
                ocTreeNode2.setDimensions(f11, f6, f13, f7, f9, f5);
                ocTreeNode3.setDimensions(f11, f6, f5, f7, f9, f8);
                ocTreeNode4.setDimensions(f7, f6, f13, f14, f9, f5);
                ocTreeNode5.setDimensions(f7, f6, f5, f14, f9, f8);
                ((OcTreeNode)object).setDimensions(f11, f12, f13, f7, f6, f5);
                ocTreeNode6.setDimensions(f11, f12, f5, f7, f6, f8);
                ocTreeNode7.setDimensions(f7, f12, f13, f14, f6, f5);
                ocTreeNode8.setDimensions(f7, f12, f5, f14, f6, f8);
                ocTreeNode.addChild(ocTreeNode2);
                boolean bl = this.createChildren(ocTreeNode2, n);
                if (!bl && ocTreeNode2.getChildCount() == 0) {
                    ocTreeNode.removeChild(ocTreeNode2);
                    --this.nodes;
                }
                ocTreeNode.addChild(ocTreeNode4);
                bl = this.createChildren(ocTreeNode4, n);
                if (!bl && ocTreeNode4.getChildCount() == 0) {
                    ocTreeNode.removeChild(ocTreeNode4);
                    --this.nodes;
                }
                ocTreeNode.addChild(ocTreeNode3);
                bl = this.createChildren(ocTreeNode3, n);
                if (!bl && ocTreeNode3.getChildCount() == 0) {
                    ocTreeNode.removeChild(ocTreeNode3);
                    --this.nodes;
                }
                ocTreeNode.addChild(ocTreeNode5);
                bl = this.createChildren(ocTreeNode5, n);
                if (!bl && ocTreeNode5.getChildCount() == 0) {
                    ocTreeNode.removeChild(ocTreeNode5);
                    --this.nodes;
                }
                ocTreeNode.addChild((OcTreeNode)object);
                bl = this.createChildren((OcTreeNode)object, n);
                if (!bl && ((OcTreeNode)object).getChildCount() == 0) {
                    ocTreeNode.removeChild((OcTreeNode)object);
                    --this.nodes;
                }
                ocTreeNode.addChild(ocTreeNode7);
                bl = this.createChildren(ocTreeNode7, n);
                if (!bl && ocTreeNode7.getChildCount() == 0) {
                    ocTreeNode.removeChild(ocTreeNode7);
                    --this.nodes;
                }
                ocTreeNode.addChild(ocTreeNode6);
                bl = this.createChildren(ocTreeNode6, n);
                if (!bl && ocTreeNode6.getChildCount() == 0) {
                    ocTreeNode.removeChild(ocTreeNode6);
                    --this.nodes;
                }
                ocTreeNode.addChild(ocTreeNode8);
                bl = this.createChildren(ocTreeNode8, n);
                if (!bl && ocTreeNode8.getChildCount() == 0) {
                    ocTreeNode.removeChild(ocTreeNode8);
                    --this.nodes;
                }
            }
            return ocTreeNode.getPolyCount() != 0;
        }
        return false;
    }

    private void buildTree() {
        OcTreeNode.resetNodeID();
        this.root = new OcTreeNode();
        Logger.log("Building octree for " + this.objMesh.anzTri + " triangles!", 2);
        float[] fArray = this.objMesh.calcBoundingBox();
        this.root.setDimensions(fArray[0], fArray[2], fArray[4], fArray[1], fArray[3], fArray[5]);
        this.createChildren(this.root, 0);
        Logger.log("Octree constructed with " + this.nodes + " nodes / " + this.leafs + " leafs.", 2);
    }
}

