/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.Matrix;
import com.threed.jpct.SimpleVector;
import java.io.Serializable;

final class OcTreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static int nodeID = 0;
    OcTreeNode[] children = null;
    OcTreeNode parent = null;
    float xLow;
    float yLow;
    float zLow;
    float xHigh;
    float yHigh;
    float zHigh;
    int childCnt = 0;
    int id = -1;
    int polyCnt = 0;
    int pointCnt = 0;
    int[] polyList = null;
    int[] pointList = null;
    SimpleVector[] pList = new SimpleVector[8];

    OcTreeNode() {
        for (int i = 0; i < 8; ++i) {
            this.pList[i] = new SimpleVector(0.0f, 0.0f, 0.0f);
        }
        this.parent = null;
        this.id = nodeID++;
        this.polyCnt = 0;
        this.pointCnt = 0;
    }

    boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    int isVisible(Matrix matrix, float f, float f2, float f3, float f4) {
        int n;
        float[][] fArray = matrix.mat;
        float f5 = fArray[0][0];
        float f6 = fArray[1][0];
        float f7 = fArray[1][1];
        float f8 = fArray[2][1];
        float f9 = fArray[2][2];
        float f10 = fArray[1][2];
        float f11 = fArray[2][0];
        float f12 = fArray[0][2];
        float f13 = fArray[0][1];
        float f14 = fArray[3][0];
        float f15 = fArray[3][1];
        float f16 = fArray[3][2];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        double d = f;
        double d2 = f2;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < 8; ++n) {
            SimpleVector simpleVector = this.pList[n];
            float f17 = simpleVector.x;
            float f18 = simpleVector.y;
            float f19 = simpleVector.z;
            double d3 = f17 * f5 + f18 * f6 + f19 * f11 + f14;
            double d4 = f17 * f12 + f18 * f10 + f19 * f9 + f16;
            boolean bl3 = false;
            if (d4 < (double)Config.nearPlane) {
                ++n2;
                bl2 = true;
            } else if (d4 > (double)Config.farPlane) {
                ++n3;
                bl2 = true;
            } else {
                bl3 = true;
            }
            double d5 = d4 * d;
            double d6 = d5 * (double)f3;
            if (d3 < -d5 - d6) {
                ++n4;
                bl2 = true;
            } else if (d3 > d5 - d6) {
                ++n5;
                bl2 = true;
            } else {
                double d7 = f17 * f13 + f18 * f7 + f19 * f8 + f15;
                d5 = d4 * d2;
                d6 = d5 * (double)f4;
                if (d7 < -d5 - d6) {
                    ++n6;
                    bl2 = true;
                } else if (d7 > d5 - d6) {
                    ++n7;
                    bl2 = true;
                } else if (bl3) {
                    bl = true;
                }
            }
            if (!bl2 || !bl) continue;
            return 1;
        }
        int n8 = n = n7 == 8 || n5 == 8 || n6 == 8 || n4 == 8 || n2 == 8 || n3 == 8 ? 1 : 0;
        if (n == 0) {
            if (n7 == 0 && n5 == 0 && n6 == 0 && n4 == 0 && n2 == 0 && n3 == 0) {
                return 999;
            }
            return 1;
        }
        return 0;
    }

    void addTriangle(int n, int n2, int n3, int n4, int n5) {
        if (this.polyList == null) {
            this.polyList = new int[n];
            this.pointList = new int[n * 3];
        }
        this.polyList[this.polyCnt] = n2;
        if (this.notInList(this.pointList, this.pointCnt, n3)) {
            this.pointList[this.pointCnt] = n3;
            ++this.pointCnt;
        }
        if (this.notInList(this.pointList, this.pointCnt, n4)) {
            this.pointList[this.pointCnt] = n4;
            ++this.pointCnt;
        }
        if (this.notInList(this.pointList, this.pointCnt, n5)) {
            this.pointList[this.pointCnt] = n5;
            ++this.pointCnt;
        }
        ++this.polyCnt;
    }

    void packPoints() {
        if (this.pointCnt != this.polyCnt * 3) {
            int[] nArray = new int[this.pointCnt];
            System.arraycopy(this.pointList, 0, nArray, 0, this.pointCnt);
            this.pointList = nArray;
        }
    }

    private boolean notInList(int[] nArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            if (n2 != nArray[i]) continue;
            return false;
        }
        return true;
    }

    static void resetNodeID() {
        nodeID = 0;
    }

    int getID() {
        return this.id;
    }

    void addChild(OcTreeNode ocTreeNode) {
        if (this.children == null) {
            this.children = new OcTreeNode[8];
        }
        if (this.childCnt < 8) {
            this.children[this.childCnt] = ocTreeNode;
            ++this.childCnt;
            ocTreeNode.setParent(this);
        }
    }

    void removeChild(OcTreeNode ocTreeNode) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.childCnt; ++n) {
            if (!this.children[n].equals(ocTreeNode)) continue;
            n2 = n;
            break;
        }
        if (n2 != -1) {
            for (n = n2; n < this.childCnt - 1; ++n) {
                this.children[n] = this.children[n + 1];
            }
            --this.childCnt;
        }
    }

    void setParent(OcTreeNode ocTreeNode) {
        this.parent = ocTreeNode;
    }

    OcTreeNode getParent() {
        return this.parent;
    }

    OcTreeNode[] getChildren() {
        return this.children;
    }

    int getChildCount() {
        return this.childCnt;
    }

    int getPolyCount() {
        return this.polyCnt;
    }

    int getPointCount() {
        return this.pointCnt;
    }

    int[] getPolygons() {
        return this.polyList;
    }

    int[] getPoints() {
        return this.pointList;
    }

    boolean completeFit(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return f >= this.xLow && f <= this.xHigh && f4 >= this.xLow && f4 <= this.xHigh && f7 >= this.xLow && f7 <= this.xHigh && f2 >= this.yLow && f2 <= this.yHigh && f5 >= this.yLow && f5 <= this.yHigh && f8 >= this.yLow && f8 <= this.yHigh && f3 >= this.zLow && f3 <= this.zHigh && f6 >= this.zLow && f6 <= this.zHigh && f9 >= this.zLow && f9 <= this.zHigh;
    }

    boolean partialFit(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (f >= this.xLow && f <= this.xHigh && f2 >= this.yLow && f2 <= this.yHigh && f3 >= this.zLow && f3 <= this.zHigh) {
            return true;
        }
        if (f4 >= this.xLow && f4 <= this.xHigh && f5 >= this.yLow && f5 <= this.yHigh && f6 >= this.zLow && f6 <= this.zHigh) {
            return true;
        }
        return f7 >= this.xLow && f7 <= this.xHigh && f8 >= this.yLow && f8 <= this.yHigh && f9 >= this.zLow && f9 <= this.zHigh;
    }

    boolean sphereIntersectsNode(float f, float f2, float f3, float f4) {
        return !(f + f4 < this.xLow || f - f4 > this.xHigh || f2 + f4 < this.yLow || f2 - f4 > this.yHigh || f3 + f4 < this.zLow || f3 - f4 > this.zHigh);
    }

    void extendDimensions(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (f < this.xLow) {
            this.xLow = f;
        }
        if (f4 < this.xLow) {
            this.xLow = f4;
        }
        if (f7 < this.xLow) {
            this.xLow = f7;
        }
        if (f2 < this.yLow) {
            this.yLow = f2;
        }
        if (f5 < this.yLow) {
            this.yLow = f5;
        }
        if (f8 < this.yLow) {
            this.yLow = f8;
        }
        if (f3 < this.zLow) {
            this.zLow = f3;
        }
        if (f6 < this.zLow) {
            this.zLow = f6;
        }
        if (f9 < this.zLow) {
            this.zLow = f9;
        }
        if (f > this.xHigh) {
            this.xHigh = f;
        }
        if (f4 > this.xHigh) {
            this.xHigh = f4;
        }
        if (f7 > this.xHigh) {
            this.xHigh = f7;
        }
        if (f2 > this.yHigh) {
            this.yHigh = f2;
        }
        if (f5 > this.yHigh) {
            this.yHigh = f5;
        }
        if (f8 > this.yHigh) {
            this.yHigh = f8;
        }
        if (f3 > this.zHigh) {
            this.zHigh = f3;
        }
        if (f6 > this.zHigh) {
            this.zHigh = f6;
        }
        if (f9 > this.zHigh) {
            this.zHigh = f9;
        }
        this.setDimensions(this.xLow, this.yLow, this.zLow, this.xHigh, this.yHigh, this.zHigh);
        if (this.parent != null) {
            this.parent.extendDimensions(f, f2, f3, f4, f5, f6, f7, f8, f9);
        }
    }

    void setDimensions(float f, float f2, float f3, float f4, float f5, float f6) {
        this.xLow = f;
        this.yLow = f2;
        this.zLow = f3;
        this.xHigh = f4;
        this.yHigh = f5;
        this.zHigh = f6;
        this.pList[4].x = f;
        this.pList[4].y = f2;
        this.pList[4].z = f6;
        this.pList[5].x = f;
        this.pList[5].y = f2;
        this.pList[5].z = f3;
        this.pList[6].x = f4;
        this.pList[6].y = f2;
        this.pList[6].z = f3;
        this.pList[7].x = f4;
        this.pList[7].y = f2;
        this.pList[7].z = f6;
        this.pList[0].x = f;
        this.pList[0].y = f5;
        this.pList[0].z = f6;
        this.pList[1].x = f;
        this.pList[1].y = f5;
        this.pList[1].z = f3;
        this.pList[2].x = f4;
        this.pList[2].y = f5;
        this.pList[2].z = f3;
        this.pList[3].x = f4;
        this.pList[3].y = f5;
        this.pList[3].z = f6;
    }
}

