/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Mesh;
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.TextureInfo;
import com.threed.jpct.TextureManager;
import com.threed.jpct.Vectors;

public class PolygonManager {
    Object3D myObj = null;
    TextureManager texMan = null;

    PolygonManager(Object3D object3D) {
        this.myObj = object3D;
        this.texMan = TextureManager.getInstance();
    }

    public int getPolygonTexture(int n) {
        if (this.outOfBounds(n)) {
            return -1;
        }
        return this.myObj.texture[n];
    }

    public int[] getPolygonTextures(int n) {
        if (this.outOfBounds(n)) {
            return null;
        }
        int n2 = 0;
        if (this.myObj.multiTex != null) {
            n2 = this.myObj.multiTex.length;
        }
        int[] nArray = new int[1 + n2];
        nArray[0] = this.myObj.texture[n];
        if (this.myObj.multiTex != null) {
            for (int i = 0; i < this.myObj.multiTex.length; ++i) {
                nArray[1 + i] = this.myObj.multiTex[i][n];
            }
        }
        return nArray;
    }

    public void setPolygonTexture(int n, int n2) {
        if (this.outOfBounds(n)) {
            return;
        }
        this.myObj.texture[n] = n2;
    }

    public void addTexture(int n, int n2, int n3) {
        int n4;
        int n5;
        if (this.myObj.stripped) {
            return;
        }
        if (this.myObj.multiTex == null) {
            if (Logger.isDebugEnabled()) {
                Logger.log("Creating texture arrays of size " + (Config.maxTextureLayers - 1), 3);
            }
            this.myObj.multiTex = new int[Config.maxTextureLayers - 1][this.myObj.texture.length];
            this.myObj.multiMode = new int[Config.maxTextureLayers - 1][this.myObj.texture.length];
            for (n5 = 0; n5 < this.myObj.texture.length; ++n5) {
                for (n4 = 0; n4 < Config.maxTextureLayers - 1; ++n4) {
                    this.myObj.multiTex[n4][n5] = -1;
                }
            }
            this.myObj.objVectors.createMultiCoords();
        }
        n5 = 0;
        for (n4 = 0; n4 < this.myObj.multiTex.length; ++n4) {
            if (this.myObj.multiTex[n4][n] == -1) {
                if (Logger.isDebugEnabled()) {
                    Logger.log("Found empty stage at " + n4, 3);
                }
                this.myObj.multiTex[n4][n] = n2;
                this.myObj.multiMode[n4][n] = n3;
                this.myObj.maxStagesUsed = Math.max(this.myObj.maxStagesUsed, n4 + 2);
                n5 = 1;
                break;
            }
            if (!Logger.isDebugEnabled()) continue;
            Logger.log("Stage " + n4 + " not empty: " + this.myObj.multiTex[n4][n], 3);
        }
        if (n5 == 0 && this.myObj.multiTex.length < Config.maxTextureLayers - 1) {
            int n6;
            int n7;
            Logger.log("Expanding texture arrays (" + this.myObj.multiTex.length + "->" + (this.myObj.multiTex.length + 1) + ")...");
            int[][] nArray = new int[this.myObj.multiTex.length + 1][this.myObj.texture.length];
            int[][] nArray2 = new int[this.myObj.multiMode.length + 1][this.myObj.texture.length];
            float[][] fArray = new float[this.myObj.objVectors.uMul.length + 1][this.myObj.objVectors.maxVectors];
            float[][] fArray2 = new float[this.myObj.objVectors.vMul.length + 1][this.myObj.objVectors.maxVectors];
            for (n7 = 0; n7 < this.myObj.multiTex.length; ++n7) {
                System.arraycopy(this.myObj.multiTex[n7], 0, nArray[n7], 0, nArray[n7].length);
                System.arraycopy(this.myObj.multiMode[n7], 0, nArray2[n7], 0, nArray2[n7].length);
            }
            for (n7 = 0; n7 < this.myObj.objVectors.uMul.length; ++n7) {
                System.arraycopy(this.myObj.objVectors.uMul[n7], 0, fArray[n7], 0, this.myObj.objVectors.maxVectors);
                System.arraycopy(this.myObj.objVectors.vMul[n7], 0, fArray2[n7], 0, this.myObj.objVectors.maxVectors);
            }
            n7 = this.myObj.texture.length;
            for (n6 = 0; n6 < n7; ++n6) {
                nArray[this.myObj.multiTex.length][n6] = -1;
            }
            n7 = this.myObj.objVectors.maxVectors;
            for (n6 = 0; n6 < n7; ++n6) {
                fArray[this.myObj.objVectors.uMul.length][n6] = this.myObj.objVectors.nuOrg[n6];
                fArray2[this.myObj.objVectors.vMul.length][n6] = this.myObj.objVectors.nvOrg[n6];
            }
            this.myObj.multiTex = nArray;
            this.myObj.multiMode = nArray2;
            this.myObj.objVectors.uMul = fArray;
            this.myObj.objVectors.vMul = fArray2;
            this.myObj.multiTex[this.myObj.multiTex.length - 1][n] = n2;
            this.myObj.multiMode[this.myObj.multiMode.length - 1][n] = n3;
            this.myObj.maxStagesUsed = Math.max(this.myObj.maxStagesUsed, this.myObj.multiTex.length + 1);
            n5 = 1;
        }
        if (n5 != 0) {
            this.myObj.usesMultiTexturing = true;
            if (this.myObj.maxStagesUsed > Config.maxTextureLayers) {
                this.myObj.maxStagesUsed = Config.maxTextureLayers;
            }
        } else {
            Logger.log("No further texture stage available (" + this.myObj.maxStagesUsed + "/" + this.myObj.multiTex.length + "/" + Config.maxTextureLayers + ")!", 1);
        }
    }

    public void setPolygonTexture(int n, TextureInfo textureInfo) {
        if (this.myObj.stripped) {
            return;
        }
        if (textureInfo != null) {
            if (this.myObj.multiTex == null && textureInfo.stageCnt > 1) {
                this.myObj.multiTex = new int[Config.maxTextureLayers - 1][this.myObj.texture.length];
                this.myObj.multiMode = new int[Config.maxTextureLayers - 1][this.myObj.texture.length];
                for (int i = 0; i < this.myObj.texture.length; ++i) {
                    for (int j = 0; j < Config.maxTextureLayers - 1; ++j) {
                        this.myObj.multiTex[j][i] = -1;
                    }
                }
                this.myObj.objVectors.createMultiCoords();
                this.myObj.usesMultiTexturing = true;
            }
            Vectors vectors = this.myObj.objVectors;
            float[] fArray = new float[]{textureInfo.u0[0], textureInfo.u1[0], textureInfo.u2[0]};
            float[] fArray2 = new float[]{textureInfo.v0[0], textureInfo.v1[0], textureInfo.v2[0]};
            int n2 = textureInfo.textures[0];
            if (this.myObj.maxStagesUsed < textureInfo.stageCnt) {
                this.myObj.maxStagesUsed = textureInfo.stageCnt;
            }
            boolean bl = this.myObj.usesMultiTexturing && textureInfo != null;
            this.myObj.texture[n] = n2;
            this.myObj.basemap[n] = n2;
            if (bl) {
                int n3;
                for (n3 = 0; n3 < textureInfo.stageCnt - 1; ++n3) {
                    this.myObj.multiTex[n3][n] = textureInfo.textures[n3 + 1];
                    this.myObj.multiMode[n3][n] = textureInfo.mode[n3 + 1];
                }
                n3 = Math.min(this.myObj.multiTex.length, Config.maxTextureLayers - 1);
                for (int i = textureInfo.stageCnt - 1; i < n3; ++i) {
                    this.myObj.multiTex[i][n] = -1;
                }
            }
            float f = 2.0f;
            float f2 = 2.0f;
            if (n2 != -1) {
                f = this.texMan.textures[n2].width;
                f2 = this.texMan.textures[n2].height;
            }
            float[] fArray3 = null;
            float[] fArray4 = null;
            for (int i = 0; i < 3; ++i) {
                int n4 = this.myObj.objMesh.points[n][i];
                vectors.nuOrg[n4] = fArray[i];
                vectors.nvOrg[n4] = fArray2[i];
                vectors.uOrg[n4] = fArray[i] * f;
                vectors.vOrg[n4] = fArray2[i] * f2;
                vectors.buOrg[n4] = fArray[i];
                vectors.bvOrg[n4] = fArray2[i];
                switch (i) {
                    case 0: {
                        fArray3 = textureInfo.u0;
                        fArray4 = textureInfo.v0;
                        break;
                    }
                    case 1: {
                        fArray3 = textureInfo.u1;
                        fArray4 = textureInfo.v1;
                        break;
                    }
                    case 2: {
                        fArray3 = textureInfo.u2;
                        fArray4 = textureInfo.v2;
                    }
                }
                for (int j = 0; j < textureInfo.stageCnt - 1; ++j) {
                    vectors.uMul[j][n4] = fArray3[j + 1];
                    vectors.vMul[j][n4] = fArray4[j + 1];
                }
            }
        }
    }

    public void setVertexAlpha(int n, int n2, float f) {
        if (this.myObj.stripped) {
            return;
        }
        if (this.outOfBounds(n) || n2 < 0 || n2 > 2) {
            return;
        }
        int n3 = this.myObj.objMesh.points[n][n2];
        Vectors vectors = this.myObj.objVectors;
        vectors.createAlpha();
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        vectors.alpha[n3] = f;
    }

    public SimpleVector getTransformedVertex(int n, int n2) {
        return this.getTransformedVertex(n, n2, null, new SimpleVector());
    }

    public SimpleVector getTransformedVertex(int n, int n2, Matrix matrix, SimpleVector simpleVector) {
        if (this.outOfBounds(n) || n2 < 0 || n2 > 2) {
            return null;
        }
        Matrix matrix2 = matrix;
        if (matrix2 == null) {
            matrix2 = this.myObj.getWorldTransformation();
        }
        SimpleVector simpleVector2 = simpleVector;
        Mesh mesh = this.myObj.objMesh;
        int n3 = mesh.coords[mesh.points[n][n2]];
        simpleVector2.x = mesh.xOrg[n3];
        simpleVector2.y = mesh.yOrg[n3];
        simpleVector2.z = mesh.zOrg[n3];
        simpleVector2.matMul(matrix2);
        return simpleVector2;
    }

    public SimpleVector getTextureUV(int n, int n2) {
        return this.getTextureUV(n, n2, new SimpleVector());
    }

    public SimpleVector getTextureUV(int n, int n2, SimpleVector simpleVector) {
        if (this.myObj.stripped) {
            return null;
        }
        if (this.outOfBounds(n) || n2 < 0 || n2 > 2) {
            return null;
        }
        int n3 = this.myObj.objMesh.points[n][n2];
        Vectors vectors = this.myObj.objVectors;
        SimpleVector simpleVector2 = simpleVector;
        simpleVector2.x = vectors.nuOrg[n3];
        simpleVector2.y = vectors.nvOrg[n3];
        simpleVector2.z = 0.0f;
        return simpleVector2;
    }

    public SimpleVector getTransformedNormal(int n) {
        return this.getTransformedNormal(n, new Matrix(this.myObj.getWorldTransformation()), new SimpleVector());
    }

    public SimpleVector getTransformedNormal(int n, Matrix matrix, SimpleVector simpleVector) {
        if (this.outOfBounds(n)) {
            return null;
        }
        Matrix matrix2 = matrix;
        SimpleVector simpleVector2 = simpleVector;
        Mesh mesh = this.myObj.objMesh;
        int n2 = mesh.coords[mesh.points[n][0]];
        int n3 = mesh.coords[mesh.points[n][1]];
        int n4 = mesh.coords[mesh.points[n][2]];
        float f = mesh.xOrg[n4];
        float f2 = mesh.yOrg[n4];
        float f3 = mesh.zOrg[n4];
        float f4 = mesh.xOrg[n3];
        float f5 = mesh.yOrg[n3];
        float f6 = mesh.zOrg[n3];
        float f7 = mesh.xOrg[n2];
        float f8 = mesh.yOrg[n2];
        float f9 = mesh.zOrg[n2];
        float f10 = f7 - f;
        float f11 = f8 - f2;
        float f12 = f9 - f3;
        float f13 = f4 - f;
        float f14 = f5 - f2;
        float f15 = f6 - f3;
        simpleVector2.x = f11 * f15 - f12 * f14;
        simpleVector2.y = f12 * f13 - f10 * f15;
        simpleVector2.z = f10 * f14 - f11 * f13;
        float f16 = matrix2.mat[3][0];
        float f17 = matrix2.mat[3][1];
        float f18 = matrix2.mat[3][2];
        float f19 = matrix2.mat[3][3];
        matrix2.setRow(3, 0.0f, 0.0f, 0.0f, 1.0f);
        simpleVector2.matMul(matrix2);
        matrix2.setRow(3, f16, f17, f18, f19);
        return simpleVector2.normalize(simpleVector2);
    }

    public int getMaxPolygonID() {
        return this.myObj.objMesh.anzTri;
    }

    private boolean outOfBounds(int n) {
        if (n < 0 || n >= this.myObj.objMesh.anzTri) {
            Logger.log("No such polygon!", 0);
            return true;
        }
        return false;
    }
}

