/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Logger;
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;
import java.awt.Color;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class Polyline
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FloatBuffer vertices = null;
    private int length = 0;
    private int maxLength = 0;
    private Color color = Color.WHITE;
    private float width = 1.0f;
    private int transparencyMode = 0;
    private float[] buffer = new float[3];
    private float percentage = 1.0f;
    private boolean visible = true;
    private boolean pointMode = false;
    private Object3D parent = null;

    public Polyline(SimpleVector[] simpleVectorArray, Color color) {
        this.vertices = ByteBuffer.allocateDirect(simpleVectorArray.length * 3 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        int n = simpleVectorArray.length;
        for (int i = 0; i < n; ++i) {
            this.buffer[0] = simpleVectorArray[i].x;
            this.buffer[1] = simpleVectorArray[i].y;
            this.buffer[2] = simpleVectorArray[i].z;
            this.vertices.put(this.buffer);
        }
        this.vertices.rewind();
        this.maxLength = this.length = simpleVectorArray.length;
        this.setColor(color);
    }

    public void update(SimpleVector[] simpleVectorArray) {
        if (simpleVectorArray.length > this.maxLength) {
            Logger.log("New data's size exceeds the size of the Polyline!", 0);
            return;
        }
        int n = simpleVectorArray.length;
        this.vertices.clear();
        for (int i = 0; i < n; ++i) {
            this.buffer[0] = simpleVectorArray[i].x;
            this.buffer[1] = simpleVectorArray[i].y;
            this.buffer[2] = simpleVectorArray[i].z;
            this.vertices.put(this.buffer);
        }
        this.vertices.rewind();
        this.length = n;
    }

    public int getLength() {
        if (this.percentage == 1.0f) {
            return this.length;
        }
        return (int)((float)this.length * this.percentage);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    FloatBuffer getData() {
        return this.vertices;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getWidth() {
        return this.width;
    }

    public void setTransparencyMode(int n) {
        this.transparencyMode = n;
    }

    public int getTransparencyMode() {
        return this.transparencyMode;
    }

    public void setPercentage(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.percentage = f;
    }

    public float getPercentage() {
        return this.percentage;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setPointMode(boolean bl) {
        this.pointMode = bl;
    }

    public boolean isPointMode() {
        return this.pointMode;
    }

    public void setParent(Object3D object3D) {
        this.parent = object3D;
    }

    public Object3D getParent() {
        return this.parent;
    }
}

