/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;

public class Primitives {
    private static final float HRT = (float)(Math.sqrt(2.0) / 2.0);

    private Primitives() {
    }

    public static Object3D getPlane(int n, float f) {
        float f2;
        float f3 = f2 = -f * (float)n / 2.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 1.0f / (float)n;
        Object3D object3D = new Object3D(n * n * 2 + 8);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                float f7 = f4 + f6;
                float f8 = f5 + f6;
                if (f7 > 1.0f) {
                    f7 = 1.0f;
                }
                if (f8 > 1.0f) {
                    f8 = 1.0f;
                }
                object3D.addTriangle(f2, f3, 0.0f, f4, f5, f2, f3 + f, 0.0f, f4, f8, f2 + f, f3, 0.0f, f7, f5);
                object3D.addTriangle(f2, f3 + f, 0.0f, f4, f8, f2 + f, f3 + f, 0.0f, f7, f8, f2 + f, f3, 0.0f, f7, f5);
                f2 += f;
                f4 += f6;
            }
            f3 += f;
            f2 = -f * (float)n / 2.0f;
            f4 = 0.0f;
            f5 += f6;
        }
        return object3D;
    }

    public static Object3D getCone(float f) {
        return Primitives.getCone(90, f);
    }

    public static Object3D getCone(int n, float f) {
        return Primitives.createLatheObject(n, new SimpleVector[]{new SimpleVector(0.5f, 0.5f, 0.0f)}, f *= 2.0f);
    }

    public static Object3D getCone(int n, float f, float f2) {
        return Primitives.createLatheObject(n, new SimpleVector[]{new SimpleVector(0.5f, 0.5f * f2, 0.0f)}, f *= 2.0f, f2);
    }

    public static Object3D getCylinder(float f) {
        return Primitives.getCylinder(90, f);
    }

    public static Object3D getCylinder(int n, float f) {
        return Primitives.createLatheObject(n, new SimpleVector[]{new SimpleVector(0.5f, 0.5f, 0.0f), new SimpleVector(0.5f, -0.5f, 0.0f)}, f *= 2.0f);
    }

    public static Object3D getCylinder(int n, float f, float f2) {
        return Primitives.createLatheObject(n, new SimpleVector[]{new SimpleVector(0.5f, 0.5f * f2, 0.0f), new SimpleVector(0.5f, -0.5f * f2, 0.0f)}, f *= 2.0f, f2);
    }

    public static Object3D getPyramide(float f) {
        return Primitives.createLatheObject(4, new SimpleVector[]{new SimpleVector(HRT, 0.5f, 0.0f)}, f *= 2.0f);
    }

    public static Object3D getPyramide(float f, float f2) {
        return Primitives.createLatheObject(4, new SimpleVector[]{new SimpleVector(HRT, 0.5f * f2, 0.0f)}, f *= 2.0f, f2);
    }

    public static Object3D getDoubleCone(float f) {
        return Primitives.getDoubleCone(90, f);
    }

    public static Object3D getDoubleCone(int n, float f) {
        return Primitives.createLatheObject(n, new SimpleVector[]{new SimpleVector(0.5f, 0.0f, 0.0f)}, f *= 2.0f);
    }

    public static Object3D getCube(float f) {
        return Primitives.createLatheObject(4, new SimpleVector[]{new SimpleVector(HRT, 0.5f, 0.0f), new SimpleVector(HRT, -0.5f, 0.0f)}, f *= 2.0f);
    }

    public static Object3D getBox(float f, float f2) {
        return Primitives.createLatheObject(4, new SimpleVector[]{new SimpleVector(HRT, 0.5f * f2, 0.0f), new SimpleVector(HRT, -0.5f * f2, 0.0f)}, f *= 2.0f, f2);
    }

    public static Object3D getSphere(float f) {
        return Primitives.getSphere(20, f);
    }

    public static Object3D getSphere(int n, float f) {
        return Primitives.getEllipsoid(n, f, 1.0f);
    }

    public static Object3D getEllipsoid(float f, float f2) {
        return Primitives.getEllipsoid(20, f, f2);
    }

    public static Object3D getEllipsoid(int n, float f, float f2) {
        f *= 2.0f;
        SimpleVector[] simpleVectorArray = new SimpleVector[n];
        for (int i = 0; i < simpleVectorArray.length; ++i) {
            float f3 = ((float)i + 1.0f) / ((float)simpleVectorArray.length + 1.0f);
            simpleVectorArray[i] = new SimpleVector((float)Math.sin((double)f3 * Math.PI) * 0.5f, (float)Math.cos((double)f3 * Math.PI) * 0.5f * f2, 0.0f);
        }
        return Primitives.createLatheObject(n, simpleVectorArray, f, f2);
    }

    private static final Object3D createLatheObject(int n, SimpleVector[] simpleVectorArray, float f) {
        return Primitives.createLatheObject(n, simpleVectorArray, f, 1.0f);
    }

    private static final Object3D createLatheObject(int n, SimpleVector[] simpleVectorArray, float f, float f2) {
        int n2;
        int n3;
        int n4;
        int n5;
        Object3D object3D = new Object3D(n * 2 + n * 2 * (simpleVectorArray.length - 1) + 1);
        SimpleVector[] simpleVectorArray2 = new SimpleVector[n * simpleVectorArray.length + 2];
        simpleVectorArray2[0] = new SimpleVector(0.0f, 0.5f * f2, 0.0f);
        simpleVectorArray2[1] = new SimpleVector(0.0f, -0.5f * f2, 0.0f);
        int n6 = 2;
        for (n5 = 0; n5 < n; ++n5) {
            for (n4 = 0; n4 < simpleVectorArray.length; ++n4) {
                float f3 = (float)n5 / (float)n;
                simpleVectorArray2[n6++] = simpleVectorArray[n4].rotate(new SimpleVector(0.0f, f3 * 2.0f * (float)Math.PI, 0.0f));
            }
        }
        for (n5 = 0; n5 < n; ++n5) {
            n4 = (n5 + 0) % n * simpleVectorArray.length + 2;
            int n7 = (n5 + 1) % n * simpleVectorArray.length + 2;
            object3D.addTriangle(f * simpleVectorArray2[0].x, f * simpleVectorArray2[0].y, f * simpleVectorArray2[0].z, f * simpleVectorArray2[n7].x, f * simpleVectorArray2[n7].y, f * simpleVectorArray2[n7].z, f * simpleVectorArray2[n4].x, f * simpleVectorArray2[n4].y, f * simpleVectorArray2[n4].z);
            n3 = n4 + simpleVectorArray.length - 1;
            n2 = n7 + simpleVectorArray.length - 1;
            object3D.addTriangle(f * simpleVectorArray2[1].x, f * simpleVectorArray2[1].y, f * simpleVectorArray2[1].z, f * simpleVectorArray2[n3].x, f * simpleVectorArray2[n3].y, f * simpleVectorArray2[n3].z, f * simpleVectorArray2[n2].x, f * simpleVectorArray2[n2].y, f * simpleVectorArray2[n2].z);
        }
        for (n5 = 0; n5 < simpleVectorArray.length - 1; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                int n8 = (n4 + 0) % n * simpleVectorArray.length + n5 + 2;
                n3 = n8 + 1;
                n2 = (n4 + 1) % n * simpleVectorArray.length + n5 + 2;
                int n9 = n2 + 1;
                object3D.addTriangle(f * simpleVectorArray2[n8].x, f * simpleVectorArray2[n8].y, f * simpleVectorArray2[n8].z, f * simpleVectorArray2[n9].x, f * simpleVectorArray2[n9].y, f * simpleVectorArray2[n9].z, f * simpleVectorArray2[n3].x, f * simpleVectorArray2[n3].y, f * simpleVectorArray2[n3].z);
                object3D.addTriangle(f * simpleVectorArray2[n8].x, f * simpleVectorArray2[n8].y, f * simpleVectorArray2[n8].z, f * simpleVectorArray2[n2].x, f * simpleVectorArray2[n2].y, f * simpleVectorArray2[n2].z, f * simpleVectorArray2[n9].x, f * simpleVectorArray2[n9].y, f * simpleVectorArray2[n9].z);
            }
        }
        return object3D;
    }
}

