/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.IPaintListener;
import com.threed.jpct.IRenderer;
import com.threed.jpct.Logger;
import com.threed.jpct.Mesh;
import com.threed.jpct.Object3D;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.Vectors;
import com.threed.jpct.VideoMode;
import com.threed.jpct.VisList;
import com.threed.jpct.World;
import com.threed.jpct.threading.WorkLoad;
import com.threed.jpct.threading.Worker;
import java.io.Serializable;

public final class SoftGLRenderer
implements IRenderer,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ALPHA = -16777216;
    private static final int XORRER = 196608;
    private final int[] p = new int[3];
    private final TextureManager texMan = TextureManager.getInstance();
    private static float[] multiLU = new float[17];
    private static float[] multiZLU = new float[17];
    private static float[] multiZTLU = new float[17];
    private IPaintListener listener = null;
    private boolean listenerActive = true;
    private Worker worker = null;
    private MyWorkLoad[] workers = null;

    SoftGLRenderer() {
    }

    public void init(int n, int n2, int n3, int n4, int n5) {
        Logger.log("Software renderer (OpenGL mode) initialized", 2);
    }

    public void setPaintListener(IPaintListener iPaintListener) {
        this.listener = iPaintListener;
    }

    public void dispose() {
        this.listener = null;
        if (this.worker != null) {
            this.worker.dispose();
        }
        Logger.log("Software renderer disposed", 2);
    }

    public void finalize() {
        this.dispose();
    }

    public void execute(int n, Object[] objectArray) {
        if (this.listener != null) {
            if (n == 12 && this.listenerActive) {
                this.listener.startPainting();
            } else if (n == 13 && this.listenerActive) {
                this.listener.finishedPainting();
            }
        }
        if (n == 24) {
            boolean bl;
            this.listenerActive = bl = ((Boolean)objectArray[0]).booleanValue();
        }
    }

    public void drawStrip(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
        for (int i = n; i <= n2 + n; ++i) {
            this.drawPolygon(visList, i, frameBuffer, world);
        }
    }

    public Worker initWorker() {
        if (this.worker == null) {
            int n = Config.maxNumberOfCores;
            int n2 = Math.max(n - 1, 2);
            this.worker = new Worker(n2);
        }
        return this.worker;
    }

    public void drawVertexArray(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
        block13: {
            block12: {
                MyWorkLoad myWorkLoad;
                int n3;
                int n4;
                if (!Config.useMultipleThreads) break block12;
                if (this.workers == null) {
                    this.initWorker();
                    n4 = Config.maxNumberOfCores;
                    this.workers = new MyWorkLoad[n4];
                    for (n3 = 0; n3 < this.workers.length; ++n3) {
                        this.workers[n3] = myWorkLoad = new MyWorkLoad(n3, n4);
                    }
                }
                n4 = this.workers.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    myWorkLoad = this.workers[n3];
                    myWorkLoad.set(visList, n, n2, frameBuffer, world);
                    if (n3 < n4 - 1) {
                        this.worker.add(myWorkLoad);
                        continue;
                    }
                    myWorkLoad.doWork();
                }
                this.worker.waitForAll();
                if (Config.loadBalancingStrategy <= 0) break block13;
                long l = 2L;
                int n5 = (int)((float)(frameBuffer.height / n4) * 0.1f);
                for (int i = 1; i < n4; ++i) {
                    long l2 = frameBuffer.sliTimes[i - 1];
                    long l3 = frameBuffer.sliTimes[i];
                    if (l2 < l3 - l) {
                        int n6 = i;
                        frameBuffer.sliStart[n6] = frameBuffer.sliStart[n6] + n5;
                    } else if (l3 < l2 - l) {
                        int n7 = i;
                        frameBuffer.sliStart[n7] = frameBuffer.sliStart[n7] - n5;
                    }
                    int n8 = frameBuffer.height;
                    if (i < n4 - 1) {
                        n8 = frameBuffer.sliStart[i + 1];
                    }
                    if (frameBuffer.sliStart[i] < frameBuffer.sliStart[i - 1]) {
                        int n9 = i;
                        frameBuffer.sliStart[n9] = frameBuffer.sliStart[n9] + n5 * 2;
                    }
                    while (frameBuffer.sliStart[i] >= n8) {
                        int n10 = i;
                        frameBuffer.sliStart[n10] = frameBuffer.sliStart[n10] - n5;
                    }
                }
                break block13;
            }
            for (int i = n; i <= n2; ++i) {
                this.drawPolygon(visList, i, frameBuffer, world);
            }
        }
    }

    public void drawPolygon(VisList visList, int n, FrameBuffer frameBuffer, World world) {
        this.drawPolygon(visList, n, frameBuffer, world, 0, frameBuffer.height);
    }

    private void drawPolygon(VisList visList, int n, FrameBuffer frameBuffer, World world, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        float f;
        float f2;
        float f3;
        boolean bl;
        Texture texture;
        Texture texture2;
        int n7;
        int n8;
        int n9;
        float f4;
        int n10;
        int n11 = visList.vnum[n];
        Object3D object3D = visList.vobj[n];
        int n12 = n;
        if (visList.stageCnt[n] > 0) {
            return;
        }
        int[] nArray = this.p;
        if (Config.useMultipleThreads && n2 != 0) {
            nArray = new int[3];
        }
        n = visList.portalNum[n12];
        float f5 = 0.0f;
        float f6 = frameBuffer.width;
        float f7 = n2;
        float f8 = n3;
        Mesh mesh = object3D.objMesh;
        Vectors vectors = object3D.objVectors;
        float[] fArray = vectors.sx;
        float[] fArray2 = vectors.sy;
        float[] fArray3 = vectors.sz;
        float[] fArray4 = vectors.sr;
        float[] fArray5 = vectors.sg;
        float[] fArray6 = vectors.sb;
        float[] fArray7 = vectors.su;
        float[] fArray8 = vectors.sv;
        float[] fArray9 = vectors.nuOrg;
        float[] fArray10 = vectors.nvOrg;
        float[] fArray11 = vectors.bsu;
        float[] fArray12 = vectors.bsv;
        if (fArray11 == null) {
            fArray11 = vectors.su;
            fArray12 = vectors.sv;
        }
        int[] nArray2 = mesh.coords;
        if (n != 99999999) {
            f5 = world.portals.lowx[n];
            f6 = world.portals.highx[n] + 1.0f;
            f7 = Math.max(world.portals.lowy[n], (float)n2);
            f8 = Math.min(world.portals.highy[n] + 1.0f, (float)n3);
        }
        int n13 = (int)f7;
        int n14 = 0;
        nArray[0] = mesh.points[n11][0];
        nArray[1] = mesh.points[n11][1];
        nArray[2] = mesh.points[n11][2];
        int n15 = 99999;
        int n16 = 0;
        int n17 = 99999;
        int n18 = 0;
        boolean bl2 = object3D.alwaysFilter;
        if (frameBuffer.useBb && frameBuffer.getType() == 0) {
            for (n10 = 0; n10 < 3; ++n10) {
                int n19 = nArray2[nArray[n10]];
                if (fArray2[n19] < (float)n15) {
                    n15 = (int)fArray2[n19];
                    n14 = n10;
                }
                if (fArray2[n19] > (float)n16) {
                    n16 = (int)fArray2[n19];
                }
                if (fArray[n19] < (float)n17) {
                    n17 = (int)fArray[n19];
                }
                if (fArray[n19] > (float)n18) {
                    n18 = (int)fArray[n19];
                }
                if (!(fArray2[n19] < fArray2[nArray2[nArray[n14]]])) continue;
                n14 = n10;
            }
            if (n16 > frameBuffer.bbYu) {
                frameBuffer.bbYu = n16;
            }
            if (n15 < frameBuffer.bbYo) {
                frameBuffer.bbYo = n15;
            }
            if (n17 < frameBuffer.bbXl) {
                frameBuffer.bbXl = n17;
            }
            if (n18 > frameBuffer.bbXr) {
                frameBuffer.bbXr = n18;
            }
        } else {
            float f9;
            float f10 = fArray2[nArray2[nArray[n14]]];
            float f11 = 0.0f;
            f11 = fArray2[nArray2[nArray[1]]];
            if (f9 < f10) {
                n14 = 1;
                f10 = f11;
            }
            if (fArray2[nArray2[nArray[2]]] < f10) {
                n14 = 2;
            }
        }
        n10 = 0;
        int n20 = 1;
        if (n14 == n10) {
            n10 = 2;
        }
        if (n14 == n20) {
            n20 = 2;
        }
        if (fArray2[nArray2[nArray[n20]]] > (f4 = fArray2[nArray2[nArray[n10]]])) {
            f4 = fArray2[nArray2[nArray[n20]]];
        }
        if (f4 < f7) {
            return;
        }
        int n21 = n14 + 1;
        int n22 = n14 - 1;
        if (n21 > 2) {
            n21 = 0;
        }
        if (n22 < 0) {
            n22 = 2;
        }
        int n23 = nArray[n14];
        int n24 = nArray2[n23];
        int n25 = nArray[n21];
        int n26 = nArray[n22];
        int n27 = nArray2[n25];
        int n28 = nArray2[n26];
        float f12 = fArray2[n24];
        int n29 = (int)f12;
        if ((float)n29 >= f8) {
            return;
        }
        int n30 = 0;
        Texture texture3 = this.texMan.textures[object3D.texture[n11]];
        boolean bl3 = Config.mipmap;
        if (bl3) {
            int n31 = nArray2[nArray[0]];
            n9 = nArray2[nArray[1]];
            n8 = nArray2[nArray[2]];
            float f13 = fArray[n31] * fArray2[n9] + fArray[n9] * fArray2[n8] + fArray[n8] * fArray2[n31] - (fArray2[n31] * fArray[n9] + fArray2[n9] * fArray[n8] + fArray2[n8] * fArray[n31]);
            f13 = (f13 = (float)((double)f13 * 0.5)) < 0.0f ? -f13 : f13;
            n7 = frameBuffer.getSamplingMode();
            if (n7) {
                f13 /= 4.0f;
            } else if (n7 == 3) {
                f13 /= 2.25f;
            } else if (n7 == 2) {
                f13 *= 4.0f;
            }
            float f14 = fArray9[nArray[0]] * fArray10[nArray[1]] + fArray9[nArray[1]] * fArray10[nArray[2]] + fArray9[nArray[2]] * fArray10[nArray[0]] - (fArray10[nArray[0]] * fArray9[nArray[1]] + fArray10[nArray[1]] * fArray9[nArray[2]] + fArray10[nArray[2]] * fArray9[nArray[0]]);
            f14 = (float)((double)f14 * 0.5);
            f14 = f14 < 0.0f ? -f14 : f14;
            float f15 = f14 * (float)texture3.width * (float)texture3.height;
            float f16 = f13 / f15;
            int n32 = -1;
            boolean bl4 = false;
            if (texture3.mipMaps == null) {
                texture3.getMipMappedTexture(1);
            }
            if (texture3.mipMaps != null) {
                while (!bl4 && ++n32 < texture3.mipMaps.length - 1) {
                    bl4 = f16 > 0.5f;
                    f16 *= 4.0f;
                }
                n30 = n32;
            }
        }
        if (!bl3) {
            texture2 = texture3;
            texture = this.texMan.textures[object3D.basemap[n11]];
        } else {
            texture2 = texture3.getMipMappedTexture(n30);
            texture = this.texMan.textures[object3D.basemap[n11]].getMipMappedTexture(n30);
        }
        Texture texture4 = null;
        texture.updateUsage(world.drawCnt);
        texture2.updateUsage(world.drawCnt);
        n9 = visList.vorg[n12].transValue;
        n8 = visList.vorg[n12].transMode == 1 ? 1 : 0;
        boolean bl5 = (visList.mode[n12] & 2) == 2;
        n7 = texture2.alpha != null ? 1 : 0;
        boolean bl6 = (visList.mode[n12] & 1) == 1;
        boolean bl7 = (visList.mode[n12] & 4) == 4;
        boolean bl8 = bl = (visList.mode[n12] & 8) == 8;
        if (bl7) {
            n7 = texture.alpha != null ? 1 : 0;
        }
        float f17 = 1.0f;
        float f18 = 1.0f;
        if (bl && object3D.bumpmap != null) {
            if (!bl3) {
                texture4 = this.texMan.textures[object3D.bumpmap[n11]];
            } else {
                texture4 = this.texMan.textures[object3D.bumpmap[n11]].getMipMappedTexture(n30);
                f17 = texture4.xDiv;
                f18 = texture4.yDiv;
            }
            texture4.updateUsage(world.drawCnt);
        }
        int n33 = world.lights.rgbScale;
        float f19 = 0.0f;
        float f20 = 0.0f;
        float f21 = 0.0f;
        float f22 = 0.0f;
        float f23 = 0.0f;
        float f24 = 0.0f;
        float f25 = 0.0f;
        float f26 = 0.0f;
        float f27 = 0.0f;
        float f28 = 0.0f;
        float f29 = 0.0f;
        float f30 = 0.0f;
        float f31 = 0.0f;
        float f32 = 0.0f;
        float f33 = 0.0f;
        float f34 = 0.0f;
        float f35 = 0.0f;
        float f36 = 0.0f;
        float f37 = fArray[n24];
        float f38 = fArray7[n23];
        float f39 = fArray8[n23];
        float f40 = fArray3[n24];
        float f41 = f38;
        float f42 = f37;
        float f43 = f39;
        float f44 = f40;
        float f45 = fArray11[n23];
        float f46 = f3 = fArray12[n23];
        float f47 = f45;
        if (n30 > 0) {
            f38 /= texture2.xDiv;
            f39 /= texture2.yDiv;
            f41 /= texture2.xDiv;
            f43 /= texture2.yDiv;
            if (texture4 != null) {
                f45 /= f17;
                f3 /= f18;
                f47 /= f17;
                f46 /= f18;
            }
        }
        float f48 = fArray4[n23];
        float f49 = fArray5[n23];
        float f50 = f2 = fArray6[n23];
        float f51 = f48;
        float f52 = f49;
        float f53 = fArray2[n27];
        float f54 = fArray2[n28];
        int n34 = (int)f53;
        int n35 = (int)f54;
        float f55 = f53 - f12 + 1.0f;
        float f56 = f54 - f12 + 1.0f;
        float f57 = (float)n29 - f12;
        if (f55 != 0.0f) {
            f = 1.0f / f55;
            f19 = (fArray[nArray2[n25]] - f37) * f;
            f21 = (fArray7[n25] / texture2.xDiv - f38) * f;
            f23 = (fArray8[n25] / texture2.yDiv - f39) * f;
            f25 = (fArray3[nArray2[n25]] - f40) * f;
            f27 = (fArray11[n25] / f17 - f45) * f;
            f29 = (fArray12[n25] / f18 - f3) * f;
            f33 = (fArray4[n25] - f48) * f;
            f35 = (fArray5[n25] - f49) * f;
            f31 = (fArray6[n25] - f2) * f;
        }
        if (f56 != 0.0f) {
            f = 1.0f / f56;
            f20 = (fArray[nArray2[n26]] - f37) * f;
            f22 = (fArray7[n26] / texture2.xDiv - f38) * f;
            f24 = (fArray8[n26] / texture2.yDiv - f39) * f;
            f26 = (fArray3[nArray2[n26]] - f40) * f;
            f28 = (fArray11[n26] / f17 - f45) * f;
            f30 = (fArray12[n26] / f18 - f3) * f;
            f34 = (fArray4[n26] - f48) * f;
            f36 = (fArray5[n26] - f49) * f;
            f32 = (fArray6[n26] - f2) * f;
        }
        int n36 = 2;
        int n37 = 0;
        float f58 = 0.0f;
        float f59 = 0.0f;
        float f60 = 0.0f;
        if ((float)n29 < f7) {
            n6 = n13 - n29;
            if ((float)n34 >= f7 && (float)n35 >= f7) {
                f37 += f19 * (float)n6;
                f42 += f20 * (float)n6;
                f38 += f21 * (float)n6;
                f41 += f22 * (float)n6;
                f39 += f23 * (float)n6;
                f43 += f24 * (float)n6;
                f40 += f25 * (float)n6;
                f44 += f26 * (float)n6;
                f45 += f27 * (float)n6;
                f47 += f28 * (float)n6;
                f3 += f29 * (float)n6;
                f46 += f30 * (float)n6;
                f2 += f31 * (float)n6;
                f50 += f32 * (float)n6;
                f48 += f33 * (float)n6;
                f51 += f34 * (float)n6;
                f49 += f35 * (float)n6;
                f52 += f36 * (float)n6;
                n29 = n13;
            } else {
                if ((float)n34 < f7 && (float)n35 < f7) {
                    return;
                }
                if ((float)n34 < f7) {
                    n36 = 1;
                    n5 = n21 + 1;
                    if (n5 > 2) {
                        n5 = 0;
                    }
                    n4 = nArray[n5];
                    n34 = (int)fArray2[nArray2[n4]];
                    f55 = fArray2[nArray2[n4]] - fArray2[nArray2[n25]] + 1.0f;
                    if (f55 != 0.0f) {
                        float f61 = 1.0f / f55;
                        f19 = fArray[nArray2[n4]] - fArray[nArray2[n25]];
                        f21 = (fArray7[n4] - fArray7[n25]) / texture2.xDiv * f61;
                        f23 = (fArray8[n4] - fArray8[n25]) / texture2.yDiv * f61;
                        f25 = (fArray3[nArray2[n4]] - fArray3[nArray2[n25]]) * f61;
                        f27 = (fArray11[n4] - fArray11[n25]) / f17 * f61;
                        f29 = (fArray12[n4] - fArray12[n25]) / f18 * f61;
                        f33 = (fArray4[n4] - fArray4[n25]) * f61;
                        f35 = (fArray5[n4] - fArray5[n25]) * f61;
                        f31 = (fArray6[n4] - fArray6[n25]) * f61;
                        f19 *= f61;
                    }
                    f37 = fArray[nArray2[n25]];
                    f38 = fArray7[n25] / texture2.xDiv;
                    f39 = fArray8[n25] / texture2.yDiv;
                    f40 = fArray3[nArray2[n25]];
                    if (vectors.bsu != null) {
                        f45 = vectors.bsu[n25] / f17;
                        f3 = vectors.bsv[n25] / f18;
                    }
                    f48 = fArray4[n25];
                    f49 = fArray5[n25];
                    f2 = fArray6[n25];
                    n37 = 1;
                    if (f7 == 0.0f) {
                        f58 = 0.0f;
                    } else {
                        f12 = f7;
                        int n38 = (int)f7;
                        f58 = (float)n38 - f12;
                    }
                    f42 += f20 * (float)n6;
                    f41 += f22 * (float)n6;
                    f43 += f24 * (float)n6;
                    f44 += f26 * (float)n6;
                    f47 += f28 * (float)n6;
                    f46 += f30 * (float)n6;
                    f50 += f32 * (float)n6;
                    f51 += f34 * (float)n6;
                    f52 += f36 * (float)n6;
                    f60 = f7 - fArray2[nArray2[n25]];
                    n21 = n5;
                    n29 = n13;
                    f37 += f19 * f60;
                    f38 += f21 * f60;
                    f39 += f23 * f60;
                    f40 += f25 * f60;
                    f45 += f27 * f60;
                    f3 += f29 * f60;
                    f48 += f33 * f60;
                    f49 += f35 * f60;
                    f2 += f31 * f60;
                } else {
                    n36 = 1;
                    n5 = n22 - 1;
                    if (n5 < 0) {
                        n5 = 2;
                    }
                    n4 = nArray[n5];
                    n35 = (int)fArray2[nArray2[n4]];
                    f56 = fArray2[nArray2[n4]] - fArray2[nArray2[n26]] + 1.0f;
                    if (f56 != 0.0f) {
                        float f62 = 1.0f / f56;
                        f20 = fArray[nArray2[n4]] - fArray[nArray2[n26]];
                        f22 = (fArray7[n4] - fArray7[n26]) / texture2.xDiv * f62;
                        f24 = (fArray8[n4] - fArray8[n26]) / texture2.yDiv * f62;
                        f26 = (fArray3[nArray2[n4]] - fArray3[nArray2[n26]]) * f62;
                        f28 = (fArray11[n4] - fArray11[n26]) / f17 * f62;
                        f30 = (fArray12[n4] - fArray12[n26]) / f18 * f62;
                        f34 = (fArray4[n4] - fArray4[n26]) * f62;
                        f36 = (fArray5[n4] - fArray5[n26]) * f62;
                        f32 = (fArray6[n4] - fArray6[n26]) * f62;
                        f20 *= f62;
                    }
                    f42 = fArray[nArray2[n26]];
                    f41 = fArray7[n26] / texture2.xDiv;
                    f43 = fArray8[n26] / texture2.yDiv;
                    f44 = fArray3[nArray2[n26]];
                    if (vectors.bsu != null) {
                        f47 = vectors.bsu[n26] / f17;
                        f46 = vectors.bsv[n26] / f18;
                    }
                    f51 = fArray4[n26];
                    f52 = fArray5[n26];
                    f50 = fArray6[n26];
                    n37 = 2;
                    if (f7 == 0.0f) {
                        f59 = 0.0f;
                    } else {
                        f12 = f7;
                        int n39 = (int)f7;
                        f59 = (float)n39 - f12;
                    }
                    f37 += f19 * (float)n6;
                    f38 += f21 * (float)n6;
                    f39 += f23 * (float)n6;
                    f40 += f25 * (float)n6;
                    f45 += f27 * (float)n6;
                    f3 += f29 * (float)n6;
                    f48 += f33 * (float)n6;
                    f49 += f35 * (float)n6;
                    f2 += f31 * (float)n6;
                    f60 = f7 - fArray2[nArray2[n26]];
                    n22 = n5;
                    n29 = n13;
                    f42 += f20 * f60;
                    f41 += f22 * f60;
                    f43 += f24 * f60;
                    f44 += f26 * f60;
                    f47 += f28 * f60;
                    f46 += f30 * f60;
                    f51 += f34 * f60;
                    f52 += f36 * f60;
                    f50 += f32 * f60;
                }
            }
        }
        switch (n37) {
            case 0: {
                f37 += f19 * f57 + 0.5f;
                f40 += f25 * f57;
                f38 += f21 * f57;
                f39 += f23 * f57;
                f48 += f33 * f57;
                f49 += f35 * f57;
                f2 += f31 * f57;
                f45 += f27 * f57;
                f3 += f29 * f57;
                f42 += f20 * f57 + 0.5f;
                f44 += f26 * f57;
                f41 += f22 * f57;
                f43 += f24 * f57;
                f51 += f34 * f57;
                f52 += f36 * f57;
                f50 += f32 * f57;
                f47 += f28 * f57;
                f46 += f30 * f57;
                break;
            }
            case 1: {
                f37 += f19 * f58 + 0.5f;
                f42 += f20 * f57 + 0.5f;
                f40 += f25 * f58;
                f44 += f26 * f57;
                f38 += f21 * f58;
                f41 += f22 * f57;
                f39 += f23 * f58;
                f43 += f24 * f57;
                f48 += f33 * f58;
                f51 += f34 * f57;
                f49 += f35 * f58;
                f52 += f36 * f57;
                f2 += f31 * f58;
                f50 += f32 * f57;
                f45 += f27 * f58;
                f3 += f29 * f58;
                f47 += f28 * f57;
                f46 += f30 * f57;
                break;
            }
            case 2: {
                f37 += f19 * f57 + 0.5f;
                f42 += f20 * f59 + 0.5f;
                f40 += f25 * f57;
                f44 += f26 * f59;
                f38 += f21 * f57;
                f41 += f22 * f59;
                f39 += f23 * f57;
                f43 += f24 * f59;
                f48 += f33 * f57;
                f51 += f34 * f59;
                f49 += f35 * f57;
                f52 += f36 * f59;
                f2 += f31 * f57;
                f50 += f32 * f59;
                f45 += f27 * f57;
                f3 += f29 * f57;
                f47 += f28 * f59;
                f46 += f30 * f59;
            }
        }
        n6 = 0;
        n5 = object3D.writeToZbuffer;
        n4 = Config.texelFilter & (!object3D.alwaysFilter ? 1 : 0);
        int n40 = (int)(f8 - 1.0f);
        if (f8 != (float)frameBuffer.height) {
            n40 = frameBuffer.height;
        }
        boolean bl9 = !bl || !bl6;
        float f63 = 0.0f;
        if (texture2.isUnicolor || n30 > 0) {
            n4 = 0;
            bl2 = false;
        }
        int n41 = n36;
        while (n41 > 0) {
            float f64;
            int n42;
            int n43;
            int n44;
            n6 = n34 < n35 ? n34 : n35;
            while (n29 < n6 || n29 == n40) {
                f37 += f19;
                f42 += f20;
                f38 += f21;
                f39 += f23;
                f40 += f25;
                f45 += f27;
                f3 += f29;
                f48 += f33;
                f49 += f35;
                f2 += f31;
                f41 += f22;
                f43 += f24;
                f44 += f26;
                f47 += f28;
                f46 += f30;
                f51 += f34;
                f52 += f36;
                f50 += f32;
                if (n4 != 0) {
                    float f65;
                    float f66;
                    bl2 = false;
                    f63 = f21 < 0.0f ? -f21 : f21;
                    if (f63 <= (f66 = 0.75f * f40)) {
                        f63 = f23 < 0.0f ? -f23 : f23;
                        boolean bl10 = bl2 = f63 <= f66;
                    }
                    if (!bl2 && (f63 = f22 < 0.0f ? -f22 : f22) <= (f65 = 0.75f * f44)) {
                        f63 = f24 < 0.0f ? -f24 : f24;
                        boolean bl11 = bl2 = f63 <= f65;
                    }
                }
                if (!(!(f37 >= 0.0f) && !(f42 >= 0.0f) || f37 >= f6 && f42 >= f6)) {
                    if (bl9) {
                        if (!bl5) {
                            this.drawShadedZbufferedFilteredScanline(f48, f51, f49, f52, f2, f50, f37, f42, f38, f41, f39, f43, f40, f44, n29, f5, f6, frameBuffer, texture2, bl2, n33);
                        } else if (n8 == 0) {
                            if (!n7) {
                                this.drawShadedZbufferedFilteredTransparentScanline(f48, f51, f49, f52, f2, f50, f37, f42, f38, f41, f39, f43, f40, f44, n29, f5, f6, frameBuffer, texture2, bl2, n9, n33, n5 != 0);
                            } else {
                                this.drawShadedZbufferedFilteredAlphaScanline(f48, f51, f49, f52, f2, f50, f37, f42, f38, f41, f39, f43, f40, f44, n29, f5, f6, frameBuffer, texture2, bl2, n9, n33, n5 != 0);
                            }
                        } else if (!n7) {
                            this.drawShadedZbufferedFilteredAdditiveTransparentScanline(f48, f51, f49, f52, f2, f50, f37, f42, f38, f41, f39, f43, f40, f44, n29, f5, f6, frameBuffer, texture2, bl2, n9, n33, n5 != 0);
                        } else {
                            this.drawShadedZbufferedFilteredAdditiveAlphaScanline(f48, f51, f49, f52, f2, f50, f37, f42, f38, f41, f39, f43, f40, f44, n29, f5, f6, frameBuffer, texture2, bl2, n9, n33, n5 != 0);
                        }
                    } else if (bl7) {
                        if (bl5) {
                            if (n8 != 0) {
                                this.drawShadedZbufferedFilteredBumpmappedBlendedAdditiveAlphaScanline(f48, f51, f49, f52, f2, f50, f37, f42, f38, f41, f39, f43, f40, f44, n29, f5, f6, frameBuffer, texture2, bl2, f45, f47, f3, f46, texture4, texture, n9, n7 != 0, n33);
                            } else {
                                this.drawShadedZbufferedFilteredBumpmappedBlendedAlphaScanline(f48, f51, f49, f52, f2, f50, f37, f42, f38, f41, f39, f43, f40, f44, n29, f5, f6, frameBuffer, texture2, bl2, f45, f47, f3, f46, texture4, texture, n9, n7 != 0, n33);
                            }
                        } else {
                            this.drawShadedZbufferedFilteredBumpmappedBlendedScanline(f48, f51, f49, f52, f2, f50, f37, f42, f38, f41, f39, f43, f40, f44, n29, f5, f6, frameBuffer, texture2, bl2, f45, f47, f3, f46, texture4, texture, n33);
                        }
                    } else {
                        this.drawShadedZbufferedFilteredBumpmappedScanline(f48, f51, f49, f52, f2, f50, f37, f42, f38, f41, f39, f43, f40, f44, n29, f5, f6, frameBuffer, texture2, bl2, f45, f47, f3, f46, texture4, n33);
                    }
                } else if (f37 < 0.0f && f37 < f42 && f20 <= 0.0f || f37 < 0.0f && f42 < f37 && f19 <= 0.0f || f42 >= f6 && f37 < f42 && f19 >= 0.0f || f42 >= f6 && f42 < f37 && f20 >= 0.0f) {
                    return;
                }
                if (!((float)(++n29) >= f8)) continue;
                return;
            }
            if (n29 >= n34) {
                int n45 = n21 + 1;
                if (n45 > 2) {
                    n45 = 0;
                }
                if (n41 == n36) {
                    int n46 = nArray[n21];
                    n44 = nArray[n45];
                    n43 = nArray2[n46];
                    n42 = nArray2[n44];
                    n34 = (int)fArray2[n42];
                    f55 = fArray2[n42] - fArray2[n43] + 1.0f;
                    if (f55 != 0.0f) {
                        f64 = 1.0f / f55;
                        f19 = (fArray[n42] - fArray[n43]) * f64;
                        f21 = (fArray7[n44] - fArray7[n46]) / texture2.xDiv * f64;
                        f23 = (fArray8[n44] - fArray8[n46]) / texture2.yDiv * f64;
                        f25 = (fArray3[n42] - fArray3[n43]) * f64;
                        f27 = (fArray11[n44] - fArray11[n46]) / f17 * f64;
                        f29 = (fArray12[n44] - fArray12[n46]) / f18 * f64;
                        f33 = (fArray4[n44] - fArray4[n46]) * f64;
                        f35 = (fArray5[n44] - fArray5[n46]) * f64;
                        f31 = (fArray6[n44] - fArray6[n46]) * f64;
                    }
                    f37 = fArray[n43];
                    f38 = fArray7[n46] / texture2.xDiv;
                    f39 = fArray8[n46] / texture2.yDiv;
                    f40 = fArray3[n43];
                    if (vectors.bsu != null) {
                        f45 = vectors.bsu[n46] / f17;
                        f3 = vectors.bsv[n46] / f18;
                    }
                    f48 = fArray4[n46];
                    f49 = fArray5[n46];
                    f2 = fArray6[n46];
                    f12 = vectors.sy[n43];
                    f57 = (float)n29 - f12;
                    f37 += f19 * f57 + 0.5f;
                    f40 += f25 * f57;
                    f38 += f21 * f57;
                    f39 += f23 * f57;
                    f48 += f33 * f57;
                    f49 += f35 * f57;
                    f2 += f31 * f57;
                    f45 += f27 * f57;
                    f3 += f29 * f57;
                }
                --n41;
                n21 = n45;
            }
            if (n29 < n35) continue;
            int n47 = n22 - 1;
            if (n47 < 0) {
                n47 = 2;
            }
            if (n41 == n36) {
                int n48 = nArray[n22];
                n44 = nArray[n47];
                n43 = nArray2[n48];
                n42 = nArray2[n44];
                n35 = (int)fArray2[n42];
                f56 = fArray2[n42] - fArray2[n43] + 1.0f;
                if (f56 != 0.0f) {
                    f64 = 1.0f / f56;
                    f20 = (fArray[n42] - fArray[n43]) * f64;
                    f22 = (fArray7[n44] - fArray7[n48]) / texture2.xDiv * f64;
                    f24 = (fArray8[n44] - fArray8[n48]) / texture2.yDiv * f64;
                    f26 = (fArray3[n42] - fArray3[n43]) * f64;
                    f28 = (fArray11[n44] - fArray11[n48]) / f17 * f64;
                    f30 = (fArray12[n44] - fArray12[n48]) / f18 * f64;
                    f34 = (fArray4[n44] - fArray4[n48]) * f64;
                    f36 = (fArray5[n44] - fArray5[n48]) * f64;
                    f32 = (fArray6[n44] - fArray6[n48]) * f64;
                }
                f42 = fArray[n43];
                f41 = fArray7[n48] / texture2.xDiv;
                f43 = fArray8[n48] / texture2.yDiv;
                f44 = fArray3[n43];
                if (vectors.bsu != null) {
                    f47 = vectors.bsu[n48] / f17;
                    f46 = vectors.bsv[n48] / f18;
                }
                f51 = fArray4[n48];
                f52 = fArray5[n48];
                f50 = fArray6[n48];
                f12 = fArray2[n43];
                f57 = (float)n29 - f12;
                f42 += f20 * f57 + 0.5f;
                f44 += f26 * f57;
                f41 += f22 * f57;
                f43 += f24 * f57;
                f51 += f34 * f57;
                f52 += f36 * f57;
                f50 += f32 * f57;
                f47 += f28 * f57;
                f46 += f30 * f57;
            }
            --n41;
            n22 = n47;
        }
    }

    private final void drawShadedZbufferedFilteredScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl, int n2) {
        float f17;
        boolean bl2 = Config.texelFilter;
        boolean bl3 = Config.spanBasedHsr;
        boolean bl4 = Config.optiZ;
        if (n2 != 1) {
            float f18 = n2;
            f *= f18;
            f2 *= f18;
            f3 *= f18;
            f4 *= f18;
            f5 *= f18;
            f6 *= f18;
        }
        int[] nArray = texture.texels;
        int[] nArray2 = frameBuffer.pixels;
        int[] nArray3 = frameBuffer.zbuffer;
        int n3 = frameBuffer.xstart[n];
        int n4 = frameBuffer.xend[n];
        float f19 = frameBuffer.zhigh[n];
        int n5 = frameBuffer.exXstart[n];
        int n6 = frameBuffer.exXend[n];
        float f20 = frameBuffer.exZlow[n];
        int n7 = frameBuffer.exXstart2[n];
        int n8 = frameBuffer.exXend2[n];
        float f21 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f17 = f7;
            f7 = f8;
            f8 = f17;
            f17 = f9;
            f9 = f10;
            f10 = f17;
            f17 = f11;
            f11 = f12;
            f12 = f17;
            f17 = f13;
            f13 = f14;
            f14 = f17;
            f17 = f;
            f = f2;
            f2 = f17;
            f17 = f3;
            f3 = f4;
            f4 = f17;
            f17 = f5;
            f5 = f6;
            f6 = f17;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n6 <= n8) {
                if (n6 >= n7) {
                    n6 = n8;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n7 < n5) {
                        n5 = n7;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f21 < f20) {
                        f20 = f21;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n7 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n8 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f21 = 2.1474836E9f;
                }
            } else if (n8 >= n5) {
                if (n7 < n5) {
                    n5 = n7;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f21 < f20) {
                        f20 = f21;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n7 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n8 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f21 = 2.1474836E9f;
            }
            if (!(bl3 && (float)n5 <= f7 && (float)n6 >= f8 && f20 >= f13 && f20 >= f14 || (float)n7 <= f7 && (float)n8 >= f8 && f21 >= f13 && f21 >= f14)) {
                int n9;
                float f22;
                float f23;
                float f24;
                float f25;
                float f26;
                float f27;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f17 = f13;
                float f28 = f8 - f7;
                if (f28 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f28 != 0.0f) {
                    float f29 = 1.0f / f28;
                    f27 = (f10 - f9) * f29;
                    f26 = (f12 - f11) * f29;
                    f25 = (f14 - f13) * f29;
                    f24 = (f2 - f) * f29;
                    f23 = (f4 - f3) * f29;
                    f22 = (f6 - f5) * f29;
                } else {
                    f27 = 0.0f;
                    f26 = 0.0f;
                    f25 = 0.0f;
                    f22 = 0.0f;
                    f24 = 0.0f;
                    f23 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f24;
                    f3 += f7 * f23;
                    f5 += f7 * f22;
                    f9 += f7 * f27;
                    f11 += f7 * f26;
                    f13 += f7 * f25;
                    f7 = f15;
                }
                int n10 = n * frameBuffer.width;
                int n11 = n9 = (int)f7;
                int n12 = n9 - 1;
                int n13 = (int)f8;
                int n14 = 16;
                float f30 = 16384.0f;
                float f31 = 16384.0f;
                float f32 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f33 = 16.0f * f27;
                float f34 = 16.0f * f26;
                float f35 = 16.0f * f25;
                float f36 = 16.0f * f24;
                float f37 = 16.0f * f23;
                float f38 = 16.0f * f22;
                float f39 = 1.0f / f13;
                float f40 = f9 * f39;
                float f41 = f11 * f39;
                float f42 = f * f39;
                float f43 = f3 * f39;
                float f44 = f5 * f39;
                byte by = texture.shifter;
                int n15 = (int)(f42 * 262144.0f);
                int n16 = (int)(f43 * 262144.0f);
                int n17 = (int)(f44 * 262144.0f);
                int n18 = 0;
                boolean bl5 = false;
                if (Config.zTrick) {
                    n18 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n18 = -n18;
                        bl5 = true;
                    }
                } else {
                    n18 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                int n19 = (int)((double)f40 * 262144.0);
                int n20 = (int)((double)f41 * 262144.0);
                int n21 = 0;
                int n22 = 0;
                int n23 = 0;
                int n24 = n & 1;
                int n25 = 1 - n24 << 17;
                int n26 = n24 << 17;
                int n27 = texture.width - 1 << 18;
                int n28 = texture.height - 1 << 18;
                do {
                    n9 = n12 + 1;
                    if ((n12 += n14) > n13) {
                        n14 -= n12 - n13;
                        n12 = n13;
                        if (n14 != 0) {
                            f33 = (float)n14 * f27;
                            f34 = (float)n14 * f26;
                            f35 = (float)n14 * f25;
                            f36 = (float)n14 * f24;
                            f37 = (float)n14 * f23;
                            f38 = (float)n14 * f22;
                            f30 = f31 = multiLU[n14];
                            f32 = Config.zTrick ? multiZTLU[n14] : multiZLU[n14];
                        } else {
                            f33 = 0.0f;
                            f34 = 0.0f;
                            f35 = 0.0f;
                            f36 = 0.0f;
                            f37 = 0.0f;
                            f38 = 0.0f;
                            n14 = 1;
                            f31 = 262144.0f;
                            f30 = 262144.0f;
                            f32 = Config.zTrick ? 2.1474836E9f : 4.2949673E9f;
                        }
                    }
                    if (n12 == n13 && f8 < f16 - 1.0f) {
                        f33 = f10 - f9;
                        f34 = f12 - f11;
                        f35 = f14 - f13;
                    }
                    float f45 = f13;
                    f9 += f33;
                    f11 += f34;
                    f += f36;
                    f3 += f37;
                    f5 += f38;
                    f39 = 1.0f / (f13 += f35);
                    float f46 = f9 * f39;
                    float f47 = f11 * f39;
                    float f48 = f * f39;
                    float f49 = f3 * f39;
                    float f50 = f5 * f39;
                    int n29 = (int)(f32 * (f13 - f45));
                    if (bl5) {
                        n29 = -n29;
                    }
                    int n30 = (int)(f30 * (f46 - f40));
                    int n31 = (int)(f30 * (f47 - f41));
                    n21 = (int)(f31 * (f48 - f42));
                    n22 = (int)(f31 * (f49 - f43));
                    n23 = (int)(f31 * (f50 - f44));
                    if (bl3 && (n5 <= n9 && n6 >= n12 && f20 >= f45 && f20 >= f13 || n7 <= n9 && n8 >= n12 && f21 >= f45 && f21 >= f13)) {
                        if (n12 != n13) {
                            n18 += n14 * n29;
                            n19 += n14 * n30;
                            n20 += n14 * n31;
                            n15 += n14 * n21;
                            n16 += n14 * n22;
                            n17 += n14 * n23;
                        }
                    } else {
                        int n32;
                        int n33 = n12 + n10;
                        int n34 = 0;
                        int n35 = 0;
                        int n36 = 0;
                        int n37 = 0;
                        if (bl2) {
                            if (!bl && n30 < 196608 && n30 > -196608 && n31 <= 196608 && n31 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n38 = (n9 & 1) != 0 ? 65536 + n25 : n26;
                            if (bl4 && (n3 > n12 || n4 < n9 || f45 >= f19 && f13 >= f19)) {
                                for (n32 = n9 + n10; n32 <= n33; ++n32) {
                                    n34 = nArray[((n19 + n38 & n27) >> 18) + ((n20 + (n38 ^ 0x10000) & n28) >> 18 << by)];
                                    n38 ^= 0x30000;
                                    n37 = (n34 >> 16) * (n15 >> 10) >> 16;
                                    n36 = (n34 >> 8 & 0xFF) * (n16 >> 10) >> 16;
                                    n35 = (n34 & 0xFF) * (n17 >> 10) >> 16;
                                    if ((n37 & 0xFFFFFF00) != 0) {
                                        n37 = 255 >> (n37 >> 28 & 8);
                                    }
                                    if ((n36 & 0xFFFFFF00) != 0) {
                                        n36 = 255 >> (n36 >> 28 & 8);
                                    }
                                    if ((n35 & 0xFFFFFF00) != 0) {
                                        n35 = 255 >> (n35 >> 28 & 8);
                                    }
                                    nArray2[n32] = n35 | n36 << 8 | n37 << 16 | 0xFF000000;
                                    nArray3[n32] = n18;
                                    n19 += n30;
                                    n20 += n31;
                                    n15 += n21;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n29;
                                }
                            } else if (bl5) {
                                for (n32 = n9 + n10; n32 <= n33; ++n32) {
                                    if (nArray3[n32] > n18) {
                                        n34 = nArray[((n19 + n38 & n27) >> 18) + ((n20 + (n38 ^ 0x10000) & n28) >> 18 << by)];
                                        n38 ^= 0x30000;
                                        n37 = (n34 >> 16) * (n15 >> 10) >> 16;
                                        n36 = (n34 >> 8 & 0xFF) * (n16 >> 10) >> 16;
                                        n35 = (n34 & 0xFF) * (n17 >> 10) >> 16;
                                        if ((n37 & 0xFFFFFF00) != 0) {
                                            n37 = 255 >> (n37 >> 28 & 8);
                                        }
                                        if ((n36 & 0xFFFFFF00) != 0) {
                                            n36 = 255 >> (n36 >> 28 & 8);
                                        }
                                        if ((n35 & 0xFFFFFF00) != 0) {
                                            n35 = 255 >> (n35 >> 28 & 8);
                                        }
                                        nArray2[n32] = n35 | n36 << 8 | n37 << 16 | 0xFF000000;
                                        nArray3[n32] = n18;
                                    }
                                    n19 += n30;
                                    n20 += n31;
                                    n15 += n21;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n29;
                                }
                            } else {
                                for (n32 = n9 + n10; n32 <= n33; ++n32) {
                                    if (nArray3[n32] < n18) {
                                        n34 = nArray[((n19 + n38 & n27) >> 18) + ((n20 + (n38 ^ 0x10000) & n28) >> 18 << by)];
                                        n38 ^= 0x30000;
                                        n37 = (n34 >> 16) * (n15 >> 10) >> 16;
                                        n36 = (n34 >> 8 & 0xFF) * (n16 >> 10) >> 16;
                                        n35 = (n34 & 0xFF) * (n17 >> 10) >> 16;
                                        if ((n37 & 0xFFFFFF00) != 0) {
                                            n37 = 255 >> (n37 >> 28 & 8);
                                        }
                                        if ((n36 & 0xFFFFFF00) != 0) {
                                            n36 = 255 >> (n36 >> 28 & 8);
                                        }
                                        if ((n35 & 0xFFFFFF00) != 0) {
                                            n35 = 255 >> (n35 >> 28 & 8);
                                        }
                                        nArray2[n32] = n35 | n36 << 8 | n37 << 16 | 0xFF000000;
                                        nArray3[n32] = n18;
                                    }
                                    n19 += n30;
                                    n20 += n31;
                                    n15 += n21;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n29;
                                }
                            }
                        } else if (bl4 && (n3 > n12 || n4 < n9 || f45 >= f19 && f13 >= f19)) {
                            for (n32 = n9 + n10; n32 <= n33; ++n32) {
                                n34 = nArray[((n19 & n27) >> 18) + ((n20 & n28) >> 18 << by)];
                                n37 = (n34 >> 16) * (n15 >> 10) >> 16;
                                n36 = (n34 >> 8 & 0xFF) * (n16 >> 10) >> 16;
                                n35 = (n34 & 0xFF) * (n17 >> 10) >> 16;
                                if ((n37 & 0xFFFFFF00) != 0) {
                                    n37 = 255 >> (byte)(n37 >> 28 & 8);
                                }
                                if ((n36 & 0xFFFFFF00) != 0) {
                                    n36 = 255 >> (byte)(n36 >> 28 & 8);
                                }
                                if ((n35 & 0xFFFFFF00) != 0) {
                                    n35 = 255 >> (byte)(n35 >> 28 & 8);
                                }
                                nArray2[n32] = n35 | n36 << 8 | n37 << 16 | 0xFF000000;
                                nArray3[n32] = n18;
                                n19 += n30;
                                n20 += n31;
                                n15 += n21;
                                n16 += n22;
                                n17 += n23;
                                n18 += n29;
                            }
                        } else if (bl5) {
                            for (n32 = n9 + n10; n32 <= n33; ++n32) {
                                if (nArray3[n32] > n18) {
                                    n34 = nArray[((n19 & n27) >> 18) + ((n20 & n28) >> 18 << by)];
                                    n37 = (n34 >> 16) * (n15 >> 10) >> 16;
                                    n36 = (n34 >> 8 & 0xFF) * (n16 >> 10) >> 16;
                                    n35 = (n34 & 0xFF) * (n17 >> 10) >> 16;
                                    if ((n37 & 0xFFFFFF00) != 0) {
                                        n37 = 255 >> (byte)(n37 >> 28 & 8);
                                    }
                                    if ((n36 & 0xFFFFFF00) != 0) {
                                        n36 = 255 >> (byte)(n36 >> 28 & 8);
                                    }
                                    if ((n35 & 0xFFFFFF00) != 0) {
                                        n35 = 255 >> (byte)(n35 >> 28 & 8);
                                    }
                                    nArray2[n32] = n35 | n36 << 8 | n37 << 16 | 0xFF000000;
                                    nArray3[n32] = n18;
                                }
                                n19 += n30;
                                n20 += n31;
                                n15 += n21;
                                n16 += n22;
                                n17 += n23;
                                n18 += n29;
                            }
                        } else {
                            for (n32 = n9 + n10; n32 <= n33; ++n32) {
                                if (nArray3[n32] < n18) {
                                    n34 = nArray[((n19 & n27) >> 18) + ((n20 & n28) >> 18 << by)];
                                    n37 = (n34 >> 16) * (n15 >> 10) >> 16;
                                    n36 = (n34 >> 8 & 0xFF) * (n16 >> 10) >> 16;
                                    n35 = (n34 & 0xFF) * (n17 >> 10) >> 16;
                                    if ((n37 & 0xFFFFFF00) != 0) {
                                        n37 = 255 >> (byte)(n37 >> 28 & 8);
                                    }
                                    if ((n36 & 0xFFFFFF00) != 0) {
                                        n36 = 255 >> (byte)(n36 >> 28 & 8);
                                    }
                                    if ((n35 & 0xFFFFFF00) != 0) {
                                        n35 = 255 >> (byte)(n35 >> 28 & 8);
                                    }
                                    nArray2[n32] = n35 | n36 << 8 | n37 << 16 | 0xFF000000;
                                    nArray3[n32] = n18;
                                }
                                n19 += n30;
                                n20 += n31;
                                n15 += n21;
                                n16 += n22;
                                n17 += n23;
                                n18 += n29;
                            }
                        }
                    }
                    f40 = f46;
                    f41 = f47;
                    f42 = f48;
                    f43 = f49;
                    f44 = f50;
                } while (n12 < n13);
                boolean bl6 = false;
                if (n11 < n5 && n13 >= n5 || n5 == 99999999) {
                    frameBuffer.exXstart[n] = n11;
                    if (f20 > f17) {
                        frameBuffer.exZlow[n] = f17;
                    }
                    if (frameBuffer.exZlow[n] > f14) {
                        frameBuffer.exZlow[n] = f14;
                    }
                    bl6 = true;
                }
                if (n13 > n6 && f7 <= (float)n6 || n6 == -1) {
                    frameBuffer.exXend[n] = n13;
                    if (frameBuffer.exZlow[n] > f14) {
                        frameBuffer.exZlow[n] = f14;
                    }
                    if (frameBuffer.exZlow[n] > f17) {
                        frameBuffer.exZlow[n] = f17;
                    }
                    bl6 = true;
                }
                if (!bl6) {
                    if (n11 < n7 && n13 >= n7 || n7 == 99999999) {
                        frameBuffer.exXstart2[n] = n11;
                        if (f21 > f17) {
                            frameBuffer.exZlow2[n] = f17;
                        }
                        if (frameBuffer.exZlow2[n] > f14) {
                            frameBuffer.exZlow2[n] = f14;
                        }
                    }
                    if (n13 > n8 && f7 <= (float)n8 || n8 == -1) {
                        frameBuffer.exXend2[n] = n13;
                        if (frameBuffer.exZlow2[n] > f14) {
                            frameBuffer.exZlow2[n] = f14;
                        }
                        if (frameBuffer.exZlow2[n] > f17) {
                            frameBuffer.exZlow2[n] = f17;
                        }
                        bl6 = true;
                    }
                }
                if (f7 < (float)n3) {
                    frameBuffer.xstart[n] = n11;
                }
                if (n13 > n4) {
                    frameBuffer.xend[n] = n13;
                }
                if (f14 < f17) {
                    f14 = f17;
                }
                if (f14 > f19) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    public void drawWireframe(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
        int n3 = visList.vnum[n];
        Object3D object3D = visList.vobj[n];
        int n4 = object3D.objMesh.coords[object3D.objMesh.points[n3][0]];
        int n5 = object3D.objMesh.coords[object3D.objMesh.points[n3][1]];
        int n6 = object3D.objMesh.coords[object3D.objMesh.points[n3][2]];
        float f = object3D.objVectors.sx[n4];
        float f2 = object3D.objVectors.sx[n5];
        float f3 = object3D.objVectors.sx[n6];
        float f4 = object3D.objVectors.sy[n4];
        float f5 = object3D.objVectors.sy[n5];
        float f6 = object3D.objVectors.sy[n6];
        frameBuffer.drawLine(f, f4, f2, f5, n2);
        frameBuffer.drawLine(f2, f5, f3, f6, n2);
        frameBuffer.drawLine(f, f4, f3, f6, n2);
    }

    private final void drawShadedZbufferedFilteredBumpmappedBlendedScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl, float f17, float f18, float f19, float f20, Texture texture2, Texture texture3, int n2) {
        float f21;
        if (n2 != 1) {
            float f22 = n2;
            f *= f22;
            f2 *= f22;
            f3 *= f22;
            f4 *= f22;
            f5 *= f22;
            f6 *= f22;
        }
        int[] nArray = texture.texels;
        int[] nArray2 = texture2.texels;
        int[] nArray3 = texture3.texels;
        int[] nArray4 = frameBuffer.pixels;
        int[] nArray5 = frameBuffer.zbuffer;
        int n3 = frameBuffer.xstart[n];
        int n4 = frameBuffer.xend[n];
        float f23 = frameBuffer.zhigh[n];
        int n5 = frameBuffer.exXstart[n];
        int n6 = frameBuffer.exXend[n];
        float f24 = frameBuffer.exZlow[n];
        int n7 = frameBuffer.exXstart2[n];
        int n8 = frameBuffer.exXend2[n];
        float f25 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f21 = f7;
            f7 = f8;
            f8 = f21;
            f21 = f9;
            f9 = f10;
            f10 = f21;
            f21 = f11;
            f11 = f12;
            f12 = f21;
            f21 = f13;
            f13 = f14;
            f14 = f21;
            f21 = f17;
            f17 = f18;
            f18 = f21;
            f21 = f19;
            f19 = f20;
            f20 = f21;
            f21 = f;
            f = f2;
            f2 = f21;
            f21 = f3;
            f3 = f4;
            f4 = f21;
            f21 = f5;
            f5 = f6;
            f6 = f21;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n6 <= n8) {
                if (n6 >= n7) {
                    n6 = n8;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n7 < n5) {
                        n5 = n7;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f25 < f24) {
                        f24 = f25;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n7 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n8 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f25 = 2.1474836E9f;
                }
            } else if (n8 >= n5) {
                if (n7 < n5) {
                    n5 = n7;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f25 < f24) {
                        f24 = f25;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n7 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n8 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f25 = 2.1474836E9f;
            }
            if (!(Config.spanBasedHsr && (float)n5 <= f7 && (float)n6 >= f8 && f24 >= f13 && f24 >= f14 || (float)n7 <= f7 && (float)n8 >= f8 && f25 >= f13 && f25 >= f14)) {
                int n9;
                float f26;
                float f27;
                float f28;
                float f29;
                float f30;
                float f31;
                float f32;
                float f33;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f21 = f8 - f7;
                float f34 = f13;
                if (f21 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f21 != 0.0f) {
                    float f35 = 1.0f / f21;
                    f33 = (f10 - f9) * f35;
                    f32 = (f12 - f11) * f35;
                    f31 = (f18 - f17) * f35;
                    f30 = (f20 - f19) * f35;
                    f29 = (f14 - f13) * f35;
                    f28 = (f2 - f) * f35;
                    f27 = (f4 - f3) * f35;
                    f26 = (f6 - f5) * f35;
                } else {
                    f33 = 0.0f;
                    f32 = 0.0f;
                    f29 = 0.0f;
                    f26 = 0.0f;
                    f28 = 0.0f;
                    f27 = 0.0f;
                    f31 = 0.0f;
                    f30 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f28;
                    f3 += f7 * f27;
                    f5 += f7 * f26;
                    f9 += f7 * f33;
                    f11 += f7 * f32;
                    f17 += f7 * f31;
                    f19 += f7 * f30;
                    f13 += f7 * f29;
                    f7 = f15;
                }
                int n10 = n * frameBuffer.width;
                int n11 = n9 = (int)f7;
                int n12 = n9 - 1;
                int n13 = (int)f8;
                int n14 = 16;
                float f36 = 16384.0f;
                float f37 = 16384.0f;
                float f38 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f39 = 16.0f * f33;
                float f40 = 16.0f * f32;
                float f41 = 16.0f * f29;
                float f42 = 16.0f * f28;
                float f43 = 16.0f * f27;
                float f44 = 16.0f * f26;
                float f45 = 16.0f * f31;
                float f46 = 16.0f * f30;
                float f47 = 1.0f / f13;
                float f48 = f9 * f47;
                float f49 = f11 * f47;
                float f50 = f17 * f47;
                float f51 = f19 * f47;
                float f52 = f * f47;
                float f53 = f3 * f47;
                float f54 = f5 * f47;
                byte by = texture.shifter;
                byte by2 = texture2.shifter;
                int n15 = (int)(f52 * 262144.0f);
                int n16 = (int)(f53 * 262144.0f);
                int n17 = (int)(f54 * 262144.0f);
                int n18 = 0;
                boolean bl2 = false;
                if (Config.zTrick) {
                    n18 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n18 = -n18;
                        bl2 = true;
                    }
                } else {
                    n18 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                int n19 = (int)(f48 * 262144.0f);
                int n20 = (int)(f49 * 262144.0f);
                int n21 = (int)(f50 * 262144.0f);
                int n22 = (int)(f51 * 262144.0f);
                int n23 = 0;
                int n24 = 0;
                int n25 = 0;
                int n26 = n & 1;
                int n27 = 1 - n26 << 17;
                int n28 = n26 << 17;
                do {
                    n9 = n12 + 1;
                    if ((n12 += n14) > n13) {
                        n14 -= n12 - n13;
                        n12 = n13;
                        if (n14 != 0) {
                            f39 = (float)n14 * f33;
                            f40 = (float)n14 * f32;
                            f45 = (float)n14 * f31;
                            f46 = (float)n14 * f30;
                            f41 = (float)n14 * f29;
                            f42 = (float)n14 * f28;
                            f43 = (float)n14 * f27;
                            f44 = (float)n14 * f26;
                            f36 = f37 = multiLU[n14];
                            f38 = Config.zTrick ? multiZTLU[n14] : multiZLU[n14];
                        } else {
                            f39 = 0.0f;
                            f40 = 0.0f;
                            f45 = 0.0f;
                            f46 = 0.0f;
                            f41 = 0.0f;
                            f42 = 0.0f;
                            f43 = 0.0f;
                            f44 = 0.0f;
                            n14 = 1;
                            f37 = 262144.0f;
                            f36 = 262144.0f;
                            f38 = Config.zTrick ? 2.1474836E9f : 4.2949673E9f;
                        }
                    }
                    if (n12 == n13 && f8 < f16 - 1.0f) {
                        f39 = f10 - f9;
                        f40 = f12 - f11;
                        f41 = f14 - f13;
                        f45 = f18 - f17;
                        f46 = f20 - f19;
                    }
                    float f55 = f13;
                    f9 += f39;
                    f11 += f40;
                    f17 += f45;
                    f19 += f46;
                    f += f42;
                    f3 += f43;
                    f5 += f44;
                    f47 = 1.0f / (f13 += f41);
                    float f56 = f9 * f47;
                    float f57 = f11 * f47;
                    float f58 = f17 * f47;
                    float f59 = f19 * f47;
                    float f60 = f * f47;
                    float f61 = f3 * f47;
                    float f62 = f5 * f47;
                    int n29 = texture.width - 1 << 18;
                    int n30 = texture.height - 1 << 18;
                    int n31 = texture2.width - 1 << 18;
                    int n32 = texture2.height - 1 << 18;
                    int n33 = (int)(f38 * (f13 - f55));
                    if (bl2) {
                        n33 = -n33;
                    }
                    int n34 = (int)(f36 * (f56 - f48));
                    int n35 = (int)(f36 * (f57 - f49));
                    int n36 = (int)(f36 * (f58 - f50));
                    int n37 = (int)(f36 * (f59 - f51));
                    n23 = (int)(f37 * (f60 - f52));
                    n24 = (int)(f37 * (f61 - f53));
                    n25 = (int)(f37 * (f62 - f54));
                    if (Config.spanBasedHsr && (n5 <= n9 && n6 >= n12 && f24 >= f55 && f24 >= f13 || n7 <= n9 && n8 >= n12 && f25 >= f55 && f25 >= f13)) {
                        if (n12 != n13) {
                            n18 += n14 * n33;
                            n19 += n14 * n34;
                            n20 += n14 * n35;
                            n21 += n14 * n36;
                            n22 += n14 * n37;
                            n15 += n14 * n23;
                            n16 += n14 * n24;
                            n17 += n14 * n25;
                        }
                    } else {
                        int n38;
                        int n39;
                        int n40;
                        int n41;
                        int n42;
                        int n43;
                        int n44;
                        int n45;
                        int n46 = n12 + n10;
                        int n47 = 0;
                        int n48 = 0;
                        int n49 = 0;
                        int n50 = 0;
                        if (Config.texelFilter) {
                            if (!bl && n34 < 196608 && n34 > -196608 && n35 <= 196608 && n35 >= -196608) {
                                bl = true;
                            }
                            if (!bl && n36 < 196608 && n36 > -196608 && n37 <= 196608 && n37 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n51 = (n9 & 1) != 0 ? 65536 + n27 : n28;
                            if (Config.optiZ && (n3 > n12 || n4 < n9 || f55 >= f23 && f13 >= f23)) {
                                for (n45 = n9 + n10; n45 <= n46; ++n45) {
                                    n44 = ((n21 + n51 & n31) >> 18) + ((n22 + (n51 ^ 0x10000) & n32) >> 18 << by2);
                                    n43 = nArray2[n44];
                                    n42 = nArray3[n44];
                                    n41 = ((n19 + n51 & n29) >> 18) - 128 + (n43 >> 8) + (((n20 + (n51 ^ 0x10000) & n30) >> 18) - 128 + (n43 & 0xFF) << by);
                                    n51 ^= 0x30000;
                                    if (n41 < 0) {
                                        n41 = 0;
                                    } else if (n41 >= texture.intSize) {
                                        n41 = texture.intSize - 1;
                                    }
                                    n47 = nArray[n41];
                                    n40 = n42 >> 16;
                                    n39 = n42 >> 8 & 0xFF;
                                    n38 = n42 & 0xFF;
                                    n50 = (n40 * (n15 >> 10) >> 16) + (n47 >> 16) >> 1;
                                    n49 = (n39 * (n16 >> 10) >> 16) + (n47 >> 8 & 0xFF) >> 1;
                                    n48 = (n38 * (n17 >> 10) >> 16) + (n47 & 0xFF) >> 1;
                                    if ((n50 & 0xFFFFFF00) != 0) {
                                        n50 = 255 >> (n50 >> 28 & 8);
                                    }
                                    if ((n49 & 0xFFFFFF00) != 0) {
                                        n49 = 255 >> (n49 >> 28 & 8);
                                    }
                                    if ((n48 & 0xFFFFFF00) != 0) {
                                        n48 = 255 >> (n48 >> 28 & 8);
                                    }
                                    nArray4[n45] = n48 | n49 << 8 | n50 << 16 | 0xFF000000;
                                    nArray5[n45] = n18;
                                    n19 += n34;
                                    n20 += n35;
                                    n21 += n36;
                                    n22 += n37;
                                    n15 += n23;
                                    n16 += n24;
                                    n17 += n25;
                                    n18 += n33;
                                }
                            } else if (!bl2) {
                                for (n45 = n9 + n10; n45 <= n46; ++n45) {
                                    if (nArray5[n45] < n18) {
                                        n44 = ((n21 + n51 & n31) >> 18) + ((n22 + (n51 ^ 0x10000) & n32) >> 18 << by2);
                                        n43 = nArray2[n44];
                                        n42 = nArray3[n44];
                                        n41 = ((n19 + n51 & n29) >> 18) - 128 + (n43 >> 8) + (((n20 + (n51 ^ 0x10000) & n30) >> 18) - 128 + (n43 & 0xFF) << by);
                                        n51 ^= 0x30000;
                                        if (n41 < 0) {
                                            n41 = 0;
                                        } else if (n41 >= texture.intSize) {
                                            n41 = texture.intSize - 1;
                                        }
                                        n47 = nArray[n41];
                                        n40 = n42 >> 16;
                                        n39 = n42 >> 8 & 0xFF;
                                        n38 = n42 & 0xFF;
                                        n50 = (n40 * (n15 >> 10) >> 16) + (n47 >> 16) >> 1;
                                        n49 = (n39 * (n16 >> 10) >> 16) + (n47 >> 8 & 0xFF) >> 1;
                                        n48 = (n38 * (n17 >> 10) >> 16) + (n47 & 0xFF) >> 1;
                                        if ((n50 & 0xFFFFFF00) != 0) {
                                            n50 = 255 >> (n50 >> 28 & 8);
                                        }
                                        if ((n49 & 0xFFFFFF00) != 0) {
                                            n49 = 255 >> (n49 >> 28 & 8);
                                        }
                                        if ((n48 & 0xFFFFFF00) != 0) {
                                            n48 = 255 >> (n48 >> 28 & 8);
                                        }
                                        nArray4[n45] = n48 | n49 << 8 | n50 << 16 | 0xFF000000;
                                        nArray5[n45] = n18;
                                    }
                                    n19 += n34;
                                    n20 += n35;
                                    n21 += n36;
                                    n22 += n37;
                                    n15 += n23;
                                    n16 += n24;
                                    n17 += n25;
                                    n18 += n33;
                                }
                            } else {
                                for (n45 = n9 + n10; n45 <= n46; ++n45) {
                                    if (nArray5[n45] > n18) {
                                        n44 = ((n21 + n51 & n31) >> 18) + ((n22 + (n51 ^ 0x10000) & n32) >> 18 << by2);
                                        n43 = nArray2[n44];
                                        n42 = nArray3[n44];
                                        n41 = ((n19 + n51 & n29) >> 18) - 128 + (n43 >> 8) + (((n20 + (n51 ^ 0x10000) & n30) >> 18) - 128 + (n43 & 0xFF) << by);
                                        n51 ^= 0x30000;
                                        if (n41 < 0) {
                                            n41 = 0;
                                        } else if (n41 >= texture.intSize) {
                                            n41 = texture.intSize - 1;
                                        }
                                        n47 = nArray[n41];
                                        n40 = n42 >> 16;
                                        n39 = n42 >> 8 & 0xFF;
                                        n38 = n42 & 0xFF;
                                        n50 = (n40 * (n15 >> 10) >> 16) + (n47 >> 16) >> 1;
                                        n49 = (n39 * (n16 >> 10) >> 16) + (n47 >> 8 & 0xFF) >> 1;
                                        n48 = (n38 * (n17 >> 10) >> 16) + (n47 & 0xFF) >> 1;
                                        if ((n50 & 0xFFFFFF00) != 0) {
                                            n50 = 255 >> (n50 >> 28 & 8);
                                        }
                                        if ((n49 & 0xFFFFFF00) != 0) {
                                            n49 = 255 >> (n49 >> 28 & 8);
                                        }
                                        if ((n48 & 0xFFFFFF00) != 0) {
                                            n48 = 255 >> (n48 >> 28 & 8);
                                        }
                                        nArray4[n45] = n48 | n49 << 8 | n50 << 16 | 0xFF000000;
                                        nArray5[n45] = n18;
                                    }
                                    n19 += n34;
                                    n20 += n35;
                                    n21 += n36;
                                    n22 += n37;
                                    n15 += n23;
                                    n16 += n24;
                                    n17 += n25;
                                    n18 += n33;
                                }
                            }
                        } else if (Config.optiZ && (n3 > n12 || n4 < n9 || f55 >= f23 && f13 >= f23)) {
                            for (n45 = n9 + n10; n45 <= n46; ++n45) {
                                n44 = ((n21 & n31) >> 18) + ((n22 & n32) >> 18 << by2);
                                n43 = nArray2[n44];
                                n42 = nArray3[n44];
                                n41 = ((n19 & n29) >> 18) - 128 + (n43 >> 8) + (((n20 & n30) >> 18) - 128 + (n43 & 0xFF) << by);
                                if (n41 >= texture.intSize) {
                                    n41 = texture.intSize - 1;
                                } else if (n41 < 0) {
                                    n41 = 0;
                                }
                                n47 = nArray[n41];
                                n40 = n42 >> 16;
                                n39 = n42 >> 8 & 0xFF;
                                n38 = n42 & 0xFF;
                                n50 = (n40 * (n15 >> 10) >> 16) + (n47 >> 16) >> 1;
                                n49 = (n39 * (n16 >> 10) >> 16) + (n47 >> 8 & 0xFF) >> 1;
                                n48 = (n38 * (n17 >> 10) >> 16) + (n47 & 0xFF) >> 1;
                                if ((n50 & 0xFFFFFF00) != 0) {
                                    n50 = 255 >> (byte)(n50 >> 28 & 8);
                                }
                                if ((n49 & 0xFFFFFF00) != 0) {
                                    n49 = 255 >> (byte)(n49 >> 28 & 8);
                                }
                                if ((n48 & 0xFFFFFF00) != 0) {
                                    n48 = 255 >> (byte)(n48 >> 28 & 8);
                                }
                                nArray4[n45] = n48 | n49 << 8 | n50 << 16 | 0xFF000000;
                                nArray5[n45] = n18;
                                n19 += n34;
                                n20 += n35;
                                n21 += n36;
                                n22 += n37;
                                n15 += n23;
                                n16 += n24;
                                n17 += n25;
                                n18 += n33;
                            }
                        } else if (!bl2) {
                            for (n45 = n9 + n10; n45 <= n46; ++n45) {
                                if (nArray5[n45] < n18) {
                                    n44 = ((n21 & n31) >> 18) + ((n22 & n32) >> 18 << by2);
                                    n43 = nArray2[n44];
                                    n42 = nArray3[n44];
                                    n41 = ((n19 & n29) >> 18) - 128 + (n43 >> 8) + (((n20 & n30) >> 18) - 128 + (n43 & 0xFF) << by);
                                    if (n41 >= texture.intSize) {
                                        n41 = texture.intSize - 1;
                                    } else if (n41 < 0) {
                                        n41 = 0;
                                    }
                                    n47 = nArray[n41];
                                    n40 = n42 >> 16;
                                    n39 = n42 >> 8 & 0xFF;
                                    n38 = n42 & 0xFF;
                                    n50 = (n40 * (n15 >> 10) >> 16) + (n47 >> 16) >> 1;
                                    n49 = (n39 * (n16 >> 10) >> 16) + (n47 >> 8 & 0xFF) >> 1;
                                    n48 = (n38 * (n17 >> 10) >> 16) + (n47 & 0xFF) >> 1;
                                    if ((n50 & 0xFFFFFF00) != 0) {
                                        n50 = 255 >> (byte)(n50 >> 28 & 8);
                                    }
                                    if ((n49 & 0xFFFFFF00) != 0) {
                                        n49 = 255 >> (byte)(n49 >> 28 & 8);
                                    }
                                    if ((n48 & 0xFFFFFF00) != 0) {
                                        n48 = 255 >> (byte)(n48 >> 28 & 8);
                                    }
                                    nArray4[n45] = n48 | n49 << 8 | n50 << 16 | 0xFF000000;
                                    nArray5[n45] = n18;
                                }
                                n19 += n34;
                                n20 += n35;
                                n21 += n36;
                                n22 += n37;
                                n15 += n23;
                                n16 += n24;
                                n17 += n25;
                                n18 += n33;
                            }
                        } else {
                            for (n45 = n9 + n10; n45 <= n46; ++n45) {
                                if (nArray5[n45] > n18) {
                                    n44 = ((n21 & n31) >> 18) + ((n22 & n32) >> 18 << by2);
                                    n43 = nArray2[n44];
                                    n42 = nArray3[n44];
                                    n41 = ((n19 & n29) >> 18) - 128 + (n43 >> 8) + (((n20 & n30) >> 18) - 128 + (n43 & 0xFF) << by);
                                    if (n41 >= texture.intSize) {
                                        n41 = texture.intSize - 1;
                                    } else if (n41 < 0) {
                                        n41 = 0;
                                    }
                                    n47 = nArray[n41];
                                    n40 = n42 >> 16;
                                    n39 = n42 >> 8 & 0xFF;
                                    n38 = n42 & 0xFF;
                                    n50 = (n40 * (n15 >> 10) >> 16) + (n47 >> 16) >> 1;
                                    n49 = (n39 * (n16 >> 10) >> 16) + (n47 >> 8 & 0xFF) >> 1;
                                    n48 = (n38 * (n17 >> 10) >> 16) + (n47 & 0xFF) >> 1;
                                    if ((n50 & 0xFFFFFF00) != 0) {
                                        n50 = 255 >> (byte)(n50 >> 28 & 8);
                                    }
                                    if ((n49 & 0xFFFFFF00) != 0) {
                                        n49 = 255 >> (byte)(n49 >> 28 & 8);
                                    }
                                    if ((n48 & 0xFFFFFF00) != 0) {
                                        n48 = 255 >> (byte)(n48 >> 28 & 8);
                                    }
                                    nArray4[n45] = n48 | n49 << 8 | n50 << 16 | 0xFF000000;
                                    nArray5[n45] = n18;
                                }
                                n19 += n34;
                                n20 += n35;
                                n21 += n36;
                                n22 += n37;
                                n15 += n23;
                                n16 += n24;
                                n17 += n25;
                                n18 += n33;
                            }
                        }
                    }
                    f48 = f56;
                    f49 = f57;
                    f50 = f58;
                    f51 = f59;
                    f52 = f60;
                    f53 = f61;
                    f54 = f62;
                } while (n12 < n13);
                boolean bl3 = false;
                if (n11 < n5 && n13 >= n5 || n5 == 99999999) {
                    frameBuffer.exXstart[n] = n11;
                    if (f24 > f34) {
                        frameBuffer.exZlow[n] = f34;
                    }
                    if (frameBuffer.exZlow[n] > f14) {
                        frameBuffer.exZlow[n] = f14;
                    }
                    bl3 = true;
                }
                if (n13 > n6 && f7 <= (float)n6 || n6 == -1) {
                    frameBuffer.exXend[n] = n13;
                    if (frameBuffer.exZlow[n] > f14) {
                        frameBuffer.exZlow[n] = f14;
                    }
                    if (frameBuffer.exZlow[n] > f34) {
                        frameBuffer.exZlow[n] = f34;
                    }
                    bl3 = true;
                }
                if (!bl3) {
                    if (n11 < n7 && n13 >= n7 || n7 == 99999999) {
                        frameBuffer.exXstart2[n] = n11;
                        if (f25 > f34) {
                            frameBuffer.exZlow2[n] = f34;
                        }
                        if (frameBuffer.exZlow2[n] > f14) {
                            frameBuffer.exZlow2[n] = f14;
                        }
                    }
                    if (n13 > n8 && f7 <= (float)n8 || n8 == -1) {
                        frameBuffer.exXend2[n] = n13;
                        if (frameBuffer.exZlow2[n] > f14) {
                            frameBuffer.exZlow2[n] = f14;
                        }
                        if (frameBuffer.exZlow2[n] > f34) {
                            frameBuffer.exZlow2[n] = f34;
                        }
                        bl3 = true;
                    }
                }
                if (f7 < (float)n3) {
                    frameBuffer.xstart[n] = n11;
                }
                if (n13 > n4) {
                    frameBuffer.xend[n] = n13;
                }
                if (f14 < f34) {
                    f14 = f34;
                }
                if (f14 > f23) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    private final void drawShadedZbufferedFilteredBumpmappedBlendedAlphaScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl, float f17, float f18, float f19, float f20, Texture texture2, Texture texture3, int n2, boolean bl2, int n3) {
        float f21;
        if (n3 != 1) {
            float f22 = n3;
            f *= f22;
            f2 *= f22;
            f3 *= f22;
            f4 *= f22;
            f5 *= f22;
            f6 *= f22;
        }
        int[] nArray = texture3.alpha;
        int[] nArray2 = texture.texels;
        int[] nArray3 = texture2.texels;
        int[] nArray4 = texture3.texels;
        int[] nArray5 = frameBuffer.pixels;
        int[] nArray6 = frameBuffer.zbuffer;
        int n4 = frameBuffer.xstart[n];
        int n5 = frameBuffer.xend[n];
        float f23 = frameBuffer.zhigh[n];
        int n6 = frameBuffer.exXstart[n];
        int n7 = frameBuffer.exXend[n];
        float f24 = frameBuffer.exZlow[n];
        int n8 = frameBuffer.exXstart2[n];
        int n9 = frameBuffer.exXend2[n];
        float f25 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f21 = f7;
            f7 = f8;
            f8 = f21;
            f21 = f9;
            f9 = f10;
            f10 = f21;
            f21 = f11;
            f11 = f12;
            f12 = f21;
            f21 = f13;
            f13 = f14;
            f14 = f21;
            f21 = f17;
            f17 = f18;
            f18 = f21;
            f21 = f19;
            f19 = f20;
            f20 = f21;
            f21 = f;
            f = f2;
            f2 = f21;
            f21 = f3;
            f3 = f4;
            f4 = f21;
            f21 = f5;
            f5 = f6;
            f6 = f21;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n7 <= n9) {
                if (n7 >= n8) {
                    n7 = n9;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n8 < n6) {
                        n6 = n8;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f25 < f24) {
                        f24 = f25;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n8 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n9 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f25 = 2.1474836E9f;
                }
            } else if (n9 >= n6) {
                if (n8 < n6) {
                    n6 = n8;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f25 < f24) {
                        f24 = f25;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n8 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n9 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f25 = 2.1474836E9f;
            }
            if (!(Config.spanBasedHsr && (float)n6 <= f7 && (float)n7 >= f8 && f24 >= f13 && f24 >= f14 || (float)n8 <= f7 && (float)n9 >= f8 && f25 >= f13 && f25 >= f14)) {
                int n10;
                float f26;
                float f27;
                float f28;
                float f29;
                float f30;
                float f31;
                float f32;
                float f33;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f21 = f8 - f7;
                float f34 = f13;
                if (f21 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f21 != 0.0f) {
                    float f35 = 1.0f / f21;
                    f33 = (f10 - f9) * f35;
                    f32 = (f12 - f11) * f35;
                    f31 = (f18 - f17) * f35;
                    f30 = (f20 - f19) * f35;
                    f29 = (f14 - f13) * f35;
                    f28 = (f2 - f) * f35;
                    f27 = (f4 - f3) * f35;
                    f26 = (f6 - f5) * f35;
                } else {
                    f33 = 0.0f;
                    f32 = 0.0f;
                    f29 = 0.0f;
                    f26 = 0.0f;
                    f28 = 0.0f;
                    f27 = 0.0f;
                    f31 = 0.0f;
                    f30 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f28;
                    f3 += f7 * f27;
                    f5 += f7 * f26;
                    f9 += f7 * f33;
                    f11 += f7 * f32;
                    f17 += f7 * f31;
                    f19 += f7 * f30;
                    f13 += f7 * f29;
                    f7 = f15;
                }
                int n11 = n * frameBuffer.width;
                int n12 = n10 = (int)f7;
                int n13 = n10 - 1;
                int n14 = (int)f8;
                int n15 = 16;
                float f36 = 16384.0f;
                float f37 = 16384.0f;
                float f38 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f39 = 16.0f * f33;
                float f40 = 16.0f * f32;
                float f41 = 16.0f * f29;
                float f42 = 16.0f * f28;
                float f43 = 16.0f * f27;
                float f44 = 16.0f * f26;
                float f45 = 16.0f * f31;
                float f46 = 16.0f * f30;
                float f47 = 1.0f / f13;
                float f48 = f9 * f47;
                float f49 = f11 * f47;
                float f50 = f17 * f47;
                float f51 = f19 * f47;
                float f52 = f * f47;
                float f53 = f3 * f47;
                float f54 = f5 * f47;
                byte by = texture.shifter;
                byte by2 = texture2.shifter;
                int n16 = (int)(f52 * 262144.0f);
                int n17 = (int)(f53 * 262144.0f);
                int n18 = (int)(f54 * 262144.0f);
                int n19 = 0;
                boolean bl3 = false;
                if (Config.zTrick) {
                    n19 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n19 = -n19;
                        bl3 = true;
                    }
                } else {
                    n19 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                int n20 = (int)(f48 * 262144.0f);
                int n21 = (int)(f49 * 262144.0f);
                int n22 = (int)(f50 * 262144.0f);
                int n23 = (int)(f51 * 262144.0f);
                int n24 = 0;
                int n25 = 0;
                int n26 = 0;
                int n27 = n & 1;
                int n28 = 1 - n27 << 17;
                int n29 = n27 << 17;
                do {
                    n10 = n13 + 1;
                    if ((n13 += n15) > n14) {
                        n15 -= n13 - n14;
                        n13 = n14;
                        if (n15 != 0) {
                            f39 = (float)n15 * f33;
                            f40 = (float)n15 * f32;
                            f45 = (float)n15 * f31;
                            f46 = (float)n15 * f30;
                            f41 = (float)n15 * f29;
                            f42 = (float)n15 * f28;
                            f43 = (float)n15 * f27;
                            f44 = (float)n15 * f26;
                            f36 = f37 = multiLU[n15];
                            f38 = Config.zTrick ? multiZTLU[n15] : multiZLU[n15];
                        } else {
                            f39 = 0.0f;
                            f40 = 0.0f;
                            f45 = 0.0f;
                            f46 = 0.0f;
                            f41 = 0.0f;
                            f42 = 0.0f;
                            f43 = 0.0f;
                            f44 = 0.0f;
                            n15 = 1;
                            f37 = 262144.0f;
                            f36 = 262144.0f;
                            f38 = Config.zTrick ? 2.1474836E9f : 4.2949673E9f;
                        }
                    }
                    if (n13 == n14 && f8 < f16 - 1.0f) {
                        f39 = f10 - f9;
                        f40 = f12 - f11;
                        f41 = f14 - f13;
                        f45 = f18 - f17;
                        f46 = f20 - f19;
                    }
                    float f55 = f13;
                    f9 += f39;
                    f11 += f40;
                    f17 += f45;
                    f19 += f46;
                    f += f42;
                    f3 += f43;
                    f5 += f44;
                    f47 = 1.0f / (f13 += f41);
                    float f56 = f9 * f47;
                    float f57 = f11 * f47;
                    float f58 = f17 * f47;
                    float f59 = f19 * f47;
                    float f60 = f * f47;
                    float f61 = f3 * f47;
                    float f62 = f5 * f47;
                    int n30 = texture.width - 1 << 18;
                    int n31 = texture.height - 1 << 18;
                    int n32 = texture2.width - 1 << 18;
                    int n33 = texture2.height - 1 << 18;
                    int n34 = (int)(f38 * (f13 - f55));
                    if (bl3) {
                        n34 = -n34;
                    }
                    int n35 = (int)(f36 * (f56 - f48));
                    int n36 = (int)(f36 * (f57 - f49));
                    int n37 = (int)(f36 * (f58 - f50));
                    int n38 = (int)(f36 * (f59 - f51));
                    n24 = (int)(f37 * (f60 - f52));
                    n25 = (int)(f37 * (f61 - f53));
                    n26 = (int)(f37 * (f62 - f54));
                    if (Config.spanBasedHsr && (n6 <= n10 && n7 >= n13 && f24 >= f55 && f24 >= f13 || n8 <= n10 && n9 >= n13 && f25 >= f55 && f25 >= f13)) {
                        if (n13 != n14) {
                            n19 += n15 * n34;
                            n20 += n15 * n35;
                            n21 += n15 * n36;
                            n22 += n15 * n37;
                            n23 += n15 * n38;
                            n16 += n15 * n24;
                            n17 += n15 * n25;
                            n18 += n15 * n26;
                        }
                    } else {
                        int n39;
                        int n40;
                        int n41;
                        int n42;
                        int n43;
                        int n44;
                        int n45;
                        int n46;
                        int n47;
                        int n48;
                        int n49;
                        int n50 = n13 + n11;
                        int n51 = 0;
                        int n52 = 0;
                        int n53 = 0;
                        int n54 = 0;
                        if (Config.texelFilter) {
                            if (!bl && n35 < 196608 && n35 > -196608 && n36 <= 196608 && n36 >= -196608) {
                                bl = true;
                            }
                            if (!bl && n37 < 196608 && n37 > -196608 && n38 <= 196608 && n38 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n55 = (n10 & 1) != 0 ? 65536 + n28 : n29;
                            if (!bl3) {
                                for (n49 = n10 + n11; n49 <= n50; ++n49) {
                                    if (nArray6[n49] < n19) {
                                        n48 = ((n22 + n55 & n32) >> 18) + ((n23 + (n55 ^ 0x10000) & n33) >> 18 << by2);
                                        n47 = nArray3[n48];
                                        n46 = nArray4[n48];
                                        n45 = ((n20 + n55 & n30) >> 18) - 128 + (n47 >> 8) + (((n21 + (n55 ^ 0x10000) & n31) >> 18) - 128 + (n47 & 0xFF) << by);
                                        n55 ^= 0x30000;
                                        if (n45 < 0) {
                                            n45 = 0;
                                        } else if (n45 >= texture.intSize) {
                                            n45 = texture.intSize - 1;
                                        }
                                        n51 = nArray2[n45];
                                        if (bl2) {
                                            n44 = nArray[n48] >>> 24;
                                            if (n44 != 0) {
                                                n43 = nArray5[n49];
                                                n42 = n46 >> 16;
                                                n41 = n46 >> 8 & 0xFF;
                                                n40 = n46 & 0xFF;
                                                if ((n44 <<= n2) > 255) {
                                                    n44 = 255;
                                                }
                                                n39 = 255 - n44;
                                                n54 = ((n42 * (n16 >> 10) >> 16) + (n51 >> 16)) * n44 + n39 * (n43 >> 16 & 0xFF) >> 9;
                                                n53 = ((n41 * (n17 >> 10) >> 16) + (n51 >> 8 & 0xFF)) * n44 + n39 * (n43 >> 8 & 0xFF) >> 9;
                                                n52 = ((n40 * (n18 >> 10) >> 16) + (n51 & 0xFF)) * n44 + n39 * (n43 & 0xFF) >> 9;
                                                n44 = n44 * n44 + n39 * (n43 >>> 24 & 0xFF) >> 8;
                                                if ((n54 & 0xFFFFFF00) != 0) {
                                                    n54 = 255 >> (n54 >> 28 & 8);
                                                }
                                                if ((n53 & 0xFFFFFF00) != 0) {
                                                    n53 = 255 >> (n53 >> 28 & 8);
                                                }
                                                if ((n52 & 0xFFFFFF00) != 0) {
                                                    n52 = 255 >> (n52 >> 28 & 8);
                                                }
                                                nArray5[n49] = n52 | n53 << 8 | n54 << 16 | n44 << 24;
                                                nArray6[n49] = n19;
                                            }
                                        } else if ((n51 & 0xF0F0F0) != 0) {
                                            n44 = nArray5[n49];
                                            n43 = n46 >> 16;
                                            n42 = n46 >> 8 & 0xFF;
                                            n41 = n46 & 0xFF;
                                            n54 = ((n43 * (n16 >> 10) >> 16) + (n51 >> 16) >> 1) + ((n44 >> 16 & 0xFF) >> n2) >> 1;
                                            n53 = ((n42 * (n17 >> 10) >> 16) + (n51 >> 8 & 0xFF) >> 1) + ((n44 >> 8 & 0xFF) >> n2) >> 1;
                                            n52 = ((n41 * (n18 >> 10) >> 16) + (n51 & 0xFF) >> 1) + ((n44 & 0xFF) >> n2) >> 1;
                                            if ((n54 & 0xFFFFFF00) != 0) {
                                                n54 = 255 >> (n54 >> 28 & 8);
                                            }
                                            if ((n53 & 0xFFFFFF00) != 0) {
                                                n53 = 255 >> (n53 >> 28 & 8);
                                            }
                                            if ((n52 & 0xFFFFFF00) != 0) {
                                                n52 = 255 >> (n52 >> 28 & 8);
                                            }
                                            nArray5[n49] = n52 | n53 << 8 | n54 << 16 | 0xFF000000;
                                            nArray6[n49] = n19;
                                        }
                                    }
                                    n20 += n35;
                                    n21 += n36;
                                    n22 += n37;
                                    n23 += n38;
                                    n16 += n24;
                                    n17 += n25;
                                    n18 += n26;
                                    n19 += n34;
                                }
                            } else {
                                for (n49 = n10 + n11; n49 <= n50; ++n49) {
                                    if (nArray6[n49] > n19) {
                                        n48 = ((n22 + n55 & n32) >> 18) + ((n23 + (n55 ^ 0x10000) & n33) >> 18 << by2);
                                        n47 = nArray3[n48];
                                        n46 = nArray4[n48];
                                        n45 = ((n20 + n55 & n30) >> 18) - 128 + (n47 >> 8) + (((n21 + (n55 ^ 0x10000) & n31) >> 18) - 128 + (n47 & 0xFF) << by);
                                        n55 ^= 0x30000;
                                        if (n45 < 0) {
                                            n45 = 0;
                                        } else if (n45 >= texture.intSize) {
                                            n45 = texture.intSize - 1;
                                        }
                                        n51 = nArray2[n45];
                                        if (bl2) {
                                            n44 = nArray[n48] >>> 24;
                                            if (n44 != 0) {
                                                n43 = nArray5[n49];
                                                n42 = n46 >> 16;
                                                n41 = n46 >> 8 & 0xFF;
                                                n40 = n46 & 0xFF;
                                                if ((n44 <<= n2) > 255) {
                                                    n44 = 255;
                                                }
                                                n39 = 255 - n44;
                                                n54 = ((n42 * (n16 >> 10) >> 16) + (n51 >> 16)) * n44 + n39 * (n43 >> 16 & 0xFF) >> 9;
                                                n53 = ((n41 * (n17 >> 10) >> 16) + (n51 >> 8 & 0xFF)) * n44 + n39 * (n43 >> 8 & 0xFF) >> 9;
                                                n52 = ((n40 * (n18 >> 10) >> 16) + (n51 & 0xFF)) * n44 + n39 * (n43 & 0xFF) >> 9;
                                                n44 = n44 * n44 + n39 * (n43 >>> 24 & 0xFF) >> 8;
                                                if ((n54 & 0xFFFFFF00) != 0) {
                                                    n54 = 255 >> (n54 >> 28 & 8);
                                                }
                                                if ((n53 & 0xFFFFFF00) != 0) {
                                                    n53 = 255 >> (n53 >> 28 & 8);
                                                }
                                                if ((n52 & 0xFFFFFF00) != 0) {
                                                    n52 = 255 >> (n52 >> 28 & 8);
                                                }
                                                nArray5[n49] = n52 | n53 << 8 | n54 << 16 | n44 << 24;
                                                nArray6[n49] = n19;
                                            }
                                        } else if ((n51 & 0xF0F0F0) != 0) {
                                            n44 = nArray5[n49];
                                            n43 = n46 >> 16;
                                            n42 = n46 >> 8 & 0xFF;
                                            n41 = n46 & 0xFF;
                                            n54 = ((n43 * (n16 >> 10) >> 16) + (n51 >> 16) >> 1) + ((n44 >> 16 & 0xFF) >> n2) >> 1;
                                            n53 = ((n42 * (n17 >> 10) >> 16) + (n51 >> 8 & 0xFF) >> 1) + ((n44 >> 8 & 0xFF) >> n2) >> 1;
                                            n52 = ((n41 * (n18 >> 10) >> 16) + (n51 & 0xFF) >> 1) + ((n44 & 0xFF) >> n2) >> 1;
                                            if ((n54 & 0xFFFFFF00) != 0) {
                                                n54 = 255 >> (n54 >> 28 & 8);
                                            }
                                            if ((n53 & 0xFFFFFF00) != 0) {
                                                n53 = 255 >> (n53 >> 28 & 8);
                                            }
                                            if ((n52 & 0xFFFFFF00) != 0) {
                                                n52 = 255 >> (n52 >> 28 & 8);
                                            }
                                            nArray5[n49] = n52 | n53 << 8 | n54 << 16 | 0xFF000000;
                                            nArray6[n49] = n19;
                                        }
                                    }
                                    n20 += n35;
                                    n21 += n36;
                                    n22 += n37;
                                    n23 += n38;
                                    n16 += n24;
                                    n17 += n25;
                                    n18 += n26;
                                    n19 += n34;
                                }
                            }
                        } else if (!bl3) {
                            for (n49 = n10 + n11; n49 <= n50; ++n49) {
                                if (nArray6[n49] < n19) {
                                    n48 = ((n22 & n32) >> 18) + ((n23 & n33) >> 18 << by2);
                                    n47 = nArray3[n48];
                                    n46 = nArray4[n48];
                                    n45 = ((n20 & n30) >> 18) - 128 + (n47 >> 8) + (((n21 & n31) >> 18) - 128 + (n47 & 0xFF) << by);
                                    if (n45 >= texture.intSize) {
                                        n45 = texture.intSize - 1;
                                    } else if (n45 < 0) {
                                        n45 = 0;
                                    }
                                    n51 = nArray2[n45];
                                    if (bl2) {
                                        n44 = nArray[n48] >>> 24;
                                        if (n44 != 0) {
                                            n43 = nArray5[n49];
                                            n42 = n46 >> 16;
                                            n41 = n46 >> 8 & 0xFF;
                                            n40 = n46 & 0xFF;
                                            if ((n44 <<= n2) > 255) {
                                                n44 = 255;
                                            }
                                            n39 = 255 - n44;
                                            n54 = ((n42 * (n16 >> 10) >> 16) + (n51 >> 16)) * n44 + n39 * (n43 >> 16 & 0xFF) >> 9;
                                            n53 = ((n41 * (n17 >> 10) >> 16) + (n51 >> 8 & 0xFF)) * n44 + n39 * (n43 >> 8 & 0xFF) >> 9;
                                            n52 = ((n40 * (n18 >> 10) >> 16) + (n51 & 0xFF)) * n44 + n39 * (n43 & 0xFF) >> 9;
                                            n44 = n44 * n44 + n39 * (n43 >>> 24 & 0xFF) >> 8;
                                            if ((n54 & 0xFFFFFF00) != 0) {
                                                n54 = 255 >> (n54 >> 28 & 8);
                                            }
                                            if ((n53 & 0xFFFFFF00) != 0) {
                                                n53 = 255 >> (n53 >> 28 & 8);
                                            }
                                            if ((n52 & 0xFFFFFF00) != 0) {
                                                n52 = 255 >> (n52 >> 28 & 8);
                                            }
                                            nArray5[n49] = n52 | n53 << 8 | n54 << 16 | n44 << 24;
                                            nArray6[n49] = n19;
                                        }
                                    } else if ((n51 & 0xF0F0F0) != 0) {
                                        n44 = nArray5[n49];
                                        n43 = n46 >> 16;
                                        n42 = n46 >> 8 & 0xFF;
                                        n41 = n46 & 0xFF;
                                        n54 = ((n43 * (n16 >> 10) >> 16) + (n51 >> 16) >> 1) + ((n44 >> 16 & 0xFF) >> n2) >> 1;
                                        n53 = ((n42 * (n17 >> 10) >> 16) + (n51 >> 8 & 0xFF) >> 1) + ((n44 >> 8 & 0xFF) >> n2) >> 1;
                                        n52 = ((n41 * (n18 >> 10) >> 16) + (n51 & 0xFF) >> 1) + ((n44 & 0xFF) >> n2) >> 1;
                                        if ((n54 & 0xFFFFFF00) != 0) {
                                            n54 = 255 >> (byte)(n54 >> 28 & 8);
                                        }
                                        if ((n53 & 0xFFFFFF00) != 0) {
                                            n53 = 255 >> (byte)(n53 >> 28 & 8);
                                        }
                                        if ((n52 & 0xFFFFFF00) != 0) {
                                            n52 = 255 >> (byte)(n52 >> 28 & 8);
                                        }
                                        nArray5[n49] = n52 | n53 << 8 | n54 << 16 | 0xFF000000;
                                        nArray6[n49] = n19;
                                    }
                                }
                                n20 += n35;
                                n21 += n36;
                                n22 += n37;
                                n23 += n38;
                                n16 += n24;
                                n17 += n25;
                                n18 += n26;
                                n19 += n34;
                            }
                        } else {
                            for (n49 = n10 + n11; n49 <= n50; ++n49) {
                                if (nArray6[n49] > n19) {
                                    n48 = ((n22 & n32) >> 18) + ((n23 & n33) >> 18 << by2);
                                    n47 = nArray3[n48];
                                    n46 = nArray4[n48];
                                    n45 = ((n20 & n30) >> 18) - 128 + (n47 >> 8) + (((n21 & n31) >> 18) - 128 + (n47 & 0xFF) << by);
                                    if (n45 >= texture.intSize) {
                                        n45 = texture.intSize - 1;
                                    } else if (n45 < 0) {
                                        n45 = 0;
                                    }
                                    n51 = nArray2[n45];
                                    if (bl2) {
                                        n44 = nArray[n48] >>> 24;
                                        if (n44 != 0) {
                                            n43 = nArray5[n49];
                                            n42 = n46 >> 16;
                                            n41 = n46 >> 8 & 0xFF;
                                            n40 = n46 & 0xFF;
                                            if ((n44 <<= n2) > 255) {
                                                n44 = 255;
                                            }
                                            n39 = 255 - n44;
                                            n54 = ((n42 * (n16 >> 10) >> 16) + (n51 >> 16)) * n44 + n39 * (n43 >> 16 & 0xFF) >> 9;
                                            n53 = ((n41 * (n17 >> 10) >> 16) + (n51 >> 8 & 0xFF)) * n44 + n39 * (n43 >> 8 & 0xFF) >> 9;
                                            n52 = ((n40 * (n18 >> 10) >> 16) + (n51 & 0xFF)) * n44 + n39 * (n43 & 0xFF) >> 9;
                                            n44 = n44 * n44 + n39 * (n43 >>> 24 & 0xFF) >> 8;
                                            if ((n54 & 0xFFFFFF00) != 0) {
                                                n54 = 255 >> (n54 >> 28 & 8);
                                            }
                                            if ((n53 & 0xFFFFFF00) != 0) {
                                                n53 = 255 >> (n53 >> 28 & 8);
                                            }
                                            if ((n52 & 0xFFFFFF00) != 0) {
                                                n52 = 255 >> (n52 >> 28 & 8);
                                            }
                                            nArray5[n49] = n52 | n53 << 8 | n54 << 16 | n44 << 24;
                                            nArray6[n49] = n19;
                                        }
                                    } else if ((n51 & 0xF0F0F0) != 0) {
                                        n44 = nArray5[n49];
                                        n43 = n46 >> 16;
                                        n42 = n46 >> 8 & 0xFF;
                                        n41 = n46 & 0xFF;
                                        n54 = ((n43 * (n16 >> 10) >> 16) + (n51 >> 16) >> 1) + ((n44 >> 16 & 0xFF) >> n2) >> 1;
                                        n53 = ((n42 * (n17 >> 10) >> 16) + (n51 >> 8 & 0xFF) >> 1) + ((n44 >> 8 & 0xFF) >> n2) >> 1;
                                        n52 = ((n41 * (n18 >> 10) >> 16) + (n51 & 0xFF) >> 1) + ((n44 & 0xFF) >> n2) >> 1;
                                        if ((n54 & 0xFFFFFF00) != 0) {
                                            n54 = 255 >> (byte)(n54 >> 28 & 8);
                                        }
                                        if ((n53 & 0xFFFFFF00) != 0) {
                                            n53 = 255 >> (byte)(n53 >> 28 & 8);
                                        }
                                        if ((n52 & 0xFFFFFF00) != 0) {
                                            n52 = 255 >> (byte)(n52 >> 28 & 8);
                                        }
                                        nArray5[n49] = n52 | n53 << 8 | n54 << 16 | 0xFF000000;
                                        nArray6[n49] = n19;
                                    }
                                }
                                n20 += n35;
                                n21 += n36;
                                n22 += n37;
                                n23 += n38;
                                n16 += n24;
                                n17 += n25;
                                n18 += n26;
                                n19 += n34;
                            }
                        }
                    }
                    f48 = f56;
                    f49 = f57;
                    f50 = f58;
                    f51 = f59;
                    f52 = f60;
                    f53 = f61;
                    f54 = f62;
                } while (n13 < n14);
                if (f7 < (float)n4) {
                    frameBuffer.xstart[n] = n12;
                }
                if (n14 > n5) {
                    frameBuffer.xend[n] = n14;
                }
                if (f14 < f34) {
                    f14 = f34;
                }
                if (f14 > f23) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    private final void drawShadedZbufferedFilteredBumpmappedBlendedAdditiveAlphaScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl, float f17, float f18, float f19, float f20, Texture texture2, Texture texture3, int n2, boolean bl2, int n3) {
        float f21;
        if (n3 != 1) {
            float f22 = n3;
            f *= f22;
            f2 *= f22;
            f3 *= f22;
            f4 *= f22;
            f5 *= f22;
            f6 *= f22;
        }
        int[] nArray = texture3.alpha;
        int[] nArray2 = texture.texels;
        int[] nArray3 = texture2.texels;
        int[] nArray4 = texture3.texels;
        int[] nArray5 = frameBuffer.pixels;
        int[] nArray6 = frameBuffer.zbuffer;
        int n4 = frameBuffer.xstart[n];
        int n5 = frameBuffer.xend[n];
        float f23 = frameBuffer.zhigh[n];
        int n6 = frameBuffer.exXstart[n];
        int n7 = frameBuffer.exXend[n];
        float f24 = frameBuffer.exZlow[n];
        int n8 = frameBuffer.exXstart2[n];
        int n9 = frameBuffer.exXend2[n];
        float f25 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f21 = f7;
            f7 = f8;
            f8 = f21;
            f21 = f9;
            f9 = f10;
            f10 = f21;
            f21 = f11;
            f11 = f12;
            f12 = f21;
            f21 = f13;
            f13 = f14;
            f14 = f21;
            f21 = f17;
            f17 = f18;
            f18 = f21;
            f21 = f19;
            f19 = f20;
            f20 = f21;
            f21 = f;
            f = f2;
            f2 = f21;
            f21 = f3;
            f3 = f4;
            f4 = f21;
            f21 = f5;
            f5 = f6;
            f6 = f21;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n7 <= n9) {
                if (n7 >= n8) {
                    n7 = n9;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n8 < n6) {
                        n6 = n8;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f25 < f24) {
                        f24 = f25;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n8 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n9 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f25 = 2.1474836E9f;
                }
            } else if (n9 >= n6) {
                if (n8 < n6) {
                    n6 = n8;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f25 < f24) {
                        f24 = f25;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n8 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n9 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f25 = 2.1474836E9f;
            }
            if (!(Config.spanBasedHsr && (float)n6 <= f7 && (float)n7 >= f8 && f24 >= f13 && f24 >= f14 || (float)n8 <= f7 && (float)n9 >= f8 && f25 >= f13 && f25 >= f14)) {
                int n10;
                float f26;
                float f27;
                float f28;
                float f29;
                float f30;
                float f31;
                float f32;
                float f33;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f21 = f8 - f7;
                float f34 = f13;
                if (f21 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f21 != 0.0f) {
                    float f35 = 1.0f / f21;
                    f33 = (f10 - f9) * f35;
                    f32 = (f12 - f11) * f35;
                    f31 = (f18 - f17) * f35;
                    f30 = (f20 - f19) * f35;
                    f29 = (f14 - f13) * f35;
                    f28 = (f2 - f) * f35;
                    f27 = (f4 - f3) * f35;
                    f26 = (f6 - f5) * f35;
                } else {
                    f33 = 0.0f;
                    f32 = 0.0f;
                    f29 = 0.0f;
                    f26 = 0.0f;
                    f28 = 0.0f;
                    f27 = 0.0f;
                    f31 = 0.0f;
                    f30 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f28;
                    f3 += f7 * f27;
                    f5 += f7 * f26;
                    f9 += f7 * f33;
                    f11 += f7 * f32;
                    f17 += f7 * f31;
                    f19 += f7 * f30;
                    f13 += f7 * f29;
                    f7 = f15;
                }
                int n11 = n * frameBuffer.width;
                int n12 = n10 = (int)f7;
                int n13 = n10 - 1;
                int n14 = (int)f8;
                int n15 = 16;
                float f36 = 16384.0f;
                float f37 = 16384.0f;
                float f38 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f39 = 16.0f * f33;
                float f40 = 16.0f * f32;
                float f41 = 16.0f * f29;
                float f42 = 16.0f * f28;
                float f43 = 16.0f * f27;
                float f44 = 16.0f * f26;
                float f45 = 16.0f * f31;
                float f46 = 16.0f * f30;
                float f47 = 1.0f / f13;
                float f48 = f9 * f47;
                float f49 = f11 * f47;
                float f50 = f17 * f47;
                float f51 = f19 * f47;
                float f52 = f * f47;
                float f53 = f3 * f47;
                float f54 = f5 * f47;
                byte by = texture.shifter;
                byte by2 = texture2.shifter;
                int n16 = (int)(f52 * 262144.0f);
                int n17 = (int)(f53 * 262144.0f);
                int n18 = (int)(f54 * 262144.0f);
                int n19 = 0;
                boolean bl3 = false;
                if (Config.zTrick) {
                    n19 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n19 = -n19;
                        bl3 = true;
                    }
                } else {
                    n19 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                int n20 = (int)(f48 * 262144.0f);
                int n21 = (int)(f49 * 262144.0f);
                int n22 = (int)(f50 * 262144.0f);
                int n23 = (int)(f51 * 262144.0f);
                int n24 = 0;
                int n25 = 0;
                int n26 = 0;
                int n27 = n & 1;
                int n28 = 1 - n27 << 17;
                int n29 = n27 << 17;
                do {
                    n10 = n13 + 1;
                    if ((n13 += n15) > n14) {
                        n15 -= n13 - n14;
                        n13 = n14;
                        if (n15 != 0) {
                            f39 = (float)n15 * f33;
                            f40 = (float)n15 * f32;
                            f45 = (float)n15 * f31;
                            f46 = (float)n15 * f30;
                            f41 = (float)n15 * f29;
                            f42 = (float)n15 * f28;
                            f43 = (float)n15 * f27;
                            f44 = (float)n15 * f26;
                            f36 = f37 = multiLU[n15];
                            f38 = Config.zTrick ? multiZTLU[n15] : multiZLU[n15];
                        } else {
                            f39 = 0.0f;
                            f40 = 0.0f;
                            f45 = 0.0f;
                            f46 = 0.0f;
                            f41 = 0.0f;
                            f42 = 0.0f;
                            f43 = 0.0f;
                            f44 = 0.0f;
                            n15 = 1;
                            f37 = 262144.0f;
                            f36 = 262144.0f;
                            f38 = Config.zTrick ? 2.1474836E9f : 4.2949673E9f;
                        }
                    }
                    if (n13 == n14 && f8 < f16 - 1.0f) {
                        f39 = f10 - f9;
                        f40 = f12 - f11;
                        f41 = f14 - f13;
                        f45 = f18 - f17;
                        f46 = f20 - f19;
                    }
                    float f55 = f13;
                    f9 += f39;
                    f11 += f40;
                    f17 += f45;
                    f19 += f46;
                    f += f42;
                    f3 += f43;
                    f5 += f44;
                    f47 = 1.0f / (f13 += f41);
                    float f56 = f9 * f47;
                    float f57 = f11 * f47;
                    float f58 = f17 * f47;
                    float f59 = f19 * f47;
                    float f60 = f * f47;
                    float f61 = f3 * f47;
                    float f62 = f5 * f47;
                    int n30 = texture.width - 1 << 18;
                    int n31 = texture.height - 1 << 18;
                    int n32 = texture2.width - 1 << 18;
                    int n33 = texture2.height - 1 << 18;
                    int n34 = (int)(f38 * (f13 - f55));
                    if (bl3) {
                        n34 = -n34;
                    }
                    int n35 = (int)(f36 * (f56 - f48));
                    int n36 = (int)(f36 * (f57 - f49));
                    int n37 = (int)(f36 * (f58 - f50));
                    int n38 = (int)(f36 * (f59 - f51));
                    n24 = (int)(f37 * (f60 - f52));
                    n25 = (int)(f37 * (f61 - f53));
                    n26 = (int)(f37 * (f62 - f54));
                    if (Config.spanBasedHsr && (n6 <= n10 && n7 >= n13 && f24 >= f55 && f24 >= f13 || n8 <= n10 && n9 >= n13 && f25 >= f55 && f25 >= f13)) {
                        if (n13 != n14) {
                            n19 += n15 * n34;
                            n20 += n15 * n35;
                            n21 += n15 * n36;
                            n22 += n15 * n37;
                            n23 += n15 * n38;
                            n16 += n15 * n24;
                            n17 += n15 * n25;
                            n18 += n15 * n26;
                        }
                    } else {
                        int n39;
                        int n40;
                        int n41;
                        int n42;
                        int n43;
                        int n44;
                        int n45;
                        int n46;
                        int n47;
                        int n48;
                        int n49 = n13 + n11;
                        int n50 = 0;
                        int n51 = 0;
                        int n52 = 0;
                        int n53 = 0;
                        if (Config.texelFilter) {
                            if (!bl && n35 < 196608 && n35 > -196608 && n36 <= 196608 && n36 >= -196608) {
                                bl = true;
                            }
                            if (!bl && n37 < 196608 && n37 > -196608 && n38 <= 196608 && n38 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n54 = (n10 & 1) != 0 ? 65536 + n28 : n29;
                            if (!bl3) {
                                for (n48 = n10 + n11; n48 <= n49; ++n48) {
                                    if (nArray6[n48] < n19) {
                                        n47 = ((n22 + n54 & n32) >> 18) + ((n23 + (n54 ^ 0x10000) & n33) >> 18 << by2);
                                        n46 = nArray3[n47];
                                        n45 = nArray4[n47];
                                        n44 = ((n20 + n54 & n30) >> 18) - 128 + (n46 >> 8) + (((n21 + (n54 ^ 0x10000) & n31) >> 18) - 128 + (n46 & 0xFF) << by);
                                        n54 ^= 0x30000;
                                        if (n44 < 0) {
                                            n44 = 0;
                                        } else if (n44 >= texture.intSize) {
                                            n44 = texture.intSize - 1;
                                        }
                                        n50 = nArray2[n44];
                                        if (bl2) {
                                            n43 = nArray[n47] >>> 24;
                                            if (n43 != 0) {
                                                n42 = nArray5[n48];
                                                n41 = n45 >> 16;
                                                n40 = n45 >> 8 & 0xFF;
                                                n39 = n45 & 0xFF;
                                                if ((n43 <<= n2) > 255) {
                                                    n43 = 255;
                                                }
                                                n53 = ((n41 * (n16 >> 10) >> 16) + (n50 >> 16)) * n43 >> 9;
                                                n52 = ((n40 * (n17 >> 10) >> 16) + (n50 >> 8 & 0xFF)) * n43 >> 9;
                                                n51 = ((n39 * (n18 >> 10) >> 16) + (n50 & 0xFF)) * n43 >> 9;
                                                if (n53 > 255) {
                                                    n53 = 255;
                                                }
                                                if (n52 > 255) {
                                                    n52 = 255;
                                                }
                                                if (n51 > 255) {
                                                    n51 = 255;
                                                }
                                                n52 += n42 >> 8 & 0xFF;
                                                n51 += n42 & 0xFF;
                                                n43 = n43 * n43 + (n42 >>> 24 & 0xFF) >> 8;
                                                if (((n53 += n42 >> 16 & 0xFF) & 0xFFFFFF00) != 0) {
                                                    n53 = 255 >> (n53 >> 28 & 8);
                                                }
                                                if ((n52 & 0xFFFFFF00) != 0) {
                                                    n52 = 255 >> (n52 >> 28 & 8);
                                                }
                                                if ((n51 & 0xFFFFFF00) != 0) {
                                                    n51 = 255 >> (n51 >> 28 & 8);
                                                }
                                                nArray5[n48] = n51 | n52 << 8 | n53 << 16 | n43 << 24;
                                                nArray6[n48] = n19;
                                            }
                                        } else if ((n50 & 0xF0F0F0) != 0) {
                                            n43 = nArray5[n48];
                                            n42 = n45 >> 16;
                                            n41 = n45 >> 8 & 0xFF;
                                            n40 = n45 & 0xFF;
                                            n53 = (n42 * (n16 >> 10) >> 16 << n2) + (n50 >> 16 << n2) >> 1;
                                            n52 = (n41 * (n17 >> 10) >> 16 << n2) + ((n50 >> 8 & 0xFF) << n2) >> 1;
                                            n51 = (n40 * (n18 >> 10) >> 16 << n2) + ((n50 & 0xFF) << n2) >> 1;
                                            if (n53 > 255) {
                                                n53 = 255;
                                            }
                                            if (n52 > 255) {
                                                n52 = 255;
                                            }
                                            if (n51 > 255) {
                                                n51 = 255;
                                            }
                                            n52 += n43 >> 8 & 0xFF;
                                            n51 += n43 & 0xFF;
                                            if (((n53 += n43 >> 16 & 0xFF) & 0xFFFFFF00) != 0) {
                                                n53 = 255 >> (n53 >> 28 & 8);
                                            }
                                            if ((n52 & 0xFFFFFF00) != 0) {
                                                n52 = 255 >> (n52 >> 28 & 8);
                                            }
                                            if ((n51 & 0xFFFFFF00) != 0) {
                                                n51 = 255 >> (n51 >> 28 & 8);
                                            }
                                            nArray5[n48] = n51 | n52 << 8 | n53 << 16 | 0xFF000000;
                                            nArray6[n48] = n19;
                                        }
                                    }
                                    n20 += n35;
                                    n21 += n36;
                                    n22 += n37;
                                    n23 += n38;
                                    n16 += n24;
                                    n17 += n25;
                                    n18 += n26;
                                    n19 += n34;
                                }
                            } else {
                                for (n48 = n10 + n11; n48 <= n49; ++n48) {
                                    if (nArray6[n48] > n19) {
                                        n47 = ((n22 + n54 & n32) >> 18) + ((n23 + (n54 ^ 0x10000) & n33) >> 18 << by2);
                                        n46 = nArray3[n47];
                                        n45 = nArray4[n47];
                                        n44 = ((n20 + n54 & n30) >> 18) - 128 + (n46 >> 8) + (((n21 + (n54 ^ 0x10000) & n31) >> 18) - 128 + (n46 & 0xFF) << by);
                                        n54 ^= 0x30000;
                                        if (n44 < 0) {
                                            n44 = 0;
                                        } else if (n44 >= texture.intSize) {
                                            n44 = texture.intSize - 1;
                                        }
                                        n50 = nArray2[n44];
                                        if (bl2) {
                                            n43 = nArray[n47] >>> 24;
                                            if (n43 != 0) {
                                                n42 = nArray5[n48];
                                                n41 = n45 >> 16;
                                                n40 = n45 >> 8 & 0xFF;
                                                n39 = n45 & 0xFF;
                                                if ((n43 <<= n2) > 255) {
                                                    n43 = 255;
                                                }
                                                n53 = ((n41 * (n16 >> 10) >> 16) + (n50 >> 16)) * n43 >> 9;
                                                n52 = ((n40 * (n17 >> 10) >> 16) + (n50 >> 8 & 0xFF)) * n43 >> 9;
                                                n51 = ((n39 * (n18 >> 10) >> 16) + (n50 & 0xFF)) * n43 >> 9;
                                                if (n53 > 255) {
                                                    n53 = 255;
                                                }
                                                if (n52 > 255) {
                                                    n52 = 255;
                                                }
                                                if (n51 > 255) {
                                                    n51 = 255;
                                                }
                                                n52 += n42 >> 8 & 0xFF;
                                                n51 += n42 & 0xFF;
                                                n43 = n43 * n43 + (n42 >>> 24 & 0xFF) >> 8;
                                                if (((n53 += n42 >> 16 & 0xFF) & 0xFFFFFF00) != 0) {
                                                    n53 = 255 >> (n53 >> 28 & 8);
                                                }
                                                if ((n52 & 0xFFFFFF00) != 0) {
                                                    n52 = 255 >> (n52 >> 28 & 8);
                                                }
                                                if ((n51 & 0xFFFFFF00) != 0) {
                                                    n51 = 255 >> (n51 >> 28 & 8);
                                                }
                                                nArray5[n48] = n51 | n52 << 8 | n53 << 16 | n43 << 24;
                                                nArray6[n48] = n19;
                                            }
                                        } else if ((n50 & 0xF0F0F0) != 0) {
                                            n43 = nArray5[n48];
                                            n42 = n45 >> 16;
                                            n41 = n45 >> 8 & 0xFF;
                                            n40 = n45 & 0xFF;
                                            n53 = (n42 * (n16 >> 10) >> 16 << n2) + (n50 >> 16 << n2) >> 1;
                                            n52 = (n41 * (n17 >> 10) >> 16 << n2) + ((n50 >> 8 & 0xFF) << n2) >> 1;
                                            n51 = (n40 * (n18 >> 10) >> 16 << n2) + ((n50 & 0xFF) << n2) >> 1;
                                            if (n53 > 255) {
                                                n53 = 255;
                                            }
                                            if (n52 > 255) {
                                                n52 = 255;
                                            }
                                            if (n51 > 255) {
                                                n51 = 255;
                                            }
                                            n52 += n43 >> 8 & 0xFF;
                                            n51 += n43 & 0xFF;
                                            if (((n53 += n43 >> 16 & 0xFF) & 0xFFFFFF00) != 0) {
                                                n53 = 255 >> (n53 >> 28 & 8);
                                            }
                                            if ((n52 & 0xFFFFFF00) != 0) {
                                                n52 = 255 >> (n52 >> 28 & 8);
                                            }
                                            if ((n51 & 0xFFFFFF00) != 0) {
                                                n51 = 255 >> (n51 >> 28 & 8);
                                            }
                                            nArray5[n48] = n51 | n52 << 8 | n53 << 16 | 0xFF000000;
                                            nArray6[n48] = n19;
                                        }
                                    }
                                    n20 += n35;
                                    n21 += n36;
                                    n22 += n37;
                                    n23 += n38;
                                    n16 += n24;
                                    n17 += n25;
                                    n18 += n26;
                                    n19 += n34;
                                }
                            }
                        } else if (!bl3) {
                            for (n48 = n10 + n11; n48 <= n49; ++n48) {
                                if (nArray6[n48] < n19) {
                                    n47 = ((n22 & n32) >> 18) + ((n23 & n33) >> 18 << by2);
                                    n46 = nArray3[n47];
                                    n45 = nArray4[n47];
                                    n44 = ((n20 & n30) >> 18) - 128 + (n46 >> 8) + (((n21 & n31) >> 18) - 128 + (n46 & 0xFF) << by);
                                    if (n44 >= texture.intSize) {
                                        n44 = texture.intSize - 1;
                                    } else if (n44 < 0) {
                                        n44 = 0;
                                    }
                                    n50 = nArray2[n44];
                                    if (bl2) {
                                        n43 = nArray[n47] >>> 24;
                                        if (n43 != 0) {
                                            n42 = nArray5[n48];
                                            n41 = n45 >> 16;
                                            n40 = n45 >> 8 & 0xFF;
                                            n39 = n45 & 0xFF;
                                            if ((n43 <<= n2) > 255) {
                                                n43 = 255;
                                            }
                                            n53 = ((n41 * (n16 >> 10) >> 16) + (n50 >> 16)) * n43 >> 9;
                                            n52 = ((n40 * (n17 >> 10) >> 16) + (n50 >> 8 & 0xFF)) * n43 >> 9;
                                            n51 = ((n39 * (n18 >> 10) >> 16) + (n50 & 0xFF)) * n43 >> 9;
                                            if (n53 > 255) {
                                                n53 = 255;
                                            }
                                            if (n52 > 255) {
                                                n52 = 255;
                                            }
                                            if (n51 > 255) {
                                                n51 = 255;
                                            }
                                            n52 += n42 >> 8 & 0xFF;
                                            n51 += n42 & 0xFF;
                                            n43 = n43 * n43 + (n42 >>> 24 & 0xFF) >> 8;
                                            if (((n53 += n42 >> 16 & 0xFF) & 0xFFFFFF00) != 0) {
                                                n53 = 255 >> (n53 >> 28 & 8);
                                            }
                                            if ((n52 & 0xFFFFFF00) != 0) {
                                                n52 = 255 >> (n52 >> 28 & 8);
                                            }
                                            if ((n51 & 0xFFFFFF00) != 0) {
                                                n51 = 255 >> (n51 >> 28 & 8);
                                            }
                                            nArray5[n48] = n51 | n52 << 8 | n53 << 16 | n43 << 24;
                                            nArray6[n48] = n19;
                                        }
                                    } else if ((n50 & 0xF0F0F0) != 0) {
                                        n43 = nArray5[n48];
                                        n42 = n45 >> 16;
                                        n41 = n45 >> 8 & 0xFF;
                                        n40 = n45 & 0xFF;
                                        n53 = (n42 * (n16 >> 10) >> 16 << n2) + (n50 >> 16 << n2) >> 1;
                                        n52 = (n41 * (n17 >> 10) >> 16 << n2) + ((n50 >> 8 & 0xFF) << n2) >> 1;
                                        n51 = (n40 * (n18 >> 10) >> 16 << n2) + ((n50 & 0xFF) << n2) >> 1;
                                        if (n53 > 255) {
                                            n53 = 255;
                                        }
                                        if (n52 > 255) {
                                            n52 = 255;
                                        }
                                        if (n51 > 255) {
                                            n51 = 255;
                                        }
                                        n52 += n43 >> 8 & 0xFF;
                                        n51 += n43 & 0xFF;
                                        if (((n53 += n43 >> 16 & 0xFF) & 0xFFFFFF00) != 0) {
                                            n53 = 255 >> (byte)(n53 >> 28 & 8);
                                        }
                                        if ((n52 & 0xFFFFFF00) != 0) {
                                            n52 = 255 >> (byte)(n52 >> 28 & 8);
                                        }
                                        if ((n51 & 0xFFFFFF00) != 0) {
                                            n51 = 255 >> (byte)(n51 >> 28 & 8);
                                        }
                                        nArray5[n48] = n51 | n52 << 8 | n53 << 16 | 0xFF000000;
                                        nArray6[n48] = n19;
                                    }
                                }
                                n20 += n35;
                                n21 += n36;
                                n22 += n37;
                                n23 += n38;
                                n16 += n24;
                                n17 += n25;
                                n18 += n26;
                                n19 += n34;
                            }
                        } else {
                            for (n48 = n10 + n11; n48 <= n49; ++n48) {
                                if (nArray6[n48] > n19) {
                                    n47 = ((n22 & n32) >> 18) + ((n23 & n33) >> 18 << by2);
                                    n46 = nArray3[n47];
                                    n45 = nArray4[n47];
                                    n44 = ((n20 & n30) >> 18) - 128 + (n46 >> 8) + (((n21 & n31) >> 18) - 128 + (n46 & 0xFF) << by);
                                    if (n44 >= texture.intSize) {
                                        n44 = texture.intSize - 1;
                                    } else if (n44 < 0) {
                                        n44 = 0;
                                    }
                                    n50 = nArray2[n44];
                                    if (bl2) {
                                        n43 = nArray[n47] >>> 24;
                                        if (n43 != 0) {
                                            n42 = nArray5[n48];
                                            n41 = n45 >> 16;
                                            n40 = n45 >> 8 & 0xFF;
                                            n39 = n45 & 0xFF;
                                            if ((n43 <<= n2) > 255) {
                                                n43 = 255;
                                            }
                                            n53 = ((n41 * (n16 >> 10) >> 16) + (n50 >> 16)) * n43 >> 9;
                                            n52 = ((n40 * (n17 >> 10) >> 16) + (n50 >> 8 & 0xFF)) * n43 >> 9;
                                            n51 = ((n39 * (n18 >> 10) >> 16) + (n50 & 0xFF)) * n43 >> 9;
                                            if (n53 > 255) {
                                                n53 = 255;
                                            }
                                            if (n52 > 255) {
                                                n52 = 255;
                                            }
                                            if (n51 > 255) {
                                                n51 = 255;
                                            }
                                            n52 += n42 >> 8 & 0xFF;
                                            n51 += n42 & 0xFF;
                                            n43 = n43 * n43 + (n42 >>> 24 & 0xFF) >> 8;
                                            if (((n53 += n42 >> 16 & 0xFF) & 0xFFFFFF00) != 0) {
                                                n53 = 255 >> (n53 >> 28 & 8);
                                            }
                                            if ((n52 & 0xFFFFFF00) != 0) {
                                                n52 = 255 >> (n52 >> 28 & 8);
                                            }
                                            if ((n51 & 0xFFFFFF00) != 0) {
                                                n51 = 255 >> (n51 >> 28 & 8);
                                            }
                                            nArray5[n48] = n51 | n52 << 8 | n53 << 16 | n43 << 24;
                                            nArray6[n48] = n19;
                                        }
                                    } else if ((n50 & 0xF0F0F0) != 0) {
                                        n43 = nArray5[n48];
                                        n42 = n45 >> 16;
                                        n41 = n45 >> 8 & 0xFF;
                                        n40 = n45 & 0xFF;
                                        n53 = (n42 * (n16 >> 10) >> 16 << n2) + (n50 >> 16 << n2) >> 1;
                                        n52 = (n41 * (n17 >> 10) >> 16 << n2) + ((n50 >> 8 & 0xFF) << n2) >> 1;
                                        n51 = (n40 * (n18 >> 10) >> 16 << n2) + ((n50 & 0xFF) << n2) >> 1;
                                        if (n53 > 255) {
                                            n53 = 255;
                                        }
                                        if (n52 > 255) {
                                            n52 = 255;
                                        }
                                        if (n51 > 255) {
                                            n51 = 255;
                                        }
                                        n52 += n43 >> 8 & 0xFF;
                                        n51 += n43 & 0xFF;
                                        if (((n53 += n43 >> 16 & 0xFF) & 0xFFFFFF00) != 0) {
                                            n53 = 255 >> (byte)(n53 >> 28 & 8);
                                        }
                                        if ((n52 & 0xFFFFFF00) != 0) {
                                            n52 = 255 >> (byte)(n52 >> 28 & 8);
                                        }
                                        if ((n51 & 0xFFFFFF00) != 0) {
                                            n51 = 255 >> (byte)(n51 >> 28 & 8);
                                        }
                                        nArray5[n48] = n51 | n52 << 8 | n53 << 16 | 0xFF000000;
                                        nArray6[n48] = n19;
                                    }
                                }
                                n20 += n35;
                                n21 += n36;
                                n22 += n37;
                                n23 += n38;
                                n16 += n24;
                                n17 += n25;
                                n18 += n26;
                                n19 += n34;
                            }
                        }
                    }
                    f48 = f56;
                    f49 = f57;
                    f50 = f58;
                    f51 = f59;
                    f52 = f60;
                    f53 = f61;
                    f54 = f62;
                } while (n13 < n14);
                if (f7 < (float)n4) {
                    frameBuffer.xstart[n] = n12;
                }
                if (n14 > n5) {
                    frameBuffer.xend[n] = n14;
                }
                if (f14 < f34) {
                    f14 = f34;
                }
                if (f14 > f23) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    private final void drawShadedZbufferedFilteredBumpmappedScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl, float f17, float f18, float f19, float f20, Texture texture2, int n2) {
        float f21;
        if (n2 != 1) {
            float f22 = n2;
            f *= f22;
            f2 *= f22;
            f3 *= f22;
            f4 *= f22;
            f5 *= f22;
            f6 *= f22;
        }
        int[] nArray = texture.texels;
        int[] nArray2 = texture2.texels;
        int[] nArray3 = frameBuffer.pixels;
        int[] nArray4 = frameBuffer.zbuffer;
        int n3 = frameBuffer.xstart[n];
        int n4 = frameBuffer.xend[n];
        float f23 = frameBuffer.zhigh[n];
        int n5 = frameBuffer.exXstart[n];
        int n6 = frameBuffer.exXend[n];
        float f24 = frameBuffer.exZlow[n];
        int n7 = frameBuffer.exXstart2[n];
        int n8 = frameBuffer.exXend2[n];
        float f25 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f21 = f7;
            f7 = f8;
            f8 = f21;
            f21 = f9;
            f9 = f10;
            f10 = f21;
            f21 = f11;
            f11 = f12;
            f12 = f21;
            f21 = f13;
            f13 = f14;
            f14 = f21;
            f21 = f17;
            f17 = f18;
            f18 = f21;
            f21 = f19;
            f19 = f20;
            f20 = f21;
            f21 = f;
            f = f2;
            f2 = f21;
            f21 = f3;
            f3 = f4;
            f4 = f21;
            f21 = f5;
            f5 = f6;
            f6 = f21;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n6 <= n8) {
                if (n6 >= n7) {
                    n6 = n8;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n7 < n5) {
                        n5 = n7;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f25 < f24) {
                        f24 = f25;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n7 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n8 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f25 = 2.1474836E9f;
                }
            } else if (n8 >= n5) {
                if (n7 < n5) {
                    n5 = n7;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f25 < f24) {
                        f24 = f25;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n7 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n8 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f25 = 2.1474836E9f;
            }
            if (!(Config.spanBasedHsr && (float)n5 <= f7 && (float)n6 >= f8 && f24 >= f13 && f24 >= f14 || (float)n7 <= f7 && (float)n8 >= f8 && f25 >= f13 && f25 >= f14)) {
                int n9;
                float f26;
                float f27;
                float f28;
                float f29;
                float f30;
                float f31;
                float f32;
                float f33;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f21 = f8 - f7;
                float f34 = f13;
                if (f21 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f21 != 0.0f) {
                    float f35 = 1.0f / f21;
                    f33 = (f10 - f9) * f35;
                    f32 = (f12 - f11) * f35;
                    f31 = (f18 - f17) * f35;
                    f30 = (f20 - f19) * f35;
                    f29 = (f14 - f13) * f35;
                    f28 = (f2 - f) * f35;
                    f27 = (f4 - f3) * f35;
                    f26 = (f6 - f5) * f35;
                } else {
                    f33 = 0.0f;
                    f32 = 0.0f;
                    f29 = 0.0f;
                    f26 = 0.0f;
                    f28 = 0.0f;
                    f27 = 0.0f;
                    f31 = 0.0f;
                    f30 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f28;
                    f3 += f7 * f27;
                    f5 += f7 * f26;
                    f9 += f7 * f33;
                    f11 += f7 * f32;
                    f17 += f7 * f31;
                    f19 += f7 * f30;
                    f13 += f7 * f29;
                    f7 = f15;
                }
                int n10 = n * frameBuffer.width;
                int n11 = n9 = (int)f7;
                int n12 = n9 - 1;
                int n13 = (int)f8;
                int n14 = 16;
                float f36 = 16384.0f;
                float f37 = 16384.0f;
                float f38 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f39 = 16.0f * f33;
                float f40 = 16.0f * f32;
                float f41 = 16.0f * f29;
                float f42 = 16.0f * f28;
                float f43 = 16.0f * f27;
                float f44 = 16.0f * f26;
                float f45 = 16.0f * f31;
                float f46 = 16.0f * f30;
                float f47 = 1.0f / f13;
                float f48 = f9 * f47;
                float f49 = f11 * f47;
                float f50 = f17 * f47;
                float f51 = f19 * f47;
                float f52 = f * f47;
                float f53 = f3 * f47;
                float f54 = f5 * f47;
                byte by = texture.shifter;
                byte by2 = texture2.shifter;
                int n15 = (int)(f52 * 262144.0f);
                int n16 = (int)(f53 * 262144.0f);
                int n17 = (int)(f54 * 262144.0f);
                int n18 = 0;
                boolean bl2 = false;
                if (Config.zTrick) {
                    n18 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n18 = -n18;
                        bl2 = true;
                    }
                } else {
                    n18 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                int n19 = (int)(f48 * 262144.0f);
                int n20 = (int)(f49 * 262144.0f);
                int n21 = (int)(f50 * 262144.0f);
                int n22 = (int)(f51 * 262144.0f);
                int n23 = 0;
                int n24 = 0;
                int n25 = 0;
                int n26 = n & 1;
                int n27 = 1 - n26 << 17;
                int n28 = n26 << 17;
                do {
                    n9 = n12 + 1;
                    if ((n12 += n14) > n13) {
                        n14 -= n12 - n13;
                        n12 = n13;
                        if (n14 != 0) {
                            f39 = (float)n14 * f33;
                            f40 = (float)n14 * f32;
                            f45 = (float)n14 * f31;
                            f46 = (float)n14 * f30;
                            f41 = (float)n14 * f29;
                            f42 = (float)n14 * f28;
                            f43 = (float)n14 * f27;
                            f44 = (float)n14 * f26;
                            f36 = f37 = multiLU[n14];
                            f38 = Config.zTrick ? multiZTLU[n14] : multiZLU[n14];
                        } else {
                            f39 = 0.0f;
                            f40 = 0.0f;
                            f45 = 0.0f;
                            f46 = 0.0f;
                            f41 = 0.0f;
                            f42 = 0.0f;
                            f43 = 0.0f;
                            f44 = 0.0f;
                            n14 = 1;
                            f37 = 262144.0f;
                            f36 = 262144.0f;
                            f38 = Config.zTrick ? 2.1474836E9f : 4.2949673E9f;
                        }
                    }
                    float f55 = f13;
                    if (n12 == n13 && f8 < f16 - 1.0f) {
                        f39 = f10 - f9;
                        f40 = f12 - f11;
                        f41 = f14 - f13;
                        f45 = f18 - f17;
                        f46 = f20 - f19;
                    }
                    f9 += f39;
                    f11 += f40;
                    f17 += f45;
                    f19 += f46;
                    f += f42;
                    f3 += f43;
                    f5 += f44;
                    f47 = 1.0f / (f13 += f41);
                    float f56 = f9 * f47;
                    float f57 = f11 * f47;
                    float f58 = f17 * f47;
                    float f59 = f19 * f47;
                    float f60 = f * f47;
                    float f61 = f3 * f47;
                    float f62 = f5 * f47;
                    int n29 = texture.width - 1 << 18;
                    int n30 = texture.height - 1 << 18;
                    int n31 = texture2.width - 1 << 18;
                    int n32 = texture2.height - 1 << 18;
                    int n33 = (int)(f38 * (f13 - f55));
                    if (bl2) {
                        n33 = -n33;
                    }
                    int n34 = (int)(f36 * (f56 - f48));
                    int n35 = (int)(f36 * (f57 - f49));
                    int n36 = (int)(f36 * (f58 - f50));
                    int n37 = (int)(f36 * (f59 - f51));
                    n23 = (int)(f37 * (f60 - f52));
                    n24 = (int)(f37 * (f61 - f53));
                    n25 = (int)(f37 * (f62 - f54));
                    if (Config.spanBasedHsr && (n5 <= n9 && n6 >= n12 && f24 >= f55 && f24 >= f13 || n7 <= n9 && n8 >= n12 && f25 >= f55 && f25 >= f13)) {
                        if (n12 != n13) {
                            n18 += n14 * n33;
                            n19 += n14 * n34;
                            n20 += n14 * n35;
                            n21 += n14 * n36;
                            n22 += n14 * n37;
                            n15 += n14 * n23;
                            n16 += n14 * n24;
                            n17 += n14 * n25;
                        }
                    } else {
                        int n38;
                        int n39;
                        int n40;
                        int n41 = n12 + n10;
                        int n42 = 0;
                        int n43 = 0;
                        int n44 = 0;
                        int n45 = 0;
                        if (Config.texelFilter) {
                            if (!bl && n34 < 196608 && n34 > -196608 && n35 <= 196608 && n35 >= -196608) {
                                bl = true;
                            }
                            if (!bl && n36 < 196608 && n36 > -196608 && n37 <= 196608 && n37 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n46 = (n9 & 1) != 0 ? 65536 + n27 : n28;
                            if (Config.optiZ && (n3 > n12 || n4 < n9 || f55 >= f23 && f13 >= f23)) {
                                for (n40 = n9 + n10; n40 <= n41; ++n40) {
                                    n39 = nArray2[((n21 + n46 & n31) >> 18) + ((n22 + (n46 ^ 0x10000) & n32) >> 18 << by2)];
                                    n38 = ((n19 + n46 & n29) >> 18) - 128 + (n39 >> 8) + (((n20 + (n46 ^ 0x10000) & n30) >> 18) - 128 + (n39 & 0xFF) << by);
                                    n46 ^= 0x30000;
                                    if (n38 < 0) {
                                        n38 = 0;
                                    } else if (n38 >= texture.intSize) {
                                        n38 = texture.intSize - 1;
                                    }
                                    n42 = nArray[n38];
                                    n45 = (n42 >> 16) * (n15 >> 10) >> 16;
                                    n44 = (n42 >> 8 & 0xFF) * (n16 >> 10) >> 16;
                                    n43 = (n42 & 0xFF) * (n17 >> 10) >> 16;
                                    if ((n45 & 0xFFFFFF00) != 0) {
                                        n45 = 255 >> (n45 >> 28 & 8);
                                    }
                                    if ((n44 & 0xFFFFFF00) != 0) {
                                        n44 = 255 >> (n44 >> 28 & 8);
                                    }
                                    if ((n43 & 0xFFFFFF00) != 0) {
                                        n43 = 255 >> (n43 >> 28 & 8);
                                    }
                                    nArray3[n40] = n43 | n44 << 8 | n45 << 16 | 0xFF000000;
                                    nArray4[n40] = n18;
                                    n19 += n34;
                                    n20 += n35;
                                    n21 += n36;
                                    n22 += n37;
                                    n15 += n23;
                                    n16 += n24;
                                    n17 += n25;
                                    n18 += n33;
                                }
                            } else if (!bl2) {
                                for (n40 = n9 + n10; n40 <= n41; ++n40) {
                                    if (nArray4[n40] < n18) {
                                        n39 = nArray2[((n21 + n46 & n31) >> 18) + ((n22 + (n46 ^ 0x10000) & n32) >> 18 << by2)];
                                        n38 = ((n19 + n46 & n29) >> 18) - 128 + (n39 >> 8) + (((n20 + (n46 ^ 0x10000) & n30) >> 18) - 128 + (n39 & 0xFF) << by);
                                        n46 ^= 0x30000;
                                        if (n38 < 0) {
                                            n38 = 0;
                                        } else if (n38 >= texture.intSize) {
                                            n38 = texture.intSize - 1;
                                        }
                                        n42 = nArray[n38];
                                        n45 = (n42 >> 16) * (n15 >> 10) >> 16;
                                        n44 = (n42 >> 8 & 0xFF) * (n16 >> 10) >> 16;
                                        n43 = (n42 & 0xFF) * (n17 >> 10) >> 16;
                                        if ((n45 & 0xFFFFFF00) != 0) {
                                            n45 = 255 >> (n45 >> 28 & 8);
                                        }
                                        if ((n44 & 0xFFFFFF00) != 0) {
                                            n44 = 255 >> (n44 >> 28 & 8);
                                        }
                                        if ((n43 & 0xFFFFFF00) != 0) {
                                            n43 = 255 >> (n43 >> 28 & 8);
                                        }
                                        nArray3[n40] = n43 | n44 << 8 | n45 << 16 | 0xFF000000;
                                        nArray4[n40] = n18;
                                    }
                                    n19 += n34;
                                    n20 += n35;
                                    n21 += n36;
                                    n22 += n37;
                                    n15 += n23;
                                    n16 += n24;
                                    n17 += n25;
                                    n18 += n33;
                                }
                            } else {
                                for (n40 = n9 + n10; n40 <= n41; ++n40) {
                                    if (nArray4[n40] > n18) {
                                        n39 = nArray2[((n21 + n46 & n31) >> 18) + ((n22 + (n46 ^ 0x10000) & n32) >> 18 << by2)];
                                        n38 = ((n19 + n46 & n29) >> 18) - 128 + (n39 >> 8) + (((n20 + (n46 ^ 0x10000) & n30) >> 18) - 128 + (n39 & 0xFF) << by);
                                        n46 ^= 0x30000;
                                        if (n38 < 0) {
                                            n38 = 0;
                                        } else if (n38 >= texture.intSize) {
                                            n38 = texture.intSize - 1;
                                        }
                                        n42 = nArray[n38];
                                        n45 = (n42 >> 16) * (n15 >> 10) >> 16;
                                        n44 = (n42 >> 8 & 0xFF) * (n16 >> 10) >> 16;
                                        n43 = (n42 & 0xFF) * (n17 >> 10) >> 16;
                                        if ((n45 & 0xFFFFFF00) != 0) {
                                            n45 = 255 >> (n45 >> 28 & 8);
                                        }
                                        if ((n44 & 0xFFFFFF00) != 0) {
                                            n44 = 255 >> (n44 >> 28 & 8);
                                        }
                                        if ((n43 & 0xFFFFFF00) != 0) {
                                            n43 = 255 >> (n43 >> 28 & 8);
                                        }
                                        nArray3[n40] = n43 | n44 << 8 | n45 << 16 | 0xFF000000;
                                        nArray4[n40] = n18;
                                    }
                                    n19 += n34;
                                    n20 += n35;
                                    n21 += n36;
                                    n22 += n37;
                                    n15 += n23;
                                    n16 += n24;
                                    n17 += n25;
                                    n18 += n33;
                                }
                            }
                        } else if (Config.optiZ && (n3 > n12 || n4 < n9 || f55 >= f23 && f13 >= f23)) {
                            for (n40 = n9 + n10; n40 <= n41; ++n40) {
                                n39 = nArray2[((n21 & n31) >> 18) + ((n22 & n32) >> 18 << by2)];
                                n38 = ((n19 & n29) >> 18) - 128 + (n39 >> 8) + (((n20 & n30) >> 18) - 128 + (n39 & 0xFF) << by);
                                if (n38 >= texture.intSize) {
                                    n38 = texture.intSize - 1;
                                } else if (n38 < 0) {
                                    n38 = 0;
                                }
                                n42 = nArray[n38];
                                n45 = (n42 >> 16) * (n15 >> 10) >> 16;
                                n44 = (n42 >> 8 & 0xFF) * (n16 >> 10) >> 16;
                                n43 = (n42 & 0xFF) * (n17 >> 10) >> 16;
                                if ((n45 & 0xFFFFFF00) != 0) {
                                    n45 = 255 >> (byte)(n45 >> 28 & 8);
                                }
                                if ((n44 & 0xFFFFFF00) != 0) {
                                    n44 = 255 >> (byte)(n44 >> 28 & 8);
                                }
                                if ((n43 & 0xFFFFFF00) != 0) {
                                    n43 = 255 >> (byte)(n43 >> 28 & 8);
                                }
                                nArray3[n40] = n43 | n44 << 8 | n45 << 16 | 0xFF000000;
                                nArray4[n40] = n18;
                                n19 += n34;
                                n20 += n35;
                                n21 += n36;
                                n22 += n37;
                                n15 += n23;
                                n16 += n24;
                                n17 += n25;
                                n18 += n33;
                            }
                        } else if (!bl2) {
                            for (n40 = n9 + n10; n40 <= n41; ++n40) {
                                if (frameBuffer.zbuffer[n40] < n18) {
                                    n39 = nArray2[((n21 & n31) >> 18) + ((n22 & n32) >> 18 << by2)];
                                    n38 = ((n19 & n29) >> 18) - 128 + (n39 >> 8) + (((n20 & n30) >> 18) - 128 + (n39 & 0xFF) << by);
                                    if (n38 >= texture.intSize) {
                                        n38 = texture.intSize - 1;
                                    } else if (n38 < 0) {
                                        n38 = 0;
                                    }
                                    n42 = nArray[n38];
                                    n45 = (n42 >> 16) * (n15 >> 10) >> 16;
                                    n44 = (n42 >> 8 & 0xFF) * (n16 >> 10) >> 16;
                                    n43 = (n42 & 0xFF) * (n17 >> 10) >> 16;
                                    if ((n45 & 0xFFFFFF00) != 0) {
                                        n45 = 255 >> (byte)(n45 >> 28 & 8);
                                    }
                                    if ((n44 & 0xFFFFFF00) != 0) {
                                        n44 = 255 >> (byte)(n44 >> 28 & 8);
                                    }
                                    if ((n43 & 0xFFFFFF00) != 0) {
                                        n43 = 255 >> (byte)(n43 >> 28 & 8);
                                    }
                                    nArray3[n40] = n43 | n44 << 8 | n45 << 16 | 0xFF000000;
                                    nArray4[n40] = n18;
                                }
                                n19 += n34;
                                n20 += n35;
                                n21 += n36;
                                n22 += n37;
                                n15 += n23;
                                n16 += n24;
                                n17 += n25;
                                n18 += n33;
                            }
                        } else {
                            for (n40 = n9 + n10; n40 <= n41; ++n40) {
                                if (frameBuffer.zbuffer[n40] > n18) {
                                    n39 = nArray2[((n21 & n31) >> 18) + ((n22 & n32) >> 18 << by2)];
                                    n38 = ((n19 & n29) >> 18) - 128 + (n39 >> 8) + (((n20 & n30) >> 18) - 128 + (n39 & 0xFF) << by);
                                    if (n38 >= texture.intSize) {
                                        n38 = texture.intSize - 1;
                                    } else if (n38 < 0) {
                                        n38 = 0;
                                    }
                                    n42 = nArray[n38];
                                    n45 = (n42 >> 16) * (n15 >> 10) >> 16;
                                    n44 = (n42 >> 8 & 0xFF) * (n16 >> 10) >> 16;
                                    n43 = (n42 & 0xFF) * (n17 >> 10) >> 16;
                                    if ((n45 & 0xFFFFFF00) != 0) {
                                        n45 = 255 >> (byte)(n45 >> 28 & 8);
                                    }
                                    if ((n44 & 0xFFFFFF00) != 0) {
                                        n44 = 255 >> (byte)(n44 >> 28 & 8);
                                    }
                                    if ((n43 & 0xFFFFFF00) != 0) {
                                        n43 = 255 >> (byte)(n43 >> 28 & 8);
                                    }
                                    nArray3[n40] = n43 | n44 << 8 | n45 << 16 | 0xFF000000;
                                    nArray4[n40] = n18;
                                }
                                n19 += n34;
                                n20 += n35;
                                n21 += n36;
                                n22 += n37;
                                n15 += n23;
                                n16 += n24;
                                n17 += n25;
                                n18 += n33;
                            }
                        }
                    }
                    f48 = f56;
                    f49 = f57;
                    f50 = f58;
                    f51 = f59;
                    f52 = f60;
                    f53 = f61;
                    f54 = f62;
                } while (n12 < n13);
                boolean bl3 = false;
                if (n11 < n5 && n13 >= n5 || n5 == 99999999) {
                    frameBuffer.exXstart[n] = n11;
                    if (f24 > f34) {
                        frameBuffer.exZlow[n] = f34;
                    }
                    if (frameBuffer.exZlow[n] > f14) {
                        frameBuffer.exZlow[n] = f14;
                    }
                    bl3 = true;
                }
                if (n13 > n6 && f7 <= (float)n6 || n6 == -1) {
                    frameBuffer.exXend[n] = n13;
                    if (frameBuffer.exZlow[n] > f14) {
                        frameBuffer.exZlow[n] = f14;
                    }
                    if (frameBuffer.exZlow[n] > f34) {
                        frameBuffer.exZlow[n] = f34;
                    }
                    bl3 = true;
                }
                if (!bl3) {
                    if (n11 < n7 && n13 >= n7 || n7 == 99999999) {
                        frameBuffer.exXstart2[n] = n11;
                        if (f25 > f34) {
                            frameBuffer.exZlow2[n] = f34;
                        }
                        if (frameBuffer.exZlow2[n] > f14) {
                            frameBuffer.exZlow2[n] = f14;
                        }
                    }
                    if (n13 > n8 && f7 <= (float)n8 || n8 == -1) {
                        frameBuffer.exXend2[n] = n13;
                        if (frameBuffer.exZlow2[n] > f14) {
                            frameBuffer.exZlow2[n] = f14;
                        }
                        if (frameBuffer.exZlow2[n] > f34) {
                            frameBuffer.exZlow2[n] = f34;
                        }
                        bl3 = true;
                    }
                }
                if (f7 < (float)n3) {
                    frameBuffer.xstart[n] = n11;
                }
                if (n13 > n4) {
                    frameBuffer.xend[n] = n13;
                }
                if (f14 < f34) {
                    f14 = f34;
                }
                if (f14 > f23) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    private final void drawShadedZbufferedFilteredTransparentScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl, int n2, int n3, boolean bl2) {
        float f17;
        if (n3 != 1) {
            float f18 = n3;
            f *= f18;
            f2 *= f18;
            f3 *= f18;
            f4 *= f18;
            f5 *= f18;
            f6 *= f18;
        }
        int[] nArray = texture.texels;
        int[] nArray2 = frameBuffer.pixels;
        int[] nArray3 = frameBuffer.zbuffer;
        int n4 = 0;
        int n5 = frameBuffer.xstart[n];
        int n6 = frameBuffer.xend[n];
        float f19 = frameBuffer.zhigh[n];
        int n7 = frameBuffer.exXstart[n];
        int n8 = frameBuffer.exXend[n];
        float f20 = frameBuffer.exZlow[n];
        int n9 = frameBuffer.exXstart2[n];
        int n10 = frameBuffer.exXend2[n];
        float f21 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f17 = f7;
            f7 = f8;
            f8 = f17;
            f17 = f9;
            f9 = f10;
            f10 = f17;
            f17 = f11;
            f11 = f12;
            f12 = f17;
            f17 = f13;
            f13 = f14;
            f14 = f17;
            f17 = f;
            f = f2;
            f2 = f17;
            f17 = f3;
            f3 = f4;
            f4 = f17;
            f17 = f5;
            f5 = f6;
            f6 = f17;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n8 <= n10) {
                if (n8 >= n9) {
                    n8 = n10;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n9 < n7) {
                        n7 = n9;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f21 < f20) {
                        f20 = f21;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n9 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n10 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f21 = 2.1474836E9f;
                }
            } else if (n10 >= n7) {
                if (n9 < n7) {
                    n7 = n9;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f21 < f20) {
                        f20 = f21;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n9 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n10 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f21 = 2.1474836E9f;
            }
            if (!(Config.spanBasedHsr && (float)n7 <= f7 && (float)n8 >= f8 && f20 >= f13 && f20 >= f14 || (float)n9 <= f7 && (float)n10 >= f8 && f21 >= f13 && f21 >= f14)) {
                float f22;
                float f23;
                float f24;
                float f25;
                float f26;
                float f27;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f17 = f13;
                float f28 = f8 - f7;
                if (f28 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f28 != 0.0f) {
                    float f29 = 1.0f / f28;
                    f27 = (f10 - f9) * f29;
                    f26 = (f12 - f11) * f29;
                    f25 = (f14 - f13) * f29;
                    f24 = (f2 - f) * f29;
                    f23 = (f4 - f3) * f29;
                    f22 = (f6 - f5) * f29;
                } else {
                    f27 = 0.0f;
                    f26 = 0.0f;
                    f25 = 0.0f;
                    f22 = 0.0f;
                    f24 = 0.0f;
                    f23 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f24;
                    f3 += f7 * f23;
                    f5 += f7 * f22;
                    f9 += f7 * f27;
                    f11 += f7 * f26;
                    f13 += f7 * f25;
                    f7 = f15;
                }
                int n11 = n * frameBuffer.width;
                int n12 = (int)f7;
                int n13 = n12 - 1;
                int n14 = (int)f8;
                int n15 = 16;
                float f30 = 16384.0f;
                float f31 = 16384.0f;
                float f32 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f33 = 16.0f * f27;
                float f34 = 16.0f * f26;
                float f35 = 16.0f * f25;
                float f36 = 16.0f * f24;
                float f37 = 16.0f * f23;
                float f38 = 16.0f * f22;
                float f39 = 1.0f / f13;
                float f40 = f9 * f39;
                float f41 = f11 * f39;
                float f42 = f * f39;
                float f43 = f3 * f39;
                float f44 = f5 * f39;
                byte by = texture.shifter;
                int n16 = (int)(f42 * 262144.0f);
                int n17 = (int)(f43 * 262144.0f);
                int n18 = (int)(f44 * 262144.0f);
                int n19 = 0;
                boolean bl3 = false;
                if (Config.zTrick) {
                    n19 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n19 = -n19;
                        bl3 = true;
                    }
                } else {
                    n19 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                int n20 = (int)(f40 * 262144.0f);
                int n21 = (int)(f41 * 262144.0f);
                int n22 = 0;
                int n23 = 0;
                int n24 = 0;
                int n25 = n & 1;
                int n26 = 1 - n25 << 17;
                int n27 = n25 << 17;
                do {
                    n12 = n13 + 1;
                    if ((n13 += n15) > n14) {
                        n15 -= n13 - n14;
                        n13 = n14;
                        if (n15 != 0) {
                            f33 = (float)n15 * f27;
                            f34 = (float)n15 * f26;
                            f35 = (float)n15 * f25;
                            f36 = (float)n15 * f24;
                            f37 = (float)n15 * f23;
                            f38 = (float)n15 * f22;
                            f30 = f31 = multiLU[n15];
                            f32 = Config.zTrick ? multiZTLU[n15] : multiZLU[n15];
                        } else {
                            f33 = 0.0f;
                            f34 = 0.0f;
                            f35 = 0.0f;
                            f36 = 0.0f;
                            f37 = 0.0f;
                            f38 = 0.0f;
                            n15 = 1;
                            f31 = 262144.0f;
                            f30 = 262144.0f;
                            f32 = Config.zTrick ? 2.1474836E9f : 4.2949673E9f;
                        }
                    }
                    float f45 = f13;
                    if (n13 == n14 && f8 < f16 - 1.0f) {
                        f33 = f10 - f9;
                        f34 = f12 - f11;
                        f35 = f14 - f13;
                    }
                    f9 += f33;
                    f11 += f34;
                    f += f36;
                    f3 += f37;
                    f5 += f38;
                    f39 = 1.0f / (f13 += f35);
                    float f46 = f9 * f39;
                    float f47 = f11 * f39;
                    float f48 = f * f39;
                    float f49 = f3 * f39;
                    float f50 = f5 * f39;
                    int n28 = texture.width - 1 << 18;
                    int n29 = texture.height - 1 << 18;
                    int n30 = (int)(f32 * (f13 - f45));
                    if (bl3) {
                        n30 = -n30;
                    }
                    int n31 = (int)(f30 * (f46 - f40));
                    int n32 = (int)(f30 * (f47 - f41));
                    n22 = (int)(f31 * (f48 - f42));
                    n23 = (int)(f31 * (f49 - f43));
                    n24 = (int)(f31 * (f50 - f44));
                    if (Config.spanBasedHsr && (n7 <= n12 && n8 >= n13 && f20 >= f45 && f20 >= f13 || n9 <= n12 && n10 >= n13 && f21 >= f45 && f21 >= f13)) {
                        if (n13 != n14) {
                            n19 += n15 * n30;
                            n20 += n15 * n31;
                            n21 += n15 * n32;
                            n16 += n15 * n22;
                            n17 += n15 * n23;
                            n18 += n15 * n24;
                        }
                    } else {
                        int n33;
                        int n34;
                        n4 = n13 + n11;
                        int n35 = 0;
                        int n36 = 0;
                        int n37 = 0;
                        int n38 = 0;
                        if (Config.texelFilter) {
                            if (!bl && n31 < 196608 && n31 > -196608 && n32 <= 196608 && n32 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n39 = (n12 & 1) != 0 ? 65536 + n26 : n27;
                            if (!bl3) {
                                for (n34 = n12 + n11; n34 <= n4; ++n34) {
                                    if (n19 > frameBuffer.zbuffer[n34]) {
                                        n35 = nArray[((n20 + n39 & n28) >> 18) + ((n21 + (n39 ^ 0x10000) & n29) >> 18 << by)];
                                        n39 ^= 0x30000;
                                        if ((n35 & 0xF0F0F0) != 0) {
                                            n33 = nArray2[n34];
                                            n38 = ((n35 >> 16) * (n16 >> 10) >> 16) + ((n33 >> 16 & 0xFF) >> n2) >> 1;
                                            n37 = ((n35 >> 8 & 0xFF) * (n17 >> 10) >> 16) + ((n33 >> 8 & 0xFF) >> n2) >> 1;
                                            n36 = ((n35 & 0xFF) * (n18 >> 10) >> 16) + ((n33 & 0xFF) >> n2) >> 1;
                                            if ((n38 & 0xFFFFFF00) != 0) {
                                                n38 = 255 >> (n38 >> 28 & 8);
                                            }
                                            if ((n37 & 0xFFFFFF00) != 0) {
                                                n37 = 255 >> (n37 >> 28 & 8);
                                            }
                                            if ((n36 & 0xFFFFFF00) != 0) {
                                                n36 = 255 >> (n36 >> 28 & 8);
                                            }
                                            nArray2[n34] = n36 | n37 << 8 | n38 << 16 | 0xFF000000;
                                            if (bl2) {
                                                nArray3[n34] = n19;
                                            }
                                        }
                                    }
                                    n20 += n31;
                                    n21 += n32;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n24;
                                    n19 += n30;
                                }
                            } else {
                                for (n34 = n12 + n11; n34 <= n4; ++n34) {
                                    if (n19 < frameBuffer.zbuffer[n34]) {
                                        n35 = nArray[((n20 + n39 & n28) >> 18) + ((n21 + (n39 ^ 0x10000) & n29) >> 18 << by)];
                                        n39 ^= 0x30000;
                                        if ((n35 & 0xF0F0F0) != 0) {
                                            n33 = nArray2[n34];
                                            n38 = ((n35 >> 16) * (n16 >> 10) >> 16) + ((n33 >> 16 & 0xFF) >> n2) >> 1;
                                            n37 = ((n35 >> 8 & 0xFF) * (n17 >> 10) >> 16) + ((n33 >> 8 & 0xFF) >> n2) >> 1;
                                            n36 = ((n35 & 0xFF) * (n18 >> 10) >> 16) + ((n33 & 0xFF) >> n2) >> 1;
                                            if ((n38 & 0xFFFFFF00) != 0) {
                                                n38 = 255 >> (n38 >> 28 & 8);
                                            }
                                            if ((n37 & 0xFFFFFF00) != 0) {
                                                n37 = 255 >> (n37 >> 28 & 8);
                                            }
                                            if ((n36 & 0xFFFFFF00) != 0) {
                                                n36 = 255 >> (n36 >> 28 & 8);
                                            }
                                            nArray2[n34] = n36 | n37 << 8 | n38 << 16 | 0xFF000000;
                                            if (bl2) {
                                                nArray3[n34] = n19;
                                            }
                                        }
                                    }
                                    n20 += n31;
                                    n21 += n32;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n24;
                                    n19 += n30;
                                }
                            }
                        } else if (!bl3) {
                            for (n34 = n12 + n11; n34 <= n4; ++n34) {
                                if (nArray3[n34] < n19 && ((n35 = nArray[((n20 & n28) >> 18) + ((n21 & n29) >> 18 << by)]) & 0xF0F0F0) != 0) {
                                    n33 = nArray2[n34];
                                    n38 = ((n35 >> 16) * (n16 >> 10) >> 16) + ((n33 >> 16 & 0xFF) >> n2) >> 1;
                                    n37 = ((n35 >> 8 & 0xFF) * (n17 >> 10) >> 16) + ((n33 >> 8 & 0xFF) >> n2) >> 1;
                                    n36 = ((n35 & 0xFF) * (n18 >> 10) >> 16) + ((n33 & 0xFF) >> n2) >> 1;
                                    if ((n38 & 0xFFFFFF00) != 0) {
                                        n38 = 255 >> (byte)(n38 >> 28 & 8);
                                    }
                                    if ((n37 & 0xFFFFFF00) != 0) {
                                        n37 = 255 >> (byte)(n37 >> 28 & 8);
                                    }
                                    if ((n36 & 0xFFFFFF00) != 0) {
                                        n36 = 255 >> (byte)(n36 >> 28 & 8);
                                    }
                                    nArray2[n34] = n36 | n37 << 8 | n38 << 16 | 0xFF000000;
                                    if (bl2) {
                                        nArray3[n34] = n19;
                                    }
                                }
                                n20 += n31;
                                n21 += n32;
                                n16 += n22;
                                n17 += n23;
                                n18 += n24;
                                n19 += n30;
                            }
                        } else {
                            for (n34 = n12 + n11; n34 <= n4; ++n34) {
                                if (nArray3[n34] > n19 && ((n35 = nArray[((n20 & n28) >> 18) + ((n21 & n29) >> 18 << by)]) & 0xF0F0F0) != 0) {
                                    n33 = nArray2[n34];
                                    n38 = ((n35 >> 16) * (n16 >> 10) >> 16) + ((n33 >> 16 & 0xFF) >> n2) >> 1;
                                    n37 = ((n35 >> 8 & 0xFF) * (n17 >> 10) >> 16) + ((n33 >> 8 & 0xFF) >> n2) >> 1;
                                    n36 = ((n35 & 0xFF) * (n18 >> 10) >> 16) + ((n33 & 0xFF) >> n2) >> 1;
                                    if ((n38 & 0xFFFFFF00) != 0) {
                                        n38 = 255 >> (byte)(n38 >> 28 & 8);
                                    }
                                    if ((n37 & 0xFFFFFF00) != 0) {
                                        n37 = 255 >> (byte)(n37 >> 28 & 8);
                                    }
                                    if ((n36 & 0xFFFFFF00) != 0) {
                                        n36 = 255 >> (byte)(n36 >> 28 & 8);
                                    }
                                    nArray2[n34] = n36 | n37 << 8 | n38 << 16 | 0xFF000000;
                                    if (bl2) {
                                        nArray3[n34] = n19;
                                    }
                                }
                                n20 += n31;
                                n21 += n32;
                                n16 += n22;
                                n17 += n23;
                                n18 += n24;
                                n19 += n30;
                            }
                        }
                    }
                    f40 = f46;
                    f41 = f47;
                    f42 = f48;
                    f43 = f49;
                    f44 = f50;
                } while (n13 < n14);
                if (f7 < (float)n5) {
                    frameBuffer.xstart[n] = (int)f7;
                }
                if (n14 > n6) {
                    frameBuffer.xend[n] = n14;
                }
                if (f14 < f17) {
                    f14 = f17;
                }
                if (f14 > f19) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    private final void drawShadedZbufferedFilteredAdditiveTransparentScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl, int n2, int n3, boolean bl2) {
        float f17;
        if (n3 != 1) {
            float f18 = n3;
            f *= f18;
            f2 *= f18;
            f3 *= f18;
            f4 *= f18;
            f5 *= f18;
            f6 *= f18;
        }
        int[] nArray = texture.texels;
        int[] nArray2 = frameBuffer.pixels;
        int[] nArray3 = frameBuffer.zbuffer;
        int n4 = 0;
        int n5 = frameBuffer.xstart[n];
        int n6 = frameBuffer.xend[n];
        float f19 = frameBuffer.zhigh[n];
        int n7 = frameBuffer.exXstart[n];
        int n8 = frameBuffer.exXend[n];
        float f20 = frameBuffer.exZlow[n];
        int n9 = frameBuffer.exXstart2[n];
        int n10 = frameBuffer.exXend2[n];
        float f21 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f17 = f7;
            f7 = f8;
            f8 = f17;
            f17 = f9;
            f9 = f10;
            f10 = f17;
            f17 = f11;
            f11 = f12;
            f12 = f17;
            f17 = f13;
            f13 = f14;
            f14 = f17;
            f17 = f;
            f = f2;
            f2 = f17;
            f17 = f3;
            f3 = f4;
            f4 = f17;
            f17 = f5;
            f5 = f6;
            f6 = f17;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n8 <= n10) {
                if (n8 >= n9) {
                    n8 = n10;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n9 < n7) {
                        n7 = n9;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f21 < f20) {
                        f20 = f21;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n9 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n10 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f21 = 2.1474836E9f;
                }
            } else if (n10 >= n7) {
                if (n9 < n7) {
                    n7 = n9;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f21 < f20) {
                        f20 = f21;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n9 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n10 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f21 = 2.1474836E9f;
            }
            if (!(Config.spanBasedHsr && (float)n7 <= f7 && (float)n8 >= f8 && f20 >= f13 && f20 >= f14 || (float)n9 <= f7 && (float)n10 >= f8 && f21 >= f13 && f21 >= f14)) {
                float f22;
                float f23;
                float f24;
                float f25;
                float f26;
                float f27;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f17 = f13;
                float f28 = f8 - f7;
                if (f28 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f28 != 0.0f) {
                    float f29 = 1.0f / f28;
                    f27 = (f10 - f9) * f29;
                    f26 = (f12 - f11) * f29;
                    f25 = (f14 - f13) * f29;
                    f24 = (f2 - f) * f29;
                    f23 = (f4 - f3) * f29;
                    f22 = (f6 - f5) * f29;
                } else {
                    f27 = 0.0f;
                    f26 = 0.0f;
                    f25 = 0.0f;
                    f22 = 0.0f;
                    f24 = 0.0f;
                    f23 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f24;
                    f3 += f7 * f23;
                    f5 += f7 * f22;
                    f9 += f7 * f27;
                    f11 += f7 * f26;
                    f13 += f7 * f25;
                    f7 = f15;
                }
                int n11 = n * frameBuffer.width;
                int n12 = (int)f7;
                int n13 = n12 - 1;
                int n14 = (int)f8;
                int n15 = 16;
                float f30 = 16384.0f;
                float f31 = 16384.0f;
                float f32 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f33 = 16.0f * f27;
                float f34 = 16.0f * f26;
                float f35 = 16.0f * f25;
                float f36 = 16.0f * f24;
                float f37 = 16.0f * f23;
                float f38 = 16.0f * f22;
                float f39 = 1.0f / f13;
                float f40 = f9 * f39;
                float f41 = f11 * f39;
                float f42 = f * f39;
                float f43 = f3 * f39;
                float f44 = f5 * f39;
                byte by = texture.shifter;
                int n16 = (int)(f42 * 262144.0f);
                int n17 = (int)(f43 * 262144.0f);
                int n18 = (int)(f44 * 262144.0f);
                int n19 = 0;
                boolean bl3 = false;
                if (Config.zTrick) {
                    n19 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n19 = -n19;
                        bl3 = true;
                    }
                } else {
                    n19 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                int n20 = (int)(f40 * 262144.0f);
                int n21 = (int)(f41 * 262144.0f);
                int n22 = 0;
                int n23 = 0;
                int n24 = 0;
                int n25 = n & 1;
                int n26 = 1 - n25 << 17;
                int n27 = n25 << 17;
                do {
                    n12 = n13 + 1;
                    if ((n13 += n15) > n14) {
                        n15 -= n13 - n14;
                        n13 = n14;
                        if (n15 != 0) {
                            f33 = (float)n15 * f27;
                            f34 = (float)n15 * f26;
                            f35 = (float)n15 * f25;
                            f36 = (float)n15 * f24;
                            f37 = (float)n15 * f23;
                            f38 = (float)n15 * f22;
                            f30 = f31 = multiLU[n15];
                            f32 = Config.zTrick ? multiZTLU[n15] : multiZLU[n15];
                        } else {
                            f33 = 0.0f;
                            f34 = 0.0f;
                            f35 = 0.0f;
                            f36 = 0.0f;
                            f37 = 0.0f;
                            f38 = 0.0f;
                            n15 = 1;
                            f31 = 262144.0f;
                            f30 = 262144.0f;
                            f32 = Config.zTrick ? 2.1474836E9f : 4.2949673E9f;
                        }
                    }
                    float f45 = f13;
                    if (n13 == n14 && f8 < f16 - 1.0f) {
                        f33 = f10 - f9;
                        f34 = f12 - f11;
                        f35 = f14 - f13;
                    }
                    f9 += f33;
                    f11 += f34;
                    f += f36;
                    f3 += f37;
                    f5 += f38;
                    f39 = 1.0f / (f13 += f35);
                    float f46 = f9 * f39;
                    float f47 = f11 * f39;
                    float f48 = f * f39;
                    float f49 = f3 * f39;
                    float f50 = f5 * f39;
                    int n28 = texture.width - 1 << 18;
                    int n29 = texture.height - 1 << 18;
                    int n30 = (int)(f32 * (f13 - f45));
                    if (bl3) {
                        n30 = -n30;
                    }
                    int n31 = (int)(f30 * (f46 - f40));
                    int n32 = (int)(f30 * (f47 - f41));
                    n22 = (int)(f31 * (f48 - f42));
                    n23 = (int)(f31 * (f49 - f43));
                    n24 = (int)(f31 * (f50 - f44));
                    if (Config.spanBasedHsr && (n7 <= n12 && n8 >= n13 && f20 >= f45 && f20 >= f13 || n9 <= n12 && n10 >= n13 && f21 >= f45 && f21 >= f13)) {
                        if (n13 != n14) {
                            n19 += n15 * n30;
                            n20 += n15 * n31;
                            n21 += n15 * n32;
                            n16 += n15 * n22;
                            n17 += n15 * n23;
                            n18 += n15 * n24;
                        }
                    } else {
                        int n33;
                        int n34;
                        n4 = n13 + n11;
                        int n35 = 0;
                        int n36 = 0;
                        int n37 = 0;
                        int n38 = 0;
                        if (Config.texelFilter) {
                            if (!bl && n31 < 196608 && n31 > -196608 && n32 <= 196608 && n32 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n39 = (n12 & 1) != 0 ? 65536 + n26 : n27;
                            if (!bl3) {
                                for (n34 = n12 + n11; n34 <= n4; ++n34) {
                                    if (n19 > frameBuffer.zbuffer[n34]) {
                                        n35 = nArray[((n20 + n39 & n28) >> 18) + ((n21 + (n39 ^ 0x10000) & n29) >> 18 << by)];
                                        n39 ^= 0x30000;
                                        if ((n35 & 0xF0F0F0) != 0) {
                                            n33 = nArray2[n34];
                                            n38 = n35 >> 16 << n2;
                                            n37 = (n35 >> 8 & 0xFF) << n2;
                                            n36 = (n35 & 0xFF) << n2;
                                            if (n38 > 255) {
                                                n38 = 255;
                                            }
                                            if (n37 > 255) {
                                                n37 = 255;
                                            }
                                            if (n36 > 255) {
                                                n36 = 255;
                                            }
                                            n38 = (n38 * (n16 >> 10) >> 16) + (n33 >> 16 & 0xFF);
                                            n37 = (n37 * (n17 >> 10) >> 16) + (n33 >> 8 & 0xFF);
                                            n36 = (n36 * (n18 >> 10) >> 16) + (n33 & 0xFF);
                                            if ((n38 & 0xFFFFFF00) != 0) {
                                                n38 = 255 >> (n38 >> 28 & 8);
                                            }
                                            if ((n37 & 0xFFFFFF00) != 0) {
                                                n37 = 255 >> (n37 >> 28 & 8);
                                            }
                                            if ((n36 & 0xFFFFFF00) != 0) {
                                                n36 = 255 >> (n36 >> 28 & 8);
                                            }
                                            nArray2[n34] = n36 | n37 << 8 | n38 << 16 | 0xFF000000;
                                            if (bl2) {
                                                nArray3[n34] = n19;
                                            }
                                        }
                                    }
                                    n20 += n31;
                                    n21 += n32;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n24;
                                    n19 += n30;
                                }
                            } else {
                                for (n34 = n12 + n11; n34 <= n4; ++n34) {
                                    if (n19 < frameBuffer.zbuffer[n34]) {
                                        n35 = nArray[((n20 + n39 & n28) >> 18) + ((n21 + (n39 ^ 0x10000) & n29) >> 18 << by)];
                                        n39 ^= 0x30000;
                                        if ((n35 & 0xF0F0F0) != 0) {
                                            n33 = nArray2[n34];
                                            n38 = n35 >> 16 << n2;
                                            n37 = (n35 >> 8 & 0xFF) << n2;
                                            n36 = (n35 & 0xFF) << n2;
                                            if (n38 > 255) {
                                                n38 = 255;
                                            }
                                            if (n37 > 255) {
                                                n37 = 255;
                                            }
                                            if (n36 > 255) {
                                                n36 = 255;
                                            }
                                            n38 = (n38 * (n16 >> 10) >> 16) + (n33 >> 16 & 0xFF);
                                            n37 = (n37 * (n17 >> 10) >> 16) + (n33 >> 8 & 0xFF);
                                            n36 = (n36 * (n18 >> 10) >> 16) + (n33 & 0xFF);
                                            if ((n38 & 0xFFFFFF00) != 0) {
                                                n38 = 255 >> (n38 >> 28 & 8);
                                            }
                                            if ((n37 & 0xFFFFFF00) != 0) {
                                                n37 = 255 >> (n37 >> 28 & 8);
                                            }
                                            if ((n36 & 0xFFFFFF00) != 0) {
                                                n36 = 255 >> (n36 >> 28 & 8);
                                            }
                                            nArray2[n34] = n36 | n37 << 8 | n38 << 16 | 0xFF000000;
                                            if (bl2) {
                                                nArray3[n34] = n19;
                                            }
                                        }
                                    }
                                    n20 += n31;
                                    n21 += n32;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n24;
                                    n19 += n30;
                                }
                            }
                        } else if (!bl3) {
                            for (n34 = n12 + n11; n34 <= n4; ++n34) {
                                if (nArray3[n34] < n19 && ((n35 = nArray[((n20 & n28) >> 18) + ((n21 & n29) >> 18 << by)]) & 0xF0F0F0) != 0) {
                                    n33 = nArray2[n34];
                                    n38 = n35 >> 16 << n2;
                                    n37 = (n35 >> 8 & 0xFF) << n2;
                                    n36 = (n35 & 0xFF) << n2;
                                    if (n38 > 255) {
                                        n38 = 255;
                                    }
                                    if (n37 > 255) {
                                        n37 = 255;
                                    }
                                    if (n36 > 255) {
                                        n36 = 255;
                                    }
                                    n38 = (n38 * (n16 >> 10) >> 16) + (n33 >> 16 & 0xFF);
                                    n37 = (n37 * (n17 >> 10) >> 16) + (n33 >> 8 & 0xFF);
                                    n36 = (n36 * (n18 >> 10) >> 16) + (n33 & 0xFF);
                                    if ((n38 & 0xFFFFFF00) != 0) {
                                        n38 = 255 >> (byte)(n38 >> 28 & 8);
                                    }
                                    if ((n37 & 0xFFFFFF00) != 0) {
                                        n37 = 255 >> (byte)(n37 >> 28 & 8);
                                    }
                                    if ((n36 & 0xFFFFFF00) != 0) {
                                        n36 = 255 >> (byte)(n36 >> 28 & 8);
                                    }
                                    nArray2[n34] = n36 | n37 << 8 | n38 << 16 | 0xFF000000;
                                    if (bl2) {
                                        nArray3[n34] = n19;
                                    }
                                }
                                n20 += n31;
                                n21 += n32;
                                n16 += n22;
                                n17 += n23;
                                n18 += n24;
                                n19 += n30;
                            }
                        } else {
                            for (n34 = n12 + n11; n34 <= n4; ++n34) {
                                if (nArray3[n34] > n19 && ((n35 = nArray[((n20 & n28) >> 18) + ((n21 & n29) >> 18 << by)]) & 0xF0F0F0) != 0) {
                                    n33 = nArray2[n34];
                                    n38 = n35 >> 16 << n2;
                                    n37 = (n35 >> 8 & 0xFF) << n2;
                                    n36 = (n35 & 0xFF) << n2;
                                    if (n38 > 255) {
                                        n38 = 255;
                                    }
                                    if (n37 > 255) {
                                        n37 = 255;
                                    }
                                    if (n36 > 255) {
                                        n36 = 255;
                                    }
                                    n38 = (n38 * (n16 >> 10) >> 16) + (n33 >> 16 & 0xFF);
                                    n37 = (n37 * (n17 >> 10) >> 16) + (n33 >> 8 & 0xFF);
                                    n36 = (n36 * (n18 >> 10) >> 16) + (n33 & 0xFF);
                                    if ((n38 & 0xFFFFFF00) != 0) {
                                        n38 = 255 >> (byte)(n38 >> 28 & 8);
                                    }
                                    if ((n37 & 0xFFFFFF00) != 0) {
                                        n37 = 255 >> (byte)(n37 >> 28 & 8);
                                    }
                                    if ((n36 & 0xFFFFFF00) != 0) {
                                        n36 = 255 >> (byte)(n36 >> 28 & 8);
                                    }
                                    nArray2[n34] = n36 | n37 << 8 | n38 << 16 | 0xFF000000;
                                    if (bl2) {
                                        nArray3[n34] = n19;
                                    }
                                }
                                n20 += n31;
                                n21 += n32;
                                n16 += n22;
                                n17 += n23;
                                n18 += n24;
                                n19 += n30;
                            }
                        }
                    }
                    f40 = f46;
                    f41 = f47;
                    f42 = f48;
                    f43 = f49;
                    f44 = f50;
                } while (n13 < n14);
                if (f7 < (float)n5) {
                    frameBuffer.xstart[n] = (int)f7;
                }
                if (n14 > n6) {
                    frameBuffer.xend[n] = n14;
                }
                if (f14 < f17) {
                    f14 = f17;
                }
                if (f14 > f19) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    private final void drawShadedZbufferedFilteredAlphaScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl, int n2, int n3, boolean bl2) {
        float f17;
        if (n3 != 1) {
            float f18 = n3;
            f *= f18;
            f2 *= f18;
            f3 *= f18;
            f4 *= f18;
            f5 *= f18;
            f6 *= f18;
        }
        int[] nArray = texture.texels;
        int[] nArray2 = texture.alpha;
        int[] nArray3 = frameBuffer.pixels;
        int[] nArray4 = frameBuffer.zbuffer;
        int n4 = 0;
        int n5 = frameBuffer.xstart[n];
        int n6 = frameBuffer.xend[n];
        float f19 = frameBuffer.zhigh[n];
        int n7 = frameBuffer.exXstart[n];
        int n8 = frameBuffer.exXend[n];
        float f20 = frameBuffer.exZlow[n];
        int n9 = frameBuffer.exXstart2[n];
        int n10 = frameBuffer.exXend2[n];
        float f21 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f17 = f7;
            f7 = f8;
            f8 = f17;
            f17 = f9;
            f9 = f10;
            f10 = f17;
            f17 = f11;
            f11 = f12;
            f12 = f17;
            f17 = f13;
            f13 = f14;
            f14 = f17;
            f17 = f;
            f = f2;
            f2 = f17;
            f17 = f3;
            f3 = f4;
            f4 = f17;
            f17 = f5;
            f5 = f6;
            f6 = f17;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n8 <= n10) {
                if (n8 >= n9) {
                    n8 = n10;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n9 < n7) {
                        n7 = n9;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f21 < f20) {
                        f20 = f21;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n9 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n10 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f21 = 2.1474836E9f;
                }
            } else if (n10 >= n7) {
                if (n9 < n7) {
                    n7 = n9;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f21 < f20) {
                        f20 = f21;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n9 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n10 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f21 = 2.1474836E9f;
            }
            if (!(Config.spanBasedHsr && (float)n7 <= f7 && (float)n8 >= f8 && f20 >= f13 && f20 >= f14 || (float)n9 <= f7 && (float)n10 >= f8 && f21 >= f13 && f21 >= f14)) {
                float f22;
                float f23;
                float f24;
                float f25;
                float f26;
                float f27;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f17 = f13;
                float f28 = f8 - f7;
                if (f28 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f28 != 0.0f) {
                    float f29 = 1.0f / f28;
                    f27 = (f10 - f9) * f29;
                    f26 = (f12 - f11) * f29;
                    f25 = (f14 - f13) * f29;
                    f24 = (f2 - f) * f29;
                    f23 = (f4 - f3) * f29;
                    f22 = (f6 - f5) * f29;
                } else {
                    f27 = 0.0f;
                    f26 = 0.0f;
                    f25 = 0.0f;
                    f22 = 0.0f;
                    f24 = 0.0f;
                    f23 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f24;
                    f3 += f7 * f23;
                    f5 += f7 * f22;
                    f9 += f7 * f27;
                    f11 += f7 * f26;
                    f13 += f7 * f25;
                    f7 = f15;
                }
                int n11 = n * frameBuffer.width;
                int n12 = (int)f7;
                int n13 = n12 - 1;
                int n14 = (int)f8;
                int n15 = 16;
                float f30 = 16384.0f;
                float f31 = 16384.0f;
                float f32 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f33 = 16.0f * f27;
                float f34 = 16.0f * f26;
                float f35 = 16.0f * f25;
                float f36 = 16.0f * f24;
                float f37 = 16.0f * f23;
                float f38 = 16.0f * f22;
                float f39 = 1.0f / f13;
                float f40 = f9 * f39;
                float f41 = f11 * f39;
                float f42 = f * f39;
                float f43 = f3 * f39;
                float f44 = f5 * f39;
                byte by = texture.shifter;
                int n16 = (int)(f42 * 262144.0f);
                int n17 = (int)(f43 * 262144.0f);
                int n18 = (int)(f44 * 262144.0f);
                int n19 = 0;
                boolean bl3 = false;
                if (Config.zTrick) {
                    n19 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n19 = -n19;
                        bl3 = true;
                    }
                } else {
                    n19 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                int n20 = (int)(f40 * 262144.0f);
                int n21 = (int)(f41 * 262144.0f);
                int n22 = 0;
                int n23 = 0;
                int n24 = 0;
                int n25 = n & 1;
                int n26 = 1 - n25 << 17;
                int n27 = n25 << 17;
                do {
                    n12 = n13 + 1;
                    if ((n13 += n15) > n14) {
                        n15 -= n13 - n14;
                        n13 = n14;
                        if (n15 != 0) {
                            f33 = (float)n15 * f27;
                            f34 = (float)n15 * f26;
                            f35 = (float)n15 * f25;
                            f36 = (float)n15 * f24;
                            f37 = (float)n15 * f23;
                            f38 = (float)n15 * f22;
                            f30 = f31 = multiLU[n15];
                            f32 = Config.zTrick ? multiZTLU[n15] : multiZLU[n15];
                        } else {
                            f33 = 0.0f;
                            f34 = 0.0f;
                            f35 = 0.0f;
                            f36 = 0.0f;
                            f37 = 0.0f;
                            f38 = 0.0f;
                            n15 = 1;
                            f31 = 262144.0f;
                            f30 = 262144.0f;
                            f32 = Config.zTrick ? 2.1474836E9f : 4.2949673E9f;
                        }
                    }
                    float f45 = f13;
                    if (n13 == n14 && f8 < f16 - 1.0f) {
                        f33 = f10 - f9;
                        f34 = f12 - f11;
                        f35 = f14 - f13;
                    }
                    f9 += f33;
                    f11 += f34;
                    f += f36;
                    f3 += f37;
                    f5 += f38;
                    f39 = 1.0f / (f13 += f35);
                    float f46 = f9 * f39;
                    float f47 = f11 * f39;
                    float f48 = f * f39;
                    float f49 = f3 * f39;
                    float f50 = f5 * f39;
                    int n28 = texture.width - 1 << 18;
                    int n29 = texture.height - 1 << 18;
                    int n30 = (int)(f32 * (f13 - f45));
                    if (bl3) {
                        n30 = -n30;
                    }
                    int n31 = (int)(f30 * (f46 - f40));
                    int n32 = (int)(f30 * (f47 - f41));
                    n22 = (int)(f31 * (f48 - f42));
                    n23 = (int)(f31 * (f49 - f43));
                    n24 = (int)(f31 * (f50 - f44));
                    if (Config.spanBasedHsr && (n7 <= n12 && n8 >= n13 && f20 >= f45 && f20 >= f13 || n9 <= n12 && n10 >= n13 && f21 >= f45 && f21 >= f13)) {
                        if (n13 != n14) {
                            n19 += n15 * n30;
                            n20 += n15 * n31;
                            n21 += n15 * n32;
                            n16 += n15 * n22;
                            n17 += n15 * n23;
                            n18 += n15 * n24;
                        }
                    } else {
                        int n33;
                        int n34;
                        int n35;
                        int n36;
                        n4 = n13 + n11;
                        int n37 = 0;
                        int n38 = 0;
                        int n39 = 0;
                        int n40 = 0;
                        int n41 = 0;
                        if (Config.texelFilter) {
                            if (!bl && n31 < 196608 && n31 > -196608 && n32 <= 196608 && n32 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n42 = (n12 & 1) != 0 ? 65536 + n26 : n27;
                            if (!bl3) {
                                for (n36 = n12 + n11; n36 <= n4; ++n36) {
                                    if (n19 > frameBuffer.zbuffer[n36]) {
                                        n35 = ((n20 + n42 & n28) >> 18) + ((n21 + (n42 ^ 0x10000) & n29) >> 18 << by);
                                        n37 = nArray[n35];
                                        n41 = nArray2[n35] >>> 24;
                                        n42 ^= 0x30000;
                                        if (n41 != 0) {
                                            n34 = nArray3[n36];
                                            n40 = n37 >> 16;
                                            n39 = n37 >> 8 & 0xFF;
                                            n38 = n37 & 0xFF;
                                            if (n40 > 255) {
                                                n40 = 255;
                                            }
                                            if (n39 > 255) {
                                                n39 = 255;
                                            }
                                            if (n38 > 255) {
                                                n38 = 255;
                                            }
                                            if ((n41 <<= n2) > 255) {
                                                n41 = 255;
                                            }
                                            n33 = 255 - n41;
                                            n40 = n41 * (n40 * (n16 >> 10) >> 16) + n33 * (n34 >> 16 & 0xFF) >> 8;
                                            n39 = n41 * (n39 * (n17 >> 10) >> 16) + n33 * (n34 >> 8 & 0xFF) >> 8;
                                            n38 = n41 * (n38 * (n18 >> 10) >> 16) + n33 * (n34 & 0xFF) >> 8;
                                            n41 = n41 * n41 + n33 * (n34 >>> 24 & 0xFF) >> 8;
                                            if ((n40 & 0xFFFFFF00) != 0) {
                                                n40 = 255 >> (n40 >> 28 & 8);
                                            }
                                            if ((n39 & 0xFFFFFF00) != 0) {
                                                n39 = 255 >> (n39 >> 28 & 8);
                                            }
                                            if ((n38 & 0xFFFFFF00) != 0) {
                                                n38 = 255 >> (n38 >> 28 & 8);
                                            }
                                            if ((n41 & 0xFFFFFF00) != 0) {
                                                n41 = 255 >> (n41 >> 28 & 8);
                                            }
                                            nArray3[n36] = n38 | n39 << 8 | n40 << 16 | n41 << 24;
                                            if (bl2) {
                                                nArray4[n36] = n19;
                                            }
                                        }
                                    }
                                    n20 += n31;
                                    n21 += n32;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n24;
                                    n19 += n30;
                                }
                            } else {
                                for (n36 = n12 + n11; n36 <= n4; ++n36) {
                                    if (n19 < frameBuffer.zbuffer[n36]) {
                                        n35 = ((n20 + n42 & n28) >> 18) + ((n21 + (n42 ^ 0x10000) & n29) >> 18 << by);
                                        n37 = nArray[n35];
                                        n41 = nArray2[n35] >>> 24;
                                        n42 ^= 0x30000;
                                        if (n41 != 0) {
                                            n34 = nArray3[n36];
                                            n40 = n37 >> 16;
                                            n39 = n37 >> 8 & 0xFF;
                                            n38 = n37 & 0xFF;
                                            if (n40 > 255) {
                                                n40 = 255;
                                            }
                                            if (n39 > 255) {
                                                n39 = 255;
                                            }
                                            if (n38 > 255) {
                                                n38 = 255;
                                            }
                                            if ((n41 <<= n2) > 255) {
                                                n41 = 255;
                                            }
                                            n33 = 255 - n41;
                                            n40 = n41 * (n40 * (n16 >> 10) >> 16) + n33 * (n34 >> 16 & 0xFF) >> 8;
                                            n39 = n41 * (n39 * (n17 >> 10) >> 16) + n33 * (n34 >> 8 & 0xFF) >> 8;
                                            n38 = n41 * (n38 * (n18 >> 10) >> 16) + n33 * (n34 & 0xFF) >> 8;
                                            n41 = n41 * n41 + n33 * (n34 >>> 24 & 0xFF) >> 8;
                                            if ((n40 & 0xFFFFFF00) != 0) {
                                                n40 = 255 >> (n40 >> 28 & 8);
                                            }
                                            if ((n39 & 0xFFFFFF00) != 0) {
                                                n39 = 255 >> (n39 >> 28 & 8);
                                            }
                                            if ((n38 & 0xFFFFFF00) != 0) {
                                                n38 = 255 >> (n38 >> 28 & 8);
                                            }
                                            if ((n41 & 0xFFFFFF00) != 0) {
                                                n41 = 255 >> (n41 >> 28 & 8);
                                            }
                                            nArray3[n36] = n38 | n39 << 8 | n40 << 16 | n41 << 24;
                                            if (bl2) {
                                                nArray4[n36] = n19;
                                            }
                                        }
                                    }
                                    n20 += n31;
                                    n21 += n32;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n24;
                                    n19 += n30;
                                }
                            }
                        } else if (!bl3) {
                            for (n36 = n12 + n11; n36 <= n4; ++n36) {
                                if (nArray4[n36] < n19) {
                                    n35 = ((n20 & n28) >> 18) + ((n21 & n29) >> 18 << by);
                                    n37 = nArray[n35];
                                    n41 = nArray2[n35] >>> 24;
                                    if (n41 != 0) {
                                        n34 = nArray3[n36];
                                        n40 = n37 >> 16;
                                        n39 = n37 >> 8 & 0xFF;
                                        n38 = n37 & 0xFF;
                                        if (n40 > 255) {
                                            n40 = 255;
                                        }
                                        if (n39 > 255) {
                                            n39 = 255;
                                        }
                                        if (n38 > 255) {
                                            n38 = 255;
                                        }
                                        if ((n41 <<= n2) > 255) {
                                            n41 = 255;
                                        }
                                        n33 = 255 - n41;
                                        n40 = n41 * (n40 * (n16 >> 10) >> 16) + n33 * (n34 >> 16 & 0xFF) >> 8;
                                        n39 = n41 * (n39 * (n17 >> 10) >> 16) + n33 * (n34 >> 8 & 0xFF) >> 8;
                                        n38 = n41 * (n38 * (n18 >> 10) >> 16) + n33 * (n34 & 0xFF) >> 8;
                                        n41 = n41 * n41 + n33 * (n34 >>> 24 & 0xFF) >> 8;
                                        if ((n40 & 0xFFFFFF00) != 0) {
                                            n40 = 255 >> (n40 >> 28 & 8);
                                        }
                                        if ((n39 & 0xFFFFFF00) != 0) {
                                            n39 = 255 >> (n39 >> 28 & 8);
                                        }
                                        if ((n38 & 0xFFFFFF00) != 0) {
                                            n38 = 255 >> (n38 >> 28 & 8);
                                        }
                                        if ((n41 & 0xFFFFFF00) != 0) {
                                            n41 = 255 >> (n41 >> 28 & 8);
                                        }
                                        nArray3[n36] = n38 | n39 << 8 | n40 << 16 | n41 << 24;
                                        if (bl2) {
                                            nArray4[n36] = n19;
                                        }
                                    }
                                }
                                n20 += n31;
                                n21 += n32;
                                n16 += n22;
                                n17 += n23;
                                n18 += n24;
                                n19 += n30;
                            }
                        } else {
                            for (n36 = n12 + n11; n36 <= n4; ++n36) {
                                if (nArray4[n36] > n19) {
                                    n35 = ((n20 & n28) >> 18) + ((n21 & n29) >> 18 << by);
                                    n37 = nArray[n35];
                                    n41 = nArray2[n35] >>> 24;
                                    if (n41 != 0) {
                                        n34 = nArray3[n36];
                                        n40 = n37 >> 16;
                                        n39 = n37 >> 8 & 0xFF;
                                        n38 = n37 & 0xFF;
                                        if (n40 > 255) {
                                            n40 = 255;
                                        }
                                        if (n39 > 255) {
                                            n39 = 255;
                                        }
                                        if (n38 > 255) {
                                            n38 = 255;
                                        }
                                        if ((n41 <<= n2) > 255) {
                                            n41 = 255;
                                        }
                                        n33 = 255 - n41;
                                        n40 = n41 * (n40 * (n16 >> 10) >> 16) + n33 * (n34 >> 16 & 0xFF) >> 8;
                                        n39 = n41 * (n39 * (n17 >> 10) >> 16) + n33 * (n34 >> 8 & 0xFF) >> 8;
                                        n38 = n41 * (n38 * (n18 >> 10) >> 16) + n33 * (n34 & 0xFF) >> 8;
                                        n41 = n41 * n41 + n33 * (n34 >>> 24 & 0xFF) >> 8;
                                        if ((n40 & 0xFFFFFF00) != 0) {
                                            n40 = 255 >> (n40 >> 28 & 8);
                                        }
                                        if ((n39 & 0xFFFFFF00) != 0) {
                                            n39 = 255 >> (n39 >> 28 & 8);
                                        }
                                        if ((n38 & 0xFFFFFF00) != 0) {
                                            n38 = 255 >> (n38 >> 28 & 8);
                                        }
                                        if ((n41 & 0xFFFFFF00) != 0) {
                                            n41 = 255 >> (n41 >> 28 & 8);
                                        }
                                        nArray3[n36] = n38 | n39 << 8 | n40 << 16 | n41 << 24;
                                        if (bl2) {
                                            nArray4[n36] = n19;
                                        }
                                    }
                                }
                                n20 += n31;
                                n21 += n32;
                                n16 += n22;
                                n17 += n23;
                                n18 += n24;
                                n19 += n30;
                            }
                        }
                    }
                    f40 = f46;
                    f41 = f47;
                    f42 = f48;
                    f43 = f49;
                    f44 = f50;
                } while (n13 < n14);
                if (f7 < (float)n5) {
                    frameBuffer.xstart[n] = (int)f7;
                }
                if (n14 > n6) {
                    frameBuffer.xend[n] = n14;
                }
                if (f14 < f17) {
                    f14 = f17;
                }
                if (f14 > f19) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    private final void drawShadedZbufferedFilteredAdditiveAlphaScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl, int n2, int n3, boolean bl2) {
        float f17;
        if (n3 != 1) {
            float f18 = n3;
            f *= f18;
            f2 *= f18;
            f3 *= f18;
            f4 *= f18;
            f5 *= f18;
            f6 *= f18;
        }
        int[] nArray = texture.texels;
        int[] nArray2 = texture.alpha;
        int[] nArray3 = frameBuffer.pixels;
        int[] nArray4 = frameBuffer.zbuffer;
        int n4 = 0;
        int n5 = frameBuffer.xstart[n];
        int n6 = frameBuffer.xend[n];
        float f19 = frameBuffer.zhigh[n];
        int n7 = frameBuffer.exXstart[n];
        int n8 = frameBuffer.exXend[n];
        float f20 = frameBuffer.exZlow[n];
        int n9 = frameBuffer.exXstart2[n];
        int n10 = frameBuffer.exXend2[n];
        float f21 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f17 = f7;
            f7 = f8;
            f8 = f17;
            f17 = f9;
            f9 = f10;
            f10 = f17;
            f17 = f11;
            f11 = f12;
            f12 = f17;
            f17 = f13;
            f13 = f14;
            f14 = f17;
            f17 = f;
            f = f2;
            f2 = f17;
            f17 = f3;
            f3 = f4;
            f4 = f17;
            f17 = f5;
            f5 = f6;
            f6 = f17;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n8 <= n10) {
                if (n8 >= n9) {
                    n8 = n10;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n9 < n7) {
                        n7 = n9;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f21 < f20) {
                        f20 = f21;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n9 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n10 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f21 = 2.1474836E9f;
                }
            } else if (n10 >= n7) {
                if (n9 < n7) {
                    n7 = n9;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f21 < f20) {
                        f20 = f21;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n9 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n10 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f21 = 2.1474836E9f;
            }
            if (!(Config.spanBasedHsr && (float)n7 <= f7 && (float)n8 >= f8 && f20 >= f13 && f20 >= f14 || (float)n9 <= f7 && (float)n10 >= f8 && f21 >= f13 && f21 >= f14)) {
                float f22;
                float f23;
                float f24;
                float f25;
                float f26;
                float f27;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f17 = f13;
                float f28 = f8 - f7;
                if (f28 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f28 != 0.0f) {
                    float f29 = 1.0f / f28;
                    f27 = (f10 - f9) * f29;
                    f26 = (f12 - f11) * f29;
                    f25 = (f14 - f13) * f29;
                    f24 = (f2 - f) * f29;
                    f23 = (f4 - f3) * f29;
                    f22 = (f6 - f5) * f29;
                } else {
                    f27 = 0.0f;
                    f26 = 0.0f;
                    f25 = 0.0f;
                    f22 = 0.0f;
                    f24 = 0.0f;
                    f23 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f24;
                    f3 += f7 * f23;
                    f5 += f7 * f22;
                    f9 += f7 * f27;
                    f11 += f7 * f26;
                    f13 += f7 * f25;
                    f7 = f15;
                }
                int n11 = n * frameBuffer.width;
                int n12 = (int)f7;
                int n13 = n12 - 1;
                int n14 = (int)f8;
                int n15 = 16;
                float f30 = 16384.0f;
                float f31 = 16384.0f;
                float f32 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f33 = 16.0f * f27;
                float f34 = 16.0f * f26;
                float f35 = 16.0f * f25;
                float f36 = 16.0f * f24;
                float f37 = 16.0f * f23;
                float f38 = 16.0f * f22;
                float f39 = 1.0f / f13;
                float f40 = f9 * f39;
                float f41 = f11 * f39;
                float f42 = f * f39;
                float f43 = f3 * f39;
                float f44 = f5 * f39;
                byte by = texture.shifter;
                int n16 = (int)(f42 * 262144.0f);
                int n17 = (int)(f43 * 262144.0f);
                int n18 = (int)(f44 * 262144.0f);
                int n19 = 0;
                boolean bl3 = false;
                if (Config.zTrick) {
                    n19 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n19 = -n19;
                        bl3 = true;
                    }
                } else {
                    n19 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                int n20 = (int)(f40 * 262144.0f);
                int n21 = (int)(f41 * 262144.0f);
                int n22 = 0;
                int n23 = 0;
                int n24 = 0;
                int n25 = n & 1;
                int n26 = 1 - n25 << 17;
                int n27 = n25 << 17;
                do {
                    n12 = n13 + 1;
                    if ((n13 += n15) > n14) {
                        n15 -= n13 - n14;
                        n13 = n14;
                        if (n15 != 0) {
                            f33 = (float)n15 * f27;
                            f34 = (float)n15 * f26;
                            f35 = (float)n15 * f25;
                            f36 = (float)n15 * f24;
                            f37 = (float)n15 * f23;
                            f38 = (float)n15 * f22;
                            f30 = f31 = multiLU[n15];
                            f32 = Config.zTrick ? multiZTLU[n15] : multiZLU[n15];
                        } else {
                            f33 = 0.0f;
                            f34 = 0.0f;
                            f35 = 0.0f;
                            f36 = 0.0f;
                            f37 = 0.0f;
                            f38 = 0.0f;
                            n15 = 1;
                            f31 = 262144.0f;
                            f30 = 262144.0f;
                            f32 = Config.zTrick ? 2.1474836E9f : 4.2949673E9f;
                        }
                    }
                    float f45 = f13;
                    if (n13 == n14 && f8 < f16 - 1.0f) {
                        f33 = f10 - f9;
                        f34 = f12 - f11;
                        f35 = f14 - f13;
                    }
                    f9 += f33;
                    f11 += f34;
                    f += f36;
                    f3 += f37;
                    f5 += f38;
                    f39 = 1.0f / (f13 += f35);
                    float f46 = f9 * f39;
                    float f47 = f11 * f39;
                    float f48 = f * f39;
                    float f49 = f3 * f39;
                    float f50 = f5 * f39;
                    int n28 = texture.width - 1 << 18;
                    int n29 = texture.height - 1 << 18;
                    int n30 = (int)(f32 * (f13 - f45));
                    if (bl3) {
                        n30 = -n30;
                    }
                    int n31 = (int)(f30 * (f46 - f40));
                    int n32 = (int)(f30 * (f47 - f41));
                    n22 = (int)(f31 * (f48 - f42));
                    n23 = (int)(f31 * (f49 - f43));
                    n24 = (int)(f31 * (f50 - f44));
                    if (Config.spanBasedHsr && (n7 <= n12 && n8 >= n13 && f20 >= f45 && f20 >= f13 || n9 <= n12 && n10 >= n13 && f21 >= f45 && f21 >= f13)) {
                        if (n13 != n14) {
                            n19 += n15 * n30;
                            n20 += n15 * n31;
                            n21 += n15 * n32;
                            n16 += n15 * n22;
                            n17 += n15 * n23;
                            n18 += n15 * n24;
                        }
                    } else {
                        int n33;
                        int n34;
                        int n35;
                        n4 = n13 + n11;
                        int n36 = 0;
                        int n37 = 0;
                        int n38 = 0;
                        int n39 = 0;
                        int n40 = 0;
                        if (Config.texelFilter) {
                            if (!bl && n31 < 196608 && n31 > -196608 && n32 <= 196608 && n32 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n41 = (n12 & 1) != 0 ? 65536 + n26 : n27;
                            if (!bl3) {
                                for (n35 = n12 + n11; n35 <= n4; ++n35) {
                                    if (n19 > frameBuffer.zbuffer[n35]) {
                                        n34 = ((n20 + n41 & n28) >> 18) + ((n21 + (n41 ^ 0x10000) & n29) >> 18 << by);
                                        n36 = nArray[n34];
                                        n40 = nArray2[n34] >>> 24;
                                        n41 ^= 0x30000;
                                        if (n40 != 0) {
                                            n33 = nArray3[n35];
                                            n39 = n36 >> 16 << n2;
                                            n38 = (n36 >> 8 & 0xFF) << n2;
                                            n37 = (n36 & 0xFF) << n2;
                                            if (n39 > 255) {
                                                n39 = 255;
                                            }
                                            if (n38 > 255) {
                                                n38 = 255;
                                            }
                                            if (n37 > 255) {
                                                n37 = 255;
                                            }
                                            n39 = (n40 * (n39 * (n16 >> 10) >> 16) >> 8) + (n33 >> 16 & 0xFF);
                                            n38 = (n40 * (n38 * (n17 >> 10) >> 16) >> 8) + (n33 >> 8 & 0xFF);
                                            n37 = (n40 * (n37 * (n18 >> 10) >> 16) >> 8) + (n33 & 0xFF);
                                            if ((n39 & 0xFFFFFF00) != 0) {
                                                n39 = 255 >> (n39 >> 28 & 8);
                                            }
                                            if ((n38 & 0xFFFFFF00) != 0) {
                                                n38 = 255 >> (n38 >> 28 & 8);
                                            }
                                            if ((n37 & 0xFFFFFF00) != 0) {
                                                n37 = 255 >> (n37 >> 28 & 8);
                                            }
                                            if ((n40 & 0xFFFFFF00) != 0) {
                                                n40 = 255 >> (n40 >> 28 & 8);
                                            }
                                            nArray3[n35] = n37 | n38 << 8 | n39 << 16 | n40 << 24;
                                            if (bl2) {
                                                nArray4[n35] = n19;
                                            }
                                        }
                                    }
                                    n20 += n31;
                                    n21 += n32;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n24;
                                    n19 += n30;
                                }
                            } else {
                                for (n35 = n12 + n11; n35 <= n4; ++n35) {
                                    if (n19 < frameBuffer.zbuffer[n35]) {
                                        n34 = ((n20 + n41 & n28) >> 18) + ((n21 + (n41 ^ 0x10000) & n29) >> 18 << by);
                                        n36 = nArray[n34];
                                        n40 = nArray2[n34] >>> 24;
                                        n41 ^= 0x30000;
                                        if (n40 != 0) {
                                            n33 = nArray3[n35];
                                            n39 = n36 >> 16 << n2;
                                            n38 = (n36 >> 8 & 0xFF) << n2;
                                            n37 = (n36 & 0xFF) << n2;
                                            if (n39 > 255) {
                                                n39 = 255;
                                            }
                                            if (n38 > 255) {
                                                n38 = 255;
                                            }
                                            if (n37 > 255) {
                                                n37 = 255;
                                            }
                                            n39 = (n40 * (n39 * (n16 >> 10) >> 16) >> 8) + (n33 >> 16 & 0xFF);
                                            n38 = (n40 * (n38 * (n17 >> 10) >> 16) >> 8) + (n33 >> 8 & 0xFF);
                                            n37 = (n40 * (n37 * (n18 >> 10) >> 16) >> 8) + (n33 & 0xFF);
                                            if ((n39 & 0xFFFFFF00) != 0) {
                                                n39 = 255 >> (n39 >> 28 & 8);
                                            }
                                            if ((n38 & 0xFFFFFF00) != 0) {
                                                n38 = 255 >> (n38 >> 28 & 8);
                                            }
                                            if ((n37 & 0xFFFFFF00) != 0) {
                                                n37 = 255 >> (n37 >> 28 & 8);
                                            }
                                            if ((n40 & 0xFFFFFF00) != 0) {
                                                n40 = 255 >> (n40 >> 28 & 8);
                                            }
                                            nArray3[n35] = n37 | n38 << 8 | n39 << 16 | n40 << 24;
                                            if (bl2) {
                                                nArray4[n35] = n19;
                                            }
                                        }
                                    }
                                    n20 += n31;
                                    n21 += n32;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n24;
                                    n19 += n30;
                                }
                            }
                        } else if (!bl3) {
                            for (n35 = n12 + n11; n35 <= n4; ++n35) {
                                if (nArray4[n35] < n19) {
                                    n34 = ((n20 & n28) >> 18) + ((n21 & n29) >> 18 << by);
                                    n36 = nArray[n34];
                                    n40 = nArray2[n34] >>> 24;
                                    if (n40 != 0) {
                                        n33 = nArray3[n35];
                                        n39 = n36 >> 16 << n2;
                                        n38 = (n36 >> 8 & 0xFF) << n2;
                                        n37 = (n36 & 0xFF) << n2;
                                        if (n39 > 255) {
                                            n39 = 255;
                                        }
                                        if (n38 > 255) {
                                            n38 = 255;
                                        }
                                        if (n37 > 255) {
                                            n37 = 255;
                                        }
                                        n39 = (n40 * (n39 * (n16 >> 10) >> 16) >> 8) + (n33 >> 16 & 0xFF);
                                        n38 = (n40 * (n38 * (n17 >> 10) >> 16) >> 8) + (n33 >> 8 & 0xFF);
                                        n37 = (n40 * (n37 * (n18 >> 10) >> 16) >> 8) + (n33 & 0xFF);
                                        if ((n39 & 0xFFFFFF00) != 0) {
                                            n39 = 255 >> (n39 >> 28 & 8);
                                        }
                                        if ((n38 & 0xFFFFFF00) != 0) {
                                            n38 = 255 >> (n38 >> 28 & 8);
                                        }
                                        if ((n37 & 0xFFFFFF00) != 0) {
                                            n37 = 255 >> (n37 >> 28 & 8);
                                        }
                                        if ((n40 & 0xFFFFFF00) != 0) {
                                            n40 = 255 >> (n40 >> 28 & 8);
                                        }
                                        nArray3[n35] = n37 | n38 << 8 | n39 << 16 | n40 << 24;
                                        if (bl2) {
                                            nArray4[n35] = n19;
                                        }
                                    }
                                }
                                n20 += n31;
                                n21 += n32;
                                n16 += n22;
                                n17 += n23;
                                n18 += n24;
                                n19 += n30;
                            }
                        } else {
                            for (n35 = n12 + n11; n35 <= n4; ++n35) {
                                if (nArray4[n35] > n19) {
                                    n34 = ((n20 & n28) >> 18) + ((n21 & n29) >> 18 << by);
                                    n36 = nArray[n34];
                                    n40 = nArray2[n34] >>> 24;
                                    if (n40 != 0) {
                                        n33 = nArray3[n35];
                                        n39 = n36 >> 16 << n2;
                                        n38 = (n36 >> 8 & 0xFF) << n2;
                                        n37 = (n36 & 0xFF) << n2;
                                        if (n39 > 255) {
                                            n39 = 255;
                                        }
                                        if (n38 > 255) {
                                            n38 = 255;
                                        }
                                        if (n37 > 255) {
                                            n37 = 255;
                                        }
                                        n39 = (n40 * (n39 * (n16 >> 10) >> 16) >> 8) + (n33 >> 16 & 0xFF);
                                        n38 = (n40 * (n38 * (n17 >> 10) >> 16) >> 8) + (n33 >> 8 & 0xFF);
                                        n37 = (n40 * (n37 * (n18 >> 10) >> 16) >> 8) + (n33 & 0xFF);
                                        if ((n39 & 0xFFFFFF00) != 0) {
                                            n39 = 255 >> (n39 >> 28 & 8);
                                        }
                                        if ((n38 & 0xFFFFFF00) != 0) {
                                            n38 = 255 >> (n38 >> 28 & 8);
                                        }
                                        if ((n37 & 0xFFFFFF00) != 0) {
                                            n37 = 255 >> (n37 >> 28 & 8);
                                        }
                                        if ((n40 & 0xFFFFFF00) != 0) {
                                            n40 = 255 >> (n40 >> 28 & 8);
                                        }
                                        nArray3[n35] = n37 | n38 << 8 | n39 << 16 | n40 << 24;
                                        if (bl2) {
                                            nArray4[n35] = n19;
                                        }
                                    }
                                }
                                n20 += n31;
                                n21 += n32;
                                n16 += n22;
                                n17 += n23;
                                n18 += n24;
                                n19 += n30;
                            }
                        }
                    }
                    f40 = f46;
                    f41 = f47;
                    f42 = f48;
                    f43 = f49;
                    f44 = f50;
                } while (n13 < n14);
                if (f7 < (float)n5) {
                    frameBuffer.xstart[n] = (int)f7;
                }
                if (n14 > n6) {
                    frameBuffer.xend[n] = n14;
                }
                if (f14 < f17) {
                    f14 = f17;
                }
                if (f14 > f19) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    public VideoMode[] getAvailableVideoModes() {
        return new VideoMode[0];
    }

    public boolean isInitialized() {
        return true;
    }

    static {
        for (int i = 1; i < 17; ++i) {
            SoftGLRenderer.multiLU[i] = 262144.0f / (float)i;
            SoftGLRenderer.multiZTLU[i] = 2.1474836E9f / (float)i;
            SoftGLRenderer.multiZLU[i] = 4.2949673E9f / (float)i;
        }
    }

    private final class MyWorkLoad
    implements WorkLoad {
        private int ystart = 0;
        private int yend = 0;
        private int start = 0;
        private int end = 0;
        private FrameBuffer buffer = null;
        private World world = null;
        private VisList visList;
        private int part = 0;
        private int parts = 1;

        public MyWorkLoad(int n, int n2) {
            this.part = n;
            this.parts = n2;
        }

        public void set(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
            this.start = n;
            this.end = n2;
            this.buffer = frameBuffer;
            this.world = world;
            this.visList = visList;
            float f = (float)frameBuffer.height / (float)this.parts;
            this.ystart = (int)(f * (float)this.part);
            this.yend = (int)(f * ((float)this.part + 1.0f));
            if (this.part == this.parts - 1) {
                this.yend = frameBuffer.height;
            }
            if (Config.loadBalancingStrategy > 0) {
                if (frameBuffer.sliStart == null) {
                    frameBuffer.sliStart = new int[this.parts];
                    frameBuffer.sliTimes = new long[this.parts];
                    frameBuffer.sliStart[this.part] = this.ystart;
                }
                if (this.part != 0 && frameBuffer.sliStart[this.part] == 0) {
                    frameBuffer.sliStart[this.part] = this.ystart;
                }
                this.ystart = frameBuffer.sliStart[this.part];
                if (this.part < this.parts - 1 && frameBuffer.sliStart[this.part + 1] != 0) {
                    this.yend = frameBuffer.sliStart[this.part + 1];
                }
            }
        }

        public void doWork() {
            int n;
            for (n = this.start; n <= this.end; ++n) {
                SoftGLRenderer.this.drawPolygon(this.visList, n, this.buffer, this.world, this.ystart, this.yend);
            }
            if (Config.mtDebug) {
                for (n = 0; n < 100; ++n) {
                    this.buffer.pixels[this.ystart * this.buffer.width + n] = 0xFFFFFF;
                }
            }
            if (Config.loadBalancingStrategy > 0) {
                long l = this.buffer.versionHelper.getTime();
                long l2 = this.buffer.sliTimes[this.part];
                if (l2 == 0L) {
                    l2 = l;
                }
                this.buffer.sliTimes[this.part] = l + l2 >> 1;
            }
        }

        public void done() {
        }

        public void error(Exception exception) {
        }
    }
}

