/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Logger;

public class VertexAttributes {
    public static final int TYPE_SINGLE_FLOATS = 1;
    public static final int TYPE_TWO_FLOATS = 2;
    public static final int TYPE_THREE_FLOATS = 3;
    public static final int TYPE_FOUR_FLOATS = 4;
    float[] data;
    int type;
    boolean updated = false;
    String name;
    boolean dynamic = false;

    public VertexAttributes(String string, float[] fArray, int n) {
        this.data = new float[fArray.length];
        System.arraycopy(fArray, 0, this.data, 0, fArray.length);
        this.type = n;
        this.updated = true;
        this.name = string;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean bl) {
        this.dynamic = bl;
    }

    public void update(float[] fArray, int n) {
        if (!this.dynamic) {
            Logger.log("VertexAttributes haven't been defined as dynamic!", 0);
            return;
        }
        int n2 = fArray.length;
        if (n >= 0 && n + n2 <= this.data.length) {
            System.arraycopy(fArray, 0, this.data, n, n2);
            this.updated = true;
        } else {
            Logger.log("Invalid size: " + n + "/" + n2, 0);
        }
    }

    public boolean matches(int n) {
        return (float)this.data.length / (float)this.type == (float)n;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }
}

