/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Camera;
import com.threed.jpct.CollisionInfo;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.GLSLShader;
import com.threed.jpct.IRenderer;
import com.threed.jpct.IntegerC;
import com.threed.jpct.Lights;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Mesh;
import com.threed.jpct.Object3D;
import com.threed.jpct.Object3DList;
import com.threed.jpct.Plane;
import com.threed.jpct.Polyline;
import com.threed.jpct.Portals;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.TextureManager;
import com.threed.jpct.VisList;
import com.threed.jpct.VisListManager;
import com.threed.jpct.WorldProcessor;
import com.threed.jpct.util.Overlay;
import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class World
implements Serializable {
    private static final long serialVersionUID = 5L;
    public static final int MAIN_OBJECT_NOT_SET = -1;
    public static final int FOGGING_DISABLED = 0;
    public static final int FOGGING_ENABLED = 1;
    public static final int FOGGING_PER_VERTEX = 2;
    public static final int FOGGING_PER_PIXEL = 1;
    private static final Boolean TRUE_LOCK = Boolean.TRUE;
    private static final Boolean FALSE_LOCK = Boolean.FALSE;
    private static VisList staticVisList = null;
    private static Object3D staticClippedPolys = null;
    static Thread defaultThread = null;
    Object3DList objectList;
    VisList visList;
    Camera camera;
    Lights lights;
    Portals portals;
    Object3D clippedPolys;
    long drawCnt = 0L;
    int mainWorld = -1;
    boolean useFogging = false;
    int fogModeChanged = 0;
    boolean perPixelFogging = false;
    float fogStart = 1.0f;
    float fogDistance = 150.0f;
    float fogColorR = 0.0f;
    float fogColorG = 0.0f;
    float fogColorB = 0.0f;
    int ambientRed = 100;
    int ambientGreen = 100;
    int ambientBlue = 100;
    boolean invertCulling = false;
    transient GLSLShader globalShader = null;
    private Boolean lock;
    private int wasLocked;
    private transient VisListManager vlManager = new VisListManager();
    private transient Object3DList targets = null;
    private boolean disposed = false;
    private transient WorldProcessor processor = null;
    private transient boolean calledRender = false;
    private Vector lines = null;

    public World() {
        this.objectList = new Object3DList();
        int n = Config.polygonBufferSize;
        if (n == -1) {
            n = Config.maxPolysVisible;
        }
        if (!Config.shareVisibilityList) {
            this.visList = new VisList(Config.maxPolysVisible);
            this.clippedPolys = new Object3D(n);
        } else {
            if (staticVisList == null) {
                staticVisList = new VisList(Config.maxPolysVisible);
                staticClippedPolys = new Object3D(n);
            }
            this.visList = staticVisList;
            this.clippedPolys = staticClippedPolys;
        }
        this.clippedPolys.objVectors.createScreenColors();
        this.addObject(this.clippedPolys);
        this.portals = new Portals();
        this.portals.portalsObj.hasPortals = true;
        this.addObject(this.portals.portalsObj);
        this.camera = new Camera();
        this.lights = new Lights(Config.maxLights);
        this.lock = FALSE_LOCK;
        this.wasLocked = 0;
    }

    public void dispose() {
        this.disposed = true;
        if (this.vlManager != null) {
            this.vlManager.dispose();
        }
    }

    public synchronized void lockMatrices() {
        while (this.lock.booleanValue()) {
            ++this.wasLocked;
            try {
                if (Config.lockingTimer > 0) {
                    Thread.sleep(Config.lockingTimer);
                    continue;
                }
                Thread.yield();
            }
            catch (Exception exception) {}
        }
        this.lock = TRUE_LOCK;
    }

    public void unlockMatrices() {
        if (!this.lock.booleanValue()) {
            Logger.log("Tried to unlock already unlocked matrices!", 0);
        }
        this.lock = FALSE_LOCK;
    }

    public Lights getLights() {
        return this.lights;
    }

    public int getSize() {
        return this.objectList.size() - 2;
    }

    public void setMainObjectID(int n) {
        Object3D object3D = this.getObject(n);
        object3D.setThisAsMain();
        this.mainWorld = n;
    }

    public int getMainObjectID() {
        return this.mainWorld;
    }

    public Object3D getMainObject() {
        if (this.mainWorld != -1) {
            return this.getObject(this.mainWorld);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Camera getCamera() {
        Camera camera = this.camera;
        synchronized (camera) {
            return this.camera;
        }
    }

    public Portals getPortals() {
        return this.portals;
    }

    public VisList getVisibilityList() {
        return this.visList;
    }

    public void decoupleVisibilityList() {
        this.visList = new VisList(Config.maxPolysVisible);
        int n = Config.polygonBufferSize;
        if (n == -1) {
            n = Config.maxPolysVisible;
        }
        this.clippedPolys = new Object3D(n);
    }

    public void newCamera() {
        this.camera = new Camera();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraTo(Camera camera) {
        Camera camera2 = this.camera;
        synchronized (camera2) {
            this.camera = camera;
        }
    }

    public void invertCulling(boolean bl) {
        this.invertCulling = bl;
    }

    public int getCameraSector() {
        return this.portals.getCurrentSector(this.getMainObject(), this.camera.frontBx, this.camera.frontBy, this.camera.frontBz);
    }

    public synchronized void removeObject(int n) {
        boolean bl = false;
        n += 2;
        for (int i = 0; i < this.objectList.size(); ++i) {
            if (this.objectList.elementAt((int)i).number != n) continue;
            bl = true;
            this.objectList.elementAt((int)i).myWorld = null;
            this.objectList.removeElementAt(i);
            break;
        }
        if (!bl) {
            Logger.log("Can't remove object #" + (n - 2) + "!", 0);
        }
    }

    public synchronized void removeObject(Object3D object3D) {
        if (!this.objectList.removeElement(object3D)) {
            if (object3D.getUserObject() == null || !(object3D.getUserObject() instanceof Overlay)) {
                Logger.log("Can't remove object #" + object3D.getID() + "!", 0);
            }
        } else {
            object3D.myWorld = null;
        }
    }

    public Object3D getObject(int n) {
        n += 2;
        for (int i = 0; i < this.objectList.size(); ++i) {
            if (this.objectList.elementAt((int)i).number != n) continue;
            return this.objectList.elementAt(i);
        }
        Logger.log("Can't retrieve object #" + (n - 2) + "!", 0);
        return null;
    }

    public boolean containsObject(Object3D object3D) {
        for (int i = 0; i < this.objectList.size(); ++i) {
            if (this.objectList.elementAt(i) != object3D) continue;
            return true;
        }
        return false;
    }

    public Object3D getObjectByName(String string) {
        return this.getInternalObjectByName(string);
    }

    public synchronized int addObject(Object3D object3D) {
        if (object3D == null) {
            Logger.log("Can't assign 'null' to a World!", 0);
            return -100;
        }
        if (object3D.myWorld == this && this.objectList.contains(object3D)) {
            Logger.log("Object '" + object3D.getName() + "' already belongs to this world!", 1);
            return object3D.getID();
        }
        this.objectList.addElement(object3D);
        object3D.myWorld = this;
        return object3D.getID();
    }

    public synchronized void addObjects(Object3D[] object3DArray) {
        for (int i = 0; i < object3DArray.length; ++i) {
            this.addObject(object3DArray[i]);
        }
    }

    public int addLight(SimpleVector simpleVector, float f, float f2, float f3) {
        return this.lights.addLight(simpleVector.x, simpleVector.y, simpleVector.z, f, f2, f3);
    }

    public int addLight(SimpleVector simpleVector, Color color) {
        return this.lights.addLight(simpleVector.x, simpleVector.y, simpleVector.z, color.getRed(), color.getGreen(), color.getBlue());
    }

    public void removeLight(int n) {
        this.lights.remove(n);
    }

    public void setLightRotation(int n, SimpleVector simpleVector, float f, float f2, float f3) {
        this.lights.setAutoRotation(n, simpleVector.x, simpleVector.y, simpleVector.z, f, f2, f3);
    }

    public void setLightRotation(int n, float f, float f2, float f3) {
        this.lights.setAutoRotation(n, f, f2, f3);
    }

    public void setLightPosition(int n, SimpleVector simpleVector) {
        this.lights.setPosition(n, simpleVector.x, simpleVector.y, simpleVector.z);
    }

    public void setLightVisibility(int n, boolean bl) {
        this.lights.setVisibility(n, bl);
    }

    public void setLightDiscardDistance(int n, float f) {
        this.lights.setDiscardDistance(n, f);
    }

    public void setLightDistanceOverride(int n, float f) {
        this.lights.setDistanceOverride(n, f);
    }

    public float getLightDistanceOverride(int n) {
        return this.lights.getDistanceOverride(n);
    }

    public void setLightAttenuation(int n, float f) {
        this.lights.setAttenuation(n, f);
    }

    public void setLightIntensity(int n, float f, float f2, float f3) {
        this.lights.setLightIntensity(n, f, f2, f3);
    }

    public float getLightAttenuation(int n) {
        return this.lights.getAttenuation(n);
    }

    public float getLightDiscardDistance(int n) {
        return this.lights.discardDistance[n];
    }

    public SimpleVector getLightPosition(int n) {
        return this.lights.getPosition(n);
    }

    public SimpleVector getLightIntensity(int n) {
        return this.lights.getIntensity(n);
    }

    public void setWorldProcessor(WorldProcessor worldProcessor) {
        if (this.processor != null && worldProcessor != this.processor) {
            this.processor.dispose();
        }
        this.processor = worldProcessor;
    }

    public void setAmbientLight(int n, int n2, int n3) {
        this.ambientRed = n;
        this.ambientGreen = n2;
        this.ambientBlue = n3;
    }

    public int[] getAmbientLight() {
        return new int[]{this.ambientRed, this.ambientGreen, this.ambientBlue};
    }

    public void setFogging(int n) {
        boolean bl = this.useFogging = n == 1;
        if (this.perPixelFogging) {
            this.fogModeChanged = this.useFogging ? 1 : 2;
        }
    }

    public void setFoggingMode(int n) {
        if (n == 1) {
            if (this.useFogging) {
                this.fogModeChanged = 1;
            }
            this.perPixelFogging = true;
        } else {
            if (this.perPixelFogging) {
                this.fogModeChanged = 2;
            }
            this.perPixelFogging = false;
        }
    }

    public int getFogging() {
        if (this.useFogging) {
            return 1;
        }
        return 0;
    }

    public int getFoggingMode() {
        if (this.perPixelFogging) {
            return 1;
        }
        return 2;
    }

    public void setFogParameters(float f, float f2, float f3, float f4) {
        this.setFogParameters(-999.0f, f, f2, f3, f4);
    }

    public void setFogParameters(float f, float f2, float f3, float f4, float f5) {
        if (this.perPixelFogging && this.useFogging) {
            this.fogModeChanged = 1;
        }
        if (f != -999.0f) {
            this.fogStart = f;
        }
        this.fogDistance = Math.max(f2, 1.0f);
        this.fogColorR = f3;
        this.fogColorG = f4;
        this.fogColorB = f5;
    }

    public int checkCollision(SimpleVector simpleVector, SimpleVector simpleVector2, float f) {
        return this.checkSomeCollision(simpleVector.toArray(), simpleVector2.normalize().toArray(), f, null);
    }

    public SimpleVector checkCollisionSpherical(SimpleVector simpleVector, SimpleVector simpleVector2, float f) {
        return this.checkSomeCollisionSpherical(simpleVector.toArray(), simpleVector2.toArray(), f, null);
    }

    public SimpleVector checkCollisionEllipsoid(SimpleVector simpleVector, SimpleVector simpleVector2, SimpleVector simpleVector3, int n) {
        if (n < 1) {
            n = 1;
        }
        return this.checkSomeCollisionEllipsoid(simpleVector, simpleVector2, simpleVector3, null, n);
    }

    public boolean checkCameraCollision(int n, float f) {
        return this.checkCameraCollision(null, n, f, 3.0f, true);
    }

    public boolean checkCameraCollision(int n, float f, boolean bl) {
        return this.checkCameraCollision(null, n, f, 3.0f, bl);
    }

    public boolean checkCameraCollision(int n, float f, float f2, boolean bl) {
        return this.checkCameraCollision(null, n, f, f2, bl);
    }

    public boolean checkCameraCollision(SimpleVector simpleVector, float f, float f2, boolean bl) {
        return this.checkCameraCollision(simpleVector, -1, f, f2, bl);
    }

    public Object[] calcMinDistanceAndObject3D(SimpleVector simpleVector, SimpleVector simpleVector2, float f) {
        Object3D object3D = null;
        Object3D object3D2 = null;
        float f2 = Float.MAX_VALUE;
        int n = this.objectList.size();
        for (int i = 2; i < n; ++i) {
            float f3;
            object3D = this.objectList.elementAt(i);
            object3D.wasCollider = false;
            if (!object3D.isPotentialCollider || !object3D.isVisible || !object3D.isMainWorld && object3D.oneSectorOnly && Config.useFastCollisionDetection && object3D.hasBoundingBox && !(object3D.rayIntersectsAABB(simpleVector, simpleVector2, true) < f) || !((f3 = object3D.calcMinDistance(simpleVector, simpleVector2, f, false)) < f2) || f3 == 1.0E12f) continue;
            if (object3D2 != null) {
                object3D2.wasCollider = false;
            }
            f2 = f3;
            object3D2 = object3D;
        }
        if (f2 != Float.MAX_VALUE && f2 != 1.0E12f) {
            SimpleVector simpleVector3 = new SimpleVector(simpleVector2);
            simpleVector3.scalarMul(f2);
            simpleVector3.add(new SimpleVector(simpleVector));
            object3D2.notifyCollisionListeners(0, 0, new Object3D[]{object3D2}, simpleVector3);
            object3D2.wasCollider = true;
            return new Object[]{new Float(f2), object3D2};
        }
        return new Object[]{new Float(1.0E12f), null};
    }

    public float calcMinDistance(SimpleVector simpleVector, SimpleVector simpleVector2, float f) {
        Object[] objectArray = this.calcMinDistanceAndObject3D(simpleVector, simpleVector2, f);
        if (objectArray != null && objectArray.length > 0) {
            return ((Float)objectArray[0]).floatValue();
        }
        return 1.0E12f;
    }

    public boolean checkCameraCollisionSpherical(int n, float f, float f2, boolean bl) {
        return this.checkCameraCollisionSpherical(null, n, f, f2, bl);
    }

    public boolean checkCameraCollisionSpherical(SimpleVector simpleVector, float f, float f2, boolean bl) {
        return this.checkCameraCollisionSpherical(simpleVector, -1, f, f2, bl);
    }

    public boolean checkCameraCollisionEllipsoid(int n, SimpleVector simpleVector, float f, int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        return this.checkCameraCollisionEllipsoid(null, n, simpleVector, f, n2);
    }

    public boolean checkCameraCollisionEllipsoid(SimpleVector simpleVector, SimpleVector simpleVector2, float f, int n) {
        if (n < 1) {
            n = 1;
        }
        return this.checkCameraCollisionEllipsoid(simpleVector, -1, simpleVector2, f, n);
    }

    public void buildAllObjects() {
        int n = this.objectList.size();
        for (int i = 2; i < n; ++i) {
            this.objectList.elementAt(i).build();
        }
    }

    public synchronized void prewarmCompiledObjects(FrameBuffer frameBuffer) {
        if (frameBuffer.usesRenderer(1)) {
            Logger.log("Can't compile objects this way on the enabled renderer!", 1);
        }
        if (frameBuffer.isOpenGLOnly()) {
            this.compileAllInternal(frameBuffer);
        } else {
            frameBuffer.prewarmAllObjects(this);
        }
    }

    public void createTriangleStrips() {
        for (int i = 2; i < this.objectList.size(); ++i) {
            this.objectList.elementAt(i).createTriangleStrips();
        }
    }

    public void renderScene(FrameBuffer frameBuffer) {
        try {
            int n;
            Object3D.cullCount = 0L;
            this.calledRender = true;
            this.camera.setPlanes(false);
            boolean bl = frameBuffer.usesRenderer(1);
            FrameBuffer frameBuffer2 = frameBuffer;
            if (frameBuffer.proxy != null) {
                frameBuffer2 = frameBuffer.proxy;
            }
            if (Config.useLocking) {
                this.lockMatrices();
            }
            this.camera.prepareTransform();
            if (Config.useLocking) {
                this.unlockMatrices();
            }
            if (Config.doPortalHsr && this.mainWorld == -1) {
                Logger.log("Can't do portal rendering without a main world being defined!", 0);
            }
            if (this.vlManager == null) {
                this.vlManager = new VisListManager();
            }
            this.visList = this.vlManager.getVisList(frameBuffer, this.visList);
            this.visList.clearList();
            float f = frameBuffer2.middleX;
            float f2 = frameBuffer2.middleY;
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = frameBuffer2.width;
            int n3 = frameBuffer2.height;
            if (frameBuffer.renderTarget != null) {
                n2 = frameBuffer.renderTarget.width;
                n3 = frameBuffer.renderTarget.height;
                if (frameBuffer.virtualHeight > 0) {
                    n2 = frameBuffer.virtualWidth;
                    n3 = frameBuffer.virtualHeight;
                }
                f = n2 / 2;
                f2 = n3 / 2;
            }
            this.camera.calcFOV(n2, n3);
            float f3 = this.camera.scaleX;
            float f4 = this.camera.scaleY;
            if (frameBuffer.usesRenderer(2)) {
                Object[] objectArray = new Object[]{this, frameBuffer};
                frameBuffer.glRend.execute(0, objectArray);
                if (!frameBuffer.usesRenderer(1)) {
                    bl2 = true;
                }
                if (!Config.glIgnoreNearPlane) {
                    f3 = this.camera.scaleXAfter;
                    f4 = this.camera.scaleYAfter;
                }
            }
            this.clippedPolys.clearObject();
            this.lights.transformLights(this.camera);
            if (!Config.doPortalHsr) {
                n = 2;
            } else {
                n = 1;
                this.portals.getCurrentSector(this.getObject(this.mainWorld), this.camera.frontBx, this.camera.frontBy, this.camera.frontBz);
            }
            int n4 = this.objectList.size();
            boolean bl4 = frameBuffer.usesRenderer(2);
            WorldProcessor worldProcessor = this.getWorldProcessor();
            bl3 = worldProcessor.process(frameBuffer, this.objectList, this.portals, this.camera, bl, f, f2, bl2, bl3, n, n4, f3, f4, bl4);
            if (frameBuffer.glRend != null) {
                this.visList.fillInstances();
            }
            if (Config.doSorting && !bl2 || bl3 || Config.alwaysSort || Config.glMultiPassSorting) {
                if (Config.glMultiPassSorting) {
                    this.visList.splitForMultiPass();
                }
                this.visList.sort(0, this.visList.anzpoly, bl);
            }
            if (!Config.glMultiPassSorting) {
                this.visList.splitForMultiPass();
            }
            this.camera.setPlanes(true);
        }
        catch (NullPointerException nullPointerException) {
            Logger.log("There's a problem with the object list not being consistent during rendering. This is often caused by concurrent modification of jPCT objects on a thread different from the rendering thread!", 1);
            Logger.log(nullPointerException, 0);
        }
    }

    public void draw(FrameBuffer frameBuffer) {
        this.draw(frameBuffer, false, 0);
    }

    public void draw(FrameBuffer frameBuffer, int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.visList.anzpoly) {
            n2 = this.visList.anzpoly;
        }
        this.draw(frameBuffer, false, 0, n, n2);
    }

    public void drawWireframe(FrameBuffer frameBuffer, Color color) {
        this.draw(frameBuffer, true, color.getRGB());
        frameBuffer.expandBoundingBox();
    }

    public long getFrameCounter() {
        return this.drawCnt;
    }

    public Enumeration getObjects() {
        Enumeration enumeration = this.objectList.elements();
        if (this.objectList.size() > 1) {
            enumeration.nextElement();
            enumeration.nextElement();
        }
        return enumeration;
    }

    public void setObjectsVisibility(boolean bl) {
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            ((Object3D)enumeration.nextElement()).setVisibility(bl);
        }
    }

    public void removeAll() {
        this.removeAllLights();
        this.removeAllObjects();
    }

    public synchronized void removeAllObjects() {
        Object3D object3D = this.objectList.elementAt(0);
        Object3D object3D2 = this.objectList.elementAt(1);
        for (int i = 0; i < this.objectList.size(); ++i) {
            this.objectList.elementAt((int)i).myWorld = null;
        }
        this.objectList = new Object3DList();
        this.addObject(object3D);
        this.addObject(object3D2);
        if (!Config.shareVisibilityList) {
            this.visList = new VisList(Config.maxPolysVisible);
        }
    }

    public void removeAllLights() {
        this.lights = new Lights(Config.maxLights);
    }

    public void addPolyline(Polyline polyline) {
        if (this.lines == null) {
            this.lines = new Vector();
        }
        this.lines.addElement(polyline);
    }

    public void removePolyline(Polyline polyline) {
        if (this.lines == null) {
            return;
        }
        this.lines.removeElement(polyline);
    }

    public void removeAllPolylines() {
        if (this.lines != null) {
            this.lines.clear();
        }
    }

    public static synchronized void setDefaultThread(Thread thread) {
        defaultThread = thread;
    }

    public static synchronized Thread getDefaultThread() {
        return defaultThread;
    }

    public void setGlobalShader(GLSLShader gLSLShader) {
        this.globalShader = gLSLShader;
        gLSLShader.assignedTo += 10000000;
    }

    public GLSLShader getGlobalShader() {
        return this.globalShader;
    }

    public void setClippingPlanes(float f, float f2) {
        this.getCamera().setClippingPlanes(f, f2);
    }

    public float[] getBounds(boolean bl) {
        float[] fArray = new float[6];
        fArray[0] = Float.MAX_VALUE;
        fArray[2] = Float.MAX_VALUE;
        fArray[4] = Float.MAX_VALUE;
        fArray[1] = -3.4028235E38f;
        fArray[3] = -3.4028235E38f;
        fArray[5] = -3.4028235E38f;
        for (int i = 2; i < this.objectList.size(); ++i) {
            Object3D object3D = this.objectList.elementAt(i);
            if (bl && !object3D.isVisible) continue;
            float[] fArray2 = object3D.getWorldSpaceBounds();
            if (fArray2[0] < fArray[0]) {
                fArray[0] = fArray2[0];
            }
            if (fArray2[2] < fArray[2]) {
                fArray[2] = fArray2[2];
            }
            if (fArray2[4] < fArray[4]) {
                fArray[4] = fArray2[4];
            }
            if (fArray2[1] > fArray[1]) {
                fArray[1] = fArray2[1];
            }
            if (fArray2[3] > fArray[3]) {
                fArray[3] = fArray2[3];
            }
            if (!(fArray2[5] > fArray[5])) continue;
            fArray[5] = fArray2[5];
        }
        return fArray;
    }

    public String toXML() {
        Serializable serializable;
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<jpct>\n");
        stringBuffer.append("<light_list>\n");
        Lights lights = this.getLights();
        for (int i = 0; i < lights.lightCnt; ++i) {
            stringBuffer.append("<light x='").append(lights.xOrg[i]).append("' y='").append(lights.yOrg[i]).append("' z='").append(lights.zOrg[i]).append("' r='").append(lights.rOrg[i]).append("' g='").append(lights.gOrg[i]).append("' b='").append(lights.bOrg[i]).append("'/>\n");
        }
        stringBuffer.append("</light_list>\n");
        stringBuffer.append("<texture_list>\n");
        TextureManager textureManager = TextureManager.getInstance();
        Enumeration enumeration = textureManager.getNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).equals("--dummy--")) continue;
            stringBuffer.append("<texture name='").append((String)object).append("' id='").append(textureManager.getTextureID((String)object)).append("'/>\n");
        }
        stringBuffer.append("</texture_list>\n");
        stringBuffer.append("<object_list>\n");
        for (n = 2; n < this.objectList.size(); ++n) {
            object = this.objectList.elementAt(n);
            stringBuffer.append("<object name='").append(((Object3D)object).getName()).append("' id='").append(n - 2).append("' triangles='").append(((Object3D)object).objMesh.anzTri).append("' main='");
            if (((Object3D)object).isMainWorld) {
                stringBuffer.append("1'");
            } else {
                stringBuffer.append("0'");
            }
            if (((Object3D)object).oneSectorOnly) {
                if (((Object3D)object).dynSectorDetect) {
                    stringBuffer.append(" insector='auto'");
                } else if (((Object3D)object).singleSectorNumber == 0) {
                    stringBuffer.append(" insector='all'");
                } else {
                    stringBuffer.append(" insector='" + ((Object3D)object).singleSectorNumber + "'");
                }
            }
            stringBuffer.append(">\n");
            stringBuffer.append("<attributes>\n");
            SimpleVector simpleVector = ((Object3D)object).getRotationPivot();
            serializable = ((Object3D)object).getCenter();
            SimpleVector simpleVector2 = ((Object3D)object).getOriginMatrix().getTranslation();
            stringBuffer.append("<pivot x='").append(simpleVector.x).append("' y='").append(simpleVector.y).append("' z='").append(simpleVector.z).append("'/>\n");
            stringBuffer.append("<center x='").append(serializable.x).append("' y='").append(serializable.y).append("' z='").append(serializable.z).append("'/>\n");
            stringBuffer.append("<origin x='").append(simpleVector2.x).append("' y='").append(simpleVector2.y).append("' z='").append(simpleVector2.z).append("'/>\n");
            stringBuffer.append("</attributes>\n");
            int n2 = -1;
            for (int i = 0; i < ((Object3D)object).objMesh.anzTri; ++i) {
                int n3;
                int n4 = 0;
                if (((Object3D)object).sector != null) {
                    n4 = ((Object3D)object).sector[i];
                }
                if (n4 != n2) {
                    if (n2 != -1) {
                        stringBuffer.append("</triangle_list>\n");
                    }
                    stringBuffer.append("<triangle_list");
                    if (!((Object3D)object).oneSectorOnly) {
                        stringBuffer.append(" sector='" + n4 + "'");
                    }
                    stringBuffer.append(">\n");
                    n2 = n4;
                }
                stringBuffer.append("<triangle>\n");
                for (n3 = 0; n3 < 3; ++n3) {
                    int n5 = ((Object3D)object).objMesh.coords[((Object3D)object).objMesh.points[i][n3]];
                    float f = ((Object3D)object).objMesh.xOrg[n5];
                    float f2 = ((Object3D)object).objMesh.yOrg[n5];
                    float f3 = ((Object3D)object).objMesh.zOrg[n5];
                    float f4 = ((Object3D)object).objVectors.nuOrg[((Object3D)object).objMesh.points[i][n3]];
                    float f5 = ((Object3D)object).objVectors.nvOrg[((Object3D)object).objMesh.points[i][n3]];
                    stringBuffer.append("<coord x='").append(f).append("' y='").append(f2).append("' z='").append(f3).append("' u='").append(f4).append("' v='").append(f5).append("'/>\n");
                }
                stringBuffer.append("<textures>\n");
                n3 = ((Object3D)object).texture[i];
                if (((Object3D)object).texture[i] != 0) {
                    stringBuffer.append("<texturemap texid='").append(n3).append("'/>\n");
                }
                if (((Object3D)object).basemap[i] != 0 && ((Object3D)object).basemap[i] != n3) {
                    stringBuffer.append("<basemap texid='").append(((Object3D)object).basemap[i]).append("'/>\n");
                }
                if (((Object3D)object).bumpmap != null && ((Object3D)object).bumpmap[i] != 0 && ((Object3D)object).bumpmap[i] != n3) {
                    stringBuffer.append("<bumpmap texid='").append(((Object3D)object).bumpmap[i]).append("'/>\n");
                }
                stringBuffer.append("</textures>\n");
                stringBuffer.append("</triangle>\n");
            }
            stringBuffer.append("</triangle_list>\n");
            stringBuffer.append("</object>\n");
        }
        stringBuffer.append("</object_list>\n");
        stringBuffer.append("<portal_list>\n");
        for (n = 0; n < this.portals.anzPortals; ++n) {
            stringBuffer.append("<portal from='").append(this.portals.fromSector[n]).append("' to='").append(this.portals.toSector[n]).append("' type='s'>\n");
            for (int i = 0; i < this.portals.coordCount[n]; ++i) {
                int n6 = this.portals.coords[n][i];
                serializable = this.objectList.elementAt(1);
                float f = ((Object3D)serializable).objMesh.xOrg[n6];
                float f6 = ((Object3D)serializable).objMesh.yOrg[n6];
                float f7 = ((Object3D)serializable).objMesh.zOrg[n6];
                stringBuffer.append("<coord x='").append(f).append("' y='").append(f6).append("' z='").append(f7).append("'/>\n");
            }
            stringBuffer.append("</portal>\n");
        }
        stringBuffer.append("</portal_list>\n");
        stringBuffer.append("</jpct>\n");
        return stringBuffer.toString();
    }

    synchronized void compileAllInternal(FrameBuffer frameBuffer) {
        int n = this.objectList.size();
        Logger.log("Compiling all assigned objects!", 2);
        for (int i = 2; i < n; ++i) {
            Object3D object3D;
            Object3D object3D2 = this.objectList.elementAt(i);
            object3D2.object3DRendered = false;
            Logger.log("Compiling object " + object3D2.name + "/" + object3D2 + "!", 2);
            if (!object3D2.hasBeenBuild) {
                Logger.log("Object " + object3D2.name + " hasn't been build yet. Forcing build()!", 1);
                object3D2.build();
            }
            if (object3D2.compiled == null || object3D2.isCompiled() || object3D2.getMesh().anzTri <= 0) continue;
            if (object3D2.shareWith != null && !(object3D = object3D2.shareWith).isCompiled() && object3D.getMesh().anzTri > 0) {
                if (object3D.compiled == null) {
                    object3D.compile(object3D2.dynamic);
                }
                Logger.log("Compiling source object...", 2);
                this.compile(frameBuffer, object3D);
            }
            this.compile(frameBuffer, object3D2);
        }
        Logger.log("Compiled all assigned objects successfully!", 2);
    }

    Object3D getInternalObjectByName(String string) {
        for (int i = 0; i < this.objectList.size(); ++i) {
            if (!this.objectList.elementAt((int)i).name.equals(string)) continue;
            return this.objectList.elementAt(i);
        }
        return null;
    }

    void rescaleClippedPolys() {
        Logger.log("Enlarging polygon buffer by " + Config.polygonBufferSize, 2);
        this.clippedPolys.enlarge(Config.polygonBufferSize);
    }

    final SimpleVector checkObjCollisionSpherical(Object3D object3D, SimpleVector simpleVector, float f) {
        if (object3D.mayCollide) {
            float[] fArray = new float[3];
            float[] fArray2 = new float[3];
            object3D.getProjectedPoint(object3D.centerX, object3D.centerY, object3D.centerZ, null, fArray);
            fArray2[0] = simpleVector.x;
            fArray2[1] = simpleVector.y;
            fArray2[2] = simpleVector.z;
            return this.checkSomeCollisionSpherical(fArray, fArray2, f, object3D);
        }
        return new SimpleVector(simpleVector.x, simpleVector.y, simpleVector.z);
    }

    final SimpleVector checkObjCollisionEllipsoid(Object3D object3D, SimpleVector simpleVector, SimpleVector simpleVector2, int n) {
        if (object3D.mayCollide) {
            SimpleVector simpleVector3 = new SimpleVector();
            SimpleVector simpleVector4 = new SimpleVector(simpleVector);
            object3D.getProjectedPoint(object3D.centerX, object3D.centerY, object3D.centerZ, simpleVector3, null);
            return this.checkSomeCollisionEllipsoid(simpleVector3, simpleVector4, simpleVector2, object3D, n);
        }
        return new SimpleVector(simpleVector);
    }

    final void createWSNormals() {
        WorldProcessor worldProcessor = this.getWorldProcessor();
        if (worldProcessor != null) {
            worldProcessor.createWSNormals();
        }
    }

    final int checkObjCollision(Object3D object3D, SimpleVector simpleVector, float f) {
        if (object3D.mayCollide) {
            float[] fArray = new float[3];
            float[] fArray2 = new float[3];
            object3D.getProjectedPoint(object3D.centerX, object3D.centerY, object3D.centerZ, null, fArray);
            float f2 = simpleVector.x;
            float f3 = simpleVector.y;
            float f4 = simpleVector.z;
            float f5 = 1.0f / (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
            fArray2[0] = f2 * f5;
            fArray2[1] = f3 * f5;
            fArray2[2] = f4 * f5;
            return this.checkSomeCollision(fArray, fArray2, f, object3D);
        }
        return -100;
    }

    private final void draw(FrameBuffer frameBuffer, boolean bl, int n) {
        this.draw(frameBuffer, bl, n, 0, this.visList.anzpoly);
    }

    private final void draw(FrameBuffer objectArray, boolean bl, int n, int n2, int n3) {
        int n4;
        Object[] objectArray2;
        this.camera.setPlanes(false);
        if (!this.calledRender && objectArray.usesRenderer(2)) {
            objectArray2 = new Object[]{this, objectArray};
            objectArray.glRend.execute(0, objectArray2);
        }
        this.calledRender = false;
        objectArray2 = objectArray;
        if (objectArray.proxy != null) {
            objectArray2 = objectArray.proxy;
        }
        IRenderer iRenderer = objectArray2.softRend;
        IRenderer iRenderer2 = objectArray.glRend;
        int n5 = 0;
        boolean bl2 = iRenderer != null;
        boolean bl3 = iRenderer2 != null;
        Object[] objectArray3 = null;
        boolean bl4 = false;
        boolean bl5 = bl3 && !objectArray.canvasMode && !Config.useMultipleThreads;
        ++this.drawCnt;
        int n6 = objectArray.getOutputWidth();
        int n7 = objectArray.getOutputHeight();
        if (this.useFogging && this.perPixelFogging) {
            objectArray.useFogging(this.fogDistance, this.fogColorR, this.fogColorG, this.fogColorB);
        } else {
            objectArray.dontUseFogging();
        }
        if (n2 == 0) {
            if (bl2) {
                iRenderer.execute(12, null);
            }
            if (bl5) {
                iRenderer2.execute(12, null);
            }
        }
        if (bl3) {
            objectArray3 = new Object[]{this.visList};
            iRenderer2.execute(23, objectArray3);
        }
        if (this.visList.anzpoly != -1) {
            if (bl3 && (Config.viewportOffsetX != 0.0f || Config.viewportOffsetY != 0.0f)) {
                objectArray3 = new Object[]{IntegerC.valueOf((int)(Config.viewportOffsetX * (float)n6)), IntegerC.valueOf((int)(-Config.viewportOffsetY * (float)n7)), IntegerC.valueOf(n6), IntegerC.valueOf(n7)};
                objectArray.glRend.execute(9, objectArray3);
                bl4 = true;
            }
            if (bl) {
                for (n4 = n2; n4 <= n3; ++n4) {
                    if (bl3) {
                        iRenderer2.drawWireframe(this.visList, n4, n, (FrameBuffer)objectArray, this);
                    }
                    if (!bl2) continue;
                    iRenderer.drawWireframe(this.visList, n4, n, (FrameBuffer)objectArray2, this);
                }
            } else {
                if (!Config.glTriangleStrips || bl2 || Config.glVertexArrays) {
                    if (Config.glVertexArrays || bl2 && Config.useMultipleThreads) {
                        if (bl3) {
                            iRenderer2.drawVertexArray(this.visList, n2, n3, (FrameBuffer)objectArray, this);
                        }
                        if (bl2) {
                            iRenderer.drawVertexArray(this.visList, n2, n3, (FrameBuffer)objectArray2, this);
                        }
                    } else {
                        for (int i = n2; i <= n3; ++i) {
                            if (bl3) {
                                iRenderer2.drawPolygon(this.visList, i, (FrameBuffer)objectArray, this);
                            }
                            if (!bl2) continue;
                            iRenderer.drawPolygon(this.visList, i, (FrameBuffer)objectArray2, this);
                        }
                    }
                } else {
                    for (int i = n2; i <= n3; ++i) {
                        int n8 = 0;
                        boolean bl6 = true;
                        do {
                            int n9 = i + n8;
                            int n10 = n9 + 1;
                            Object3D object3D = this.visList.vorg[n9];
                            if (this.visList.stageCnt[n9] != this.visList.stageCnt[n10] || this.visList.stageCnt[n9] >= Config.glStageCount || object3D.objVectors.alpha != null) {
                                bl6 = false;
                                continue;
                            }
                            if (n9 < this.visList.anzpoly && object3D == this.visList.vorg[n10] && object3D.texture[this.visList.vnum[n9]] == object3D.texture[this.visList.vnum[n10]] && !object3D.isFlatShaded) {
                                int n11;
                                int n12;
                                int n13;
                                int n14;
                                int n15;
                                boolean bl7;
                                float f;
                                float f2;
                                float f3;
                                float f4;
                                float f5;
                                float f6;
                                float f7;
                                float f8;
                                float f9;
                                float f10;
                                Mesh mesh = object3D.objMesh;
                                int n16 = this.visList.vnumOrg[n9];
                                int n17 = this.visList.vnumOrg[n10];
                                int n18 = mesh.points[n16][0];
                                int n19 = mesh.points[n16][1];
                                int n20 = mesh.points[n16][2];
                                int n21 = mesh.points[n17][0];
                                int n22 = mesh.points[n17][1];
                                int n23 = mesh.coords[n18];
                                int n24 = mesh.coords[n19];
                                int n25 = mesh.coords[n20];
                                int n26 = mesh.coords[n21];
                                int n27 = mesh.coords[n22];
                                if (!object3D.isEnvmapped || object3D.isBlended) {
                                    f10 = object3D.objVectors.nuOrg[n18];
                                    f9 = object3D.objVectors.nvOrg[n18];
                                    f8 = object3D.objVectors.nuOrg[n19];
                                    f7 = object3D.objVectors.nvOrg[n19];
                                    f6 = object3D.objVectors.nuOrg[n20];
                                    f5 = object3D.objVectors.nvOrg[n20];
                                    f4 = object3D.objVectors.nuOrg[n21];
                                    f3 = object3D.objVectors.nvOrg[n21];
                                    f2 = object3D.objVectors.nuOrg[n22];
                                    f = object3D.objVectors.nvOrg[n22];
                                } else {
                                    f10 = 0.0f;
                                    f9 = 0.0f;
                                    f8 = 0.0f;
                                    f7 = 0.0f;
                                    f6 = 0.0f;
                                    f5 = 0.0f;
                                    f4 = 0.0f;
                                    f3 = 0.0f;
                                    f2 = 0.0f;
                                    f = 0.0f;
                                }
                                if ((n8 & 1) == 0 && n24 == n27 && n25 == n26 && f8 == f2 && f7 == f && f6 == f4 && f5 == f3) {
                                    if (object3D.usesMultiTexturing) {
                                        bl7 = true;
                                        for (n15 = 0; n15 < object3D.maxStagesUsed - 1; ++n15) {
                                            n14 = object3D.multiTex[n15][this.visList.vnum[n9]];
                                            n13 = object3D.multiTex[n15][this.visList.vnum[n10]];
                                            n12 = object3D.multiMode[n15][this.visList.vnum[n9]];
                                            n11 = object3D.multiMode[n15][this.visList.vnum[n10]];
                                            if (n14 == n13 && n12 == n11) {
                                                if (n14 == -1) continue;
                                                f10 = object3D.objVectors.uMul[n15][n18];
                                                f9 = object3D.objVectors.vMul[n15][n18];
                                                f8 = object3D.objVectors.uMul[n15][n19];
                                                f7 = object3D.objVectors.vMul[n15][n19];
                                                f6 = object3D.objVectors.uMul[n15][n20];
                                                f5 = object3D.objVectors.vMul[n15][n20];
                                                f4 = object3D.objVectors.uMul[n15][n21];
                                                f3 = object3D.objVectors.vMul[n15][n21];
                                                f2 = object3D.objVectors.uMul[n15][n22];
                                                f = object3D.objVectors.vMul[n15][n22];
                                                if (f8 == f2 && f7 == f && f6 == f4 && f5 == f3) continue;
                                                bl7 = false;
                                                break;
                                            }
                                            bl7 = false;
                                            break;
                                        }
                                        if (bl7) {
                                            ++n8;
                                            continue;
                                        }
                                        bl6 = false;
                                        continue;
                                    }
                                    ++n8;
                                    continue;
                                }
                                if ((n8 & 1) == 1 && n23 == n26 && n25 == n27 && f10 == f4 && f9 == f3 && f6 == f2 && f5 == f) {
                                    if (object3D.usesMultiTexturing) {
                                        bl7 = true;
                                        for (n15 = 0; n15 < object3D.maxStagesUsed - 1; ++n15) {
                                            n14 = object3D.multiTex[n15][this.visList.vnum[n9]];
                                            n13 = object3D.multiTex[n15][this.visList.vnum[n10]];
                                            n12 = object3D.multiMode[n15][this.visList.vnum[n9]];
                                            n11 = object3D.multiMode[n15][this.visList.vnum[n10]];
                                            if (n14 == n13 && n12 == n11) {
                                                if (n14 == -1) continue;
                                                f10 = object3D.objVectors.uMul[n15][n18];
                                                f9 = object3D.objVectors.vMul[n15][n18];
                                                f8 = object3D.objVectors.uMul[n15][n19];
                                                f7 = object3D.objVectors.vMul[n15][n19];
                                                f6 = object3D.objVectors.uMul[n15][n20];
                                                f5 = object3D.objVectors.vMul[n15][n20];
                                                f4 = object3D.objVectors.uMul[n15][n21];
                                                f3 = object3D.objVectors.vMul[n15][n21];
                                                f2 = object3D.objVectors.uMul[n15][n22];
                                                f = object3D.objVectors.vMul[n15][n22];
                                                if (f10 == f4 && f9 == f3 && f6 == f2 && f5 == f) continue;
                                                bl7 = false;
                                                break;
                                            }
                                            bl7 = false;
                                            break;
                                        }
                                        if (bl7) {
                                            ++n8;
                                            continue;
                                        }
                                        bl6 = false;
                                        continue;
                                    }
                                    ++n8;
                                    continue;
                                }
                                bl6 = false;
                                continue;
                            }
                            bl6 = false;
                        } while (bl6);
                        if (n8 == 0) {
                            iRenderer2.drawPolygon(this.visList, i, (FrameBuffer)objectArray, this);
                            continue;
                        }
                        ++n5;
                        iRenderer2.drawStrip(this.visList, i, n8, (FrameBuffer)objectArray, this);
                        i += n8;
                    }
                }
                if (bl3) {
                    iRenderer2.execute(8, null);
                    if (bl4) {
                        objectArray3 = new Object[]{IntegerC.valueOf(0), IntegerC.valueOf(0), IntegerC.valueOf(n6), IntegerC.valueOf(n7)};
                        objectArray.glRend.execute(9, objectArray3);
                        bl4 = false;
                    }
                }
            }
        }
        if (this.lines != null && bl3) {
            if (bl3 && (Config.viewportOffsetX != 0.0f || Config.viewportOffsetY != 0.0f)) {
                objectArray3 = new Object[]{IntegerC.valueOf((int)(Config.viewportOffsetX * (float)n6)), IntegerC.valueOf((int)(-Config.viewportOffsetY * (float)n7)), IntegerC.valueOf(n6), IntegerC.valueOf(n7)};
                objectArray.glRend.execute(9, objectArray3);
                bl4 = true;
            }
            objectArray3 = new Object[]{this};
            iRenderer2.execute(29, objectArray3);
            for (n4 = 0; n4 < this.lines.size(); ++n4) {
                objectArray3 = new Object[]{this, ((Polyline)this.lines.elementAt(n4)).getParent()};
                iRenderer2.execute(32, objectArray3);
                objectArray3 = new Object[]{this.lines.elementAt(n4)};
                if (!((Polyline)objectArray3[0]).isVisible()) continue;
                iRenderer2.execute(31, objectArray3);
            }
            iRenderer2.execute(30, null);
            if (bl3 && bl4) {
                objectArray3 = new Object[]{IntegerC.valueOf(0), IntegerC.valueOf(0), IntegerC.valueOf(n6), IntegerC.valueOf(n7)};
                objectArray.glRend.execute(9, objectArray3);
                bl4 = false;
            }
        }
        if (n3 == this.visList.anzpoly) {
            if (bl2) {
                iRenderer.execute(13, null);
            }
            if (bl5) {
                iRenderer2.execute(13, null);
            }
        }
        this.camera.setPlanes(true);
    }

    private final boolean checkCameraCollision(SimpleVector simpleVector, int n, float f, float f2, boolean bl) {
        float f3;
        float f4;
        float f5;
        float f6;
        if (n == 7) {
            n = 1;
        }
        float f7 = Float.MAX_VALUE;
        float f8 = Float.MAX_VALUE;
        float f9 = Float.MAX_VALUE;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 1.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float f17 = this.camera.backBx;
        float f18 = this.camera.backBy;
        float f19 = this.camera.backBz;
        int n2 = 0;
        fArray[0] = f17;
        fArray[1] = f18;
        fArray[2] = f19;
        if (simpleVector == null) {
            if ((n & 1) != 1) {
                f13 = -1.0f;
            }
            n2 = 2 - ((n + 1) / 2 - 1);
            f14 = this.camera.backMatrix.mat[0][n2];
            f15 = this.camera.backMatrix.mat[1][n2];
            f16 = this.camera.backMatrix.mat[2][n2];
            f10 = f14 * f13;
            f11 = f15 * f13;
            f12 = f16 * f13;
        } else {
            f13 = 1.0f;
            f14 = simpleVector.x;
            f15 = simpleVector.y;
            f16 = simpleVector.z;
            f10 = f14;
            f11 = f15;
            f12 = f16;
        }
        float[] fArray5 = new float[]{f10, f11, f12};
        fArray2[0] = f10;
        fArray2[1] = 0.0f;
        fArray2[2] = 0.0f;
        fArray3[0] = 0.0f;
        fArray3[1] = f11;
        fArray3[2] = 0.0f;
        fArray4[0] = 0.0f;
        fArray4[1] = 0.0f;
        fArray4[2] = f12;
        fArray2[0] = fArray2[0] < 0.0f ? -1.0f : 1.0f;
        fArray3[1] = fArray3[1] < 0.0f ? -1.0f : 1.0f;
        fArray4[2] = fArray4[2] < 0.0f ? -1.0f : 1.0f;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = false;
        float f20 = 1.0E12f;
        Object3D object3D = null;
        Object3D object3D2 = null;
        Object3D object3D3 = null;
        for (int i = 2; i < this.objectList.size(); ++i) {
            Object3D object3D4 = this.objectList.elementAt(i);
            object3D4.wasCollider = false;
            object3D4.resetPolygonIDCount();
            if (!object3D4.isPotentialCollider || !object3D4.isVisible || !object3D4.isMainWorld && object3D4.oneSectorOnly && Config.useFastCollisionDetection && !(object3D4.rayIntersectsAABB(fArray, fArray5, false) < Config.collideOffset)) continue;
            f20 = object3D4.collide(fArray, fArray2, 3.0f, Config.collideSectorOffset);
            if (f20 < f7) {
                f7 = f20;
                object3D = object3D4;
            }
            if ((f20 = object3D4.collide(fArray, fArray3, 3.0f, Config.collideSectorOffset)) < f8) {
                f8 = f20;
                object3D2 = object3D4;
            }
            if (!((f20 = object3D4.collide(fArray, fArray4, 3.0f, Config.collideSectorOffset)) < f9)) continue;
            f9 = f20;
            object3D3 = object3D4;
        }
        float f21 = f2 * 0.9f;
        if (f7 < f2 && f7 > f21) {
            f7 = f2;
        }
        if (f8 < f2 && f8 > f21) {
            f8 = f2;
        }
        if (f9 < f2 && f9 > f21) {
            f9 = f2;
        }
        if (f7 - (f6 = Math.abs(f5 = f14 * f * f13)) <= f2) {
            bl5 = true;
            f5 = f5 >= 0.0f ? f7 - f2 : -(f7 - f2);
            if (object3D != null) {
                object3D.wasCollider = true;
            }
        } else {
            bl2 = false;
        }
        if (f8 - (f6 = Math.abs(f4 = f15 * f * f13)) <= f2) {
            bl5 = true;
            f4 = f4 >= 0.0f ? f8 - f2 : -(f8 - f2);
            if (object3D2 != null) {
                object3D2.wasCollider = true;
            }
        } else {
            bl3 = false;
        }
        if (f9 - (f6 = Math.abs(f3 = f16 * f * f13)) <= f2) {
            bl5 = true;
            f3 = f3 >= 0.0f ? f9 - f2 : -(f9 - f2);
            if (object3D3 != null) {
                object3D3.wasCollider = true;
            }
        } else {
            bl4 = false;
        }
        if (object3D != null && object3D.wasCollider) {
            object3D.notifyCollisionListeners(0, 0, new Object3D[]{object3D}, null);
        }
        if (object3D2 != null && object3D2.wasCollider && !object3D2.equals(object3D)) {
            object3D2.notifyCollisionListeners(0, 0, new Object3D[]{object3D2}, null);
        }
        if (object3D3 != null && object3D3.wasCollider && !object3D3.equals(object3D) && !object3D3.equals(object3D2)) {
            object3D3.notifyCollisionListeners(0, 0, new Object3D[]{object3D3}, null);
        }
        if (bl || !bl5) {
            this.camera.backBx += f5;
            this.camera.backBy += f4;
            this.camera.backBz += f3;
        }
        return bl2 | bl3 | bl4;
    }

    private final int checkSomeCollision(float[] fArray, float[] fArray2, float f, Object3D object3D) {
        int n;
        Object3D object3D2 = null;
        Object3D object3D3 = null;
        float f2 = Float.MAX_VALUE;
        float f3 = 1.0E12f;
        for (n = 2; n < this.objectList.size(); ++n) {
            object3D2 = this.objectList.elementAt(n);
            object3D2.wasCollider = false;
            object3D2.resetPolygonIDCount();
            if (!object3D2.isPotentialCollider || object3D != null && object3D2 == object3D || !object3D2.isVisible || !object3D2.isMainWorld && object3D2.oneSectorOnly && Config.useFastCollisionDetection && !(object3D2.rayIntersectsAABB(fArray, fArray2, true) < Config.collideOffset) || !((f3 = object3D2.collide(fArray, fArray2, f, Config.collideSectorOffset)) < f2) || !((f2 = f3) < f)) continue;
            object3D3 = object3D2;
        }
        if (f2 < f && object3D3 != null) {
            Serializable serializable;
            object3D3.wasCollider = true;
            for (n = 2; n < this.objectList.size(); ++n) {
                serializable = this.objectList.elementAt(n);
                if (serializable == object3D3) continue;
                ((Object3D)serializable).wasCollider = false;
                ((Object3D)serializable).resetPolygonIDCount();
            }
            Object3D[] object3DArray = new Object3D[]{object3D3};
            serializable = new SimpleVector(fArray2);
            ((SimpleVector)serializable).scalarMul(f2);
            ((SimpleVector)serializable).add(new SimpleVector(fArray));
            if (object3D != null) {
                object3D.notifyCollisionListeners(1, 0, object3DArray, (SimpleVector)serializable);
            }
            object3D3.notifyCollisionListeners(object3D, 0, 0, object3DArray, (SimpleVector)serializable);
            return object3D3.getID();
        }
        return -100;
    }

    private final SimpleVector checkSomeCollisionSpherical(float[] fArray, float[] fArray2, float f, Object3D object3D) {
        Object3D object3D2 = null;
        float[] fArray3 = new float[]{fArray[0] + fArray2[0], fArray[1] + fArray2[1], fArray[2] + fArray2[2]};
        boolean[] blArray = new boolean[]{false};
        for (int i = 2; i < this.objectList.size(); ++i) {
            object3D2 = this.objectList.elementAt(i);
            object3D2.wasCollider = false;
            object3D2.resetPolygonIDCount();
            if (!object3D2.isPotentialCollider || object3D != null && object3D2 == object3D || !object3D2.isVisible || !object3D2.isMainWorld && object3D2.oneSectorOnly && object3D2.hasBoundingBox && !object3D2.sphereIntersectsAABB(fArray3, f)) continue;
            boolean bl = blArray[0];
            blArray[0] = false;
            fArray3 = object3D2.collideSpherical(fArray3, f, Config.collideSectorOffset, blArray, false);
            if (blArray[0]) {
                object3D2.wasCollider = true;
            }
            blArray[0] = blArray[0] | bl;
        }
        if (blArray[0]) {
            SimpleVector simpleVector = new SimpleVector(fArray3[0], fArray3[1], fArray3[2]);
            SimpleVector simpleVector2 = new SimpleVector(simpleVector);
            simpleVector2.x -= fArray[0];
            simpleVector2.y -= fArray[1];
            simpleVector2.z -= fArray[2];
            this.notifyAll(object3D, null, 1, simpleVector);
            return simpleVector2;
        }
        return new SimpleVector(fArray2[0], fArray2[1], fArray2[2]);
    }

    private final boolean checkCameraCollisionSpherical(SimpleVector simpleVector, int n, float f, float f2, boolean bl) {
        int n2;
        float[] fArray = new float[]{this.camera.backBx, this.camera.backBy, this.camera.backBz};
        if (simpleVector == null) {
            if (n != 7) {
                float f3 = -1.0f;
                if ((n & 1) == 1) {
                    f3 = 1.0f;
                }
                n2 = 2 - ((n + 1) / 2 - 1);
                fArray[0] = fArray[0] + this.camera.backMatrix.mat[0][n2] * (f3 *= f2);
                fArray[1] = fArray[1] + this.camera.backMatrix.mat[1][n2] * f3;
                fArray[2] = fArray[2] + this.camera.backMatrix.mat[2][n2] * f3;
            }
        } else {
            fArray[0] = fArray[0] + simpleVector.x * f2;
            fArray[1] = fArray[1] + simpleVector.y * f2;
            fArray[2] = fArray[2] + simpleVector.z * f2;
        }
        boolean[] blArray = new boolean[]{false};
        for (n2 = 2; n2 < this.objectList.size(); ++n2) {
            Object3D object3D = this.objectList.elementAt(n2);
            object3D.wasCollider = false;
            object3D.resetPolygonIDCount();
            if (!object3D.isPotentialCollider || !object3D.isVisible || !object3D.isMainWorld && object3D.oneSectorOnly && object3D.hasBoundingBox && !object3D.sphereIntersectsAABB(fArray, f)) continue;
            boolean bl2 = blArray[0];
            blArray[0] = false;
            fArray = object3D.collideSpherical(fArray, f, Config.collideSectorOffset, blArray, true);
            if (blArray[0]) {
                object3D.wasCollider = true;
            }
            blArray[0] = blArray[0] | bl2;
        }
        n2 = blArray[0];
        if (bl || n2 == 0) {
            this.camera.backBx = fArray[0];
            this.camera.backBy = fArray[1];
            this.camera.backBz = fArray[2];
        }
        if (n2 != 0) {
            this.notifyAll(null, null, 1, new SimpleVector(fArray));
        }
        return n2 != 0;
    }

    private void compile(FrameBuffer frameBuffer, Object3D object3D) {
        Object3D object3D2 = object3D.shareWith;
        if (object3D2 != null) {
            if (object3D2.compiled == null) {
                Logger.log("Parent object hasn't been compiled...trying to compile it for you!", 1);
                object3D2.compile();
            }
            if (object3D2.compiled != null && !object3D2.isCompiled() && object3D2.getMesh().anzTri > 0) {
                Logger.log("Compiling source object...", 2);
                frameBuffer.versionHelper.compile(object3D2, frameBuffer.glRend);
                frameBuffer.versionHelper.fillVBO(object3D2, frameBuffer.glRend);
                if (object3D.toStrip) {
                    object3D.reallyStrip();
                }
            }
        }
        frameBuffer.versionHelper.compile(object3D, frameBuffer.glRend);
        frameBuffer.versionHelper.fillVBO(object3D, frameBuffer.glRend);
    }

    private final SimpleVector checkSomeCollisionEllipsoid(SimpleVector simpleVector, SimpleVector simpleVector2, SimpleVector simpleVector3, Object3D object3D, int n) {
        Serializable serializable;
        CollisionInfo collisionInfo = new CollisionInfo();
        collisionInfo.eRadius = simpleVector3;
        collisionInfo.r3Pos = new SimpleVector(simpleVector);
        collisionInfo.r3Velocity = new SimpleVector(simpleVector2);
        collisionInfo.calculateInverseAndDest();
        if (object3D != null && object3D.getEllipsoidMode() == 1) {
            collisionInfo.addTransMat = object3D.getWorldTransformation();
            serializable = collisionInfo.addTransMat.cloneMatrix();
            ((Matrix)serializable).mat[3][0] = 0.0f;
            ((Matrix)serializable).mat[3][1] = 0.0f;
            ((Matrix)serializable).mat[3][2] = 0.0f;
            collisionInfo.addRotMat = serializable;
        }
        this.doWorldCollisionEllipsoid(collisionInfo, 0, object3D, n);
        if (Config.collideEllipsoidSmoothing) {
            serializable = collisionInfo.r3Pos.calcSub(simpleVector);
            ((SimpleVector)serializable).makeEqualLength(simpleVector2);
            ((SimpleVector)serializable).add(simpleVector);
            collisionInfo.r3Pos = serializable;
        }
        serializable = collisionInfo.r3Pos;
        if (collisionInfo.collision) {
            ((SimpleVector)serializable).x -= simpleVector.x;
            ((SimpleVector)serializable).y -= simpleVector.y;
            ((SimpleVector)serializable).z -= simpleVector.z;
            return serializable;
        }
        return simpleVector2;
    }

    private final boolean checkCameraCollisionEllipsoid(SimpleVector simpleVector, int n, SimpleVector simpleVector2, float f, int n2) {
        float[] fArray = new float[]{this.camera.backBx, this.camera.backBy, this.camera.backBz};
        float[] fArray2 = new float[3];
        SimpleVector simpleVector3 = null;
        if (simpleVector == null) {
            if (n != 7) {
                float f2 = -1.0f;
                if ((n & 1) == 1) {
                    f2 = 1.0f;
                }
                int n3 = 2 - ((n + 1) / 2 - 1);
                fArray2[0] = this.camera.backMatrix.mat[0][n3] * (f2 *= f);
                fArray2[1] = this.camera.backMatrix.mat[1][n3] * f2;
                fArray2[2] = this.camera.backMatrix.mat[2][n3] * f2;
            }
        } else {
            fArray2[0] = simpleVector.x * f;
            fArray2[1] = simpleVector.y * f;
            fArray2[2] = simpleVector.z * f;
        }
        CollisionInfo collisionInfo = new CollisionInfo();
        collisionInfo.eRadius = simpleVector2;
        collisionInfo.r3Pos = new SimpleVector(fArray);
        collisionInfo.r3Velocity = new SimpleVector(fArray2);
        collisionInfo.calculateInverseAndDest();
        if (this.camera.getEllipsoidMode() == 1) {
            Matrix matrix = new Matrix();
            matrix.mat[3][0] = this.camera.backBx;
            matrix.mat[3][1] = this.camera.backBy;
            matrix.mat[3][2] = this.camera.backBz;
            Matrix matrix2 = this.camera.backMatrix.cloneMatrix();
            matrix2.matMul(matrix);
            collisionInfo.addTransMat = matrix2;
            collisionInfo.addRotMat = this.camera.backMatrix.cloneMatrix();
        }
        if (Config.collideEllipsoidSmoothing) {
            simpleVector3 = new SimpleVector(collisionInfo.r3Pos);
        }
        this.doWorldCollisionEllipsoid(collisionInfo, 0, null, n2);
        if (Config.collideEllipsoidSmoothing) {
            SimpleVector simpleVector4 = collisionInfo.r3Pos.calcSub(simpleVector3);
            simpleVector4.makeEqualLength(new SimpleVector(fArray2));
            simpleVector4.add(simpleVector3);
            collisionInfo.r3Pos = simpleVector4;
        }
        this.camera.backBx = collisionInfo.r3Pos.x;
        this.camera.backBy = collisionInfo.r3Pos.y;
        this.camera.backBz = collisionInfo.r3Pos.z;
        return collisionInfo.collision;
    }

    private final void doWorldCollisionEllipsoid(CollisionInfo collisionInfo, int n, Object3D object3D, int n2) {
        SimpleVector simpleVector;
        Serializable serializable;
        float f = Config.collideEllipsoidThreshold;
        double d = f * f;
        boolean bl = false;
        if (n >= n2) {
            return;
        }
        collisionInfo.foundCollision = false;
        collisionInfo.intersectionPoint = new SimpleVector();
        collisionInfo.nearestDistance = 1.0E11f;
        if (n == 0) {
            collisionInfo.collision = false;
        }
        SimpleVector simpleVector2 = collisionInfo.r3Velocity;
        float f2 = simpleVector2.x * simpleVector2.x + simpleVector2.y * simpleVector2.y + simpleVector2.z * simpleVector2.z;
        SimpleVector simpleVector3 = null;
        float f3 = collisionInfo.eRadius.x;
        if (f3 > collisionInfo.eRadius.y) {
            f3 = collisionInfo.eRadius.y;
        }
        if (f3 > collisionInfo.eRadius.z) {
            f3 = collisionInfo.eRadius.z;
        }
        if (f2 > (f3 *= 2.0f) * f3) {
            simpleVector2 = new SimpleVector(simpleVector2);
            simpleVector2.x = Math.abs(simpleVector2.x);
            simpleVector2.y = Math.abs(simpleVector2.y);
            simpleVector2.z = Math.abs(simpleVector2.z);
            simpleVector2.add(collisionInfo.eRadius);
            simpleVector3 = new SimpleVector(collisionInfo.r3Velocity);
            simpleVector3.scalarMul(0.5f);
            simpleVector3.add(collisionInfo.r3Pos);
        }
        for (int i = 2; i < this.objectList.size(); ++i) {
            serializable = this.objectList.elementAt(i);
            boolean bl2 = ((Object3D)serializable).getLazyTransformationState();
            if (!bl2) {
                ((Object3D)serializable).enableLazyTransformations();
            }
            if (n == 0) {
                ((Object3D)serializable).wasCollider = false;
                ((Object3D)serializable).resetPolygonIDCount();
            }
            if (((Object3D)serializable).isPotentialCollider && (object3D == null || serializable != object3D) && ((Object3D)serializable).isVisible && (((Object3D)serializable).isMainWorld || !((Object3D)serializable).oneSectorOnly || !((Object3D)serializable).hasBoundingBox || simpleVector3 != null && ((Object3D)serializable).ellipsoidIntersectsAABB(simpleVector3, simpleVector2) || simpleVector3 == null && (((Object3D)serializable).ellipsoidIntersectsAABB(collisionInfo.r3Pos, collisionInfo.eRadius) || ((Object3D)serializable).ellipsoidIntersectsAABB(collisionInfo.r3Dest, collisionInfo.eRadius)))) {
                collisionInfo.isPartOfCollision = false;
                ((Object3D)serializable).collideEllipsoid(collisionInfo, Config.collideSectorOffset);
                ((Object3D)serializable).wasCollider |= collisionInfo.isPartOfCollision;
                bl |= collisionInfo.isPartOfCollision;
            }
            if (bl2) continue;
            ((Object3D)serializable).disableLazyTransformations();
        }
        if (!bl) {
            collisionInfo.r3Pos.add(collisionInfo.r3Velocity);
            return;
        }
        SimpleVector simpleVector4 = new SimpleVector(collisionInfo.eSpaceBasePoint);
        simpleVector4.add(collisionInfo.eSpaceVelocity);
        serializable = new SimpleVector(collisionInfo.r3Pos);
        SimpleVector simpleVector5 = new SimpleVector(collisionInfo.eSpaceBasePoint);
        if (collisionInfo.nearestDistance >= f || collisionInfo.nearestDistance <= 0.0f) {
            simpleVector = new SimpleVector(collisionInfo.r3Velocity);
            simpleVector.scalarMul(collisionInfo.nearestDistance - f);
            ((SimpleVector)serializable).add(simpleVector);
            simpleVector = new SimpleVector(collisionInfo.eSpaceVelocity);
            simpleVector.scalarMul(collisionInfo.nearestDistance - f);
            simpleVector5.add(simpleVector);
            simpleVector = collisionInfo.eSpaceVelocity.normalize();
            collisionInfo.intersectionPoint = collisionInfo.intersectionPoint.calcSub(new SimpleVector(f * simpleVector.x, f * simpleVector.y, f * simpleVector.z));
        }
        simpleVector = collisionInfo.intersectionPoint;
        SimpleVector simpleVector6 = simpleVector5.calcSub(collisionInfo.intersectionPoint);
        simpleVector6 = simpleVector6.normalize();
        Plane plane = new Plane(simpleVector, simpleVector6);
        simpleVector6.scalarMul(plane.distanceTo(simpleVector4));
        SimpleVector simpleVector7 = simpleVector4.calcSub(simpleVector6);
        SimpleVector simpleVector8 = simpleVector7.calcSub(collisionInfo.intersectionPoint);
        double d2 = simpleVector8.x * simpleVector8.x + simpleVector8.y * simpleVector8.y + simpleVector8.z * simpleVector8.z;
        simpleVector8.x *= collisionInfo.eRadius.x;
        simpleVector8.y *= collisionInfo.eRadius.y;
        simpleVector8.z *= collisionInfo.eRadius.z;
        if (collisionInfo.addTransMat == null) {
            simpleVector8 = collisionInfo.collisionObject.reverseTransform(simpleVector8, false);
        } else {
            simpleVector8.matMul(collisionInfo.addRotMat);
        }
        collisionInfo.r3Pos = serializable;
        collisionInfo.r3Velocity = simpleVector8;
        SimpleVector simpleVector9 = null;
        if (n == 0) {
            simpleVector9 = new SimpleVector((SimpleVector)serializable);
        }
        collisionInfo.recalcDest();
        if (d2 >= d) {
            this.doWorldCollisionEllipsoid(collisionInfo, n + 1, object3D, n2);
        }
        if (n == 0) {
            this.notifyAll(object3D, collisionInfo, 2, simpleVector9);
        }
    }

    private void notifyAll(Object3D object3D, CollisionInfo collisionInfo, int n, SimpleVector simpleVector) {
        if ((collisionInfo == null || collisionInfo.collision) && Object3D.globalListenerCount > 0) {
            if (this.targets == null) {
                this.targets = new Object3DList(10);
            } else {
                this.targets.clear();
            }
            for (int i = 2; i < this.objectList.size(); ++i) {
                Object3D object3D2 = this.objectList.elementAt(i);
                if (!object3D2.wasCollider) continue;
                this.targets.addElement(object3D2);
            }
            Object3D[] object3DArray = this.targets.toArray();
            if (object3D != null) {
                object3D.notifyCollisionListeners(1, n, object3DArray, simpleVector);
            }
            for (int i = 0; i < this.targets.size(); ++i) {
                Object3D object3D3 = this.targets.elementAt(i);
                object3D3.notifyCollisionListeners(object3D, 0, n, object3DArray, simpleVector);
            }
        }
    }

    WorldProcessor getWorldProcessor() {
        if (this.processor == null) {
            this.processor = new WorldProcessor(1);
        }
        return this.processor;
    }

    protected void finalize() {
        if (!this.disposed) {
            this.dispose();
        }
    }
}

