/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct.util;

import com.threed.jpct.Object3D;
import com.threed.jpct.PolygonManager;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.TextureInfo;

public class ExtendedPrimitives {
    public static Object3D createPivot() {
        return Object3D.createDummyObj();
    }

    public static Object3D createCube() {
        return ExtendedPrimitives.createCube(1.0f);
    }

    public static Object3D createCube(float f) {
        return ExtendedPrimitives.createBox(new SimpleVector(f, f, f));
    }

    public static Object3D createBox(SimpleVector simpleVector) {
        Object3D object3D = new Object3D(12);
        simpleVector.scalarMul(0.5f);
        SimpleVector[] simpleVectorArray = new SimpleVector[]{new SimpleVector(-simpleVector.x, -simpleVector.y, -simpleVector.z), new SimpleVector(simpleVector.x, -simpleVector.y, -simpleVector.z), new SimpleVector(-simpleVector.x, simpleVector.y, -simpleVector.z), new SimpleVector(simpleVector.x, simpleVector.y, -simpleVector.z), new SimpleVector(simpleVector.x, -simpleVector.y, simpleVector.z), new SimpleVector(-simpleVector.x, -simpleVector.y, simpleVector.z), new SimpleVector(simpleVector.x, simpleVector.y, simpleVector.z), new SimpleVector(-simpleVector.x, simpleVector.y, simpleVector.z)};
        object3D.addTriangle(simpleVectorArray[0], 0.0f, 0.0f, simpleVectorArray[2], 0.0f, 1.0f, simpleVectorArray[1], 1.0f, 0.0f);
        object3D.addTriangle(simpleVectorArray[1], 1.0f, 0.0f, simpleVectorArray[2], 0.0f, 1.0f, simpleVectorArray[3], 1.0f, 1.0f);
        object3D.addTriangle(simpleVectorArray[1], 0.0f, 0.0f, simpleVectorArray[3], 0.0f, 1.0f, simpleVectorArray[4], 1.0f, 0.0f);
        object3D.addTriangle(simpleVectorArray[4], 1.0f, 0.0f, simpleVectorArray[3], 0.0f, 1.0f, simpleVectorArray[6], 1.0f, 1.0f);
        object3D.addTriangle(simpleVectorArray[5], 0.0f, 0.0f, simpleVectorArray[7], 0.0f, 1.0f, simpleVectorArray[0], 1.0f, 0.0f);
        object3D.addTriangle(simpleVectorArray[0], 1.0f, 0.0f, simpleVectorArray[7], 0.0f, 1.0f, simpleVectorArray[2], 1.0f, 1.0f);
        object3D.addTriangle(simpleVectorArray[4], 0.0f, 0.0f, simpleVectorArray[6], 0.0f, 1.0f, simpleVectorArray[5], 1.0f, 0.0f);
        object3D.addTriangle(simpleVectorArray[5], 1.0f, 0.0f, simpleVectorArray[6], 0.0f, 1.0f, simpleVectorArray[7], 1.0f, 1.0f);
        object3D.addTriangle(simpleVectorArray[5], 0.0f, 0.0f, simpleVectorArray[0], 0.0f, 1.0f, simpleVectorArray[4], 1.0f, 0.0f);
        object3D.addTriangle(simpleVectorArray[4], 1.0f, 0.0f, simpleVectorArray[0], 0.0f, 1.0f, simpleVectorArray[1], 1.0f, 1.0f);
        object3D.addTriangle(simpleVectorArray[6], 0.0f, 0.0f, simpleVectorArray[3], 0.0f, 1.0f, simpleVectorArray[7], 1.0f, 0.0f);
        object3D.addTriangle(simpleVectorArray[7], 1.0f, 0.0f, simpleVectorArray[3], 0.0f, 1.0f, simpleVectorArray[2], 1.0f, 1.0f);
        return object3D;
    }

    public static Object3D createCylinder(int n) {
        return ExtendedPrimitives.createCylinder(0.5f, 1.0f, n, true);
    }

    public static Object3D createCylinder(float f, float f2, int n, boolean bl) {
        float f3;
        int n2 = 2 * n;
        if (bl) {
            n2 += 2 * n - 4;
        }
        Object3D object3D = new Object3D(n2);
        SimpleVector[] simpleVectorArray = new SimpleVector[n];
        SimpleVector[] simpleVectorArray2 = new SimpleVector[n];
        float f4 = f2 / 2.0f;
        float f5 = 0.0f;
        float f6 = (float)(Math.PI * 2 / (double)n);
        for (int i = 0; i < n; ++i) {
            float f7 = (float)Math.cos(f5);
            float f8 = (float)Math.sin(f5);
            simpleVectorArray[i] = new SimpleVector(f * f7, -f4, f * f8);
            simpleVectorArray2[i] = new SimpleVector(f * f7, f4, f * f8);
            f5 += f6;
        }
        if (bl) {
            f5 = f6 + f6;
            float f9 = 0.5f + 0.5f * (float)Math.cos(0.0);
            f3 = 0.5f - 0.5f * (float)Math.sin(0.0);
            float f10 = 0.5f + 0.5f * (float)Math.cos(f6);
            float f11 = 0.5f - 0.5f * (float)Math.sin(f6);
            float f12 = 0.5f + 0.5f * (float)Math.cos(f5);
            float f13 = 0.5f - 0.5f * (float)Math.sin(f5);
            int n3 = 1;
            while (n3 + 1 < n) {
                f12 = 0.5f + 0.5f * (float)Math.cos(f5);
                f13 = 0.5f - 0.5f * (float)Math.sin(f5);
                object3D.addTriangle(simpleVectorArray[0], f9, f3, simpleVectorArray[n3], f10, f11, simpleVectorArray[n3 + 1], f12, f13);
                object3D.addTriangle(simpleVectorArray2[0], 1.0f - f9, f3, simpleVectorArray2[n3 + 1], 1.0f - f12, f13, simpleVectorArray2[n3], 1.0f - f10, f11);
                f10 = f12;
                f11 = f13;
                f5 += f6;
                ++n3;
            }
        }
        float f14 = 0.0f;
        f3 = 2.0f / (float)n;
        for (int i = 0; i < n; ++i) {
            object3D.addTriangle(simpleVectorArray[i], f14, 0.0f, simpleVectorArray2[i], f14, 1.0f, simpleVectorArray[(i + 1) % n], f14 + f3, 0.0f);
            object3D.addTriangle(simpleVectorArray[(i + 1) % n], f14 + f3, 0.0f, simpleVectorArray2[i], f14, 1.0f, simpleVectorArray2[(i + 1) % n], f14 + f3, 1.0f);
            f14 += f3;
        }
        return object3D;
    }

    public static Object3D createCone(int n) {
        return ExtendedPrimitives.createCone(0.5f, 1.0f, n, true);
    }

    public static Object3D createCone(float f, float f2, int n, boolean bl) {
        float f3;
        int n2 = n;
        if (bl) {
            n2 += n - 2;
        }
        Object3D object3D = new Object3D(n2);
        float f4 = f2 / 2.0f;
        SimpleVector simpleVector = new SimpleVector(0.0f, -f4, 0.0f);
        SimpleVector[] simpleVectorArray = new SimpleVector[n];
        float f5 = 0.0f;
        float f6 = (float)(Math.PI * 2 / (double)n);
        for (int i = 0; i < n; ++i) {
            float f7 = (float)Math.cos(f5);
            float f8 = (float)Math.sin(f5);
            simpleVectorArray[i] = new SimpleVector(f * f7, f4, f * f8);
            f5 += f6;
        }
        if (bl) {
            f5 = f6 + f6;
            float f9 = 0.5f + 0.5f * (float)Math.cos(0.0);
            f3 = 0.5f - 0.5f * (float)Math.sin(0.0);
            float f10 = 0.5f + 0.5f * (float)Math.cos(f6);
            float f11 = 0.5f - 0.5f * (float)Math.sin(f6);
            float f12 = 0.5f + 0.5f * (float)Math.cos(f5);
            float f13 = 0.5f - 0.5f * (float)Math.sin(f5);
            int n3 = 1;
            while (n3 + 1 < n) {
                f12 = 0.5f + 0.5f * (float)Math.cos(f5);
                f13 = 0.5f - 0.5f * (float)Math.sin(f5);
                object3D.addTriangle(simpleVectorArray[0], 1.0f - f9, f3, simpleVectorArray[n3 + 1], 1.0f - f12, f13, simpleVectorArray[n3], 1.0f - f10, f11);
                f10 = f12;
                f11 = f13;
                f5 += f6;
                ++n3;
            }
        }
        float f14 = 0.0f;
        f3 = 2.0f / (float)n;
        for (int i = 0; i < n; ++i) {
            object3D.addTriangle(simpleVector, f14 + f3 / 2.0f, 0.0f, simpleVectorArray[i], f14, 1.0f, simpleVectorArray[(i + 1) % n], f14 + f3, 1.0f);
            f14 += f3;
        }
        return object3D;
    }

    public static Object3D createSprite() {
        return ExtendedPrimitives.createSprite(1.0f);
    }

    public static Object3D createSprite(float f) {
        return ExtendedPrimitives.createSprite(f, f);
    }

    public static Object3D createSprite(float f, float f2) {
        Object3D object3D = new Object3D(2);
        float f3 = f / 2.0f;
        float f4 = f2 / 2.0f;
        SimpleVector simpleVector = new SimpleVector(-f3, -f4, 0.0f);
        SimpleVector simpleVector2 = new SimpleVector(f3, -f4, 0.0f);
        SimpleVector simpleVector3 = new SimpleVector(-f3, f4, 0.0f);
        SimpleVector simpleVector4 = new SimpleVector(f3, f4, 0.0f);
        object3D.addTriangle(simpleVector, 0.0f, 0.0f, simpleVector3, 0.0f, 1.0f, simpleVector2, 1.0f, 0.0f);
        object3D.addTriangle(simpleVector2, 1.0f, 0.0f, simpleVector3, 0.0f, 1.0f, simpleVector4, 1.0f, 1.0f);
        object3D.setBillboarding(true);
        return object3D;
    }

    public static Object3D createPlane(int n) {
        return ExtendedPrimitives.createPlane(1.0f, n);
    }

    public static Object3D createPlane(float f, int n) {
        int n2;
        Object3D object3D = new Object3D(2 * n * n);
        SimpleVector[][] simpleVectorArray = new SimpleVector[n + 1][n + 1];
        for (int i = 0; i <= n; ++i) {
            for (n2 = 0; n2 <= n; ++n2) {
                simpleVectorArray[i][n2] = new SimpleVector(f * ((float)i - (float)n / 2.0f), 0.0f, f * ((float)n2 - (float)n / 2.0f));
            }
        }
        float f2 = 1.0f / (float)n;
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 0; i < n; ++i) {
                object3D.addTriangle(simpleVectorArray[n2][i + 1], f2 * (float)n2, f2 * (float)(n - i - 1), simpleVectorArray[n2][i], f2 * (float)n2, f2 * (float)(n - i), simpleVectorArray[n2 + 1][i + 1], f2 * (float)(n2 + 1), f2 * (float)(n - i - 1));
                object3D.addTriangle(simpleVectorArray[n2 + 1][i + 1], f2 * (float)(n2 + 1), f2 * (float)(n - i - 1), simpleVectorArray[n2][i], f2 * (float)n2, f2 * (float)(n - i), simpleVectorArray[n2 + 1][i], f2 * (float)(n2 + 1), f2 * (float)(n - i));
            }
        }
        return object3D;
    }

    public static Object3D createTorus(int n, int n2) {
        return ExtendedPrimitives.createTorus(0.35f, 0.15f, n, n2);
    }

    public static Object3D createTorus(float f, float f2, int n, int n2) {
        float f3;
        Object3D object3D = new Object3D(2 * n * n2);
        SimpleVector[][] simpleVectorArray = new SimpleVector[n][n2];
        for (int i = 0; i < n2; ++i) {
            double d = Math.PI * 2 * (double)i / (double)n2 + Math.PI;
            f3 = (float)((double)f + (double)f2 * Math.cos(d));
            float f4 = (float)((double)f2 * Math.sin(d));
            float f5 = 0.0f;
            float f6 = (float)(Math.PI * 2 / (double)n);
            for (int j = 0; j < n; ++j) {
                simpleVectorArray[j][i] = new SimpleVector((double)f3 * Math.cos(f5), (double)f4, (double)f3 * Math.sin(f5));
                f5 += f6;
            }
        }
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 1.0f / (float)n;
        f3 = 1.0f / (float)n2;
        for (int i = 0; i < n2; ++i) {
            f7 = 0.0f;
            for (int j = 0; j < n; ++j) {
                object3D.addTriangle(simpleVectorArray[j][i], f7, f8, simpleVectorArray[j][(i + 1) % n2], f7, f8 + f3, simpleVectorArray[(j + 1) % n][i], f7 + f9, f8);
                object3D.addTriangle(simpleVectorArray[(j + 1) % n][i], f7 + f9, f8, simpleVectorArray[j][(i + 1) % n2], f7, f8 + f3, simpleVectorArray[(j + 1) % n][(i + 1) % n2], f7 + f9, f8 + f3);
                f7 += f9;
            }
            f8 += f3;
        }
        return object3D;
    }

    public static Object3D createPyramid() {
        return ExtendedPrimitives.createPyramid(1.0f);
    }

    public static Object3D createPyramid(float f) {
        return ExtendedPrimitives.createPyramid(f, f);
    }

    public static Object3D createPyramid(float f, float f2) {
        Object3D object3D = new Object3D(6);
        float f3 = f / 2.0f;
        float f4 = f2 / 2.0f;
        SimpleVector simpleVector = new SimpleVector(f3, f4, f3);
        SimpleVector simpleVector2 = new SimpleVector(-f3, f4, f3);
        SimpleVector simpleVector3 = new SimpleVector(f3, f4, -f3);
        SimpleVector simpleVector4 = new SimpleVector(-f3, f4, -f3);
        SimpleVector simpleVector5 = new SimpleVector(0.0f, -f4, 0.0f);
        object3D.addTriangle(simpleVector, 0.0f, 0.0f, simpleVector3, 0.0f, 1.0f, simpleVector2, 1.0f, 0.0f);
        object3D.addTriangle(simpleVector2, 1.0f, 0.0f, simpleVector3, 0.0f, 1.0f, simpleVector4, 1.0f, 1.0f);
        object3D.addTriangle(simpleVector5, 0.5f, 0.0f, simpleVector4, 0.0f, 1.0f, simpleVector3, 1.0f, 1.0f);
        object3D.addTriangle(simpleVector5, 0.5f, 0.0f, simpleVector3, 0.0f, 1.0f, simpleVector, 1.0f, 1.0f);
        object3D.addTriangle(simpleVector5, 0.5f, 0.0f, simpleVector2, 0.0f, 1.0f, simpleVector4, 1.0f, 1.0f);
        object3D.addTriangle(simpleVector5, 0.5f, 0.0f, simpleVector, 0.0f, 1.0f, simpleVector2, 1.0f, 1.0f);
        return object3D;
    }

    public static Object3D createSphere(int n) {
        return ExtendedPrimitives.createSphere(0.5f, n);
    }

    public static Object3D createSphere(float f, int n) {
        float f2 = 2.0f * f;
        return ExtendedPrimitives.createEllipsoid(new SimpleVector(f2, f2, f2), n);
    }

    public static Object3D createEllipsoid(SimpleVector simpleVector, int n) {
        return ExtendedPrimitives.createEllipsoid(simpleVector, n, 2.0f, 1.0f);
    }

    public static Object3D createEllipsoid(SimpleVector simpleVector, int n, float f, float f2) {
        float f3;
        float f4;
        int n2;
        float f5;
        float f6;
        int n3 = Math.max(n / 2 + 1, 3);
        Object3D object3D = new Object3D(2 * n * n3);
        SimpleVector[][] simpleVectorArray = new SimpleVector[n][n3];
        for (int i = 0; i < n3; ++i) {
            f6 = (float)(Math.PI * (double)i / (double)(n3 - 1));
            f5 = -0.5f * simpleVector.y * (float)Math.cos(f6);
            float f7 = (float)Math.sin(f6);
            for (n2 = 0; n2 < n; ++n2) {
                f4 = (float)(Math.PI * 2 * (double)n2 / (double)n);
                f3 = 0.5f * simpleVector.x * (float)Math.cos(f4) * f7;
                float f8 = 0.5f * simpleVector.z * (float)Math.sin(f4) * f7;
                simpleVectorArray[n2][i] = new SimpleVector(f3, f5, f8);
            }
        }
        float f9 = 0.0f;
        f5 = f6 = f2 / (float)(n3 - 1);
        int n4 = 0;
        while (n4 + 1 < n3) {
            for (n2 = 0; n2 < n; ++n2) {
                f4 = f * (float)n2 / (float)n;
                f3 = f * (float)(n2 + 1) / (float)n;
                if (n4 > 0) {
                    object3D.addTriangle(simpleVectorArray[n2][n4], f4, f9, simpleVectorArray[n2][n4 + 1], f4, f6, simpleVectorArray[(n2 + 1) % n][n4], f3, f9);
                }
                if (n4 + 2 >= n3) continue;
                object3D.addTriangle(simpleVectorArray[(n2 + 1) % n][n4], f3, f9, simpleVectorArray[n2][n4 + 1], f4, f6, simpleVectorArray[(n2 + 1) % n][n4 + 1], f3, f6);
            }
            f9 = f6;
            f6 += f5;
            ++n4;
        }
        return object3D;
    }

    public static Object3D createDisc(int n) {
        return ExtendedPrimitives.createDisc(0.5f, n);
    }

    public static Object3D createDisc(float f, int n) {
        return ExtendedPrimitives.createDisc(f, f, n);
    }

    public static Object3D createDisc(float f, float f2, int n) {
        float f3;
        float f4;
        Object3D object3D = new Object3D(n - 2);
        SimpleVector[] simpleVectorArray = new SimpleVector[n];
        float f5 = 0.0f;
        float f6 = (float)(Math.PI * 2 / (double)n);
        for (int i = 0; i < n; ++i) {
            f4 = f * (float)Math.cos(f5);
            f3 = f2 * (float)Math.sin(f5);
            simpleVectorArray[i] = new SimpleVector(f4, f3, 0.0f);
            f5 += f6;
        }
        f5 = f6 + f6;
        float f7 = 0.5f - 0.5f * (float)Math.cos(0.0);
        f4 = 0.5f + 0.5f * (float)Math.sin(0.0);
        f3 = 0.5f - 0.5f * (float)Math.cos(f6);
        float f8 = 0.5f + 0.5f * (float)Math.sin(f6);
        float f9 = 0.5f - 0.5f * (float)Math.cos(f5);
        float f10 = 0.5f + 0.5f * (float)Math.sin(f5);
        int n2 = 1;
        while (n2 + 1 < n) {
            f9 = 0.5f - 0.5f * (float)Math.cos(f5);
            f10 = 0.5f + 0.5f * (float)Math.sin(f5);
            object3D.addTriangle(simpleVectorArray[0], 1.0f - f7, f4, simpleVectorArray[n2 + 1], 1.0f - f9, f10, simpleVectorArray[n2], 1.0f - f3, f8);
            f3 = f9;
            f8 = f10;
            f5 += f6;
            ++n2;
        }
        return object3D;
    }

    public static Object3D createCog(int n) {
        return ExtendedPrimitives.createCog(n, 0.1f, 0.4f, 0.5f, 1.0f, 1.0f, 0.0f, 0.1f);
    }

    public static Object3D createCog(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8;
        float f9;
        int n2;
        Object3D object3D = new Object3D(24 * n);
        int n3 = 2 * n;
        SimpleVector[] simpleVectorArray = new SimpleVector[n3];
        SimpleVector[] simpleVectorArray2 = new SimpleVector[n3];
        SimpleVector[] simpleVectorArray3 = new SimpleVector[n3];
        SimpleVector[] simpleVectorArray4 = new SimpleVector[n3];
        SimpleVector[] simpleVectorArray5 = new SimpleVector[n3];
        SimpleVector[] simpleVectorArray6 = new SimpleVector[n3];
        float f10 = f7 / 2.0f;
        float f11 = 0.0f;
        float f12 = (float)(Math.PI / (double)n);
        for (n2 = 0; n2 < n3; ++n2) {
            f9 = f * (float)Math.cos(f11);
            f8 = f * (float)Math.sin(f11);
            simpleVectorArray[n2] = new SimpleVector(f9, -f10, f8);
            simpleVectorArray2[n2] = new SimpleVector(f9, f10, f8);
            f11 += f12;
        }
        f11 = 0.5f * (2.0f - f4) * f12;
        for (n2 = 0; n2 < n3; n2 += 2) {
            f9 = f2 * (float)Math.cos(f11);
            f8 = f2 * (float)Math.sin(f11);
            simpleVectorArray3[n2] = new SimpleVector(f9, -f10, f8);
            simpleVectorArray4[n2] = new SimpleVector(f9, f10, f8);
            f9 = f2 * (float)Math.cos(f11 += f4 * f12);
            f8 = f2 * (float)Math.sin(f11);
            simpleVectorArray3[n2 + 1] = new SimpleVector(f9, -f10, f8);
            simpleVectorArray4[n2 + 1] = new SimpleVector(f9, f10, f8);
            f11 += (2.0f - f4) * f12;
        }
        f11 = 0.5f * f5 * f12 + f6;
        for (n2 = 0; n2 < n3; n2 += 2) {
            f9 = f3 * (float)Math.cos(f11);
            f8 = f3 * (float)Math.sin(f11);
            simpleVectorArray5[n2] = new SimpleVector(f9, -f10, f8);
            simpleVectorArray6[n2] = new SimpleVector(f9, f10, f8);
            f9 = f3 * (float)Math.cos(f11 += (2.0f - f5) * f12);
            f8 = f3 * (float)Math.sin(f11);
            simpleVectorArray5[n2 + 1] = new SimpleVector(f9, -f10, f8);
            simpleVectorArray6[n2 + 1] = new SimpleVector(f9, f10, f8);
            f11 += f5 * f12;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            f9 = 0.5f + 0.5f * simpleVectorArray[n2].x / f3;
            f8 = 0.5f + 0.5f * simpleVectorArray[(n2 + 1) % n3].x / f3;
            float f13 = 0.5f - 0.5f * simpleVectorArray[n2].z / f3;
            float f14 = 0.5f - 0.5f * simpleVectorArray[(n2 + 1) % n3].z / f3;
            float f15 = 0.5f + 0.5f * simpleVectorArray3[n2].x / f3;
            float f16 = 0.5f + 0.5f * simpleVectorArray3[(n2 + 1) % n3].x / f3;
            float f17 = 0.5f - 0.5f * simpleVectorArray3[n2].z / f3;
            float f18 = 0.5f - 0.5f * simpleVectorArray3[(n2 + 1) % n3].z / f3;
            float f19 = 0.5f + 0.5f * simpleVectorArray5[n2].x / f3;
            float f20 = 0.5f + 0.5f * simpleVectorArray5[(n2 + 1) % n3].x / f3;
            float f21 = 0.5f - 0.5f * simpleVectorArray5[n2].z / f3;
            float f22 = 0.5f - 0.5f * simpleVectorArray5[(n2 + 1) % n3].z / f3;
            object3D.addTriangle(simpleVectorArray[(n2 + 1) % n3], f8, f14, simpleVectorArray2[(n2 + 1) % n3], -f8, f14, simpleVectorArray[n2], f9, f13);
            object3D.addTriangle(simpleVectorArray[n2], f9, f13, simpleVectorArray2[(n2 + 1) % n3], -f8, f14, simpleVectorArray2[n2], -f9, f13);
            object3D.addTriangle(simpleVectorArray3[(n2 + 1) % n3], f16, f18, simpleVectorArray[(n2 + 1) % n3], f8, f14, simpleVectorArray3[n2], f15, f17);
            object3D.addTriangle(simpleVectorArray3[n2], f15, f17, simpleVectorArray[(n2 + 1) % n3], f8, f14, simpleVectorArray[n2], f9, f13);
            object3D.addTriangle(simpleVectorArray4[n2], -f15, f17, simpleVectorArray2[n2], -f9, f13, simpleVectorArray4[(n2 + 1) % n3], -f16, f18);
            object3D.addTriangle(simpleVectorArray4[(n2 + 1) % n3], -f16, f18, simpleVectorArray2[n2], -f9, f13, simpleVectorArray2[(n2 + 1) % n3], -f8, f14);
            if (n2 % 2 == 1) {
                object3D.addTriangle(simpleVectorArray5[(n2 + 1) % n3], f20, f22, simpleVectorArray3[(n2 + 1) % n3], f16, f22, simpleVectorArray5[n2], f19, f21);
                object3D.addTriangle(simpleVectorArray5[n2], f19, f21, simpleVectorArray3[(n2 + 1) % n3], f16, f18, simpleVectorArray3[n2], f15, f17);
                object3D.addTriangle(simpleVectorArray6[n2], -f19, f21, simpleVectorArray4[n2], -f15, f17, simpleVectorArray6[(n2 + 1) % n3], -f20, f22);
                object3D.addTriangle(simpleVectorArray6[(n2 + 1) % n3], -f20, f22, simpleVectorArray4[n2], -f15, f17, simpleVectorArray4[(n2 + 1) % n3], -f16, f18);
                object3D.addTriangle(simpleVectorArray5[n2], f19, f21, simpleVectorArray6[n2], f19, f21, simpleVectorArray5[(n2 + 1) % n3], f20, f22);
                object3D.addTriangle(simpleVectorArray5[(n2 + 1) % n3], f20, f22, simpleVectorArray6[n2], f19, f21, simpleVectorArray6[(n2 + 1) % n3], f20, f22);
                object3D.addTriangle(simpleVectorArray3[n2], f15, f17, simpleVectorArray4[n2], f15, f17, simpleVectorArray5[n2], f19, f21);
                object3D.addTriangle(simpleVectorArray5[n2], f19, f21, simpleVectorArray4[n2], f15, f17, simpleVectorArray6[n2], f19, f21);
                continue;
            }
            object3D.addTriangle(simpleVectorArray3[n2], f15, f17, simpleVectorArray4[n2], f15, f17, simpleVectorArray3[(n2 + 1) % n3], f16, f18);
            object3D.addTriangle(simpleVectorArray3[(n2 + 1) % n3], f16, f18, simpleVectorArray4[n2], f15, f17, simpleVectorArray4[(n2 + 1) % n3], f16, f18);
            object3D.addTriangle(simpleVectorArray5[n2], f19, f21, simpleVectorArray6[n2], f19, f21, simpleVectorArray3[n2], f15, f17);
            object3D.addTriangle(simpleVectorArray3[n2], f15, f17, simpleVectorArray6[n2], f19, f21, simpleVectorArray4[n2], f15, f17);
        }
        return object3D;
    }

    public static Object3D createTube(int n) {
        return ExtendedPrimitives.createTube(0.3f, 0.5f, 1.0f, n);
    }

    public static Object3D createTube(float f, float f2, float f3, int n) {
        float f4;
        float f5;
        float f6;
        Object3D object3D = new Object3D(8 * n);
        SimpleVector[] simpleVectorArray = new SimpleVector[n];
        SimpleVector[] simpleVectorArray2 = new SimpleVector[n];
        SimpleVector[] simpleVectorArray3 = new SimpleVector[n];
        SimpleVector[] simpleVectorArray4 = new SimpleVector[n];
        float f7 = f3 / 2.0f;
        float f8 = 0.0f;
        float f9 = (float)Math.PI * 2 / (float)n;
        float f10 = f / f2;
        for (int i = 0; i < n; ++i) {
            f6 = f2 * (float)Math.cos(f8);
            float f11 = f2 * (float)Math.sin(f8);
            f5 = f10 * f6;
            f4 = f10 * f11;
            simpleVectorArray[i] = new SimpleVector(f6, -f7, f11);
            simpleVectorArray2[i] = new SimpleVector(f5, -f7, f4);
            simpleVectorArray3[i] = new SimpleVector(f6, f7, f11);
            simpleVectorArray4[i] = new SimpleVector(f5, f7, f4);
            f8 += f9;
        }
        float f12 = 0.0f;
        f6 = 2.0f / (float)n;
        for (int i = 0; i < n; ++i) {
            f5 = 0.5f + 0.5f * simpleVectorArray[i].x / f2;
            f4 = 0.5f + 0.5f * simpleVectorArray[(i + 1) % n].x / f2;
            float f13 = 0.5f - 0.5f * simpleVectorArray[i].z / f2;
            float f14 = 0.5f - 0.5f * simpleVectorArray[(i + 1) % n].z / f2;
            float f15 = 0.5f + 0.5f * simpleVectorArray2[i].x / f2;
            float f16 = 0.5f + 0.5f * simpleVectorArray2[(i + 1) % n].x / f2;
            float f17 = 0.5f - 0.5f * simpleVectorArray2[i].z / f2;
            float f18 = 0.5f - 0.5f * simpleVectorArray2[(i + 1) % n].z / f2;
            object3D.addTriangle(simpleVectorArray[(i + 1) % n], f4, f14, simpleVectorArray2[(i + 1) % n], f16, f18, simpleVectorArray[i], f5, f13);
            object3D.addTriangle(simpleVectorArray[i], f5, f13, simpleVectorArray2[(i + 1) % n], f16, f18, simpleVectorArray2[i], f15, f17);
            object3D.addTriangle(simpleVectorArray3[i], -f5, f13, simpleVectorArray4[i], -f15, f17, simpleVectorArray3[(i + 1) % n], -f4, f14);
            object3D.addTriangle(simpleVectorArray3[(i + 1) % n], -f4, f14, simpleVectorArray4[i], -f15, f17, simpleVectorArray4[(i + 1) % n], -f16, f18);
            object3D.addTriangle(simpleVectorArray[i], f12, 0.0f, simpleVectorArray3[i], f12, 1.0f, simpleVectorArray[(i + 1) % n], f12 + f6, 0.0f);
            object3D.addTriangle(simpleVectorArray[(i + 1) % n], f12 + f6, 0.0f, simpleVectorArray3[i], f12, 1.0f, simpleVectorArray3[(i + 1) % n], f12 + f6, 1.0f);
            object3D.addTriangle(simpleVectorArray2[(i + 1) % n], -f12 - f6, 0.0f, simpleVectorArray4[(i + 1) % n], -f12 - f6, 1.0f, simpleVectorArray2[i], -f12, 0.0f);
            object3D.addTriangle(simpleVectorArray2[i], -f12, 0.0f, simpleVectorArray4[(i + 1) % n], -f12 - f6, 1.0f, simpleVectorArray4[i], -f12, 1.0f);
            f12 += f6;
        }
        return object3D;
    }

    public static void transformUVCoords(Object3D object3D, float f, float f2, float f3, float f4, float f5, float f6) {
        PolygonManager polygonManager = object3D.getPolygonManager();
        SimpleVector[] simpleVectorArray = new SimpleVector[]{new SimpleVector(), new SimpleVector(), new SimpleVector()};
        for (int i = 0; i < polygonManager.getMaxPolygonID(); ++i) {
            for (int j = 0; j < 3; ++j) {
                polygonManager.getTextureUV(i, j, simpleVectorArray[j]);
                simpleVectorArray[j].x += f;
                simpleVectorArray[j].x *= f3;
                simpleVectorArray[j].x += f5;
                simpleVectorArray[j].y += f2;
                simpleVectorArray[j].y *= f4;
                simpleVectorArray[j].y += f6;
            }
            TextureInfo textureInfo = new TextureInfo(polygonManager.getPolygonTexture(i), simpleVectorArray[0].x, simpleVectorArray[0].y, simpleVectorArray[1].x, simpleVectorArray[1].y, simpleVectorArray[2].x, simpleVectorArray[2].y);
            polygonManager.setPolygonTexture(i, textureInfo);
        }
    }
}

