/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct.util;

import com.threed.jpct.Camera;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Logger;
import com.threed.jpct.Object3D;
import com.threed.jpct.PolygonManager;
import com.threed.jpct.Projector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;
import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class ShadowHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static int cnt = 0;
    private Texture map = null;
    private boolean[] inverts = null;
    private int[] lightsOff = null;
    private boolean[] visible = null;
    private Color[] addColor = null;
    private Hashtable recMap = new Hashtable();
    private Hashtable casMap = new Hashtable();
    private World world = null;
    private FrameBuffer buffer = null;
    private int tid = 0;
    private Projector proj = null;
    private boolean disableLights = true;
    private Color col = new Color(60, 60, 60);
    private String name = "";
    private boolean revert = true;
    private boolean invertCulling = true;
    private boolean disableAddColor = false;
    private int border = 1;
    private boolean rendersShadowMap = false;
    private boolean rendersShadowPass = false;

    public ShadowHelper(World world, FrameBuffer frameBuffer, Projector projector, int n) {
        int n2;
        if (!frameBuffer.supports("GL_ARB_shadow")) {
            Logger.log("Shadow mapping is not supported by the current hardware!", 0);
            return;
        }
        if (n != 8192 && n != 4096 && n != 2048 && n != 1024 && n != 512 && n != 256 && n != 128 && n != 64 && n != 32 && n != 16) {
            n = 256;
            Logger.log("Consider using a power of two lower than 16384 as the shadow map's size. Adjusted to 256*256!", 1);
        }
        int n3 = frameBuffer.getMaxTextureSize();
        Logger.log("Hardware supports textures up to " + n3 + "*" + n3 + " in size!", 2);
        n = Math.min(n, n3);
        this.world = world;
        this.buffer = frameBuffer;
        this.proj = projector;
        int n4 = frameBuffer.getOutputHeight();
        int n5 = frameBuffer.getOutputWidth();
        int n6 = n;
        if (!Config.glUseFBO) {
            for (n2 = n; n2 > n5; n2 /= 2) {
            }
            while (n6 > n4) {
                n6 /= 2;
            }
        }
        if (n6 < (n = n2)) {
            n = n6;
        }
        n2 = n;
        n6 = n;
        this.map = new Texture(n2, n6, null);
        this.name = "--shadowMap-" + cnt + "-";
        TextureManager textureManager = TextureManager.getInstance();
        if (textureManager.containsTexture(this.name)) {
            textureManager.replaceTexture(this.name, this.map);
        } else {
            textureManager.addTexture(this.name, this.map);
        }
        this.tid = textureManager.getTextureID(this.name);
        ++cnt;
        this.map.setGLFiltering(false);
        this.map.setMipmap(false);
        this.map.setProjector(this.proj, true);
        this.map.setAsShadowMap(true);
    }

    public static void resetTextureCounter() {
        cnt = 0;
    }

    public Projector getLightSource() {
        return this.proj;
    }

    public void setLightSource(Projector projector) {
        if (this.map == null) {
            return;
        }
        this.proj = projector;
        this.map.setProjector(this.proj, true);
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void setFrameBuffer(FrameBuffer frameBuffer) {
        this.buffer = frameBuffer;
    }

    public void setRevertMode(boolean bl) {
        this.revert = bl;
    }

    public void setCullingMode(boolean bl) {
        this.invertCulling = bl;
    }

    public void setFiltering(boolean bl) {
        if (this.map == null) {
            return;
        }
        this.map.setGLFiltering(bl);
    }

    public void addReceiver(Object3D object3D) {
        if (this.map == null) {
            return;
        }
        if (!this.recMap.containsKey(object3D)) {
            this.recMap.put(object3D, object3D);
            PolygonManager polygonManager = object3D.getPolygonManager();
            int n = polygonManager.getMaxPolygonID();
            for (int i = 0; i < n; ++i) {
                polygonManager.addTexture(i, this.tid, 1);
            }
        }
    }

    public boolean isInitialized() {
        return this.world != null;
    }

    public void addCaster(Object3D object3D) {
        if (this.map == null) {
            return;
        }
        if (!this.casMap.containsKey(object3D)) {
            this.casMap.put(object3D, object3D);
        }
    }

    public void removeCaster(Object3D object3D) {
        if (this.map == null) {
            return;
        }
        this.casMap.remove(object3D);
    }

    public void setLightMode(boolean bl) {
        this.disableLights = bl;
    }

    public void setAdditionalColorMode(boolean bl) {
        this.disableAddColor = bl;
    }

    public void setAmbientLight(Color color) {
        this.col = color;
    }

    public void drawScene() {
        this.drawScene(true);
    }

    public synchronized void drawScene(boolean bl) {
        if (this.world == null) {
            return;
        }
        this.rendersShadowPass = true;
        this.buffer.setPaintListenerState(false);
        this.checkArrays();
        int n = 0;
        Object object = this.world.getObjects();
        while (object.hasMoreElements()) {
            Object3D object3D = (Object3D)object.nextElement();
            this.lightsOff[n] = object3D.getLighting();
            this.visible[n] = object3D.getVisibility();
            this.addColor[n] = object3D.getAdditionalColor();
            if (this.disableLights) {
                object3D.setLighting(1);
            }
            if (this.disableAddColor) {
                object3D.setAdditionalColor(Color.black);
            }
            if (!this.recMap.containsKey(object3D)) {
                object3D.setVisibility(false);
            }
            ++n;
        }
        this.map.setEnabled(false);
        object = this.world.getAmbientLight();
        this.world.setAmbientLight(this.col.getRed(), this.col.getGreen(), this.col.getBlue());
        boolean bl2 = Config.glRevertADDtoMODULATE;
        Config.glRevertADDtoMODULATE = this.revert;
        this.world.renderScene(this.buffer);
        this.world.draw(this.buffer);
        Config.glRevertADDtoMODULATE = bl2;
        this.map.setEnabled(true);
        n = 0;
        Enumeration enumeration = this.world.getObjects();
        while (enumeration.hasMoreElements()) {
            Object3D object3D = (Object3D)enumeration.nextElement();
            object3D.setLighting(this.lightsOff[n]);
            object3D.setVisibility(this.visible[n]);
            object3D.setAdditionalColor(this.addColor[n]);
            ++n;
        }
        this.buffer.setPaintListenerState(true);
        this.rendersShadowPass = false;
        this.world.setAmbientLight((int)object[0], (int)object[1], (int)object[2]);
        this.world.renderScene(this.buffer);
        if (bl) {
            this.world.draw(this.buffer);
        }
    }

    public boolean isRenderingShadowMap() {
        return this.rendersShadowMap;
    }

    public boolean isRenderingShadowPass() {
        return this.rendersShadowPass;
    }

    public int getReceiverCount() {
        return this.recMap.size();
    }

    public int getCasterCount() {
        return this.casMap.size();
    }

    public Texture getShadowMap() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateShadowMap() {
        Object object;
        Camera camera;
        if (this.world == null) {
            return;
        }
        this.rendersShadowMap = true;
        this.buffer.setPaintListenerState(false);
        Camera camera2 = camera = this.world.getCamera();
        synchronized (camera2) {
            this.world.setCameraTo(this.proj);
            this.checkArrays();
            int n = 0;
            object = this.world.getObjects();
            while (object.hasMoreElements()) {
                Object3D object3D = (Object3D)object.nextElement();
                this.inverts[n] = object3D.cullingIsInverted();
                this.lightsOff[n] = object3D.getLighting();
                this.visible[n] = object3D.getVisibility();
                if (this.invertCulling) {
                    object3D.invertCulling(true);
                }
                if (!this.casMap.containsKey(object3D)) {
                    object3D.setVisibility(false);
                }
                object3D.setLighting(1);
                ++n;
            }
            this.buffer.setRenderTarget(this.map, this.border, this.border, this.border, this.border, true);
            this.buffer.clearZBufferOnly();
            this.map.setEnabled(false);
            this.world.renderScene(this.buffer);
            this.world.draw(this.buffer);
            this.map.setEnabled(true);
            this.buffer.update();
            this.buffer.displayGLOnly();
            this.world.setCameraTo(camera);
        }
        if (!Config.glUseFBO) {
            this.buffer.clearZBufferOnly();
        }
        this.buffer.removeRenderTarget();
        int n = 0;
        Enumeration enumeration = this.world.getObjects();
        while (enumeration.hasMoreElements()) {
            object = (Object3D)enumeration.nextElement();
            ((Object3D)object).invertCulling(this.inverts[n]);
            ((Object3D)object).setLighting(this.lightsOff[n]);
            ((Object3D)object).setVisibility(this.visible[n]);
            ++n;
        }
        this.buffer.setPaintListenerState(true);
        this.rendersShadowMap = false;
    }

    private void checkArrays() {
        if (this.inverts == null || this.world.getSize() + 10 > this.inverts.length) {
            int n = this.world.getSize() + 8;
            this.inverts = new boolean[n];
            this.lightsOff = new int[n];
            this.visible = new boolean[n];
            this.addColor = new Color[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Texture texture = this.map;
        synchronized (texture) {
            if (this.map == null) {
                return;
            }
            TextureManager textureManager = TextureManager.getInstance();
            textureManager.removeAndUnload(this.name, this.buffer);
            this.map = null;
        }
    }

    public void finalize() {
        this.dispose();
    }
}

