/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct.util;

import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Logger;
import com.threed.jpct.Object3D;
import com.threed.jpct.Primitives;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;

public class SkyBox {
    private World world = null;
    private Object3D box = null;
    private boolean disposed = false;
    private float size = 0.0f;

    public SkyBox(float f) {
        this("left", "front", "right", "back", "up", "down", f);
    }

    public SkyBox(String string, String string2, String string3, String string4, String string5, String string6, float f) {
        this.size = f;
        this.world = new World();
        this.box = Object3D.createDummyObj();
        TextureManager textureManager = TextureManager.getInstance();
        Texture texture = textureManager.getTexture(string);
        Texture texture2 = textureManager.getTexture(string2);
        Texture texture3 = textureManager.getTexture(string4);
        Texture texture4 = textureManager.getTexture(string3);
        Texture texture5 = textureManager.getTexture(string5);
        Texture texture6 = textureManager.getTexture(string6);
        if (texture == null || texture4 == null || texture2 == null || texture3 == null || texture5 == null || texture6 == null) {
            Logger.log("Skybox textures not found!", 1);
            return;
        }
        texture.setClamping(true);
        texture2.setClamping(true);
        texture3.setClamping(true);
        texture4.setClamping(true);
        texture5.setClamping(true);
        texture6.setClamping(true);
        Object3D object3D = Primitives.getPlane(1, f);
        Object3D object3D2 = Primitives.getPlane(1, f);
        Object3D object3D3 = Primitives.getPlane(1, f);
        Object3D object3D4 = Primitives.getPlane(1, f);
        Object3D object3D5 = Primitives.getPlane(1, f);
        Object3D object3D6 = Primitives.getPlane(1, f);
        object3D5.rotateX(1.5707964f);
        object3D6.rotateX(-1.5707964f);
        object3D6.rotateY(-1.5707964f);
        object3D2.rotateY(-1.5707964f);
        object3D3.rotateY(1.5707964f);
        object3D4.rotateX((float)(-Math.PI));
        object3D4.rotateZ((float)(-Math.PI));
        object3D5.rotateY(-1.5707964f);
        object3D5.rotateMesh();
        object3D6.rotateMesh();
        object3D2.rotateMesh();
        object3D3.rotateMesh();
        object3D4.rotateMesh();
        object3D.clearRotation();
        object3D6.clearRotation();
        object3D5.clearRotation();
        object3D2.clearRotation();
        object3D3.clearRotation();
        object3D4.clearRotation();
        float f2 = f / 2.0f;
        object3D.translate(0.0f, 0.0f, f2);
        object3D4.translate(0.0f, 0.0f, -f2);
        object3D2.translate(-f2, 0.0f, 0.0f);
        object3D3.translate(f2, 0.0f, 0.0f);
        object3D6.translate(0.0f, -f2, 0.0f);
        object3D5.translate(0.0f, f2, 0.0f);
        object3D.translateMesh();
        object3D6.translateMesh();
        object3D5.translateMesh();
        object3D2.translateMesh();
        object3D3.translateMesh();
        object3D4.translateMesh();
        object3D.setTexture(string2);
        object3D6.setTexture(string5);
        object3D2.setTexture(string);
        object3D3.setTexture(string3);
        object3D4.setTexture(string4);
        object3D5.setTexture(string6);
        this.box = Object3D.mergeAll(new Object3D[]{object3D, object3D6, object3D2, object3D3, object3D4, object3D5});
        this.box.build();
        this.world.setAmbientLight(255, 255, 255);
        this.box.setLighting(1);
        this.world.addObject(this.box);
        this.world.getCamera().setClippingPlanes(1.0f, f);
    }

    public synchronized void dispose() {
        if (!this.disposed) {
            this.world.removeAllObjects();
            this.box = null;
            this.world = null;
            this.disposed = true;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    public World getWorld() {
        return this.world;
    }

    public void compile() {
        this.box.compile();
    }

    public void setCenter(SimpleVector simpleVector) {
        SimpleVector simpleVector2 = SimpleVector.create(simpleVector.x, simpleVector.y, simpleVector.z);
        simpleVector2.scalarMul(-1.0f);
        this.world.getCamera().setPosition(simpleVector2);
        float f = Math.max(Math.max(Math.abs(simpleVector.x), Math.abs(simpleVector.y)), Math.abs(simpleVector.z));
        this.world.getCamera().setClippingPlanes(100.0f, this.size + f);
    }

    public void render(World world, FrameBuffer frameBuffer) {
        if (this.disposed) {
            return;
        }
        this.world.getCamera().getBack().setTo(world.getCamera().getBack());
        this.world.renderScene(frameBuffer);
        this.world.draw(frameBuffer);
    }
}

