/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.Camera;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Loader;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.OcTree;
import com.threed.jpct.Primitives;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;
import com.threed.jpct.util.KeyMapper;
import com.threed.jpct.util.KeyState;
import java.awt.Color;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.io.File;

class JPCTDemo {
    private static final SimpleVector STARTING_POS = new SimpleVector(800.0f, -120.0f, -400.0f);
    private static final float COLLISION_SPHERE_RADIUS = 8.0f;
    private static final float PLAYER_HEIGHT = 30.0f;
    private static final SimpleVector ELLIPSOID_RADIUS = new SimpleVector(8.0f, 15.0f, 8.0f);
    private static final float GRAVITY = 4.0f;
    private static final float MOVE_SPEED = 2.5f;
    private static final float TURN_SPEED = 0.06f;
    private static final int SWITCH_RENDERER = 35;
    private boolean fullscreen = false;
    private boolean openGL = false;
    private boolean wireframe = false;
    private Object3D level = null;
    private Object3D weapon = null;
    private Object3D elevator = null;
    private FrameBuffer buffer = null;
    private World theWorld = null;
    private TextureManager texMan = null;
    private Camera camera = null;
    private Texture numbers = null;
    private Matrix playerDirection = new Matrix();
    private SimpleVector tempVector = new SimpleVector();
    private int width = 640;
    private int height = 480;
    private Frame frame = null;
    private Graphics gFrame = null;
    private BufferStrategy bufferStrategy = null;
    private GraphicsDevice device = null;
    private int titleBarHeight = 0;
    private int leftBorderWidth = 0;
    private int switchMode = 0;
    private int fps;
    private int lastFps;
    private long totalFps;
    private int pps;
    private int lastPps;
    private boolean isIdle = false;
    private boolean exit = false;
    private boolean left = false;
    private boolean right = false;
    private boolean up = false;
    private boolean down = false;
    private boolean forward = false;
    private boolean back = false;
    private KeyMapper keyMapper = null;
    float elevatorOffset = -0.8f;
    float elevatorPosition = -90.0f;
    int elevatorCountdown = 50;

    public static void main(String[] stringArray) {
        JPCTDemo jPCTDemo = new JPCTDemo(stringArray);
    }

    private JPCTDemo(String[] stringArray) {
        Object3D[] object3DArray;
        char c;
        for (c = '\u0000'; c < stringArray.length; ++c) {
            if (stringArray[c].equals("fullscreen")) {
                this.fullscreen = true;
                Config.glFullscreen = true;
            }
            if (stringArray[c].equals("mipmap")) {
                Config.glMipmap = true;
            }
            if (stringArray[c].equals("trilinear")) {
                Config.glTrilinear = true;
            }
            if (stringArray[c].equals("16bit")) {
                Config.glColorDepth = 16;
            }
            try {
                if (stringArray[c].startsWith("width=")) {
                    this.width = Integer.parseInt(stringArray[c].substring(6));
                }
                if (stringArray[c].startsWith("height=")) {
                    this.height = Integer.parseInt(stringArray[c].substring(7));
                }
                if (stringArray[c].startsWith("refresh=")) {
                    Config.glRefresh = Integer.parseInt(stringArray[c].substring(8));
                }
                if (!stringArray[c].startsWith("zbuffer=") || (Config.glZBufferDepth = Integer.parseInt(stringArray[c].substring(8))) != 16) continue;
                Config.glFixedBlitting = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isIdle = false;
        this.switchMode = 0;
        this.totalFps = 0L;
        this.fps = 0;
        this.lastFps = 0;
        this.theWorld = new World();
        this.texMan = TextureManager.getInstance();
        Config.fadeoutLight = true;
        Config.linearDiv = 100.0f;
        Config.lightDiscardDistance = 350.0f;
        this.theWorld.getLights().setOverbrightLighting(255);
        this.theWorld.getLights().setRGBScale(2);
        this.theWorld.setAmbientLight(10, 15, 15);
        this.theWorld.addLight(new SimpleVector(820.0f, -150.0f, -400.0f), 5.0f, 20.0f, 15.0f);
        this.theWorld.addLight(new SimpleVector(850.0f, -130.0f, -580.0f), 20.0f, 18.0f, 2.0f);
        this.theWorld.addLight(new SimpleVector(850.0f, -130.0f, -760.0f), 15.0f, 10.0f, 15.0f);
        this.theWorld.addLight(new SimpleVector(1060.0f, -170.0f, -910.0f), 20.0f, 0.0f, 0.0f);
        this.theWorld.addLight(new SimpleVector(760.0f, -200.0f, -990.0f), 15.0f, 10.0f, 20.0f);
        this.theWorld.addLight(new SimpleVector(850.0f, -230.0f, -780.0f), 0.0f, 15.0f, 25.0f);
        this.theWorld.addLight(new SimpleVector(600.0f, -230.0f, -770.0f), 20.0f, 25.0f, 0.0f);
        this.theWorld.addLight(new SimpleVector(405.0f, -230.0f, -610.0f), 18.0f, 20.0f, 25.0f);
        this.theWorld.addLight(new SimpleVector(340.0f, -150.0f, -370.0f), 15.0f, 20.0f, 25.0f);
        this.theWorld.addLight(new SimpleVector(650.0f, -170.0f, -200.0f), 15.0f, 0.0f, 0.0f);
        this.theWorld.addLight(new SimpleVector(870.0f, -230.0f, -190.0f), 15.0f, 20.0f, 20.0f);
        this.theWorld.addLight(new SimpleVector(540.0f, -190.0f, -180.0f), 15.0f, 15.0f, 15.0f);
        this.theWorld.setFogging(1);
        this.theWorld.setFogParameters(500.0f, 0.0f, 0.0f, 0.0f);
        Config.farPlane = 500.0f;
        c = File.separatorChar;
        this.numbers = new Texture("textures" + c + "other" + c + "numbers.jpg");
        this.texMan.addTexture("numbers", this.numbers);
        this.texMan.addTexture("envmap", new Texture("textures" + c + "other" + c + "envmap.jpg"));
        File file = new File("textures");
        String[] stringArray2 = file.list();
        for (int i = 0; i < stringArray2.length; ++i) {
            object3DArray = stringArray2[i];
            if (!object3DArray.toLowerCase().endsWith(".jpg")) continue;
            this.texMan.addTexture((String)object3DArray, new Texture("textures" + c + (String)object3DArray));
        }
        Object3D[] object3DArray2 = Loader.load3DS((String)("3ds" + c + "weapon.3ds"), (float)2.0f);
        this.weapon = object3DArray2[0];
        this.weapon.rotateY(-1.5707964f);
        this.weapon.rotateZ(-1.5707964f);
        this.weapon.rotateX(-0.44879895f);
        this.weapon.rotateMesh();
        this.weapon.translate(6.0f, 6.0f, 10.0f);
        this.weapon.translateMesh();
        this.weapon.setRotationMatrix(new Matrix());
        this.weapon.setTranslationMatrix(new Matrix());
        this.weapon.setTexture("envmap");
        this.weapon.setEnvmapped(true);
        this.weapon.setEnvmapMode(false);
        this.theWorld.addObject(this.weapon);
        object3DArray = Loader.load3DS((String)("3ds" + c + "ql.3ds"), (float)20.0f);
        this.level = new Object3D(0);
        for (int i = 0; i < object3DArray.length; ++i) {
            Object3D object3D = object3DArray[i];
            object3D.setCenter(SimpleVector.ORIGIN);
            object3D.rotateX(-1.5707964f);
            object3D.rotateMesh();
            object3D.setRotationMatrix(new Matrix());
            this.level = Object3D.mergeObjects((Object3D)this.level, (Object3D)object3D);
        }
        this.level.createTriangleStrips(2);
        this.level.setCollisionMode(1);
        this.level.setCollisionOptimization(true);
        OcTree ocTree = new OcTree(this.level, 100, 1);
        ocTree.setCollisionUse(true);
        this.level.setOcTree(ocTree);
        this.level.enableLazyTransformations();
        this.theWorld.addObject(this.level);
        this.elevator = Primitives.getBox((float)15.0f, (float)0.1f);
        this.elevator.rotateY(0.7853982f);
        this.elevator.setOrigin(new SimpleVector(800.0f, -90.0f, -450.0f));
        this.elevator.setCollisionOptimization(true);
        this.elevator.setCollisionMode(1);
        this.elevator.setTexture("envmap");
        this.elevator.setEnvmapped(true);
        this.elevator.setEnvmapMode(true);
        this.theWorld.addObject(this.elevator);
        this.camera = this.theWorld.getCamera();
        this.camera.setPosition(STARTING_POS);
        this.theWorld.buildAllObjects();
        this.weapon.setRotationPivot(new SimpleVector(0.0f, 0.0f, 0.0f));
        Config.collideOffset = 250.0f;
        Config.tuneForOutdoor();
        this.initializeFrame();
        this.gameLoop();
    }

    private void initializeFrame() {
        if (this.fullscreen) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.device = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = this.device.getDefaultConfiguration();
            this.frame = new Frame(graphicsConfiguration);
            this.frame.setUndecorated(true);
            this.frame.setIgnoreRepaint(true);
            this.device.setFullScreenWindow(this.frame);
            if (this.device.isDisplayChangeSupported()) {
                this.device.setDisplayMode(new DisplayMode(this.width, this.height, 32, 0));
            }
            this.frame.createBufferStrategy(2);
            this.bufferStrategy = this.frame.getBufferStrategy();
            Graphics graphics = this.bufferStrategy.getDrawGraphics();
            this.bufferStrategy.show();
            graphics.dispose();
        } else {
            this.frame = new Frame();
            this.frame.setTitle("jPCT " + Config.getVersion());
            this.frame.pack();
            Insets insets = this.frame.getInsets();
            this.titleBarHeight = insets.top;
            this.leftBorderWidth = insets.left;
            this.frame.setSize(this.width + this.leftBorderWidth + insets.right, this.height + this.titleBarHeight + insets.bottom);
            this.frame.setResizable(false);
            this.frame.show();
            this.gFrame = this.frame.getGraphics();
        }
        this.frame.addWindowListener(new WindowEvents());
        this.keyMapper = new KeyMapper((Component)this.frame);
    }

    private void display() {
        this.blitNumber((int)this.totalFps, 5, 2);
        this.blitNumber(this.lastPps, 5, 12);
        if (!this.openGL) {
            if (!this.fullscreen) {
                this.buffer.display(this.gFrame, this.leftBorderWidth, this.titleBarHeight);
            } else {
                Graphics graphics = this.bufferStrategy.getDrawGraphics();
                graphics.drawImage(this.buffer.getOutputBuffer(), 0, 0, null);
                this.bufferStrategy.show();
                graphics.dispose();
            }
        } else {
            this.buffer.displayGLOnly();
        }
    }

    private void blitNumber(int n, int n2, int n3) {
        if (this.numbers != null) {
            String string = Integer.toString(n);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                int n4 = c - 48;
                this.buffer.blit(this.numbers, (float)(n4 * 5), 0.0f, (float)n2, (float)n3, 5.0f, 9.0f, true);
                n2 += 5;
            }
        }
    }

    private void doMovement() {
        SimpleVector simpleVector = this.camera.getPosition();
        simpleVector.add(new SimpleVector(0.0f, 15.0f, 0.0f));
        SimpleVector simpleVector2 = new SimpleVector(0.0f, 4.0f, 0.0f);
        simpleVector2 = this.theWorld.checkCollisionEllipsoid(simpleVector, simpleVector2, ELLIPSOID_RADIUS, 1);
        simpleVector.add(new SimpleVector(0.0f, -15.0f, 0.0f));
        simpleVector2.x = 0.0f;
        simpleVector2.z = 0.0f;
        simpleVector.add(simpleVector2);
        this.camera.setPosition(simpleVector);
        boolean bl = false;
        if (this.forward) {
            this.camera.moveCamera(new SimpleVector(0.0f, 1.0f, 0.0f), 15.0f);
            bl = true;
            this.tempVector = this.playerDirection.getZAxis();
            this.theWorld.checkCameraCollisionEllipsoid(this.tempVector, ELLIPSOID_RADIUS, 2.5f, 5);
        }
        if (this.back) {
            if (!bl) {
                this.camera.moveCamera(new SimpleVector(0.0f, 1.0f, 0.0f), 15.0f);
                bl = true;
            }
            this.tempVector = this.playerDirection.getZAxis();
            this.tempVector.scalarMul(-1.0f);
            this.theWorld.checkCameraCollisionEllipsoid(this.tempVector, ELLIPSOID_RADIUS, 2.5f, 5);
        }
        if (this.left) {
            this.camera.rotateAxis(this.camera.getBack().getYAxis(), -0.06f);
            this.playerDirection.rotateY(-0.06f);
        }
        if (this.right) {
            this.camera.rotateAxis(this.camera.getBack().getYAxis(), 0.06f);
            this.playerDirection.rotateY(0.06f);
        }
        if (this.up) {
            this.camera.rotateX(0.06f);
        }
        if (this.down) {
            this.camera.rotateX(-0.06f);
        }
        if (bl) {
            this.camera.moveCamera(new SimpleVector(0.0f, -1.0f, 0.0f), 15.0f);
        }
    }

    private void moveElevator() {
        if (this.elevator.wasTargetOfLastCollision() && this.elevatorCountdown-- <= 0 || this.elevatorPosition != -90.0f && this.elevatorPosition != -180.0f) {
            float f = this.elevatorPosition + this.elevatorOffset;
            float f2 = this.elevatorOffset;
            if (f < -180.0f) {
                f2 = -180.0f - this.elevatorPosition;
                this.elevatorCountdown = 50;
                this.elevatorOffset *= -1.0f;
            } else if (f > -90.0f) {
                f2 = -90.0f - this.elevatorPosition;
                this.elevatorCountdown = 50;
                this.elevatorOffset *= -1.0f;
            }
            this.elevatorPosition += f2;
            this.elevator.translate(0.0f, f2, 0.0f);
        }
    }

    private void poll() {
        KeyState keyState = null;
        do {
            if ((keyState = this.keyMapper.poll()) == KeyState.NONE) continue;
            this.keyAffected(keyState);
        } while (keyState != KeyState.NONE);
    }

    private void gameLoop() {
        World.setDefaultThread((Thread)Thread.currentThread());
        this.buffer = new FrameBuffer(this.width, this.height, 0);
        this.buffer.enableRenderer(1);
        this.buffer.setBoundingBoxMode(false);
        this.buffer.optimizeBufferAccess();
        Timer timer = new Timer(25);
        timer.start();
        Timer timer2 = new Timer(1000);
        timer2.start();
        long l = 0L;
        while (!this.exit) {
            if (!this.isIdle) {
                long l2 = timer.getElapsedTicks();
                l += l2;
                int n = 0;
                while ((long)n < l2) {
                    this.doMovement();
                    this.moveElevator();
                    ++n;
                }
                this.poll();
                if (this.switchMode != 0) {
                    this.switchOptions();
                }
                this.buffer.clear();
                this.weapon.getTranslationMatrix().setIdentity();
                this.weapon.translate(this.camera.getPosition());
                this.weapon.align(this.camera);
                this.weapon.rotateAxis(this.camera.getDirection(), (float)Math.sin((float)l / 6.0f) / 20.0f);
                this.theWorld.renderScene(this.buffer);
                if (!this.wireframe) {
                    this.theWorld.draw(this.buffer);
                } else {
                    this.theWorld.drawWireframe(this.buffer, Color.white);
                }
                this.buffer.update();
                this.display();
                ++this.fps;
                this.pps += this.theWorld.getVisibilityList().getSize();
                if (timer2.getElapsedTicks() > 0L) {
                    this.totalFps = this.fps - this.lastFps;
                    this.lastFps = this.fps;
                    this.lastPps = this.pps;
                    this.pps = 0;
                }
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.buffer.dispose();
        if (!this.openGL && this.fullscreen) {
            this.device.setFullScreenWindow(null);
        }
        System.exit(0);
    }

    private void switchOptions() {
        switch (this.switchMode) {
            case 35: {
                this.isIdle = true;
                if (this.buffer.usesRenderer(2)) {
                    this.keyMapper.destroy();
                    this.buffer.disableRenderer(2);
                    this.buffer.enableRenderer(1, 1);
                    this.openGL = false;
                    if (this.fullscreen) {
                        this.device.setFullScreenWindow(null);
                    }
                    this.frame.hide();
                    this.frame.dispose();
                    this.initializeFrame();
                } else {
                    this.frame.hide();
                    this.keyMapper.destroy();
                    this.buffer.enableRenderer(2, 1);
                    this.buffer.disableRenderer(1);
                    this.openGL = true;
                    this.keyMapper = new KeyMapper();
                }
                this.isIdle = false;
            }
        }
        this.switchMode = 0;
    }

    private void keyAffected(KeyState keyState) {
        int n = keyState.getKeyCode();
        boolean bl = keyState.getState();
        switch (n) {
            case 27: {
                this.exit = bl;
                break;
            }
            case 37: {
                this.left = bl;
                break;
            }
            case 39: {
                this.right = bl;
                break;
            }
            case 33: {
                this.up = bl;
                break;
            }
            case 34: {
                this.down = bl;
                break;
            }
            case 38: {
                this.forward = bl;
                break;
            }
            case 40: {
                this.back = bl;
                break;
            }
            case 49: {
                if (!bl || !this.buffer.supports("GL_ARB_texture_env_combine")) break;
                this.theWorld.getLights().setRGBScale(1);
                break;
            }
            case 50: {
                if (!bl || !this.buffer.supports("GL_ARB_texture_env_combine")) break;
                this.theWorld.getLights().setRGBScale(2);
                break;
            }
            case 52: {
                if (!bl || !this.buffer.supports("GL_ARB_texture_env_combine")) break;
                this.theWorld.getLights().setRGBScale(4);
                break;
            }
            case 87: {
                if (!bl) break;
                this.wireframe = !this.wireframe;
                break;
            }
            case 88: {
                if (!bl) break;
                this.switchMode = 35;
            }
        }
    }

    private class Timer {
        private long ticks = 0L;
        private long granularity = 0L;

        public Timer(int n) {
            this.granularity = n;
        }

        public void start() {
            this.ticks = System.currentTimeMillis();
        }

        public void reset() {
            this.start();
        }

        public long getElapsedTicks() {
            long l = System.currentTimeMillis();
            long l2 = l - this.ticks;
            if (l2 >= this.granularity) {
                this.ticks = l - l2 % this.granularity;
                return l2 / this.granularity;
            }
            return 0L;
        }
    }

    private class WindowEvents
    extends WindowAdapter {
        private WindowEvents() {
        }

        public void windowIconified(WindowEvent windowEvent) {
            JPCTDemo.this.isIdle = true;
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            JPCTDemo.this.isIdle = false;
        }
    }
}

