/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.Camera;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Loader;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.OcTree;
import com.threed.jpct.Primitives;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.io.InputStream;
import org.lwjgl.input.Keyboard;

class JPCTDemoWS
implements Runnable {
    private static final int[][] LWJGL_MAPPING = new int[][]{{45, 88}, {17, 87}, {1, 27}, {200, 38}, {208, 40}, {203, 37}, {205, 39}, {201, 33}, {209, 34}, {2, 49}, {3, 50}, {5, 52}};
    private static final SimpleVector STARTING_POS = new SimpleVector(800.0f, -220.0f, -400.0f);
    private static final float COLLISION_SPHERE_RADIUS = 8.0f;
    private static final float PLAYER_HEIGHT = 30.0f;
    private static final SimpleVector ELLIPSOID_RADIUS = new SimpleVector(8.0f, 15.0f, 8.0f);
    private static final float GRAVITY = 4.0f;
    private static final float MOVE_SPEED = 2.5f;
    private static final float TURN_SPEED = 0.06f;
    private static final int SWITCH_RENDERER = 35;
    private boolean fullscreen = false;
    private boolean doResize = false;
    private boolean openGL = false;
    private boolean wireframe = false;
    private Object3D level = null;
    private Object3D weapon = null;
    private Object3D elevator = null;
    private FrameBuffer buffer = null;
    private World theWorld = null;
    private TextureManager texMan = null;
    private Camera camera = null;
    private Texture numbers = null;
    private Matrix playerDirection = new Matrix();
    private SimpleVector tempVector = new SimpleVector();
    private int width = 640;
    private int height = 480;
    private int widthGL = 640;
    private int heightGL = 480;
    private Frame frame = null;
    private Graphics gFrame = null;
    private BufferStrategy bufferStrategy = null;
    private GraphicsDevice device = null;
    private int titleBarHeight = 0;
    private int leftBorderWidth = 0;
    private Thread timerThread;
    private int timerTicks = 0;
    private int switchMode = 0;
    private int fps;
    private int lastFps;
    private long totalFps;
    private int pps;
    private int lastPps;
    private boolean isIdle = false;
    private boolean exit = false;
    private boolean[] isKeydown = new boolean[LWJGL_MAPPING.length];
    private boolean left = false;
    private boolean right = false;
    private boolean up = false;
    private boolean down = false;
    private boolean forward = false;
    private boolean back = false;
    float elevatorOffset = -0.8f;
    float elevatorPosition = -5.0f;
    int elevatorCountdown = 50;

    public static void main(String[] args) {
        try {
            JPCTDemoWS jPCTDemoWS = new JPCTDemoWS(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.timer();
    }

    private JPCTDemoWS(String[] args) throws Exception {
        Frame waitFrame = new Frame();
        waitFrame.setTitle("jPCT - Initializing...");
        waitFrame.pack();
        waitFrame.setSize(200, 60);
        waitFrame.setResizable(false);
        waitFrame.add(new Label("Please wait..."));
        waitFrame.show();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("fullscreen")) {
                this.fullscreen = true;
                Config.glFullscreen = true;
            }
            if (args[i].equals("mipmap")) {
                Config.glMipmap = true;
            }
            if (args[i].equals("trilinear")) {
                Config.glTrilinear = true;
            }
            if (args[i].equals("16bit")) {
                Config.glColorDepth = 16;
            }
            if (args[i].equals("verbose")) {
                Config.glVerbose = true;
            }
            try {
                if (args[i].startsWith("width=")) {
                    this.widthGL = this.width = Integer.parseInt(args[i].substring(6));
                }
                if (args[i].startsWith("height=")) {
                    this.heightGL = this.height = Integer.parseInt(args[i].substring(7));
                }
                if (args[i].startsWith("refresh=")) {
                    Config.glRefresh = Integer.parseInt(args[i].substring(8));
                }
                if (args[i].startsWith("zbuffer=") && (Config.glZBufferDepth = Integer.parseInt(args[i].substring(8))) == 16) {
                    Config.glFixedBlitting = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.isIdle = false;
        this.switchMode = 0;
        this.totalFps = 0L;
        this.fps = 0;
        this.lastFps = 0;
        this.theWorld = new World();
        this.texMan = TextureManager.getInstance();
        Config.fadeoutLight = true;
        Config.linearDiv = 100.0f;
        Config.lightDiscardDistance = 350.0f;
        this.theWorld.getLights().setOverbrightLighting(255);
        this.theWorld.getLights().setRGBScale(2);
        this.theWorld.setAmbientLight(10, 15, 15);
        this.theWorld.addLight(new SimpleVector(735.0f, -190.0f, -424.0f), 5.0f, 20.0f, 15.0f);
        this.theWorld.addLight(new SimpleVector(961.0f, -180.0f, -456.0f), 20.0f, 18.0f, 2.0f);
        this.theWorld.addLight(new SimpleVector(1100.0f, -180.0f, -454.0f), 15.0f, 10.0f, 15.0f);
        this.theWorld.addLight(new SimpleVector(487.0f, -180.0f, -399.0f), 20.0f, 0.0f, 10.0f);
        this.theWorld.addLight(new SimpleVector(197.0f, -180.0f, -364.0f), 15.0f, 10.0f, 20.0f);
        this.theWorld.addLight(new SimpleVector(732.0f, -202.0f, -68.0f), 15.0f, 20.0f, 25.0f);
        this.theWorld.addLight(new SimpleVector(735.0f, -190.0f, 356.0f), 20.0f, 25.0f, 15.0f);
        this.theWorld.addLight(new SimpleVector(466.0f, -180.0f, 345.0f), 18.0f, 20.0f, 25.0f);
        this.theWorld.addLight(new SimpleVector(199.0f, -180.0f, 179.0f), 15.0f, 20.0f, 25.0f);
        this.theWorld.addLight(new SimpleVector(824.0f, -100.0f, -29.0f), 15.0f, 5.0f, 10.0f);
        this.theWorld.addLight(new SimpleVector(1085.0f, -120.0f, -26.0f), 15.0f, 20.0f, 20.0f);
        this.theWorld.addLight(new SimpleVector(407.0f, -80.0f, -25.0f), 17.0f, 15.0f, 12.0f);
        this.theWorld.addLight(new SimpleVector(210.0f, -80.0f, -125.0f), 15.0f, 25.0f, 15.0f);
        this.theWorld.addLight(new SimpleVector(73.0f, -80.0f, -32.0f), 15.0f, 10.0f, 15.0f);
        this.theWorld.setFogging(1);
        this.theWorld.setFogParameters(500.0f, 0.0f, 0.0f, 0.0f);
        Config.farPlane = 500.0f;
        InputStream in = this.getStream("textures/other/numbers.jpg");
        this.numbers = new Texture(in);
        this.texMan.addTexture("numbers", this.numbers);
        in.close();
        in = this.getStream("textures/other/envmap.jpg");
        this.texMan.addTexture("envmap", new Texture(in));
        in.close();
        int i2 = 0;
        while (i2 < 22) {
            String name = "pd" + i2 + ".jpg";
            in = this.getStream("textures/" + name);
            this.texMan.addTexture(name, new Texture(in));
            in.close();
            ++i2;
        }
        in = this.getStream("3ds/weapon.3ds");
        Object3D[] miss = Loader.load3DS((InputStream)in, (float)2.0f);
        in.close();
        this.weapon = miss[0];
        this.weapon.rotateY(-1.5707964f);
        this.weapon.rotateZ(-1.5707964f);
        this.weapon.rotateX(-0.44879895f);
        this.weapon.rotateMesh();
        this.weapon.translate(6.0f, 6.0f, 10.0f);
        this.weapon.translateMesh();
        this.weapon.setRotationMatrix(new Matrix());
        this.weapon.setTranslationMatrix(new Matrix());
        this.weapon.setTexture("envmap");
        this.weapon.setEnvmapped(true);
        this.weapon.setEnvmapMode(false);
        this.theWorld.addObject(this.weapon);
        in = this.getStream("3ds/ql.3ds");
        Object3D[] levelParts = Loader.load3DS((InputStream)in, (float)20.0f);
        in.close();
        this.level = new Object3D(0);
        int i3 = 0;
        while (i3 < levelParts.length) {
            Object3D part = levelParts[i3];
            part.setCenter(SimpleVector.ORIGIN);
            part.rotateX(-1.5707964f);
            part.rotateMesh();
            part.setRotationMatrix(new Matrix());
            this.level = Object3D.mergeObjects((Object3D)this.level, (Object3D)part);
            ++i3;
        }
        this.level.setCollisionMode(1);
        this.level.setCollisionOptimization(true);
        OcTree oc = new OcTree(this.level, 100, 1);
        oc.setCollisionUse(true);
        this.level.setOcTree(oc);
        this.level.enableLazyTransformations();
        this.theWorld.addObject(this.level);
        this.elevator = Primitives.getBox((float)15.0f, (float)0.1f);
        this.elevator.rotateY(0.7853982f);
        this.elevator.setOrigin(new SimpleVector(1160.0f, -5.0f, -420.0f));
        this.elevator.setCollisionOptimization(true);
        this.elevator.setCollisionMode(1);
        this.elevator.setTexture("envmap");
        this.elevator.setEnvmapped(true);
        this.elevator.setEnvmapMode(true);
        this.theWorld.addObject(this.elevator);
        this.camera = this.theWorld.getCamera();
        this.camera.setPosition(STARTING_POS);
        this.theWorld.buildAllObjects();
        this.weapon.setRotationPivot(new SimpleVector(0.0f, 0.0f, 0.0f));
        Config.collideOffset = 250.0f;
        Config.tuneForOutdoor();
        waitFrame.hide();
        this.initializeFrame();
        this.startThread();
        this.gameLoop();
    }

    private void initializeFrame() {
        if (this.fullscreen) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.device = env.getDefaultScreenDevice();
            GraphicsConfiguration gc = this.device.getDefaultConfiguration();
            this.frame = new Frame(gc);
            this.frame.setUndecorated(true);
            this.frame.setIgnoreRepaint(true);
            this.device.setFullScreenWindow(this.frame);
            if (this.device.isDisplayChangeSupported()) {
                this.device.setDisplayMode(new DisplayMode(this.width, this.height, 32, 0));
            }
            this.frame.createBufferStrategy(2);
            this.bufferStrategy = this.frame.getBufferStrategy();
            Graphics g = this.bufferStrategy.getDrawGraphics();
            this.bufferStrategy.show();
            g.dispose();
        } else {
            this.frame = new Frame();
            this.frame.setTitle("jPCT " + Config.getVersion());
            this.frame.pack();
            Insets insets = this.frame.getInsets();
            this.titleBarHeight = insets.top;
            this.leftBorderWidth = insets.left;
            this.frame.setSize(this.width + this.leftBorderWidth + insets.right, this.height + this.titleBarHeight + insets.bottom);
            this.frame.setResizable(true);
            this.frame.show();
            this.gFrame = this.frame.getGraphics();
            this.frame.addComponentListener(new CompEvents());
        }
        this.frame.addWindowListener(new WindowEvents());
        this.frame.addKeyListener(new KeyEvents());
    }

    private void startThread() {
        if (this.timerThread == null) {
            this.timerThread = new Thread(this);
            this.timerThread.start();
        }
    }

    private void display() {
        this.blitNumber((int)this.totalFps, 5, 2);
        this.blitNumber(this.lastPps, 5, 12);
        if (!this.openGL) {
            if (!this.fullscreen) {
                this.buffer.display(this.gFrame, this.leftBorderWidth, this.titleBarHeight);
            } else {
                Graphics g = this.bufferStrategy.getDrawGraphics();
                g.drawImage(this.buffer.getOutputBuffer(), 0, 0, null);
                this.bufferStrategy.show();
                g.dispose();
            }
        } else {
            this.buffer.displayGLOnly();
        }
    }

    private void blitNumber(int number, int x, int y) {
        if (this.numbers != null) {
            String sNum = Integer.toString(number);
            int i = 0;
            while (i < sNum.length()) {
                char cNum = sNum.charAt(i);
                int iNum = cNum - 48;
                this.buffer.blit(this.numbers, (float)(iNum * 5), 0.0f, (float)x, (float)y, 5.0f, 9.0f, true);
                x += 5;
                ++i;
            }
        }
    }

    private void timer() {
        Thread.currentThread().setPriority(10);
        try {
            while (!this.exit) {
                ++this.timerTicks;
                Thread.sleep(20L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void doMovement() {
        SimpleVector camPos = this.camera.getPosition();
        camPos.add(new SimpleVector(0.0f, 15.0f, 0.0f));
        SimpleVector dir = new SimpleVector(0.0f, 4.0f, 0.0f);
        dir = this.theWorld.checkCollisionEllipsoid(camPos, dir, ELLIPSOID_RADIUS, 1);
        camPos.add(new SimpleVector(0.0f, -15.0f, 0.0f));
        dir.x = 0.0f;
        dir.z = 0.0f;
        camPos.add(dir);
        this.camera.setPosition(camPos);
        boolean cameraChanged = false;
        if (this.forward) {
            this.camera.moveCamera(new SimpleVector(0.0f, 1.0f, 0.0f), 15.0f);
            cameraChanged = true;
            this.tempVector = this.playerDirection.getZAxis();
            this.theWorld.checkCameraCollisionEllipsoid(this.tempVector, ELLIPSOID_RADIUS, 2.5f, 8);
        }
        if (this.back) {
            if (!cameraChanged) {
                this.camera.moveCamera(new SimpleVector(0.0f, 1.0f, 0.0f), 15.0f);
                cameraChanged = true;
            }
            this.tempVector = this.playerDirection.getZAxis();
            this.tempVector.scalarMul(-1.0f);
            this.theWorld.checkCameraCollisionEllipsoid(this.tempVector, ELLIPSOID_RADIUS, 2.5f, 8);
        }
        if (this.left) {
            this.camera.rotateAxis(this.camera.getBack().getYAxis(), -0.06f);
            this.playerDirection.rotateY(-0.06f);
        }
        if (this.right) {
            this.camera.rotateAxis(this.camera.getBack().getYAxis(), 0.06f);
            this.playerDirection.rotateY(0.06f);
        }
        if (this.up) {
            this.camera.rotateX(0.06f);
        }
        if (this.down) {
            this.camera.rotateX(-0.06f);
        }
        if (cameraChanged) {
            this.camera.moveCamera(new SimpleVector(0.0f, -1.0f, 0.0f), 15.0f);
        }
    }

    private void moveElevator() {
        if (this.elevator.wasTargetOfLastCollision() && this.elevatorCountdown-- <= 0 || this.elevatorPosition != -5.0f && this.elevatorPosition != -110.0f) {
            float tempElevator = this.elevatorPosition + this.elevatorOffset;
            float tempOffset = this.elevatorOffset;
            if (tempElevator < -110.0f) {
                tempOffset = -110.0f - this.elevatorPosition;
                this.elevatorCountdown = 50;
                this.elevatorOffset *= -1.0f;
            } else if (tempElevator > -5.0f) {
                tempOffset = -5.0f - this.elevatorPosition;
                this.elevatorCountdown = 50;
                this.elevatorOffset *= -1.0f;
            }
            this.elevatorPosition += tempOffset;
            this.elevator.translate(0.0f, tempOffset, 0.0f);
        }
    }

    private void gameLoop() {
        World.setDefaultThread((Thread)Thread.currentThread());
        Thread.currentThread().setPriority(5);
        this.buffer = new FrameBuffer(this.width, this.height, 0);
        this.buffer.enableRenderer(1);
        this.buffer.setBoundingBoxMode(false);
        this.buffer.optimizeBufferAccess();
        long startTime = System.currentTimeMillis();
        long ticks = this.timerTicks;
        Color lineColor = Color.white;
        while (!this.exit) {
            if (!this.isIdle) {
                if (!this.doResize) {
                    long difTicks = (long)this.timerTicks - ticks;
                    ticks = this.timerTicks;
                    int i = 0;
                    while ((long)i < difTicks) {
                        this.doMovement();
                        this.moveElevator();
                        ++i;
                    }
                    if (this.openGL) {
                        this.pollLWJGLKeys();
                    }
                    if (this.switchMode != 0) {
                        this.switchOptions();
                    }
                    this.buffer.clear();
                    this.weapon.getTranslationMatrix().setIdentity();
                    this.weapon.translate(this.camera.getPosition());
                    this.weapon.align(this.camera);
                    this.weapon.rotateAxis(this.camera.getDirection(), (float)Math.sin((float)this.timerTicks / 6.0f) / 20.0f);
                    this.theWorld.renderScene(this.buffer);
                    if (!this.wireframe) {
                        this.theWorld.draw(this.buffer);
                    } else {
                        this.theWorld.drawWireframe(this.buffer, lineColor);
                    }
                    this.buffer.update();
                    this.display();
                    ++this.fps;
                    this.pps += this.theWorld.getVisibilityList().getSize();
                } else {
                    ticks = this.timerTicks;
                }
                long endTime = System.currentTimeMillis();
                if (endTime - startTime > 1000L) {
                    if (this.doResize) {
                        this.doResize();
                        ticks = this.timerTicks;
                    }
                    this.totalFps = this.fps - this.lastFps;
                    this.lastFps = this.fps;
                    startTime = endTime;
                    this.lastPps = this.pps;
                    this.pps = 0;
                }
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.openGL) {
            this.buffer.disableRenderer(2);
        } else if (this.fullscreen) {
            this.device.setFullScreenWindow(null);
        }
        System.exit(0);
    }

    private void switchOptions() {
        switch (this.switchMode) {
            case 35: {
                this.isIdle = true;
                if (this.buffer.usesRenderer(2)) {
                    try {
                        if (Keyboard.isCreated()) {
                            Keyboard.destroy();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.buffer.disableRenderer(2);
                    this.buffer = new FrameBuffer(this.width, this.height, 0);
                    this.buffer.enableRenderer(1, 1);
                    this.openGL = false;
                    if (this.fullscreen) {
                        this.device.setFullScreenWindow(null);
                    }
                    this.frame.hide();
                    this.frame.dispose();
                    this.initializeFrame();
                } else {
                    this.frame.hide();
                    this.buffer.disableRenderer(1);
                    this.buffer = new FrameBuffer(this.widthGL, this.heightGL, 0);
                    this.buffer.disableRenderer(1);
                    this.buffer.enableRenderer(2, 1);
                    this.openGL = true;
                    if (!Keyboard.isCreated()) {
                        try {
                            Keyboard.create();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.isIdle = false;
            }
        }
        this.switchMode = 0;
    }

    private void processKey(KeyEvent e, boolean event) {
        int code = e.getKeyCode();
        this.keyAffected(code, event);
    }

    private void keyPressed(int code) {
        this.keyAffected(code, true);
    }

    private void keyReleased(int code) {
        this.keyAffected(code, false);
    }

    private void keyAffected(int code, boolean event) {
        switch (code) {
            case 27: {
                this.exit = event;
                break;
            }
            case 37: {
                this.left = event;
                break;
            }
            case 39: {
                this.right = event;
                break;
            }
            case 33: {
                this.up = event;
                break;
            }
            case 34: {
                this.down = event;
                break;
            }
            case 38: {
                this.forward = event;
                break;
            }
            case 40: {
                this.back = event;
                break;
            }
            case 49: {
                if (!event || !this.buffer.supports("GL_ARB_texture_env_combine")) break;
                this.theWorld.getLights().setRGBScale(1);
                break;
            }
            case 50: {
                if (event && this.buffer.supports("GL_ARB_texture_env_combine")) {
                    this.theWorld.getLights().setRGBScale(2);
                }
                if (this.doResize) {
                    System.out.println("Waiting for resize!");
                    break;
                }
                System.out.println("No resize pending!");
                break;
            }
            case 52: {
                if (!event || !this.buffer.supports("GL_ARB_texture_env_combine")) break;
                this.theWorld.getLights().setRGBScale(4);
                break;
            }
            case 87: {
                if (!event) break;
                this.wireframe = !this.wireframe;
                break;
            }
            case 88: {
                if (!event) break;
                this.switchMode = 35;
            }
        }
    }

    private void pollLWJGLKeys() {
        if (Keyboard.isCreated()) {
            Keyboard.poll();
            int i = 0;
            while (i < LWJGL_MAPPING.length) {
                int lwjglCode = LWJGL_MAPPING[i][0];
                int javaCode = LWJGL_MAPPING[i][1];
                if (Keyboard.isKeyDown((int)lwjglCode)) {
                    this.keyPressed(javaCode);
                    this.isKeydown[i] = true;
                } else if (this.isKeydown[i]) {
                    this.keyReleased(javaCode);
                    this.isKeydown[i] = false;
                }
                ++i;
            }
        }
    }

    private InputStream getStream(String name) {
        return this.getClass().getClassLoader().getResourceAsStream(name);
    }

    private void doResize() {
        Dimension tt = this.frame.getSize();
        Insets insets = this.frame.getInsets();
        int x = tt.width - insets.left - insets.right;
        int y = tt.height - insets.top - insets.bottom;
        if (x != this.width || y != this.height) {
            this.width = x;
            this.height = y;
            boolean temp = Config.texelFilter;
            this.buffer = new FrameBuffer(this.width, this.height, 0);
            this.buffer.enableRenderer(1);
            this.buffer.setBoundingBoxMode(false);
            Config.texelFilter = temp;
            this.frame.pack();
            this.frame.setSize(tt);
            this.frame.show();
        }
        this.doResize = false;
    }

    private final class CompEvents
    implements ComponentListener {
        private CompEvents() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            JPCTDemoWS.this.doResize = true;
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    private class KeyEvents
    implements KeyListener {
        private KeyEvents() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JPCTDemoWS.this.processKey(e, true);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            JPCTDemoWS.this.processKey(e, false);
        }
    }

    private class WindowEvents
    extends WindowAdapter {
        private WindowEvents() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
            JPCTDemoWS.this.isIdle = true;
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            JPCTDemoWS.this.isIdle = false;
        }
    }
}

