/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.multithread;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

abstract class BackgroundLoader {
    private static final int WIDTH = 32;
    private static final int HEIGHT = 32;
    private static final Object lock = new Object();
    private Drawable drawable;
    private boolean running = true;
    private ByteBuffer texture = BufferUtils.createByteBuffer((int)3072);
    private int texID;

    protected BackgroundLoader() {
    }

    abstract Drawable getDrawable() throws LWJGLException;

    void cleanup() {
        this.running = false;
    }

    void start() throws LWJGLException {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                System.out.println("-- Background Thread started --");
                System.out.println("** Sleeping, no texture created yet **");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    BackgroundLoader.this.drawable = BackgroundLoader.this.getDrawable();
                    BackgroundLoader.this.drawable.makeCurrent();
                }
                catch (LWJGLException e) {
                    throw new RuntimeException(e);
                }
                System.out.println("** Drawable created **");
                Object e = lock;
                synchronized (e) {
                    BackgroundLoader.this.createCheckerTexture(Color.RED, Color.WHITE, 2);
                    BackgroundLoader.this.texID = GL11.glGenTextures();
                    GL11.glBindTexture((int)3553, (int)BackgroundLoader.this.texID);
                    GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)32, (int)32, (int)0, (int)6407, (int)5121, (ByteBuffer)BackgroundLoader.this.texture);
                    GL11.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
                    GL11.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
                    GL11.glBindTexture((int)3553, (int)0);
                }
                System.out.println("** Dummy texture created **");
                long lastTextureCreated = System.currentTimeMillis();
                int count = 0;
                while (BackgroundLoader.this.running) {
                    long time = System.currentTimeMillis();
                    if (time - lastTextureCreated < 5000L) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e2) {
                            e2.printStackTrace();
                        }
                        continue;
                    }
                    if (count % 2 == 0) {
                        BackgroundLoader.this.createGradientTexture(Color.RED, Color.BLUE);
                    } else {
                        BackgroundLoader.this.createGradientTexture(Color.GREEN, Color.YELLOW);
                    }
                    GL11.glBindTexture((int)3553, (int)BackgroundLoader.this.texID);
                    GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)32, (int)32, (int)0, (int)6407, (int)5121, (ByteBuffer)BackgroundLoader.this.texture);
                    GL11.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
                    GL11.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
                    GL11.glBindTexture((int)3553, (int)0);
                    System.out.println("** Created new gradient texture **");
                    lastTextureCreated = System.currentTimeMillis();
                    ++count;
                }
                BackgroundLoader.this.drawable.destroy();
                System.out.println("-- Background Thread finished --");
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTexID() {
        Object object = lock;
        synchronized (object) {
            return this.texID;
        }
    }

    private void createCheckerTexture(ReadableColor a, ReadableColor b, int size) {
        int i = 0;
        for (int y = 0; y < 32; ++y) {
            for (int x = 0; x < 32; ++x) {
                ReadableColor c = x / size % 2 == 0 ? (y / size % 2 == 0 ? a : b) : (y / size % 2 == 0 ? b : a);
                this.texture.put(i + 0, c.getRedByte());
                this.texture.put(i + 1, c.getGreenByte());
                this.texture.put(i + 2, c.getBlueByte());
                i += 3;
            }
        }
    }

    private void createGradientTexture(ReadableColor a, ReadableColor b) {
        float l = 0.0f;
        int i = 0;
        for (int y = 0; y < 32; ++y) {
            for (int x = 0; x < 32; ++x) {
                this.texture.put(i + 0, BackgroundLoader.lerp(a.getRed(), b.getRed(), l));
                this.texture.put(i + 1, BackgroundLoader.lerp(a.getGreen(), b.getGreen(), l));
                this.texture.put(i + 2, BackgroundLoader.lerp(a.getBlue(), b.getBlue(), l));
                i += 3;
            }
            l += 0.032258064f;
        }
    }

    private static byte lerp(int a, int b, float l) {
        return (byte)Math.round((1.0f - l) * (float)a + l * (float)b);
    }
}

