/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.Camera;
import com.threed.jpct.CollisionListener;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.IPaintListener;
import com.threed.jpct.Loader;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.OcTree;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;
import com.threed.jpct.util.KeyMapper;
import com.threed.jpct.util.KeyState;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class AppletCarTest
extends Applet
implements IPaintListener {
    private boolean wireframe = false;
    private FrameBuffer buffer = null;
    private World theWorld = null;
    private TextureManager texMan = null;
    private Camera camera = null;
    private Canvas canvas = null;
    private Object3D terrain = null;
    private Car car = null;
    private ProjectileManager bulMan = null;
    private PlantManager plantMan = null;
    private SkidMarkManager skidMan = null;
    private Texture numbers = null;
    private int width = 640;
    private int height = 480;
    private int fps;
    private int lastFps;
    private long totalFps;
    private int pps;
    private int lastPps;
    private boolean isIdle = false;
    private boolean exit = false;
    private boolean left = false;
    private boolean right = false;
    private boolean forward = false;
    private boolean back = false;
    private boolean fire = false;
    private int fireCount = 3;
    private float speed = 0.0f;
    private KeyMapper keyMapper = null;
    private String home = "";

    public void getUp() {
        Config.maxPolysVisible = 5000;
        Config.glAWTCommandQueueSize = 100;
        Config.glMipmap = true;
        this.isIdle = false;
        this.totalFps = 0L;
        this.fps = 0;
        this.lastFps = 0;
        this.theWorld = new World();
        this.texMan = TextureManager.getInstance();
        Config.fadeoutLight = false;
        this.theWorld.getLights().setOverbrightLighting(255);
        this.theWorld.getLights().setRGBScale(2);
        this.theWorld.setAmbientLight(25, 30, 30);
        this.theWorld.addLight(new SimpleVector(0.0f, -150.0f, 0.0f), 25.0f, 22.0f, 19.0f);
        this.theWorld.addLight(new SimpleVector(-1000.0f, -150.0f, 1000.0f), 22.0f, 5.0f, 4.0f);
        this.theWorld.addLight(new SimpleVector(1000.0f, -150.0f, -1000.0f), 4.0f, 2.0f, 22.0f);
        this.theWorld.setFogging(1);
        this.theWorld.setFogParameters(1200.0f, 0.0f, 0.0f, 0.0f);
        Config.farPlane = 1200.0f;
        char c = File.separatorChar;
        this.numbers = new Texture("textures" + c + "other" + c + "numbers.jpg");
        this.texMan.addTexture("numbers", this.numbers);
        Texture texture = new Texture("textures" + c + "rocks.jpg");
        this.texMan.addTexture("rocks", texture);
        Object3D[] object3DArray = Loader.load3DS((String)("models" + c + "terascene.3ds"), (float)400.0f);
        if (object3DArray.length > 0) {
            this.terrain = object3DArray[0];
            this.terrain.setTexture("rocks");
        }
        this.terrain.enableLazyTransformations();
        this.theWorld.addObject(this.terrain);
        this.car = new Car();
        this.car.addToWorld(this.theWorld);
        this.terrain.build();
        SimpleVector simpleVector = this.terrain.getCenter();
        simpleVector.scalarMul(-1.0f);
        this.terrain.translate(simpleVector);
        this.terrain.rotateX(-1.5707964f);
        this.terrain.translateMesh();
        this.terrain.rotateMesh();
        this.terrain.setTranslationMatrix(new Matrix());
        this.terrain.setRotationMatrix(new Matrix());
        this.terrain.createTriangleStrips(2);
        this.bulMan = new ProjectileManager(this.theWorld);
        this.plantMan = new PlantManager(this.theWorld, this.terrain, 1800.0f);
        this.skidMan = new SkidMarkManager(this.theWorld);
        OcTree ocTree = new OcTree(this.terrain, 50, 1);
        this.terrain.setOcTree(ocTree);
        ocTree.setCollisionUse(true);
        Config.collideOffset = 250.0f;
        this.terrain.setCollisionMode(1);
        this.terrain.setCollisionOptimization(true);
        this.terrain.addCollisionListener((CollisionListener)new BulletTerrainListener(this.bulMan));
        this.camera = this.theWorld.getCamera();
        this.camera.setPosition(0.0f, -2500.0f, -1500.0f);
        this.camera.lookAt(this.car.getTransformedCenter());
        Config.tuneForOutdoor();
        this.initializeFrame();
    }

    public void paint(Graphics graphics) {
        if (this.canvas != null) {
            this.canvas.paint(graphics);
        } else {
            super.paint(graphics);
        }
    }

    public void startPainting() {
    }

    public void finishedPainting() {
        ++this.fps;
    }

    private void initializeFrame() {
        this.setSize(640, 480);
        this.setLayout(null);
        this.setVisible(true);
    }

    private void display() {
        this.blitNumber((int)this.totalFps, 5, 22);
        this.blitNumber(this.lastPps, 5, 212);
        this.plantMan.drawRadar(this.buffer, this.car);
        this.buffer.displayGLOnly();
    }

    private void blitNumber(int n, int n2, int n3) {
        if (this.numbers != null) {
            String string = Integer.toString(n);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                int n4 = c - 48;
                this.buffer.blit(this.numbers, (float)(n4 * 5), 0.0f, (float)n2, (float)n3, 5.0f, 9.0f, true);
                n2 += 5;
            }
        }
    }

    private void moveCar() {
        boolean bl;
        if (this.left) {
            this.car.turnLeft();
        }
        if (this.right) {
            this.car.turnRight();
        }
        Matrix matrix = this.car.getTranslationMatrix().cloneMatrix();
        if (this.forward) {
            if (this.speed < 15.0f) {
                this.speed += 0.1f;
            }
            this.car.setSpeed(this.speed);
            this.car.moveForward();
        }
        if (this.back) {
            if (this.speed > 0.0f) {
                this.speed -= 0.3f;
            }
            if (this.speed < 0.0f) {
                this.speed = 0.0f;
            }
            this.car.setSpeed(this.speed);
            this.car.moveForward();
        }
        if (this.speed >= 0.0f && !this.back && !this.forward) {
            this.speed -= 0.075f;
            if (this.speed < 0.0f) {
                this.speed = 0.0f;
            }
            this.car.setSpeed(this.speed);
            this.car.moveForward();
        }
        if (!(bl = this.car.place(this.terrain))) {
            this.car.setTranslationMatrix(matrix);
            this.speed = 0.0f;
            this.car.setSpeed(this.speed);
        } else {
            this.skidMan.createSkidMarks(this.car);
        }
    }

    private void moveCamera() {
        SimpleVector simpleVector = this.camera.getPosition();
        SimpleVector simpleVector2 = new SimpleVector(simpleVector);
        simpleVector.scalarMul(9.0f);
        SimpleVector simpleVector3 = this.car.getTransformedCenter();
        SimpleVector simpleVector4 = new SimpleVector(simpleVector3);
        SimpleVector simpleVector5 = this.car.getZAxis();
        SimpleVector simpleVector6 = new SimpleVector(0.0f, -100.0f, 0.0f);
        simpleVector5.scalarMul(-250.0f);
        simpleVector4.add(simpleVector5);
        simpleVector4.add(simpleVector6);
        simpleVector4.add(simpleVector);
        simpleVector4.scalarMul(0.1f);
        SimpleVector simpleVector7 = simpleVector4.calcSub(simpleVector2);
        float f = simpleVector7.length();
        if (f != 0.0f) {
            this.theWorld.checkCameraCollisionEllipsoid(simpleVector7.normalize(), new SimpleVector(20.0f, 20.0f, 20.0f), f, 3);
        }
        this.camera.lookAt(this.car.getTransformedCenter());
    }

    private void processProjectiles() {
        if (this.fire || this.fireCount != 3) {
            --this.fireCount;
            if (this.fireCount == 0) {
                this.bulMan.createBullet(this.car);
                this.fireCount = 3;
            }
        }
        this.bulMan.moveBullets();
    }

    private void gameLoop() {
        Thread.currentThread().setPriority(10);
        World.setDefaultThread((Thread)Thread.currentThread());
        this.buffer = new FrameBuffer(this.width, this.height, 0);
        this.buffer.disableRenderer(1);
        this.canvas = this.buffer.enableGLCanvasRenderer();
        this.add(this.canvas);
        this.buffer.setBoundingBoxMode(false);
        this.buffer.setPaintListener((IPaintListener)this);
        this.keyMapper = new KeyMapper((Component)this.canvas);
        Config.glVertexArrays = true;
        Timer timer = new Timer(25);
        timer.start();
        Timer timer2 = new Timer(1000);
        timer2.start();
        while (!this.exit) {
            if (!this.isIdle) {
                long l = timer.getElapsedTicks();
                int n = 0;
                while ((long)n < l) {
                    this.moveCar();
                    this.processProjectiles();
                    this.moveCamera();
                    ++n;
                }
                this.poll();
                this.buffer.clear();
                this.theWorld.renderScene(this.buffer);
                if (!this.wireframe) {
                    this.theWorld.draw(this.buffer);
                } else {
                    this.theWorld.drawWireframe(this.buffer, Color.white);
                }
                this.buffer.update();
                this.display();
                this.repaint();
                this.pps += this.theWorld.getVisibilityList().getSize();
                if (timer2.getElapsedTicks() > 0L) {
                    this.totalFps = this.fps - this.lastFps;
                    this.lastFps = this.fps;
                    this.lastPps = this.pps;
                    this.pps = 0;
                }
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.buffer.disableRenderer(2);
    }

    private void poll() {
        KeyState keyState = null;
        do {
            if ((keyState = this.keyMapper.poll()) == KeyState.NONE) continue;
            this.keyAffected(keyState);
        } while (keyState != KeyState.NONE);
    }

    private void keyAffected(KeyState keyState) {
        int n = keyState.getKeyCode();
        boolean bl = keyState.getState();
        switch (n) {
            case 37: {
                this.left = bl;
                break;
            }
            case 39: {
                this.right = bl;
                break;
            }
            case 38: {
                this.forward = bl;
                break;
            }
            case 32: {
                this.fire = bl;
                break;
            }
            case 40: {
                this.back = bl;
                break;
            }
            case 87: {
                if (!bl) break;
                this.wireframe = !this.wireframe;
            }
        }
    }

    public void init() {
        try {
            System.out.print("Loading native libraries...");
            String string = this.getCodeBase().toExternalForm();
            byte[] byArray = new Transferer(string + "/lwjgl.dll").transfer();
            File file = new File(this.home);
            file.mkdirs();
            String string2 = System.getProperty("java.library.path");
            String string3 = File.pathSeparator;
            int n = string2.indexOf(string3);
            this.home = n != -1 ? string2.substring(0, n) : string2;
            file = new File(this.home + File.separatorChar + "lwjgl.dll");
            System.out.println(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray, 0, byArray.length);
            ((OutputStream)fileOutputStream).close();
            System.out.println("done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void start() {
        new Thread(){

            public void run() {
                AppletCarTest.this.getUp();
                AppletCarTest.this.gameLoop();
            }
        }.start();
    }

    public void destroy() {
        this.exit = true;
    }

    public void stop() {
        this.exit = true;
    }

    private class Timer {
        private long ticks = 0L;
        private long granularity = 0L;

        public Timer(int n) {
            this.granularity = n;
        }

        public void start() {
            this.ticks = System.currentTimeMillis();
        }

        public void reset() {
            this.start();
        }

        public long getElapsedTicks() {
            long l = System.currentTimeMillis();
            long l2 = l - this.ticks;
            if (l2 >= this.granularity) {
                this.ticks = l - l2 % this.granularity;
                return l2 / this.granularity;
            }
            return 0L;
        }
    }

    private class Transferer {
        private URL url;

        public Transferer(String string) {
            try {
                this.url = new URL(string);
            }
            catch (Exception exception) {
                Logger.log((String)"Invalid URL!", (int)0);
            }
        }

        public byte[] transfer() {
            try {
                URLConnection uRLConnection = this.url.openConnection();
                uRLConnection.setDoOutput(true);
                uRLConnection.setDoInput(true);
                uRLConnection.setUseCaches(false);
                byte[] byArray = new byte[500000];
                InputStream inputStream = uRLConnection.getInputStream();
                int n = 0;
                int n2 = 0;
                do {
                    if ((n = inputStream.read(byArray, n2, byArray.length - n2)) == -1) continue;
                    n2 += n;
                } while (n != -1);
                inputStream.close();
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                return byArray2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }
}

