/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.CollisionEvent;
import com.threed.jpct.CollisionListener;
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;

public class BulletTerrainListener
implements CollisionListener {
    private ProjectileManager bulMan = null;

    public BulletTerrainListener(ProjectileManager projectileManager) {
        this.bulMan = projectileManager;
    }

    public boolean requiresPolygonIDs() {
        return true;
    }

    public void collision(CollisionEvent collisionEvent) {
        Object3D object3D;
        if (collisionEvent.getType() == 0 && collisionEvent.getSource() != null && (object3D = collisionEvent.getSource()) instanceof Bullet) {
            Bullet bullet = (Bullet)object3D;
            bullet.disable();
            Object3D object3D2 = collisionEvent.getObject();
            object3D2.disableCollisionListeners();
            SimpleVector simpleVector = bullet.getZAxis();
            SimpleVector simpleVector2 = bullet.getTransformedCenter();
            float f = object3D2.calcMinDistance(simpleVector2, simpleVector, bullet.getSpeed() * 10.0f);
            if (f != 1.0E12f) {
                simpleVector.scalarMul(f * 0.6f);
                simpleVector2.add(simpleVector);
                int[] nArray = collisionEvent.getPolygonIDs();
                if (nArray != null && nArray.length > 0) {
                    int n = nArray[0];
                    SimpleVector simpleVector3 = collisionEvent.getObject().getPolygonManager().getTransformedNormal(n);
                    this.bulMan.createDecal(simpleVector2, simpleVector3);
                }
            }
            object3D2.enableCollisionListeners();
        }
    }
}

