/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.Primitives;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;
import java.io.File;

public class Car
extends AbstractEntity {
    private Object3D leftFront = null;
    private Object3D leftRear = null;
    private Object3D rightFront = Primitives.getSphere((int)5, (float)4.0f);
    private Object3D rightRear = null;
    private float yRot = 0.0f;

    public Car() {
        super(Primitives.getBox((float)8.0f, (float)0.25f));
        this.leftFront = Primitives.getSphere((int)5, (float)4.0f);
        this.rightRear = Primitives.getSphere((int)5, (float)4.0f);
        this.leftRear = Primitives.getSphere((int)5, (float)4.0f);
        this.addChild(this.rightFront);
        this.addChild(this.leftFront);
        this.addChild(this.rightRear);
        this.addChild(this.leftRear);
        this.setTexture("car");
        this.rightFront.setTexture("car");
        this.leftFront.setTexture("car");
        this.rightRear.setTexture("car");
        this.leftRear.setTexture("car");
        this.setEnvmapped(true);
        this.rightFront.setEnvmapped(true);
        this.leftFront.setEnvmapped(true);
        this.rightRear.setEnvmapped(true);
        this.leftRear.setEnvmapped(true);
        this.rightFront.translate(new SimpleVector(-8.0f, 4.0f, 8.0f));
        this.rightRear.translate(new SimpleVector(-8.0f, 4.0f, -8.0f));
        this.leftFront.translate(new SimpleVector(8.0f, 4.0f, 8.0f));
        this.leftRear.translate(new SimpleVector(8.0f, 4.0f, -8.0f));
        this.rightFront.translateMesh();
        this.rightRear.translateMesh();
        this.leftFront.translateMesh();
        this.leftRear.translateMesh();
        this.rightFront.setTranslationMatrix(new Matrix());
        this.rightRear.setTranslationMatrix(new Matrix());
        this.leftFront.setTranslationMatrix(new Matrix());
        this.leftRear.setTranslationMatrix(new Matrix());
        this.build();
        this.rightRear.build();
        this.rightFront.build();
        this.leftRear.build();
        this.leftFront.build();
    }

    public void addToWorld(World world) {
        super.addToWorld(world);
        world.addObject(this.rightFront);
        world.addObject(this.rightRear);
        world.addObject(this.leftFront);
        world.addObject(this.leftRear);
    }

    public boolean place(Object3D object3D) {
        float f;
        SimpleVector simpleVector = new SimpleVector(0.0f, 1.0f, 0.0f);
        Matrix matrix = this.getRotationMatrix();
        matrix.setIdentity();
        this.setRotationMatrix(matrix);
        this.rotateY(this.yRot);
        this.translate(0.0f, -10.0f, 0.0f);
        float f2 = object3D.calcMinDistance(this.rightFront.getTransformedCenter(), simpleVector, 120.0f);
        float f3 = object3D.calcMinDistance(this.rightRear.getTransformedCenter(), simpleVector, 120.0f);
        float f4 = object3D.calcMinDistance(this.leftFront.getTransformedCenter(), simpleVector, 120.0f);
        float f5 = object3D.calcMinDistance(this.leftRear.getTransformedCenter(), simpleVector, 120.0f);
        this.translate(0.0f, 10.0f, 0.0f);
        matrix = this.getRotationMatrix();
        matrix.setIdentity();
        this.setRotationMatrix(matrix);
        if (f2 != 1.0E12f && f3 != 1.0E12f && f4 != 1.0E12f && f5 != 1.0E12f) {
            double d = (f2 -= 10.0f) - (f4 -= 10.0f);
            double d2 = d / 16.0;
            d = Math.atan(d2);
            double d3 = (f3 -= 10.0f) - (f5 -= 10.0f);
            d2 = d3 / 16.0;
            d3 = Math.atan(d2);
            float f6 = (float)((d + d3) / 2.0);
            this.rotateZ(f6);
            double d4 = f4 - f5;
            d2 = d4 / 16.0;
            d4 = Math.atan(d2);
            double d5 = f2 - f3;
            d2 = d5 / 16.0;
            d5 = Math.atan(d2);
            f6 = (float)((d4 + d5) / 2.0);
            this.rotateX(f6);
            f = f2;
            if (f4 < f) {
                f = f4;
            }
            if (f3 < f) {
                f = f3;
            }
            if (f5 < f) {
                f = f5;
            }
        } else {
            return false;
        }
        simpleVector.scalarMul(f - 4.0f);
        this.translate(simpleVector);
        this.rotateY(this.yRot);
        return true;
    }

    public void turnLeft() {
        this.yRot -= 0.075f;
    }

    public void turnRight() {
        this.yRot += 0.075f;
    }

    public float getDirection() {
        return this.yRot;
    }

    static {
        Texture texture = new Texture("textures" + File.separatorChar + "spot.jpg");
        TextureManager.getInstance().addTexture("car", texture);
    }
}

