/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.Camera;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Loader;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.OcTree;
import com.threed.jpct.Primitives;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;
import com.threed.jpct.util.KeyMapper;
import com.threed.jpct.util.KeyState;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.io.File;

class Cube {
    private static final int SWITCH_RENDERER = 35;
    private boolean fullscreen = false;
    private boolean openGL = true;
    private FrameBuffer buffer = null;
    private World theWorld = null;
    private TextureManager texMan = null;
    private Camera camera = null;
    private int width = 640;
    private int height = 480;
    private Frame frame = null;
    private Graphics gFrame = null;
    private BufferStrategy bufferStrategy = null;
    private GraphicsDevice device = null;
    private int titleBarHeight = 0;
    private int leftBorderWidth = 0;
    private boolean isIdle = false;
    private boolean exit = false;
    private boolean left = false;
    private boolean right = false;
    private boolean up = false;
    private boolean down = false;
    private boolean forward = false;
    private boolean back = false;
    private boolean jump = false;
    private boolean inAir = false;
    private float GRAVITY = 1.0f;
    private int theIlluminator;
    private float camAlt = 125.0f;
    private float camDist = 150.0f;
    private boolean camUp = false;
    private boolean camDown = false;
    private boolean camIn = false;
    private boolean camOut = false;
    private int t = 0;
    private float z = 0.0f;
    private KeyMapper keyMapper = null;
    private Object3D cube = Primitives.getCube((float)10.0f);
    private Object3D terrain = new Object3D(400);
    private SimpleVector Csiz = new SimpleVector();

    private Cube(String[] stringArray) {
        char c = File.separatorChar;
        Config.glFullscreen = false;
        Config.glMipmap = true;
        Config.glColorDepth = 16;
        Config.maxPolysVisible = 10000;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("fullscreen")) {
                Config.glFullscreen = true;
            }
            if (!stringArray[i].equals("noGL")) continue;
            this.openGL = false;
        }
        this.isIdle = false;
        this.theWorld = new World();
        Config.fadeoutLight = false;
        this.theWorld.getLights().setOverbrightLighting(255);
        this.theWorld.getLights().setRGBScale(2);
        this.theWorld.setAmbientLight(25, 30, 30);
        this.theWorld.addLight(new SimpleVector(0.0f, -150.0f, 0.0f), 10.0f, 10.0f, 10.0f);
        this.theWorld.addLight(new SimpleVector(-1000.0f, -1000.0f, 1000.0f), 5.0f, 5.0f, 5.0f);
        this.theWorld.addLight(new SimpleVector(1000.0f, -1000.0f, -1000.0f), 5.0f, 5.0f, 5.0f);
        this.theIlluminator = this.theWorld.addLight(new SimpleVector(1000.0f, -1000.0f, -1000.0f), 255.0f, 0.0f, 0.0f);
        this.theWorld.setLightDiscardDistance(this.theIlluminator, 20.0f);
        this.theWorld.setFogging(1);
        this.theWorld.setFogParameters(5000.0f, 0.0f, 0.0f, 0.0f);
        Config.farPlane = 5000.0f;
        this.texMan = TextureManager.getInstance();
        this.texMan.addTexture("teks", new Texture("textures" + c + "ql0.jpg"));
        this.texMan.addTexture("rocks", new Texture("textures" + c + "rocks.jpg"));
        this.terrain = Loader.load3DS((String)("models" + c + "terascene.3ds"), (float)1000.0f)[0];
        this.terrain.setOrigin(new SimpleVector(0.0f, 0.0f, 0.0f));
        this.terrain.rotateX(-1.5707964f);
        this.terrain.setTexture("rocks");
        this.terrain.createTriangleStrips(2);
        OcTree ocTree = new OcTree(this.terrain, 50, 1);
        this.terrain.setOcTree(ocTree);
        ocTree.setCollisionUse(true);
        Config.collideOffset = 25000.0f;
        this.terrain.setCollisionMode(1);
        this.terrain.setCollisionOptimization(true);
        this.theWorld.addObject(this.terrain);
        this.cube.rotateY(-1.5707964f);
        this.cube.rotateMesh();
        this.cube.setRotationMatrix(new Matrix());
        this.texMan.addTexture("suit", new Texture("models" + c + "bill" + c + "billywork.jpg"));
        this.cube.setTexture("suit");
        this.cube.setCollisionMode(2);
        this.cube.setTranslationMatrix(new Matrix());
        this.theWorld.addObject(this.cube);
        float[] fArray = this.cube.getMesh().getBoundingBox();
        this.Csiz.x = Math.abs(fArray[1] - fArray[0]) / 2.0f;
        this.Csiz.y = Math.abs(fArray[3] - fArray[2]) / 2.0f;
        this.Csiz.z = Math.abs(fArray[5] - fArray[4]) / 2.0f;
        Logger.log((String)"============================", (int)2);
        for (int i = 0; i < 6; ++i) {
            Logger.log((String)String.valueOf(fArray[i]), (int)2);
        }
        Logger.log((String)"============================", (int)2);
        Logger.log((String)String.valueOf(this.Csiz.x), (int)2);
        Logger.log((String)String.valueOf(this.Csiz.y), (int)2);
        Logger.log((String)String.valueOf(this.Csiz.z), (int)2);
        Logger.log((String)"============================", (int)2);
        this.camera = this.theWorld.getCamera();
        this.camera.setPosition(0.0f, 0.0f, 10.0f);
        this.camera.lookAt(this.cube.getTransformedCenter());
        this.theWorld.buildAllObjects();
        Config.tuneForOutdoor();
        this.initializeFrame();
        this.gameLoop();
    }

    public static void main(String[] stringArray) {
        new Cube(stringArray);
    }

    private void initializeFrame() {
        if (Config.glFullscreen) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.device = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = this.device.getDefaultConfiguration();
            this.frame = new Frame(graphicsConfiguration);
            this.frame.setUndecorated(true);
            this.frame.setIgnoreRepaint(true);
            this.device.setFullScreenWindow(this.frame);
            if (this.device.isDisplayChangeSupported()) {
                this.device.setDisplayMode(new DisplayMode(this.width, this.height, 32, 0));
            }
            this.frame.createBufferStrategy(2);
            this.bufferStrategy = this.frame.getBufferStrategy();
            Graphics graphics = this.bufferStrategy.getDrawGraphics();
            this.bufferStrategy.show();
            graphics.dispose();
        } else {
            this.frame = new Frame("jPCT " + Config.getVersion());
            this.frame.pack();
            Insets insets = this.frame.getInsets();
            this.titleBarHeight = insets.top;
            this.leftBorderWidth = insets.left;
            this.frame.setSize(this.width + this.leftBorderWidth + insets.right, this.height + this.titleBarHeight + insets.bottom);
            this.frame.setResizable(false);
            this.frame.show();
            this.gFrame = this.frame.getGraphics();
        }
        this.frame.addWindowListener(new WindowEvents());
        this.keyMapper = new KeyMapper((Component)this.frame);
    }

    private void moveCube() {
        SimpleVector simpleVector;
        this.t = 1;
        Config.collideEllipsoidThreshold = 5.0E-5f;
        this.terrain.setCollisionOptimization(true);
        if (this.cube.wasTargetOfLastCollision()) {
            this.inAir = false;
        }
        if (this.right) {
            this.cube.rotateY(0.01f);
        }
        if (this.left) {
            this.cube.rotateY(-0.01f);
        }
        if (this.up) {
            this.cube.rotateAxis(this.cube.getXAxis(), -0.01f);
        }
        if (this.down) {
            this.cube.rotateAxis(this.cube.getXAxis(), 0.01f);
        }
        boolean bl = false;
        if (this.forward) {
            this.t = 2;
            simpleVector = this.cube.getZAxis();
            simpleVector.y += 1.0f;
            simpleVector = simpleVector.normalize();
            simpleVector.scalarMul(1.0f);
            simpleVector = this.cube.checkForCollisionEllipsoid(simpleVector, this.Csiz, 25);
            this.cube.translate(simpleVector);
            bl = true;
        }
        if (this.back) {
            simpleVector = this.cube.getZAxis();
            simpleVector.scalarMul(-0.5f);
            simpleVector.y += 1.0f;
            simpleVector = simpleVector.normalize();
            simpleVector = this.cube.checkForCollisionEllipsoid(simpleVector, this.Csiz, 25);
            this.cube.translate(simpleVector);
            bl = true;
        }
        if (this.jump && !this.inAir) {
            simpleVector = this.cube.getZAxis();
            simpleVector.scalarMul(-1.0f);
            simpleVector.add(new SimpleVector(0.0f, -5.0f, 0.0f));
            simpleVector = this.cube.checkForCollisionEllipsoid(simpleVector, this.Csiz, 6);
            this.cube.translate(simpleVector);
            bl = true;
        }
        if (!bl) {
            simpleVector = new SimpleVector(0.0f, this.GRAVITY, 0.0f);
            simpleVector = this.cube.checkForCollisionEllipsoid(simpleVector, this.Csiz, 1);
            this.cube.translate(simpleVector);
        }
        if (this.camUp) {
            this.camAlt += 0.5f;
        }
        if (this.camDown) {
            this.camAlt -= 0.5f;
        }
        if (this.camIn) {
            this.camDist -= 0.5f;
        }
        if (this.camOut) {
            this.camDist += 0.5f;
        }
        if (this.z > 1.0f) {
            this.z = 0.0f;
        }
        this.cube.animate(this.z, this.t);
        this.z += 0.001f;
    }

    private void moveCube_org() {
        SimpleVector simpleVector;
        this.t = 1;
        Config.collideEllipsoidThreshold = 5.0E-5f;
        this.terrain.setCollisionOptimization(true);
        if (this.cube.wasTargetOfLastCollision()) {
            this.inAir = false;
        }
        if (this.right) {
            this.cube.rotateY(0.01f);
        }
        if (this.left) {
            this.cube.rotateY(-0.01f);
        }
        if (this.up) {
            this.cube.rotateAxis(this.cube.getXAxis(), -0.01f);
        }
        if (this.down) {
            this.cube.rotateAxis(this.cube.getXAxis(), 0.01f);
        }
        if (this.forward) {
            this.t = 2;
            simpleVector = this.cube.getZAxis();
            simpleVector.y += 1.0f;
            simpleVector = simpleVector.normalize();
            simpleVector.scalarMul(1.0f);
            simpleVector = this.cube.checkForCollisionEllipsoid(simpleVector, this.Csiz, 25);
            this.cube.translate(simpleVector);
        }
        if (this.back) {
            simpleVector = this.cube.getZAxis();
            simpleVector.scalarMul(-0.5f);
            simpleVector.y += 1.0f;
            simpleVector = simpleVector.normalize();
            simpleVector = this.cube.checkForCollisionEllipsoid(simpleVector, this.Csiz, 25);
            this.cube.translate(simpleVector);
        }
        if (this.jump && !this.inAir) {
            simpleVector = this.cube.getZAxis();
            simpleVector.scalarMul(-1.0f);
            simpleVector.add(new SimpleVector(0.0f, -5.0f, 0.0f));
            simpleVector.x = 0.0f;
            simpleVector.z = 0.0f;
            simpleVector = this.cube.checkForCollisionEllipsoid(simpleVector, this.Csiz, 6);
            this.cube.translate(simpleVector);
        }
        if (this.camUp) {
            this.camAlt += 0.5f;
        }
        if (this.camDown) {
            this.camAlt -= 0.5f;
        }
        if (this.camIn) {
            this.camDist -= 0.5f;
        }
        if (this.camOut) {
            this.camDist += 0.5f;
        }
        if (this.z > 1.0f) {
            this.z = 0.0f;
        }
        this.cube.animate(this.z, this.t);
        this.z += 0.001f;
    }

    private void display() {
        if (this.buffer.usesRenderer(1)) {
            if (Config.glFullscreen) {
                Graphics graphics = this.bufferStrategy.getDrawGraphics();
                graphics.drawImage(this.buffer.getOutputBuffer(), 0, 0, null);
                this.bufferStrategy.show();
                graphics.dispose();
            } else {
                this.buffer.display(this.gFrame, this.leftBorderWidth, this.titleBarHeight);
            }
        } else {
            this.buffer.displayGLOnly();
        }
    }

    private void gameLoop() {
        World.setDefaultThread((Thread)Thread.currentThread());
        this.buffer = new FrameBuffer(this.width, this.height, 0);
        this.buffer.enableRenderer(1);
        if (this.openGL) {
            this.frame.hide();
            this.keyMapper.destroy();
            this.buffer.enableRenderer(2, 1);
            this.buffer.disableRenderer(1);
            this.keyMapper = new KeyMapper();
        }
        this.buffer.setBoundingBoxMode(false);
        this.buffer.optimizeBufferAccess();
        Timer timer = new Timer(25);
        timer.start();
        while (!this.exit) {
            if (this.isIdle) continue;
            this.poll();
            this.buffer.clear();
            this.theWorld.renderScene(this.buffer);
            this.theWorld.draw(this.buffer);
            this.buffer.update();
            this.moveCube();
            SimpleVector simpleVector = this.cube.getTransformedCenter();
            this.theWorld.setLightPosition(this.theIlluminator, simpleVector);
            this.camera.setPosition(this.cube.getTransformedCenter());
            this.camera.align(this.cube);
            this.camera.moveCamera(2, this.camDist);
            this.camera.moveCamera(4, this.camAlt);
            this.camera.lookAt(this.cube.getTransformedCenter());
            this.display();
            Thread.yield();
        }
        if (this.openGL) {
            this.buffer.disableRenderer(2);
        } else if (this.fullscreen) {
            this.device.setFullScreenWindow(null);
        }
        System.exit(0);
    }

    private void keyAffected(KeyState keyState) {
        int n = keyState.getKeyCode();
        boolean bl = keyState.getState();
        switch (n) {
            case 27: {
                this.exit = true;
                break;
            }
            case 39: {
                this.right = bl;
                break;
            }
            case 37: {
                this.left = bl;
                break;
            }
            case 38: {
                this.forward = bl;
                break;
            }
            case 40: {
                this.back = bl;
                break;
            }
            case 32: {
                this.jump = bl;
                break;
            }
            case 100: {
                this.camUp = bl;
                break;
            }
            case 97: {
                this.camDown = bl;
                break;
            }
            case 101: {
                this.camIn = bl;
                break;
            }
            case 98: {
                this.camOut = bl;
                break;
            }
            case 155: {
                ++this.t;
                if (this.t <= 17) break;
                this.t = 0;
            }
        }
    }

    private void poll() {
        KeyState keyState = null;
        do {
            if ((keyState = this.keyMapper.poll()) == KeyState.NONE) continue;
            this.keyAffected(keyState);
        } while (keyState != KeyState.NONE);
    }

    private class Timer {
        private long ticks = 0L;
        private long granularity = 0L;

        public Timer(int n) {
            this.granularity = n;
        }

        public void start() {
            this.ticks = System.currentTimeMillis();
        }

        public void reset() {
            this.start();
        }

        public long getElapsedTicks() {
            long l = System.currentTimeMillis();
            long l2 = l - this.ticks;
            if (l2 >= this.granularity) {
                this.ticks = l - l2 % this.granularity;
                return l2 / this.granularity;
            }
            return 0L;
        }
    }

    private class WindowEvents
    extends WindowAdapter {
        private WindowEvents() {
        }

        public void windowIconified(WindowEvent windowEvent) {
            Cube.this.isIdle = true;
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            Cube.this.isIdle = false;
        }
    }
}

