/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.Camera;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.ITextureEffect;
import com.threed.jpct.Interact2D;
import com.threed.jpct.Logger;
import com.threed.jpct.Object3D;
import com.threed.jpct.PolygonManager;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.VisList;
import com.threed.jpct.World;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MipMapper {
    public static final int LEVELS = 6;
    public static final int MIN_SIZE = 8;
    public static final float FIRST_LEVEL = 0.5f;
    public static boolean colorMipmaps = false;
    private TextureManager tm = TextureManager.getInstance();
    private int[] visListData = new int[2];
    private ObjectData[] changedObjects = new ObjectData[8];
    private BitSet processedTextures = new BitSet(256);
    private Hashtable mipMappedObjs = new Hashtable();
    private Hashtable textureIds = new Hashtable();
    private Vector createdTextures = new Vector();
    private int lastObjCnt = 0;

    public void addObject(Object3D object3D) {
        this.mipMappedObjs.put(new Integer(object3D.getID()), new ObjectData(object3D));
    }

    public void removeObject(int n) {
        this.mipMappedObjs.remove(new Integer(n));
    }

    private void createMipMaps(Object3D object3D) {
        PolygonManager polygonManager = object3D.getPolygonManager();
        for (int i = 0; i < polygonManager.getMaxPolygonID(); ++i) {
            int n = polygonManager.getPolygonTexture(i);
            if (this.processedTextures.get(n)) continue;
            Texture texture = this.tm.getTextureByID(n);
            int n2 = texture.getWidth();
            int n3 = texture.getHeight();
            TexelGrabber texelGrabber = new TexelGrabber();
            texture.setEffect((ITextureEffect)texelGrabber);
            texture.applyEffect();
            texture.removeEffect();
            int[] nArray = texelGrabber.texels;
            DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
            int[] nArray2 = new int[n2 * n3];
            MemoryImageSource memoryImageSource = new MemoryImageSource(n2, n3, (ColorModel)directColorModel, nArray2, 0, n2);
            Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
            Texture texture2 = texture;
            int n4 = n;
            for (int j = 1; j < 6; ++j) {
                Object object;
                int n5 = (int)((double)n2 / Math.pow(2.0, j));
                int n6 = (int)((double)n3 / Math.pow(2.0, j));
                n5 = Math.max(8, n5);
                n6 = Math.max(8, n6);
                if (texture2.getWidth() != n5 || texture2.getHeight() != n6) {
                    if (colorMipmaps) {
                        object = new int[nArray.length];
                        int n7 = 200 << 8 * ((j - 1) % 3);
                        for (int k = 0; k < ((int[])object).length; ++k) {
                            object[k] = n7;
                        }
                        nArray = object;
                    }
                    System.arraycopy(nArray, 0, nArray2, 0, n2 * n3);
                    memoryImageSource.newPixels();
                    object = image.getScaledInstance(n5, n6, 4);
                    Texture texture3 = new Texture((Image)object);
                    String string = this.getTextureName(n, j);
                    if (this.tm.containsTexture(string)) {
                        this.tm.replaceTexture(string, texture3);
                    } else {
                        this.tm.addTexture(string, texture3);
                    }
                    texture2 = texture3;
                    n4 = this.tm.getTextureID(string);
                    this.textureIds.put(string, new Integer(n4));
                    this.createdTextures.addElement(string);
                    Logger.log((String)("mip map texture created " + string + " " + n5 + "x" + n6), (int)2);
                    continue;
                }
                object = this.getTextureName(n, j);
                this.textureIds.put(object, new Integer(n4));
                Logger.log((String)("re-used last mipmap texture " + (String)object + " " + n5 + "x" + n6), (int)2);
            }
            this.processedTextures.set(n);
        }
    }

    private String getTextureName(int n, int n2) {
        return "mipmap/" + n + "/" + n2;
    }

    public void mipMap(World world, FrameBuffer frameBuffer) {
        int n;
        if (this.mipMappedObjs.isEmpty()) {
            return;
        }
        if (this.mipMappedObjs.size() > this.changedObjects.length) {
            this.changedObjects = new ObjectData[this.mipMappedObjs.size()];
        }
        VisList visList = world.getVisibilityList();
        int n2 = visList.getSize();
        int n3 = -1;
        ObjectData objectData = null;
        this.lastObjCnt = 0;
        SimpleVector[] simpleVectorArray = new SimpleVector[3];
        Camera camera = world.getCamera();
        for (n = 0; n < n2; ++n) {
            visList.getData(n, this.visListData);
            if (n3 != this.visListData[0]) {
                n3 = this.visListData[0];
                objectData = (ObjectData)this.mipMappedObjs.get(new Integer(this.visListData[0]));
            }
            if (objectData == null) continue;
            int n4 = this.visListData[1];
            simpleVectorArray[0] = Interact2D.project3D2D((Camera)camera, (FrameBuffer)frameBuffer, (SimpleVector)objectData.pm.getTransformedVertex(n4, 0));
            simpleVectorArray[1] = Interact2D.project3D2D((Camera)camera, (FrameBuffer)frameBuffer, (SimpleVector)objectData.pm.getTransformedVertex(n4, 1));
            simpleVectorArray[2] = Interact2D.project3D2D((Camera)camera, (FrameBuffer)frameBuffer, (SimpleVector)objectData.pm.getTransformedVertex(n4, 2));
            if (simpleVectorArray[0] == null || simpleVectorArray[1] == null || simpleVectorArray[2] == null) continue;
            float f = this.calculateArea(simpleVectorArray);
            float f2 = f / objectData.textureAreas[n4];
            int n5 = -1;
            boolean bl = false;
            while (!bl && ++n5 < 5) {
                bl = f2 > 0.5f;
                f2 *= 4.0f;
            }
            int n6 = objectData.orgTex[n4][n5];
            if (n6 == objectData.curTex[n4]) continue;
            if (!objectData.isChanged()) {
                objectData.setChanged(true);
                this.changedObjects[this.lastObjCnt] = objectData;
                ++this.lastObjCnt;
            }
            ((ObjectData)objectData).curTex[n4] = n6;
            objectData.pm.setPolygonTexture(n4, n6);
        }
        for (n = 0; n < this.lastObjCnt; ++n) {
            this.changedObjects[n].recreate();
            this.changedObjects[n].setChanged(false);
            this.changedObjects[n] = null;
        }
    }

    public void reset() {
        Enumeration enumeration = this.mipMappedObjs.elements();
        while (enumeration.hasMoreElements()) {
            ((ObjectData)enumeration.nextElement()).reset();
        }
    }

    public void dispose() {
        Enumeration enumeration = this.createdTextures.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.tm.containsTexture(string)) {
                this.tm.replaceTexture(string, this.tm.getDummyTexture());
                continue;
            }
            Logger.log((String)("couldn't find texture " + string), (int)1);
        }
    }

    private float calculateArea(SimpleVector[] simpleVectorArray) {
        float f = simpleVectorArray[0].x * simpleVectorArray[1].y + simpleVectorArray[1].x * simpleVectorArray[2].y + simpleVectorArray[2].x * simpleVectorArray[0].y - (simpleVectorArray[0].y * simpleVectorArray[1].x + simpleVectorArray[1].y * simpleVectorArray[2].x + simpleVectorArray[2].y * simpleVectorArray[0].x);
        return (f = (float)((double)f * 0.5)) < 0.0f ? -f : f;
    }

    private class TexelGrabber
    implements ITextureEffect {
        private int[] texels = null;

        private TexelGrabber() {
        }

        public void init(Texture texture) {
        }

        public boolean containsAlpha() {
            return false;
        }

        public void apply(int[] nArray, int[] nArray2) {
            this.texels = nArray2;
        }
    }

    private class ObjectData {
        private Object3D object3d;
        private PolygonManager pm;
        private int[][] orgTex;
        private int[] curTex;
        private float[] textureAreas;
        private boolean changed = false;

        private ObjectData(Object3D object3D) {
            this.object3d = object3D;
            this.pm = object3D.getPolygonManager();
            this.orgTex = new int[this.pm.getMaxPolygonID()][6];
            this.curTex = new int[this.pm.getMaxPolygonID()];
            this.textureAreas = new float[this.pm.getMaxPolygonID()];
            MipMapper.this.createMipMaps(object3D);
            SimpleVector[] simpleVectorArray = new SimpleVector[3];
            for (int i = 0; i < this.orgTex.length; ++i) {
                int n;
                this.orgTex[i][0] = n = this.pm.getPolygonTexture(i);
                for (int j = 1; j < 6; ++j) {
                    this.orgTex[i][j] = (Integer)MipMapper.this.textureIds.get(MipMapper.this.getTextureName(n, j));
                }
                this.curTex[i] = this.orgTex[i][0];
                simpleVectorArray[0] = this.pm.getTextureUV(i, 0);
                simpleVectorArray[1] = this.pm.getTextureUV(i, 1);
                simpleVectorArray[2] = this.pm.getTextureUV(i, 2);
                float f = MipMapper.this.calculateArea(simpleVectorArray);
                Texture texture = MipMapper.this.tm.getTextureByID(n);
                this.textureAreas[i] = f * (float)texture.getWidth() * (float)texture.getHeight();
            }
        }

        private void setChanged(boolean bl) {
            this.changed = bl;
        }

        private boolean isChanged() {
            return this.changed;
        }

        private void recreate() {
            this.object3d.recreateTextureCoords();
        }

        private void reset() {
            boolean bl = false;
            for (int i = 0; i < this.orgTex.length; ++i) {
                int n = this.orgTex[i][0];
                if (n == this.curTex[i]) continue;
                bl = true;
                this.pm.setPolygonTexture(i, n);
                this.curTex[i] = n;
            }
            if (bl) {
                this.object3d.recreateTextureCoords();
            }
        }
    }
}

