/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.Loader;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import java.awt.Color;
import java.io.File;

public class Plant
extends AbstractEntity {
    private static final Object3D PLANT;
    private boolean dead = false;

    public Plant() {
        super(PLANT);
        this.setCollisionMode(1);
        this.setCollisionOptimization(true);
    }

    public boolean place(Object3D object3D) {
        SimpleVector simpleVector = new SimpleVector(0.0f, 1.0f, 0.0f);
        float f = object3D.calcMinDistance(this.getTransformedCenter(), simpleVector, 500.0f);
        if (f != 1.0E12f) {
            simpleVector.scalarMul(f + this.getCenter().y);
            this.translate(simpleVector);
            this.enableLazyTransformations();
            return true;
        }
        return false;
    }

    public void destroy() {
        this.setTexture("plant2");
        this.dead = true;
        this.setCollisionMode(0);
        this.disableCollisionListeners();
    }

    public boolean isDead() {
        return this.dead;
    }

    static {
        Texture texture = new Texture("textures" + File.separatorChar + "plant.jpg");
        TextureManager.getInstance().addTexture("plant", texture);
        Texture texture2 = new Texture("textures" + File.separatorChar + "plant2.jpg");
        TextureManager.getInstance().addTexture("plant2", texture2);
        Object3D[] object3DArray = Loader.load3DS((String)("models" + File.separatorChar + "plant.3ds"), (float)2.5f);
        if (object3DArray.length == 1) {
            PLANT = object3DArray[0];
            PLANT.setTexture("plant");
            PLANT.setTransparency(2);
            PLANT.setCulling(false);
            PLANT.rotateX(-1.5707964f);
            PLANT.rotateMesh();
            PLANT.setRotationMatrix(new Matrix());
            PLANT.setAdditionalColor(new Color(100, 100, 100));
            PLANT.build();
        } else {
            Logger.log((String)"Wrong file format for plants!", (int)0);
            PLANT = null;
        }
    }
}

