/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;
import java.io.File;

public class PlantManager {
    private static final int MAX_PLANTS = 100;
    private Plant[] plants;
    private SimpleVector[] positions;
    private final BulletPlantListener LISTENER = new BulletPlantListener();
    private static Texture radar = null;

    public PlantManager(World world, Object3D object3D, float f) {
        int n;
        this.plants = new Plant[100];
        this.positions = new SimpleVector[100];
        for (n = 0; n < 100; ++n) {
            Plant plant;
            this.plants[n] = plant = new Plant();
            boolean bl = false;
            do {
                float f2 = (float)(Math.random() - 0.5) * f * 2.0f;
                float f3 = (float)(Math.random() - 0.5) * f * 2.0f;
                plant.setTranslationMatrix(new Matrix());
                plant.translate(f2, 0.0f, f3);
            } while (!(bl = plant.place(object3D)));
            plant.addToWorld(world);
            plant.addCollisionListener(this.LISTENER);
        }
        for (n = 0; n < 100; ++n) {
            this.positions[n] = this.plants[n].getTransformedCenter();
            this.plants[n].enableLazyTransformations();
        }
    }

    public void drawRadar(FrameBuffer frameBuffer, Car car) {
        float f = 0.0f;
        float f2 = 0.0f;
        SimpleVector simpleVector = car.getTransformedCenter();
        SimpleVector simpleVector2 = new SimpleVector();
        float f3 = car.getDirection();
        float f4 = (float)frameBuffer.getOutputWidth() / 10.0f;
        float f5 = (float)frameBuffer.getOutputHeight() / 10.0f;
        float f6 = (float)frameBuffer.getOutputWidth() - f4 - 50.0f;
        float f7 = f5 + 50.0f;
        for (int i = 0; i < 100; ++i) {
            if (this.plants[i].isDead()) continue;
            simpleVector2.x = this.positions[i].x - simpleVector.x;
            simpleVector2.z = this.positions[i].z - simpleVector.z;
            simpleVector2.rotateY(f3);
            f = simpleVector2.x;
            f2 = simpleVector2.z;
            if (!(f > -600.0f) || !(f < 600.0f) || !(f2 > -600.0f) || !(f2 < 600.0f)) continue;
            int n = (int)(f6 + f / 600.0f * f4);
            int n2 = (int)(f7 + f2 / 600.0f * -f5);
            frameBuffer.blit(radar, 0.0f, 0.0f, (float)n, (float)n2, 4.0f, 4.0f, false);
        }
        frameBuffer.blit(radar, 0.0f, 0.0f, (float)((int)f6), (float)((int)f7), 2.0f, 2.0f, false);
    }

    static {
        radar = new Texture("textures" + File.separatorChar + "radar.jpg");
        TextureManager.getInstance().addTexture("radar", radar);
    }
}

