/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.Matrix;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.World;

public class ProjectileManager {
    private static final int MAX_BULLETS = 100;
    private static final int MAX_DECALS = 20;
    private Bullet[] bullets = new Bullet[100];
    private Decal[] decals = new Decal[20];

    public ProjectileManager(World world) {
        int n;
        for (n = 0; n < 100; ++n) {
            this.bullets[n] = new Bullet();
            this.bullets[n].addToWorld(world);
        }
        for (n = 0; n < 20; ++n) {
            this.decals[n] = new Decal();
            this.decals[n].addToWorld(world);
        }
    }

    public void moveBullets() {
        for (int i = 0; i < 100; ++i) {
            if (!this.bullets[i].getVisibility()) continue;
            this.bullets[i].moveForward();
        }
    }

    public void createBullet(AbstractEntity abstractEntity) {
        Bullet bullet = this.getFreeBullet();
        if (bullet != null) {
            bullet.enable();
            bullet.fire(abstractEntity);
        }
    }

    public void createDecal(SimpleVector simpleVector, SimpleVector simpleVector2) {
        Decal decal = this.getFreeDecal();
        if (decal != null) {
            Matrix matrix = simpleVector2.getRotationMatrix();
            decal.place(simpleVector);
            decal.rotate(matrix);
        }
    }

    private Bullet getFreeBullet() {
        for (int i = 0; i < 100; ++i) {
            if (this.bullets[i].getVisibility()) continue;
            return this.bullets[i];
        }
        return null;
    }

    private Decal getFreeDecal() {
        long l = Long.MAX_VALUE;
        Decal decal = null;
        for (int i = 0; i < 20; ++i) {
            if (!this.decals[i].getVisibility()) {
                return this.decals[i];
            }
            if (this.decals[i].getDecalID() >= l) continue;
            l = this.decals[i].getDecalID();
            decal = this.decals[i];
        }
        return decal;
    }
}

