/*
 * Decompiled with CFR 0.152.
 */
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.World;

public class SkidMarkManager {
    private static final int SKID_MARKS = 180;
    private static final float SKID_DELTA = 3.0f;
    private SkidMark[] skidmarks = new SkidMark[180];
    private SimpleVector lastPos = null;
    private int nextMark = 0;

    public SkidMarkManager(World world) {
        for (int i = 0; i < 180; ++i) {
            this.skidmarks[i] = new SkidMark();
            world.addObject((Object3D)this.skidmarks[i]);
        }
    }

    public void createSkidMarks(Car car) {
        SimpleVector simpleVector = car.getTransformedCenter();
        if (this.lastPos != null) {
            SimpleVector simpleVector2 = simpleVector.calcSub(this.lastPos);
            float f = simpleVector2.length();
            if (f > 3.0f) {
                SimpleVector simpleVector3 = simpleVector2;
                simpleVector3.scalarMul(3.0f / f);
                SimpleVector simpleVector4 = new SimpleVector(this.lastPos);
                while (f > 3.0f) {
                    simpleVector4.add(simpleVector3);
                    this.skidmarks[this.nextMark].place(-1, car, simpleVector4);
                    this.skidmarks[this.nextMark + 1].place(1, car, simpleVector4);
                    this.nextMark += 2;
                    this.nextMark %= 180;
                    f -= 3.0f;
                }
                this.lastPos = simpleVector;
            }
        } else {
            this.lastPos = simpleVector;
        }
    }
}

